/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ActivityDefPartialInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EnactmentUtils {
    private static final Logger logger = Logger.getLogger(EnactmentUtils.class);

    public static Map getPostManpowerActivities(ActivityDef actDef, WfEngine wfEngine) throws WfException {
        if (actDef == null) {
            throw new IllegalArgumentException();
        }
        HashSet visited = new HashSet();
        Map result = EnactmentUtils.findPostManpowerActivities(actDef, wfEngine, visited);
        return result;
    }

    private static Map findPostManpowerActivities(ActivityDef actDef, WfEngine wfEngine, HashSet visited) throws WfException {
        if (visited.contains(actDef)) {
            return Collections.EMPTY_MAP;
        }
        visited.add(actDef);
        HashMap<String, ActivityDef> result = new HashMap<String, ActivityDef>();
        ActivityCollection activities = actDef.getPostActivities();
        if (activities == null || activities.size() == 0) {
            return result;
        }
        for (ActivityDef activity : activities) {
            if (activity instanceof ManpowerActivityDef) {
                ProcessDef procDef = (ProcessDef)activity.getContainer();
                result.put(procDef.getHashValue() + "@" + activity.getID(), activity);
                continue;
            }
            if (activity instanceof ToolActivityDef || activity instanceof RouterActivityDef) {
                result.putAll(EnactmentUtils.findPostManpowerActivities(activity, wfEngine, visited));
                continue;
            }
            if (!(activity instanceof SubflowActivityDef)) continue;
            result.putAll(EnactmentUtils.getSubflowPostActivities((SubflowActivityDef)activity, wfEngine));
        }
        return result;
    }

    public static Map getSubflowPostActivities(SubflowActivityDef subflowActivityDef, WfEngine wfEngine) throws WfException {
        HashMap result = new HashMap();
        HashSet visited = new HashSet();
        String subProcessDefID = subflowActivityDef.getSubflowId();
        ProcessDef subProcessDef = wfEngine.getProcessMgr(subProcessDefID).getProcessDef();
        ActivityCollection startupActivities = subProcessDef.getStartupActivities();
        int size = startupActivities.size();
        for (int i = 0; i < size; ++i) {
            ActivityDef actDef = startupActivities.get(i);
            result.putAll(EnactmentUtils.findPostManpowerActivities(actDef, wfEngine, visited));
        }
        return result;
    }

    public static ActivityDefPartialInfo[] getUnitScopeActDefsByProcDef(ProcessDef procDef, Locale locale) {
        if (procDef == null) {
            return null;
        }
        HashSet<ActivityDefPartialInfo> actDefs = new HashSet<ActivityDefPartialInfo>();
        ActivityCollection activities = procDef.getActivitys();
        for (ActivityDef def : activities) {
            if (!(def instanceof ManpowerActivityDef)) continue;
            ParticipantCollection parts = ((ManpowerActivityDef)def).getParticipants();
            for (int p = 0; p < parts.size(); ++p) {
                ParticipantType type = parts.get(p).getParticipantType();
                if (!type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_SCOPE)) continue;
                ActivityDefPartialInfo actDefPartialInfo = new ActivityDefPartialInfo();
                actDefPartialInfo.setActDefId(def.getID());
                actDefPartialInfo.setActDefName(def.getName(locale));
                actDefs.add(actDefPartialInfo);
            }
        }
        return actDefs.toArray(new ActivityDefPartialInfo[0]);
    }

    public static Map getLinesActivityMap(ActivityDef actDef, Locale locale) throws WfException {
        HashMap<String, ActivityDef> map = new HashMap<String, ActivityDef>();
        TransitionCollection transitions = actDef.getOutgoingTransitions();
        for (TransitionDef transitionDef : transitions) {
            if (transitionDef.getDescription(locale) == null || transitionDef.getDescription(locale).equals("")) continue;
            map.put(transitionDef.getID(), transitionDef.getTo());
        }
        return map;
    }

    public static String[] getTransitionIds(TransitionCollection transitionCollection) {
        String[] transitionIds = new String[transitionCollection.size()];
        int size = transitionCollection.size();
        for (int i = 0; i < size; ++i) {
            transitionIds[i] = transitionCollection.get(i).getID();
        }
        return transitionIds;
    }

    public static Context getApplicationContext(WfActivity activity) throws WfParticipantException, WfException {
        Locale loacle;
        String applicationUserId;
        ToolActivityDef toolActDef;
        Context ctx = null;
        Person applicationUser = null;
        if (activity.getDefinition() instanceof ToolActivityDef && (toolActDef = (ToolActivityDef)activity.getDefinition()).getApplicationUser() != null) {
            ParticipantCollection participants = new ParticipantCollection();
            participants.add(toolActDef.getApplicationUser().getID(), toolActDef.getApplicationUser());
            List persons = ParticipantHelper.getPersonsByParticipants(activity.container(), participants);
            if (persons != null && persons.size() != 0) {
                applicationUser = (Person)persons.get(0);
            }
        }
        if ((applicationUser == null || applicationUser.getUserId() == null || applicationUser.getUserId().length() == 0) && (applicationUserId = activity.container().getProcessMeta().getInitiatorId()) != null && applicationUserId.length() > 0) {
            applicationUser = activity.getWfEngine().getPariticipantProvider().getPersonByUserId(activity.getWfEngine().context(), applicationUserId);
        }
        if (applicationUser != null && applicationUser.getUserId() != null && applicationUser.getUserId().length() > 0) {
            String userName = applicationUser.getUserName(activity.getWfEngine().context().getLocale());
            ctx = activity.getWfEngine().getCacheManager().getUserServiceContext(applicationUser.getUserId() + "," + userName, activity.getWfEngine().context());
            ctx = EnactmentUtils.cloneContext(ctx);
        }
        if (ctx == null) {
            ctx = activity.getWfEngine().context();
            String userID = null;
            if (applicationUser != null && !StringUtils.isEmpty((String)applicationUser.getUserId())) {
                userID = applicationUser.getUserId();
            } else {
                userID = activity.container().getProcessMeta().getInitiatorId();
                if (StringUtils.isEmpty((String)userID)) {
                    String partentParentProcInstid;
                    String partentProcInstid = activity.container().getProcessMeta().getParentProcInstId();
                    if (!StringUtils.isEmpty((String)partentProcInstid)) {
                        userID = activity.getWfEngine().getProcessInst(partentProcInstid).getProcessMeta().getInitiatorId();
                    }
                    if (StringUtils.isEmpty((String)userID) && !StringUtils.isEmpty((String)(partentParentProcInstid = activity.getWfEngine().getProcessInst(partentProcInstid).getProcessMeta().getParentProcInstId()))) {
                        userID = activity.getWfEngine().getProcessInst(partentParentProcInstid).getProcessMeta().getInitiatorId();
                    }
                }
            }
            ctx = EnactmentUtils.cloneContext(ctx);
            ctx.setCaller((IObjectPK)new ObjectUuidPK(userID));
        }
        if ((loacle = (Locale)activity.getProcess().getDataField("lastRealLocale")) != null) {
            ctx.setLocale(loacle);
            ContextUtils.setLocaleToThread((Locale)loacle);
        }
        return ctx;
    }

    public static Context cloneContext(Context ctx) {
        try {
            Context ctx1 = (Context)ObjectUtils.createCopy((Object)ctx);
            Locale orginal = ContextUtils.getLocaleFromEnv();
            if (orginal != null && !orginal.getLanguage().equals(ctx1.getLocale().getLanguage())) {
                ctx1.setLocale(orginal);
            }
            return ctx1;
        }
        catch (Throwable e) {
            logger.error((Object)"cloneContext()", e);
            return ctx;
        }
    }
}

