/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.debug.IDebugTracer;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.PropertyNotFoundException;
import com.kingdee.bos.metadata.configure.VOUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.ProcessControlDataKScriptAdapter;
import com.kingdee.bos.workflow.enactment.RuntimeSystemVariable;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.exception.BizObjectNotFoundException;
import com.kingdee.bos.workflow.util.EnactmentUtils;
import com.kingdee.bos.workflow.util.InnerVariable;
import com.kingdee.bos.workflow.util.InnerVariableManager;
import com.kingdee.bos.workflow.util.WfScriptTracer;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScriptUtil {
    private static final String ORG_SELECTOR = "ORG_SELECTOR";
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.ScriptUtil");

    public static boolean evalCondition(String script, ProcessContext processCtx, ProcessDef processDef) throws WfException {
        LowTimer lowTimer = new LowTimer();
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(ScriptUtil.class.getName(), "evalCondition", null);
        }
        try {
            Object rtnVal;
            if (script == null || script.length() == 0) {
                boolean bl = true;
                return bl;
            }
            HashMap context = new HashMap();
            context.putAll(ScriptUtil.getInnerVariables(processDef));
            context.putAll(processCtx.getDataCopy());
            Interpreter interpreter = new Interpreter(EnactmentUtils.cloneContext(processCtx.getWfEngine().context()));
            interpreter.setProperyExprOwnerNullIgore(true);
            String procInstId = processCtx.getProcInstDataInfo().getProcInstID().toString();
            WfScriptTracer tracer = new WfScriptTracer(procInstId);
            interpreter.setTracer((IDebugTracer)tracer);
            try {
                rtnVal = interpreter.eval(script, context);
            }
            catch (KScriptException e) {
                throw new WfException("eval condition error. script is :" + script, (Throwable)e);
            }
            if (rtnVal == null) {
                boolean bl = false;
                return bl;
            }
            if (rtnVal instanceof Boolean) {
                boolean bl = (Boolean)rtnVal;
                return bl;
            }
            log.warn((Object)("eval condition, return value 's type " + rtnVal.getClass().getName() + ".script is : " + script));
            if (rtnVal instanceof Number) {
                boolean bl = ((Number)rtnVal).intValue() == 1;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new WfException("WFE_SCRIPT_eval_condition", processCtx.getWfEngine().getLocale().getLanguage(), (Throwable)e).addArg(script);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScriptUtil.evalCondition[" + script + "] cost: " + lowTimer.msValue()));
            }
        }
    }

    public static Object evelScript(String script, ProcessInstInfo process, Locale locale, WfEngine engine) throws WfException {
        try {
            Object rtnVal;
            LowTimer lowTimer = new LowTimer();
            HashMap<String, ProcessControlDataKScriptAdapter> context = new HashMap<String, ProcessControlDataKScriptAdapter>();
            context.putAll(ScriptUtil.getInnerVariables(engine.getProcessDef(process.getProcDefHashValue())));
            context.put("currentInstance", new ProcessControlDataKScriptAdapter(process, locale, engine));
            Interpreter interpreter = new Interpreter(EnactmentUtils.cloneContext(engine.context()));
            interpreter.setProperyExprOwnerNullIgore(true);
            try {
                rtnVal = interpreter.eval(script, context);
            }
            catch (KScriptException e) {
                throw new WfException("eval script error. script is :" + script, (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScriptUtil.evelScript cost: " + lowTimer.msValue()));
            }
            return rtnVal;
        }
        catch (Throwable t) {
            log.error((Object)("error occured when evel script:" + script), t);
            return null;
        }
    }

    public static Object executeScriptReturnValue(String script, WfActivity activity, Map parameters) throws WfException {
        if (script == null || script.length() == 0) {
            return null;
        }
        LowTimer lowTimer = new LowTimer();
        Object returnValue = null;
        try {
            WfEngine engine = activity.getWfEngine();
            ProcessInstInfo process = engine.getProcessInst(activity.getProcInstId()).getProcessMeta();
            Locale locale = engine.getLocale();
            parameters.put("currentInstance", new ProcessControlDataKScriptAdapter(process, locale, engine));
            parameters.putAll(ScriptUtil.getInnerVariables(activity));
        }
        catch (Exception ex) {
            throw new WfException("error occured when init Process Script Context", (Throwable)ex);
        }
        Context context = EnactmentUtils.getApplicationContext(activity);
        try {
            context.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            Interpreter interpreter = new Interpreter(context);
            interpreter.setProperyExprOwnerNullIgore(true);
            returnValue = interpreter.eval(script, parameters);
        }
        catch (Throwable ex) {
            String lang = activity.getWfEngine().getLocale().getLanguage();
            throw new WfException("WFE_SCRIPT_eval_return", lang, ex).addArg(script);
        }
        finally {
            context.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScriptUtil.evelScript cost: " + lowTimer.msValue()));
            }
        }
        return returnValue;
    }

    public static Object executeScriptReturnValue(String script, WfActivity activity, Map parameters, Context otherSysCtx) throws WfException {
        log.error((Object)"======= OtherSys executeScript begin =======");
        if (script == null || script.length() == 0) {
            return null;
        }
        LowTimer lowTimer = new LowTimer();
        Object returnValue = null;
        try {
            WfEngine engine = activity.getWfEngine();
            ProcessInstInfo process = engine.getProcessInst(activity.getProcInstId()).getProcessMeta();
            Locale locale = engine.getLocale();
            parameters.put("currentInstance", new ProcessControlDataKScriptAdapter(process, locale, engine));
            parameters.putAll(ScriptUtil.getInnerVariables(activity));
        }
        catch (Exception ex) {
            throw new WfException("error occured when init Process Script Context", (Throwable)ex);
        }
        Context context = EnactmentUtils.getApplicationContext(activity);
        try {
            context.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            context.put((Object)"otherSysTaskId", otherSysCtx.get((Object)"otherSysTaskId"));
            Interpreter interpreter = new Interpreter(context);
            interpreter.setProperyExprOwnerNullIgore(true);
            returnValue = interpreter.eval(script, parameters);
        }
        catch (Throwable ex) {
            String lang = activity.getWfEngine().getLocale().getLanguage();
            throw new WfException("WFE_SCRIPT_eval_return", lang, ex).addArg(script);
        }
        finally {
            context.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScriptUtil.evelScript cost: " + lowTimer.msValue()));
            }
        }
        log.error((Object)"======= OtherSys executeScript begin =======");
        return returnValue;
    }

    public static void executeScript(String script, WfActivity activity, Map parameters) throws WfException {
        ScriptUtil.executeScriptReturnValue(script, activity, parameters);
    }

    public static Object evalObjectProperty(String propertyExpr, Object objectInstance) throws WfException {
        return ScriptUtil.evalObjectProperty(propertyExpr, objectInstance, null);
    }

    public static Object evalObjectProperty(String propertyExpr, Object objectInstance, Context context) throws WfException {
        LowTimer lowTimer = new LowTimer();
        if (propertyExpr == null || propertyExpr.length() == 0) {
            return null;
        }
        Context ctx = EnactmentUtils.cloneContext(context);
        Interpreter interpreter = new Interpreter(ctx);
        interpreter.setDefaultObject(objectInstance);
        interpreter.setProperyExprOwnerNullIgore(true);
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("disablePermissionForKScript", Boolean.TRUE);
        Object rtnVal = null;
        try {
            rtnVal = interpreter.eval(propertyExpr, data);
        }
        catch (KScriptException e) {
            throw new WfException("WFE_SCRIPT_eval_property", null, (Throwable)e).addArg(objectInstance.toString()).addArg(propertyExpr);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ScriptUtil.evalObjectProperty cost: " + lowTimer.msValue()));
        }
        return rtnVal;
    }

    private static boolean isAggregate(String property) {
        if (property != null) {
            if ((property = property.toLowerCase(Locale.ENGLISH)).equals("selecteditems") || property.equals("selectedopinions")) {
                return false;
            }
            if (property.indexOf("sum") >= 0 || property.indexOf("count") >= 0 || property.indexOf("max") >= 0 || property.indexOf("min") >= 0 || property.indexOf("avg") >= 0 || property.indexOf("first") >= 0 || property.indexOf("all") >= 0 || property.indexOf("select") >= 0 || property.indexOf("getbyindex") >= 0) {
                return true;
            }
        }
        return false;
    }

    public static Object getProperty(IObjectValue ov, String property, Context ctx) throws WfException {
        Object rtnObj = null;
        if (ov != null && property != null && property.trim().length() > 0) {
            if (property.indexOf(".") > 0) {
                String currentProperty = property.substring(0, property.indexOf("."));
                Object obj = ScriptUtil.getFinalProperty(ov, currentProperty, ctx);
                if (obj != null && obj instanceof IObjectCollection) {
                    IObjectCollection oc = (IObjectCollection)obj;
                    obj = oc.size() > 0 ? oc.getObject(0) : null;
                }
                rtnObj = ScriptUtil.getProperty((IObjectValue)obj, property.substring(currentProperty.length() + 1), ctx);
            } else {
                rtnObj = ScriptUtil.getFinalProperty(ov, property, ctx);
            }
        }
        return rtnObj;
    }

    private static Object getFinalProperty(IObjectValue ov, String property, Context ctx) throws WfException {
        Object rtnObj = null;
        if (ov != null && !StringUtils.isEmpty((String)property)) {
            try {
                rtnObj = VOUtil.getProperty((IObjectValue)ov, (String)property, (BOSObjectType)ov.getBOSType(), (Context)ctx);
            }
            catch (ReflectException e) {
                log.error((Object)("getproperty ReflectException error.class:" + ov.getClass().toString() + " property:" + property), (Throwable)e);
            }
            catch (PropertyNotFoundException e) {
                throw new WfException("getproperty PropertyNotFoundException error.class:" + ov.getClass().toString() + " property:" + property, (Throwable)e);
            }
        }
        return rtnObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map evalPropertyExpr(Map properties, Map boMap, Context ctx, ProcessContext processContext) throws WfException {
        LowTimer lowTimer = new LowTimer();
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(ScriptUtil.class.getName(), "evalPropertyExpr", null);
        }
        try {
            HashMap objMap = new HashMap();
            String script = "";
            HashMap returnMap = new HashMap();
            boolean flag = false;
            String bizObjType = "";
            IObjectValue defaultObjVal = null;
            SelectorItemCollection selectors = new SelectorItemCollection();
            for (Map.Entry entry : properties.entrySet()) {
                FormalParameterDef fpdef = (FormalParameterDef)entry.getValue();
                String string = fpdef.getPropertyName();
                if (StringUtils.isEmpty((String)string) && "63D30103".equals(fpdef.getBoId())) {
                    selectors.add(new SelectorItemInfo("id"));
                    selectors.add(new SelectorItemInfo("isPass"));
                    selectors.add(new SelectorItemInfo("opinion"));
                    selectors.add(new SelectorItemInfo("handlerOpinion"));
                    selectors.add(new SelectorItemInfo("multiHandleOpinion"));
                    selectors.add(new SelectorItemInfo("creator.id"));
                    selectors.add(new SelectorItemInfo("creator.number"));
                    selectors.add(new SelectorItemInfo("createTime"));
                    selectors.add(new SelectorItemInfo("creator.name"));
                    continue;
                }
                if (BasicType.BIZOBJ.equals((Object)fpdef.getDataType())) {
                    bizObjType = fpdef.getBoId();
                    continue;
                }
                selectors.add(new SelectorItemInfo(string));
            }
            Iterator propIt = null;
            for (Map.Entry entry2 : boMap.entrySet()) {
                Object k = entry2.getKey();
                Object obj = entry2.getValue();
                IObjectValue boValue = null;
                if (obj != null && !"".equals(obj)) {
                    if (obj instanceof IObjectValue) {
                        boValue = (IObjectValue)obj;
                        String orgSelector = ScriptUtil.getOrgSelector(ctx, boValue.getBOSType());
                        if (orgSelector != null && orgSelector.trim().length() > 0) {
                            boValue.setExtendedProperty(ORG_SELECTOR, orgSelector);
                        }
                    } else {
                        if (!(obj instanceof String) && !(obj instanceof BOSUuid) && !(obj instanceof ObjectUuidPK)) throw new WfException("WFE_SCRIPT_eval_unsupportType").addArg(obj == null ? null : obj.getClass().getName());
                        long startTime = System.currentTimeMillis();
                        String orgSelector = ScriptUtil.getOrgSelector(ctx, obj.toString());
                        if (orgSelector != null && orgSelector.trim().length() > 0) {
                            selectors.add(new SelectorItemInfo(orgSelector));
                        }
                        boValue = ScriptUtil.getBizObject(ctx, obj.toString(), selectors);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Get entity consume :" + (System.currentTimeMillis() - startTime)));
                        }
                        if (boValue != null) {
                            boMap.put(k, boValue);
                            boValue.setExtendedProperty(ORG_SELECTOR, orgSelector);
                        } else {
                            log.warn((Object)("get obj null.boId" + obj.toString()));
                        }
                    }
                } else {
                    log.error((Object)("un expected: boMap.get(name):obj=" + obj + ",name=" + k));
                }
                if (boValue == null) continue;
                String typeStirng = boValue.getBOSType().toString();
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                if (bizObjType != null && bizObjType.equals(typeStirng)) {
                    flag = true;
                }
                for (Map.Entry entry : properties.entrySet()) {
                    String propertyname = ((FormalParameterDef)entry.getValue()).getPropertyName().toString();
                    String boid = ((FormalParameterDef)entry.getValue()).getBoId();
                    if (boid.equals(typeStirng) || ScriptUtil.isExtend(boid, typeStirng, loader)) {
                        defaultObjVal = boValue;
                        flag = true;
                        if (propertyname != null && propertyname.indexOf(".") > 0 && !ScriptUtil.isAggregate(propertyname)) {
                            String string = propertyname.substring(propertyname.lastIndexOf(".") + 1, propertyname.length());
                            script = propertyname.substring(0, propertyname.lastIndexOf(".")) + "." + string;
                        } else {
                            script = propertyname;
                        }
                        try {
                            void var23_37;
                            Object var23_30 = null;
                            long time = System.currentTimeMillis();
                            if (ScriptUtil.isAggregate(script)) {
                                Interpreter interpreter = new Interpreter(ctx);
                                interpreter.setProperyExprOwnerNullIgore(true);
                                interpreter.setDefaultObject((Object)defaultObjVal);
                                if (script.indexOf("getByIndex") != -1) {
                                    script = ScriptUtil.buildScriptContext4EvalGetByIndex(script, processContext);
                                    script = ScriptUtil.toArrayIndexExpr(script);
                                    Object object = interpreter.eval(script, objMap);
                                } else if (script.startsWith("all") && script.split("\\.").length >= 2) {
                                    int p = script.indexOf(".");
                                    int i = script.indexOf("(");
                                    int j = script.indexOf(")");
                                    String entryName = script.substring(i + 1, p);
                                    int n = ((IObjectCollection)interpreter.eval(entryName, objMap)).size();
                                    String subExpr = script.substring(i + 1, j);
                                    int m = subExpr.indexOf(".");
                                    ArrayList<Object> list = new ArrayList<Object>();
                                    for (int k2 = 0; k2 < n; ++k2) {
                                        String x = "[" + k2 + "]";
                                        StringBuilder newStr = new StringBuilder(subExpr);
                                        newStr.insert(m, x);
                                        Object o = interpreter.eval(newStr.toString(), objMap);
                                        list.add(o);
                                    }
                                    ArrayList<Object> arrayList = list;
                                } else {
                                    Object object = interpreter.eval(script, objMap);
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("aggregate script[" + script + "] get property cost:" + (System.currentTimeMillis() - time)));
                                    time = System.currentTimeMillis();
                                }
                            } else if (StringUtils.isEmpty((String)propertyname) && "63D30103".equals(boid)) {
                                IObjectValue iObjectValue = boValue;
                            } else {
                                Object object = ScriptUtil.getProperty(boValue, script, ctx);
                            }
                            if (var23_37 == null) {
                                log.error((Object)("propertyname:" + propertyname + " , objValue is null"));
                            }
                            if ("orgdepartment.id".equals(propertyname)) {
                                log.error((Object)("propertyname:" + propertyname + " , objValue is " + var23_37));
                            }
                            returnMap.put(entry.getKey(), var23_37);
                            continue;
                        }
                        catch (KScriptException kScriptException) {
                            throw new WfException("eval script error. script is :" + script, (Throwable)kScriptException);
                        }
                    }
                    log.error((Object)("not match bo.bo:" + boid + " type:" + typeStirng));
                }
                if (!flag) {
                    log.error((Object)("Fatal Error. evalPropertyExpr, can not get match object.objectValue:" + boValue));
                    continue;
                }
                String orgField = boValue.getExtendedProperty(ORG_SELECTOR);
                if (orgField == null || orgField.trim().length() <= 0) continue;
                try {
                    Object value = ScriptUtil.getProperty(boValue, orgField, ctx);
                    String objValPkField = boValue.getPKField();
                    if (objValPkField == null || objValPkField.trim().length() == 0) {
                        log.debug((Object)("Get PKField null" + boValue));
                        objValPkField = "id";
                    }
                    Object object = boValue.get(objValPkField);
                    if (value == null || object == null) continue;
                    HashMap<String, Object> orgMap = new HashMap<String, Object>();
                    orgMap.put(object.toString(), value);
                    returnMap.put(RuntimeSystemVariable.ORGMAP.getValue(), orgMap);
                }
                catch (Exception exception) {}
            }
            HashMap hashMap = returnMap;
            return hashMap;
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ScriptUtil.evalPropertyExpr cost: " + lowTimer.msValue()));
            }
        }
    }

    private static String toArrayIndexExpr(String expr) {
        int i = expr.indexOf("(");
        int j = expr.indexOf(")");
        String subExpr = expr.substring(i + 1, j);
        String[] sub = subExpr.split(",");
        String index = "[" + sub[1] + "]";
        int k = sub[0].indexOf(".");
        StringBuilder sb = new StringBuilder(sub[0]);
        sb.insert(k, index);
        return sb.toString();
    }

    private static String buildScriptContext4EvalGetByIndex(String script, ProcessContext processContext) {
        String newScript = "";
        int index1 = script.indexOf(",");
        int index2 = script.indexOf(")");
        String strIndex = script.substring(index1 + 1, index2);
        try {
            Integer.parseInt(strIndex);
            return script;
        }
        catch (NumberFormatException e) {
            Object objIndex = processContext.getDataFieldValue(strIndex);
            if (objIndex instanceof Integer) {
                newScript = script.substring(0, index1 + 1) + objIndex + script.substring(index2);
                return newScript;
            }
            throw new IllegalArgumentException("error! objIndex:" + objIndex);
        }
    }

    private static String getOrgSelector(Context ctx, String objId) {
        BOSObjectType objectType = null;
        try {
            objectType = new ObjectUuidPK(objId).getObjectType();
        }
        catch (RuntimeException e) {
            log.error((Object)("read objId error." + objId), (Throwable)e);
        }
        return ScriptUtil.getOrgSelector(ctx, objectType);
    }

    private static String getOrgSelector(Context ctx, BOSObjectType objectType) {
        if (objectType == null) {
            return null;
        }
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(objectType);
        String orgType = null;
        if (entityObjectInfo != null) {
            orgType = entityObjectInfo.getExtendedProperty("OrgType");
        }
        if (orgType != null) {
            if ("Company".equalsIgnoreCase(orgType)) {
                return "company.id";
            }
            if ("ControlUnit".equalsIgnoreCase(orgType)) {
                return "CU.id";
            }
        }
        return null;
    }

    public static IObjectValue getBizObject(Context ctx, String objId, SelectorItemCollection selectors) throws WfException {
        return ScriptUtil.getBizObject(ctx, objId, selectors, false);
    }

    public static IObjectValue getBizObject(Context ctx, String objId, SelectorItemCollection selectors, boolean isBizObj) throws WfException {
        IObjectValue bo = null;
        try {
            bo = FunctionHelper.createObjectValueByBoId(objId, ctx, selectors);
        }
        catch (BOSException e) {
            String msg = "getBizObject Error. id:" + objId + " selector:" + selectors;
            log.error((Object)msg, (Throwable)e);
            throw new BizObjectNotFoundException(msg, (Throwable)e);
        }
        return bo;
    }

    private static boolean isExtend(String type, String selfType, IMetaDataLoader loader) {
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)selfType));
        EntityObjectInfo parentEntity = entity.getBaseEntity();
        if (parentEntity == null) {
            return false;
        }
        String parentType = parentEntity.getType().toString();
        if (parentType.equalsIgnoreCase(type)) {
            return true;
        }
        return ScriptUtil.isExtend(type, parentType, loader);
    }

    public static Map getInnerVariables(ProcessDef processDef) {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        InnerVariableManager inners = new InnerVariableManager(processDef);
        Map innerVars = inners.getVariableMap();
        for (Map.Entry entry : innerVars.entrySet()) {
            InnerVariable inner = (InnerVariable)entry.getValue();
            if (inner.getType() != 1) continue;
            retValue.put(inner.getName(), inner.getValue());
        }
        return retValue;
    }

    public static Map getInnerVariables(WfActivity wfActivity) {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        InnerVariableManager inners = new InnerVariableManager(wfActivity);
        Map innerVars = inners.getVariableMap();
        for (Map.Entry entry : innerVars.entrySet()) {
            InnerVariable inner = (InnerVariable)entry.getValue();
            if (inner.getType() != 2 && inner.getType() != 1) continue;
            retValue.put(inner.getName(), inner.getValue());
        }
        return retValue;
    }

    public static String getClassLoadPath(String className) {
        String rtn = null;
        try {
            if (className.charAt(0) != '/') {
                className = "/" + className;
            }
            className = className.replace('.', '/');
            className = className + ".class";
            URL classUrl = ScriptUtil.class.getClassLoader().getResource(className);
            if (classUrl != null) {
                rtn = classUrl.getFile();
            }
        }
        catch (Throwable e) {
            rtn = null;
        }
        return rtn;
    }
}

