/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ScriptFunctionUtil;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionInfo;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionPackageInfo;
import com.kingdee.bos.workflow.wfdesigner.service.DBOperationBridge;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FunctionStorer {
    private DBOperationBridge bridge;
    private Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.FunctionStorer");

    FunctionStorer(DBOperationBridge bridge) {
        this.bridge = bridge;
    }

    public Connection getConnection() throws SQLException {
        return this.bridge.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addWfFunctionInfo(List<WfFunctionInfo> infos) throws SQLException {
        boolean rts = false;
        String sql = "INSERT INTO T_WFD_FUNCTIONS (FID,FNAME,FHASHKEY,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName) VALUES (?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(sql);
            for (WfFunctionInfo info : infos) {
                stmt.setString(1, BOSUuid.create((String)"WFFD").toString());
                stmt.setString(2, info.getName());
                stmt.setInt(3, info.getContent().hashCode());
                stmt.setString(4, info.getContent());
                stmt.setTimestamp(5, new Timestamp(new Date().getTime()));
                stmt.setString(6, info.getPackageId());
                stmt.setString(7, info.getLastUpdateUserId());
                stmt.setString(8, info.getLastUpdateUserName());
                stmt.addBatch();
            }
            stmt.executeBatch();
            conn.commit();
            rts = true;
        }
        catch (SQLException e) {
            try {
                if (conn == null) throw e;
                conn.rollback();
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addWfFunctionInfo(WfFunctionInfo info) throws SQLException {
        String sql = "INSERT INTO T_WFD_FUNCTIONS (FID,FNAME,FHASHKEY,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName) VALUES (?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        String id = BOSUuid.create((String)"WFFD").toString();
        info.setId(id);
        info.setHashkey(info.getContent().hashCode());
        info.setLastUpdate(new Timestamp(new Date().getTime()));
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId());
            stmt.setString(2, info.getName());
            stmt.setInt(3, info.getHashkey());
            stmt.setString(4, info.getContent());
            stmt.setTimestamp(5, info.getLastUpdate());
            stmt.setString(6, info.getPackageId());
            stmt.setString(7, info.getLastUpdateUserId());
            stmt.setString(8, info.getLastUpdateUserName());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return id;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean modWfFunctionInfo(WfFunctionInfo info) throws SQLException {
        String sql = "UPDATE T_WFD_FUNCTIONS SET FNAME=?, FHASHKEY=?,FCONTENT=?,FLASTUPDATE=?,FPACKAGEID=?,FLastUpdateUserId=?,FLastUpdateUserName=? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        info.setHashkey(info.getContent().hashCode());
        info.setLastUpdate(new Timestamp(new Date().getTime()));
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getName());
            stmt.setInt(2, info.getHashkey());
            stmt.setString(3, info.getContent());
            stmt.setTimestamp(4, info.getLastUpdate());
            stmt.setString(5, info.getPackageId());
            stmt.setString(6, info.getLastUpdateUserId());
            stmt.setString(7, info.getLastUpdateUserName());
            stmt.setString(8, info.getId());
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delWfFunctionInfo(String id) throws SQLException {
        String sql = "DELETE T_WFD_FUNCTIONS WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delWfFunctionInfos(String[] ids) throws SQLException {
        if (ids == null) return false;
        if (ids.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer("DELETE T_WFD_FUNCTIONS WHERE FID in (?");
        for (int i = 1; i < ids.length; ++i) {
            sql.append(",?");
        }
        sql.append(')');
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addWfFunPackage(WfFunctionPackageInfo info) throws SQLException {
        String sql = "INSERT INTO T_WFD_FUNCTIONPACKAGE (FID, FPARENTID, FNAME, FCONTENT,FIsEdit) VALUES (?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        if (StringUtils.isEmpty((String)info.getId())) {
            String id = BOSUuid.create((String)"WFFP").toString();
            info.setId(id);
        }
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId());
            stmt.setString(2, info.getParentId());
            stmt.setString(3, info.getName());
            stmt.setString(4, info.getContent());
            stmt.setString(5, info.getIsEdit());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return info.getId();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean modWfFunctionPackage(WfFunctionPackageInfo info) throws SQLException {
        String sql = "UPDATE T_WFD_FUNCTIONPACKAGE SET FPARENTID=?, FNAME=?, FCONTENT=? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getParentId());
            stmt.setString(2, info.getName());
            stmt.setString(3, info.getContent());
            stmt.setString(4, info.getId());
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean modWfFunctionPackage(String id, String name) throws SQLException {
        String sql = "UPDATE T_WFD_FUNCTIONPACKAGE SET FNAME=? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, name);
            stmt.setString(2, id);
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delWfFunctionPackage(String id) throws SQLException {
        String sql = "DELETE T_WFD_FUNCTIONPACKAGE WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delWfFunctionPackages(String[] ids) throws SQLException {
        if (ids == null) return false;
        if (ids.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer("DELETE T_WFD_FUNCTIONPACKAGE WHERE FID in (?");
        for (int i = 1; i < ids.length; ++i) {
            sql.append(",?");
        }
        sql.append(')');
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getWfFunctionPackageRoot() throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFD_FUNCTIONPACKAGE WHERE FPARENTID = ? OR FPARENTID IS NULL ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WfFunctionPackageInfo> rts = new ArrayList<WfFunctionPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, "");
            rs = stmt.executeQuery();
            while (rs.next()) {
                WfFunctionPackageInfo info = new WfFunctionPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setIsEdit(rs.getString(4));
                info.setParentId("");
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getChildrenByPackageId(String id) throws SQLException {
        WfFunctionPackageInfo info;
        String sql1 = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFD_FUNCTIONPACKAGE WHERE FPARENTID = ? ORDER BY FNAME";
        String sql2 = "SELECT FID,FNAME,FHASHKEY,FCONTENT,FLASTUPDATE FROM T_WFD_FUNCTIONS WHERE FPACKAGEID = ? ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WfFunctionPackageInfo> rts = new ArrayList<WfFunctionPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new WfFunctionPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setIsEdit(rs.getString(4));
                info.setParentId(id);
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new WfFunctionInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setHashkey(rs.getInt(3));
                info.setContent(rs.getString(4));
                info.setLastUpdate(rs.getTimestamp(5));
                info.setPackageId(id);
                rts.add(info);
            }
            return rts;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                DBOperationBridge.cleanup(rs, stmt, conn);
            }
            catch (SQLException ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WfFunctionPackageInfo getWfFunctionPackageInfoById(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FPARENTID,FIsEdit FROM T_WFD_FUNCTIONPACKAGE WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        WfFunctionPackageInfo info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                info = new WfFunctionPackageInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setContent(rs.getString(3));
                info.setParentId(rs.getString(4));
                info.setIsEdit(rs.getString(5));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WfFunctionInfo getWfFunctionInfoById(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FHASHKEY,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName FROM T_WFD_FUNCTIONS WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        WfFunctionInfo info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new WfFunctionInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setHashkey(rs.getInt("FHASHKEY"));
                info.setContent(rs.getString("FCONTENT"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public List getPerformerChildrenByPackageId(String id) throws SQLException {
        List rts = this.getChildrenByPackageId(id);
        ArrayList<Object> performerFun = new ArrayList<Object>();
        for (Object o : rts) {
            if (o instanceof WfFunctionInfo) {
                String content = ((WfFunctionInfo)o).getContent();
                if (!this.funRetType(content)) continue;
                performerFun.add((WfFunctionInfo)o);
                continue;
            }
            performerFun.add(o);
        }
        return performerFun;
    }

    private boolean funRetType(String funcontent) {
        try {
            String returnType = ScriptFunctionUtil.parse((String)funcontent).getReturnType().toString();
            if ("PERFORMER".equals(returnType)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WfFunctionInfo> getWfFunctionInfoByIds(String[] ids) throws SQLException {
        String sql = "SELECT FID,FNAME,FHASHKEY,FCONTENT,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName  FROM T_WFD_FUNCTIONS WHERE FID in (";
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                sql = sql + "? ) ORDER BY FNAME";
                break;
            }
            sql = sql + "?,";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WfFunctionInfo> rts = new ArrayList<WfFunctionInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                WfFunctionInfo info = new WfFunctionInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setHashkey(rs.getInt("FHASHKEY"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setContent(rs.getString("FCONTENT"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WfFunctionInfo> getWfFunctionInfoByPackageId(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FHASHKEY,FLASTUPDATE,FPACKAGEID,FLastUpdateUserId,FLastUpdateUserName FROM T_WFD_FUNCTIONS WHERE FPACKAGEID = ? ORDER BY FLASTUPDATE DESC";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WfFunctionInfo> rts = new ArrayList<WfFunctionInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                WfFunctionInfo info = new WfFunctionInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setHashkey(rs.getInt("FHASHKEY"));
                info.setLastUpdate(rs.getTimestamp("FLASTUPDATE"));
                info.setPackageId(rs.getString("FPACKAGEID"));
                info.setLastUpdateUserId(rs.getString("FLastUpdateUserId"));
                info.setLastUpdateUserName(rs.getString("FLastUpdateUserName"));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WfFunctionPackageInfo> getWfFunctionPackageInfoByPid(String id) throws SQLException {
        String sql = "SELECT FID,FNAME,FCONTENT,FIsEdit FROM T_WFD_FUNCTIONPACKAGE WHERE FPARENTID = ? ORDER BY FNAME";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<WfFunctionPackageInfo> rts = new ArrayList<WfFunctionPackageInfo>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                WfFunctionPackageInfo info = new WfFunctionPackageInfo();
                info.setId(rs.getString("FID"));
                info.setName(rs.getString("FNAME"));
                info.setContent(rs.getString("FCONTENT"));
                info.setIsEdit(rs.getString("FIsEdit"));
                info.setParentId(id);
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

