/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.tools.script.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Main {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_CMD_NO_CLASSPATH = 1;
    private static final int EXIT_CMD_NO_FILE = 2;
    private static final int EXIT_CMD_NO_SCRIPT = 3;
    private static final int EXIT_CMD_NO_LANG = 4;
    private static final int EXIT_CMD_NO_ENCODING = 5;
    private static final int EXIT_CMD_NO_PROPNAME = 6;
    private static final int EXIT_UNKNOWN_OPTION = 7;
    private static final int EXIT_ENGINE_NOT_FOUND = 8;
    private static final int EXIT_NO_ENCODING_FOUND = 9;
    private static final int EXIT_SCRIPT_ERROR = 10;
    private static final int EXIT_FILE_NOT_FOUND = 11;
    private static final int EXIT_MULTIPLE_STDIN = 12;
    private static final String DEFAULT_LANGUAGE = "js";
    private static List<Command> scripts;
    private static ScriptEngineManager engineManager;
    private static Map<String, ScriptEngine> engines;
    private static ResourceBundle msgRes;
    private static String BUNDLE_NAME;
    private static String PROGRAM_NAME;

    static {
        BUNDLE_NAME = "com.apusic.tools.script.shell.messages";
        PROGRAM_NAME = "jrunscript";
        scripts = new ArrayList<Command>();
        engines = new HashMap<String, ScriptEngine>();
        msgRes = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    }

    public static void main(String[] args) {
        String[] scriptArgs = Main.processOptions(args);
        for (Command cmd : scripts) {
            cmd.run(scriptArgs);
        }
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    private static String[] processOptions(String[] args) {
        currentLanguage = "js";
        currentEncoding = null;
        Main.checkClassPath(args);
        seenScript = false;
        seenStdin = false;
        i = 0;
        while (i < args.length) {
            block27: {
                block29: {
                    block28: {
                        block26: {
                            arg = args[i];
                            if (!arg.equals("-classpath") && !arg.equals("-cp")) break block26;
                            ++i;
                            break block27;
                        }
                        if (!arg.startsWith("-")) {
                            if (seenScript) {
                                numScriptArgs = args.length - i;
                                startScriptArg = i;
                            } else {
                                numScriptArgs = args.length - i - 1;
                                startScriptArg = i + 1;
                                se = Main.getScriptEngine(currentLanguage);
                                Main.addFileSource(se, args[i], currentEncoding);
                            }
                            result = new String[numScriptArgs];
                            System.arraycopy(args, startScriptArg, result, 0, numScriptArgs);
                            return result;
                        }
                        if (!arg.startsWith("-D")) break block28;
                        value = arg.substring(2);
                        eq = value.indexOf(61);
                        if (eq != -1) {
                            System.setProperty(value.substring(0, eq), value.substring(eq + 1));
                        } else if (!value.equals("")) {
                            System.setProperty(value, "");
                        } else {
                            Main.usage(6);
                        }
                        break block27;
                    }
                    if (!arg.equals("-?") && !arg.equals("-help")) break block29;
                    Main.usage(0);
                    ** GOTO lbl76
                }
                if (arg.equals("-e")) {
                    seenScript = true;
                    if (++i == args.length) {
                        Main.usage(3);
                    }
                    se = Main.getScriptEngine(currentLanguage);
                    Main.addStringSource(se, args[i]);
                } else if (arg.equals("-encoding")) {
                    if (++i == args.length) {
                        Main.usage(5);
                    }
                    currentEncoding = args[i];
                } else if (arg.equals("-f")) {
                    seenScript = true;
                    if (++i == args.length) {
                        Main.usage(2);
                    }
                    se = Main.getScriptEngine(currentLanguage);
                    if (args[i].equals("-")) {
                        if (seenStdin) {
                            Main.usage(12);
                        } else {
                            seenStdin = true;
                        }
                        Main.addInteractiveMode(se);
                    } else {
                        Main.addFileSource(se, args[i], currentEncoding);
                    }
                } else if (arg.equals("-l")) {
                    if (++i == args.length) {
                        Main.usage(4);
                    }
                    currentLanguage = args[i];
                } else {
                    if (arg.equals("-q")) {
                        Main.listScriptEngines();
                    }
lbl76:
                    // 4 sources

                    Main.usage(7);
                }
            }
            ++i;
        }
        if (!seenScript) {
            se = Main.getScriptEngine(currentLanguage);
            Main.addInteractiveMode(se);
        }
        return new String[0];
    }

    private static void addInteractiveMode(final ScriptEngine se) {
        scripts.add(new Command(){

            public void run(String[] args) {
                Main.setScriptArguments(se, args);
                Main.processSource(se, "-", null);
            }
        });
    }

    private static void addFileSource(final ScriptEngine se, final String fileName, final String encoding) {
        scripts.add(new Command(){

            public void run(String[] args) {
                Main.setScriptArguments(se, args);
                Main.processSource(se, fileName, encoding);
            }
        });
    }

    private static void addStringSource(final ScriptEngine se, final String source) {
        scripts.add(new Command(){

            public void run(String[] args) {
                Main.setScriptArguments(se, args);
                String oldFile = Main.setScriptFilename(se, "<string>");
                try {
                    Main.evaluateString(se, source);
                }
                finally {
                    Main.setScriptFilename(se, oldFile);
                }
            }
        });
    }

    private static void listScriptEngines() {
        List<ScriptEngineFactory> factories = engineManager.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            Main.getError().println(Main.getMessage("engine.info", new Object[]{factory.getLanguageName(), factory.getLanguageVersion(), factory.getEngineName(), factory.getEngineVersion()}));
        }
        System.exit(0);
    }

    private static void processSource(ScriptEngine se, String filename, String encoding) {
        if (filename.equals("-")) {
            BufferedReader in = new BufferedReader(new InputStreamReader(Main.getIn()));
            boolean hitEOF = false;
            String prompt = Main.getPrompt(se);
            se.put("javax.script.filename", "<STDIN>");
            while (!hitEOF) {
                Main.getError().print(prompt);
                String source = "";
                try {
                    source = in.readLine();
                }
                catch (IOException ioe) {
                    Main.getError().println(ioe.toString());
                }
                if (source == null) {
                    hitEOF = true;
                    break;
                }
                Object res = Main.evaluateString(se, source, false);
                if (res == null) continue;
                if ((res = res.toString()) == null) {
                    res = "null";
                }
                Main.getError().println(res);
            }
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Main.getError().println(Main.getMessage("file.not.found", new Object[]{filename}));
                System.exit(11);
            }
            Main.evaluateStream(se, fis, filename, encoding);
        }
    }

    private static Object evaluateString(ScriptEngine se, String script, boolean exitOnError) {
        block4: {
            try {
                return se.eval(script);
            }
            catch (ScriptException sexp) {
                Main.getError().println(Main.getMessage("string.script.error", new Object[]{sexp.getMessage()}));
                if (exitOnError) {
                    System.exit(10);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace(Main.getError());
                if (!exitOnError) break block4;
                System.exit(10);
            }
        }
        return null;
    }

    private static void evaluateString(ScriptEngine se, String script) {
        Main.evaluateString(se, script, true);
    }

    private static Object evaluateReader(ScriptEngine se, Reader reader, String name) {
        String oldFilename = Main.setScriptFilename(se, name);
        try {
            Object object = se.eval(reader);
            return object;
        }
        catch (ScriptException sexp) {
            Main.getError().println(Main.getMessage("file.script.error", new Object[]{name, sexp.getMessage()}));
            System.exit(10);
        }
        catch (Exception exp) {
            exp.printStackTrace(Main.getError());
            System.exit(10);
        }
        finally {
            Main.setScriptFilename(se, oldFilename);
        }
        return null;
    }

    private static Object evaluateStream(ScriptEngine se, InputStream is, String name, String encoding) {
        BufferedReader reader = null;
        if (encoding != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(is, encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Main.getError().println(Main.getMessage("encoding.unsupported", new Object[]{encoding}));
                System.exit(9);
            }
        } else {
            reader = new BufferedReader(new InputStreamReader(is));
        }
        return Main.evaluateReader(se, reader, name);
    }

    private static void usage(int exitCode) {
        Main.getError().println(Main.getMessage("main.usage", new Object[]{PROGRAM_NAME}));
        System.exit(exitCode);
    }

    private static String getPrompt(ScriptEngine se) {
        List<String> names = se.getFactory().getNames();
        return String.valueOf(names.get(0)) + "> ";
    }

    private static String getMessage(String key, Object[] params) {
        return MessageFormat.format(msgRes.getString(key), params);
    }

    private static InputStream getIn() {
        return System.in;
    }

    private static PrintStream getError() {
        return System.err;
    }

    private static ScriptEngine getScriptEngine(String lang) {
        ScriptEngine se = engines.get(lang);
        if (se == null) {
            se = engineManager.getEngineByName(lang);
            if (se == null) {
                Main.getError().println(Main.getMessage("engine.not.found", new Object[]{lang}));
                System.exit(8);
            }
            Main.initScriptEngine(se);
            engines.put(lang, se);
        }
        return se;
    }

    private static void initScriptEngine(ScriptEngine se) {
        se.put("engine", se);
        List<String> exts = se.getFactory().getExtensions();
        InputStream sysIn = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String ext : exts) {
            sysIn = cl.getResourceAsStream("com/apusic/tools/script/shell/init." + ext);
            if (sysIn != null) break;
        }
        if (sysIn != null) {
            Main.evaluateStream(se, sysIn, "<system-init>", null);
        }
    }

    private static void checkClassPath(String[] args) {
        String classPath = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-classpath") || args[i].equals("-cp")) {
                if (++i == args.length) {
                    Main.usage(1);
                } else {
                    classPath = args[i];
                }
            }
            ++i;
        }
        if (classPath != null) {
            ClassLoader parent = Main.class.getClassLoader();
            URL[] urls = Main.pathToURLs(classPath);
            URLClassLoader loader = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(loader);
        }
        engineManager = new ScriptEngineManager();
    }

    private static URL[] pathToURLs(String path) {
        String[] components = path.split(File.pathSeparator);
        URL[] urls = new URL[components.length];
        int count = 0;
        while (count < components.length) {
            URL url = Main.fileToURL(new File(components[count]));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = String.valueOf(name) + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    private static void setScriptArguments(ScriptEngine se, String[] args) {
        se.put("arguments", args);
        se.put("javax.script.argv", args);
    }

    private static String setScriptFilename(ScriptEngine se, String name) {
        String oldName = (String)se.get("javax.script.filename");
        se.put("javax.script.filename", name);
        return oldName;
    }

    private static interface Command {
        public void run(String[] var1);
    }
}

