/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cm.module.template.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMClassFactory;
import com.kingdee.eas.cp.eip.cm.CMClassInfo;
import com.kingdee.eas.cp.eip.cm.CMTemplateCollection;
import com.kingdee.eas.cp.eip.cm.CMTemplateFactory;
import com.kingdee.eas.cp.eip.cm.CMTemplateInfo;
import com.kingdee.eas.cp.eip.cm.ICMClass;
import com.kingdee.eas.cp.eip.cm.ICMTemplate;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cm.module.template.dto.CmTemplateDto;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;

public class TemplateAction
extends BaseAction {
    public String templateManager() {
        boolean hasLicense = LicenseTool.checkLicense(this.getRequest(), CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        return "success";
    }

    public String toTemplateDetail() {
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        String templateId = this.getRequest().getParameter("id");
        CmTemplateDto cmTemplateDto = new CmTemplateDto();
        if (!StringUtils.isEmpty((String)templateId)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            try {
                ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
                CMTemplateInfo cmTemplate = iCMTemplate.getCMTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)templateId)));
                cmTemplateDto.setId(cmTemplate.getId().toString());
                cmTemplateDto.setTitle(cmTemplate.getTitle());
                cmTemplateDto.setDesc(cmTemplate.getDesc());
                cmTemplateDto.setContent(cmTemplate.getContent());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
        }
        this.getRequest().setAttribute("cmTemplateDto", (Object)cmTemplateDto);
        return "success";
    }

    public void getTemplateById() {
        String templateId = this.getRequest().getParameter("id");
        CmTemplateDto cmTemplateDto = new CmTemplateDto();
        if (!StringUtils.isEmpty((String)templateId)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            try {
                ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
                CMTemplateInfo cmTemplate = iCMTemplate.getCMTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)templateId)));
                cmTemplateDto.setId(cmTemplate.getId().toString());
                cmTemplateDto.setTitle(cmTemplate.getTitle());
                cmTemplateDto.setDesc(cmTemplate.getDesc());
                cmTemplateDto.setContent(cmTemplate.getContent());
                this.writeAjaxData(true, null, cmTemplateDto);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
        }
    }

    public void getTemplateTree() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
            CMTemplateCollection cMTemplateCollection = iCMTemplate.getCMTemplateCollection("order by title asc");
            ArrayList<CmTemplateDto> templateDtoList = new ArrayList<CmTemplateDto>();
            for (int i = 0; i < cMTemplateCollection.size(); ++i) {
                CmTemplateDto cmTemplateDto = new CmTemplateDto();
                cmTemplateDto.setId(cMTemplateCollection.get(i).getId().toString());
                cmTemplateDto.setTitle(cMTemplateCollection.get(i).getTitle());
                cmTemplateDto.setDesc(cMTemplateCollection.get(i).getDesc());
                cmTemplateDto.setContent(cMTemplateCollection.get(i).getContent());
                templateDtoList.add(cmTemplateDto);
            }
            this.writeAjaxData(true, null, templateDtoList);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void getTemplateContenByClassId() {
        String classId = this.getRequest().getParameter("classId");
        String templateDoc = "";
        if (classId != null && classId.trim().length() > 0) {
            try {
                ICMTemplate iCMTemplate;
                CMTemplateInfo info;
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                CMClassInfo classInfo = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(classId));
                if (null != classInfo && null != classInfo.getTemplateID() && !classInfo.getTemplateID().toString().equals("") && null != (info = (CMTemplateInfo)(iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx)).getValue((IObjectPK)new ObjectUuidPK(classInfo.getTemplateID())))) {
                    templateDoc = info.getContent();
                }
                this.writeAjaxData(true, null, templateDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeAjaxData(false, null, templateDoc);
            }
        } else {
            this.writeAjaxData(false, null, templateDoc);
        }
    }

    public void saveTemplate() {
        String id = this.getRequest().getParameter("id");
        String tempTitle = this.getRequest().getParameter("tempTitle");
        String regex = "['.<>()=/*|]";
        tempTitle = Pattern.compile(regex).matcher(tempTitle).replaceAll("");
        String tempDesc = this.getRequest().getParameter("tempDesc");
        tempDesc = Pattern.compile(regex).matcher(tempDesc).replaceAll("");
        String tempContent = this.getRequest().getParameter("tempContent");
        tempContent = Pattern.compile(regex).matcher(tempContent).replaceAll("");
        String unEscapeHtmpContent = StringEscapeUtils.unescapeHtml((String)tempContent);
        unEscapeHtmpContent = Pattern.compile(regex).matcher(unEscapeHtmpContent).replaceAll("");
        tempContent = unEscapeHtmpContent;
        if (tempContent.contains("alert")) {
            this.writeAjaxData(false, null, "\u4fdd\u5b58\u5931\u8d25,\u5b58\u5728\u975e\u6cd5\u5b57\u7b26");
            return;
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
            if (StringUtils.isEmpty((String)id)) {
                CMTemplateInfo cMTemplateInfo = new CMTemplateInfo();
                BOSUuid fid = BOSUuid.create((BOSObjectType)cMTemplateInfo.getBOSType());
                cMTemplateInfo.setId(fid);
                cMTemplateInfo.setTitle(tempTitle);
                cMTemplateInfo.setDesc(tempDesc);
                cMTemplateInfo.setContent(tempContent);
                id = iCMTemplate.addnew((CoreBaseInfo)cMTemplateInfo).toString();
            } else if (iCMTemplate.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) {
                CMTemplateInfo cMTemplateInfo = (CMTemplateInfo)iCMTemplate.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                cMTemplateInfo.setTitle(tempTitle);
                cMTemplateInfo.setDesc(tempDesc);
                cMTemplateInfo.setContent(tempContent);
                iCMTemplate.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (CoreBaseInfo)cMTemplateInfo);
            }
            this.writeAjaxData(true, null, id);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void deleteTemplate() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            String id = this.getRequest().getParameter("id");
            if (StringUtils.isEmpty((String)id)) {
                this.writeAjaxData(false, null, "0");
            } else {
                ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
                ICMTemplate iCMTemplate = CMTemplateFactory.getLocalInstance((Context)ctx);
                CoreBaseCollection infos = iCMClass.getCollection(" select templateID where templateID='" + id + "'");
                if (infos.size() > 0) {
                    this.writeAjaxData(false, null, "1");
                } else if (iCMTemplate.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) {
                    iCMTemplate.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.writeAjaxData(true, null, null);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }
}

