/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.common.util.FileUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.enums.DocTypeEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.exception.conf.ServiceErrConfig;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceDocumentDAO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDocument;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDocumentService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ServiceDocumentServiceImpl
implements ServiceDocumentService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServiceDocumentDAO serviceDocumentDAO;
    private ServiceDefinitionService serviceDefinitionService;

    @Override
    public ServiceDocument saveDocument(PortalContext portalContext, ServiceDocument serviceDocument, FileModel fileModel, boolean updateDoc) throws ServiceBizException {
        if (StringUtil.isEmpty((String)serviceDocument.getId())) {
            return this.createDocument(portalContext, serviceDocument, DocTypeEnum.DOC, fileModel, updateDoc);
        }
        return this.updateDocument(portalContext, serviceDocument, DocTypeEnum.DOC, fileModel, updateDoc);
    }

    @Override
    public boolean isManagerForCurrentUser(PortalContext portalContext, String serviceDefId) throws ServiceBizException {
        if ("administrator".equalsIgnoreCase(portalContext.getLoginUser().getCode())) {
            return true;
        }
        ServiceDefinition serviceDefinition = this.serviceDefinitionService.findServiceDefinitionById(portalContext, serviceDefId);
        return serviceDefinition != null && portalContext.getLoginUser().getId().equals(serviceDefinition.getManagerId());
    }

    @Override
    public ServiceDocument saveFlowchart(PortalContext portalContext, String serviceDefId, FileModel fileModel) throws ServiceBizException {
        try {
            ServiceDocument serviceDocument = new ServiceDocument();
            serviceDocument.setServiceDefId(serviceDefId);
            serviceDocument.setDocType(DocTypeEnum.FLOWCHART);
            serviceDocument = (ServiceDocument)((Object)this.serviceDocumentDAO.findObject((Object)serviceDocument, new Filter[0]));
            if (serviceDocument == null) {
                serviceDocument = new ServiceDocument();
                DisplayName displayName = new DisplayName();
                displayName.setEn("view FlowChart");
                displayName.setZh_CN("\u67e5\u770b\u6d41\u7a0b\u56fe");
                displayName.setZh_TW("\u67e5\u770b\u6d41\u7a0b\u5716");
                serviceDocument.setDisplayName(displayName.toString());
                serviceDocument.setDocType(DocTypeEnum.FLOWCHART);
                serviceDocument.setServiceDefId(serviceDefId);
                return this.createDocument(portalContext, serviceDocument, DocTypeEnum.FLOWCHART, fileModel, true);
            }
            return this.updateDocument(portalContext, serviceDocument, DocTypeEnum.FLOWCHART, fileModel, true);
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_FIND_ERR, ex);
        }
    }

    @Override
    public PagingResult<ServiceDocument> findDocListByServDefId(PortalContext portalContext, String serviceDefId, PagingParam pagingParam) throws ServiceBizException {
        PagingResult result = null;
        try {
            ServiceDocument serviceDocument = new ServiceDocument();
            serviceDocument.setServiceDefId(serviceDefId);
            serviceDocument.setDocType(DocTypeEnum.DOC);
            result = this.serviceDocumentDAO.findList((Object)serviceDocument, pagingParam, new Filter[0]);
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_FIND_ERR, ex);
        }
        return result;
    }

    @Override
    public ServiceDocument findDocById(PortalContext portalContext, String docId) throws ServiceBizException {
        try {
            return (ServiceDocument)((Object)this.serviceDocumentDAO.findById(docId));
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_FIND_ERR, ex);
        }
    }

    @Override
    public void updateDocDownloadCount(PortalContext portalContext, String docId) throws ServiceBizException {
        try {
            ServiceDocument serviceDocument = (ServiceDocument)((Object)this.serviceDocumentDAO.findById(docId));
            if (serviceDocument.getDownloadCount() == null) {
                serviceDocument.setDownloadCount(1);
            } else {
                serviceDocument.setDownloadCount(serviceDocument.getDownloadCount() + 1);
            }
            this.serviceDocumentDAO.update((Object)serviceDocument);
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_UPDATE_ERR, ex);
        }
    }

    @Override
    public void deleteDoc(PortalContext portalContext, String docId, String serviceDefId) throws ServiceBizException {
        try {
            this.serviceDocumentDAO.deleteById(docId);
            if (!StringUtil.isEmpty((String)serviceDefId)) {
                this.serviceDefinitionService.decreaseServiceDocCount(portalContext, serviceDefId);
            }
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_DELETE_ERR, ex);
        }
    }

    @Override
    public void importContent4InitData(PortalContext portalContext, String iserviceRootPath) throws ServiceBizException {
        try {
            String serviceDocumentFileDir = iserviceRootPath + "/res/file/init_data/blob/T_JP_ServiceDocument";
            File fileDir = new File(serviceDocumentFileDir);
            File[] childFiles = fileDir.listFiles();
            if (childFiles != null) {
                for (File file : childFiles) {
                    if (file.getName().endsWith(".svn") || file.getName().endsWith(".txt") || file.getName().endsWith(".db")) continue;
                    this.updateContent4File(portalContext, file);
                }
            }
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_UPDATE_ERR, ex);
        }
    }

    private void updateContent4File(PortalContext portalContext, File file) throws DataAccessException {
        String fileName = file.getName();
        String docId = this.getDocId4FileName(fileName);
        ServiceDocument serviceDocument = (ServiceDocument)((Object)this.serviceDocumentDAO.findById(docId));
        if (serviceDocument != null) {
            byte[] content = FileUtil.getByteArrayData((File)file);
            serviceDocument.setContent(content);
            serviceDocument.setPortalContext(portalContext);
            this.serviceDocumentDAO.update((Object)serviceDocument);
        }
    }

    private String getDocId4FileName(String fileName) {
        return fileName.split("_")[0];
    }

    private ServiceDocument createDocument(PortalContext portalContext, ServiceDocument serviceDocument, DocTypeEnum docType, FileModel fileModel, boolean updateDoc) throws ServiceBizException {
        try {
            if (updateDoc) {
                this.buildeServiceDocument4Save(portalContext, serviceDocument, fileModel, docType);
            }
            serviceDocument.setDownloadCount(0);
            serviceDocument.setPortalContext(portalContext);
            serviceDocument = (ServiceDocument)((Object)this.serviceDocumentDAO.create((Object)serviceDocument));
            if (DocTypeEnum.DOC.equals((Object)docType)) {
                this.serviceDefinitionService.increaseServiceDocCount(portalContext, serviceDocument.getServiceDefId());
            }
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_CREATE_ERR, ex);
        }
        return serviceDocument;
    }

    private ServiceDocument updateDocument(PortalContext portalContext, ServiceDocument serviceDocument, DocTypeEnum docType, FileModel fileModel, boolean updateDoc) throws ServiceBizException {
        ServiceDocument serviceDocument4DB = null;
        try {
            serviceDocument4DB = (ServiceDocument)((Object)this.serviceDocumentDAO.findById(serviceDocument.getId()));
            if (serviceDocument4DB == null) {
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_NO_EXISTED_ERR);
            }
            if (DocTypeEnum.DOC.equals((Object)docType)) {
                serviceDocument4DB.setDisplayName(serviceDocument.getDisplayName());
                serviceDocument4DB.setDescription(serviceDocument.getDescription());
                serviceDocument4DB.setScope(serviceDocument.getScope());
            }
            if (updateDoc) {
                this.buildeServiceDocument4Save(portalContext, serviceDocument4DB, fileModel, docType);
            }
            serviceDocument4DB.setPortalContext(portalContext);
            serviceDocument4DB = (ServiceDocument)((Object)this.serviceDocumentDAO.update((Object)serviceDocument4DB));
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_UPDATE_ERR, ex);
        }
        return serviceDocument4DB;
    }

    private void buildeServiceDocument4Save(PortalContext portalContext, ServiceDocument serviceDocument, FileModel fileModel, DocTypeEnum docType) {
        serviceDocument.setDocType(docType);
        String fileSuffix = FileUtil.getFileSuffix((String)fileModel.getUploadFilePath());
        if (!StringUtil.isEmpty((String)fileSuffix)) {
            fileSuffix = "." + fileSuffix;
        }
        serviceDocument.setDocSuffix(fileSuffix);
        serviceDocument.setContentType(fileModel.getUploadContentType());
        serviceDocument.setLength(fileModel.getLength().intValue());
        byte[] fileContent = FileUtil.getByteArrayData((String)fileModel.getUploadFilePath());
        serviceDocument.setContent(fileContent);
        DisplayName uploaderName = new DisplayName();
        String userName = portalContext.getLoginUser().getName();
        uploaderName.setEn(userName);
        uploaderName.setZh_CN(userName);
        uploaderName.setZh_TW(userName);
        serviceDocument.setUploaderName(uploaderName.toString());
    }

    @Override
    public Map<String, Object> findDocListByIdList(PortalContext portalContext, String idList) throws ServiceBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ArrayList<String> defIdList = new ArrayList<String>();
            if (idList != null) {
                List<ServiceDocument> docList = this.serviceDocumentDAO.findDocListByIdList(portalContext, idList);
                if (docList != null) {
                    for (String id : idList.split(",")) {
                        if (StringUtil.isEmpty((String)id)) continue;
                        ArrayList<ServiceDocument> scList = new ArrayList<ServiceDocument>();
                        for (ServiceDocument serviceDocument : docList) {
                            if (!id.equals(serviceDocument.getServiceDefId())) continue;
                            scList.add(serviceDocument);
                        }
                        if (scList.size() <= 0) continue;
                        map.put(id, scList);
                        defIdList.add(id);
                    }
                }
                if (defIdList.size() > 0) {
                    map.put("defIdList", defIdList);
                }
            }
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return map;
    }

    public ServiceDocumentDAO getServiceDocumentDAO() {
        return this.serviceDocumentDAO;
    }

    public void setServiceDocumentDAO(ServiceDocumentDAO serviceDocumentDAO) {
        this.serviceDocumentDAO = serviceDocumentDAO;
    }

    public ServiceDefinitionService getServiceDefinitionService() {
        return this.serviceDefinitionService;
    }

    public void setServiceDefinitionService(ServiceDefinitionService serviceDefinitionService) {
        this.serviceDefinitionService = serviceDefinitionService;
    }
}

