/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.service.impl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.iservice.common.enums.InsStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.MarkFlagEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.exception.conf.ServiceErrConfig;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceInstanceDAO;
import com.kingdee.portal.plt.iservice.module.service.dto.ServRecDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceInstance;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceInstanceService;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ServiceInstanceServiceImpl
implements ServiceInstanceService {
    private ServiceInstanceDAO serviceInstanceDAO;

    @Override
    public List<ServRecDTO> getServRec(PortalContext portalContext, InsStateEnum state, int startIndex, int lastIndex) throws ServiceBizException {
        List<ServRecDTO> recList = null;
        try {
            recList = this.serviceInstanceDAO.getServRec(portalContext.getLoginUser().getId(), state, startIndex, lastIndex);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("002", e);
        }
        return recList;
    }

    @Override
    public List<ServRecDTO> getAllServRec(PortalContext portalContext, int startIndex, int lastIndex) throws ServiceBizException {
        List<ServRecDTO> recList = null;
        try {
            recList = this.serviceInstanceDAO.getAllServRec(portalContext.getLoginUser().getId(), startIndex, lastIndex);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("002", e);
        }
        return recList;
    }

    @Override
    public List<ServRecDTO> getEvalServRec(PortalContext portalContext, int startIndex, int lastIndex) throws ServiceBizException {
        List<ServRecDTO> recList = null;
        try {
            recList = this.serviceInstanceDAO.getEvalServRec(portalContext.getLoginUser().getId(), startIndex, lastIndex);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("002", e);
        }
        return recList;
    }

    @Override
    public int getServRecTotalCount(PortalContext portalContext, InsStateEnum state, MarkFlagEnum markFlag) throws ServiceBizException {
        int count = 0;
        ServiceInstance ins = new ServiceInstance();
        FieldFilter userFilter = new FieldFilter("userId", "=", (Object)portalContext.getLoginUser().getId());
        FieldFilter stateFilter = null;
        FieldFilter markFilter = null;
        if (null != state) {
            stateFilter = new FieldFilter("state", "=", (Object)state);
        }
        if (null != markFlag) {
            markFilter = new FieldFilter("markFlag", "=", (Object)markFlag);
        }
        try {
            count = this.serviceInstanceDAO.totalCount((Object)ins, new Filter[]{userFilter, stateFilter, markFilter});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("002", e);
        }
        return count;
    }

    @Override
    public int getServRecTotalCountBySerDefId(PortalContext portalContext, String serviceDefId, InsStateEnum state) throws ServiceBizException {
        int count = 0;
        ServiceInstance ins = new ServiceInstance();
        FieldFilter userFilter = new FieldFilter("serviceDefId", "=", (Object)serviceDefId);
        FieldFilter stateFilter = null;
        Object markFilter = null;
        if (null != state) {
            stateFilter = new FieldFilter("state", "=", (Object)state);
        }
        try {
            count = this.serviceInstanceDAO.totalCount((Object)ins, new Filter[]{userFilter, stateFilter, markFilter});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("002", e);
        }
        return count;
    }

    @Override
    public boolean updateMarkFlag(PortalContext portalContext, String billid, String markFlag) throws ServiceBizException {
        ServiceInstance serviceInstance = null;
        MarkFlagEnum markflag = MarkFlagEnum.NO;
        boolean result = true;
        if (markFlag.equals("YES")) {
            markflag = MarkFlagEnum.YES;
        } else if (markFlag.equals("IGNORE")) {
            markflag = MarkFlagEnum.IGNORE;
        }
        try {
            serviceInstance = (ServiceInstance)((Object)this.serviceInstanceDAO.findById(billid));
            serviceInstance.setMarkFlag(markflag);
            this.serviceInstanceDAO.update((Object)serviceInstance);
        }
        catch (DataAccessException e) {
            result = false;
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_REC_UPDATEMARKFLAG, e);
        }
        return result;
    }

    @Override
    public boolean delMyServiceInstanceByid(PortalContext portalContext, String fid) throws ServiceBizException {
        if (StringUtil.isEmptyString((String)fid)) {
            return false;
        }
        boolean result = true;
        try {
            this.serviceInstanceDAO.deleteById(fid);
        }
        catch (DataAccessException e) {
            result = false;
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_REC_DELETESERVINSBYID, e);
        }
        return result;
    }

    @Override
    public int findServiceTotalCount(PortalContext ctx) throws ServiceBizException {
        try {
            return this.serviceInstanceDAO.totalCount((Object)new ServiceInstance(), new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
    }

    public ServiceInstanceDAO getServiceInstanceDAO() {
        return this.serviceInstanceDAO;
    }

    public void setServiceInstanceDAO(ServiceInstanceDAO serviceInstanceDAO) {
        this.serviceInstanceDAO = serviceInstanceDAO;
    }
}

