/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.ILifeCycle;
import com.kingdee.shr.base.syssetting.core.IWafController;
import com.kingdee.shr.base.syssetting.core.IWebController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.resourcemanager.ResourceManager;
import com.kingdee.shr.base.syssetting.service.ServiceContext;
import com.kingdee.shr.base.syssetting.sessionmanager.SessionManager;
import com.kingdee.shr.base.syssetting.util.BeanUtils;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class ShrCoreController
implements ILifeCycle,
IWafController,
IWebController {
    protected Logger logger = Logger.getLogger(this.getClass());
    public static final String REDIRECT_PAGE = "redirect:";
    private static final String SESSION_MANAGER_BEAN = "sessionManager";
    private boolean isInitalized = false;

    @Override
    public String destroyAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return null;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String defaultAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return this.initalizeAction(request, response, modelMap);
    }

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return null;
    }

    protected SessionManager getSessionManager() throws SHRWebException {
        return (SessionManager)BeanUtils.getBean(SESSION_MANAGER_BEAN);
    }

    @Override
    public ServiceContext getServiceContext() throws SHRWebException {
        return SHRContext.getInstance().getServiceContext();
    }

    @Override
    public IMetaDataPK getMetadataPK() {
        String uiPK = this.getClass().getName().toString();
        if (uiPK.endsWith("Controller")) {
            uiPK = uiPK.substring(0, uiPK.length() - "Controller".length());
        }
        return new MetaDataPK(uiPK);
    }

    @Override
    public Locale getLocale() throws SHRWebException {
        return SHRContext.getInstance().getContext().getLocale();
    }

    public Locale getOriginLocale() throws SHRWebException {
        return SHRContext.getInstance().getContext().getOriginLocale();
    }

    @Deprecated
    private ResourceBundle getResourceBundle(String className) throws SHRWebException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(className, this.getLocale());
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return resourceBundle;
    }

    @Override
    @Deprecated
    public ResourceBundle getResourceBundle() throws SHRWebException {
        return this.getResourceBundle(this.getClass().getName());
    }

    @Override
    public String getMessage(String key) throws SHRWebException {
        ResourceManager resourceManager = (ResourceManager)BeanUtils.getBean("resourceManager");
        return resourceManager.getControllerMessage(this, key, SHRContext.getInstance().getContext().getLocale());
    }

    public String pingRequestParamToStr(HttpServletRequest request) {
        String queryStr = "";
        Enumeration paramNameEnum = request.getParameterNames();
        while (paramNameEnum.hasMoreElements()) {
            String key = (String)paramNameEnum.nextElement();
            String value = request.getParameter(key);
            queryStr = queryStr + key + "=" + value;
            if (!paramNameEnum.hasMoreElements()) continue;
            queryStr = queryStr + "&";
        }
        return queryStr;
    }

    @Override
    public List getLocalKeys() throws SHRWebException {
        ResourceManager resourceManager = (ResourceManager)BeanUtils.getBean("resourceManager");
        return resourceManager.getControllerLocalKeys(this, SHRContext.getInstance().getContext().getLocale());
    }

    @Override
    public SHRContext getSHRContext() throws SHRWebException {
        return SHRContext.getInstance();
    }

    @Override
    public ServletContext getServletContext() throws SHRWebException {
        return this.getSHRContext().getServletContext();
    }

    public String getContextUrl(HttpServletRequest request) throws SHRWebException {
        String segmentName;
        Annotation[] annotations = this.getClass().getDeclaredAnnotations();
        String viewPath = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof RequestMapping)) continue;
            RequestMapping requestMapping = (RequestMapping)annotation;
            if (requestMapping.value() != null && requestMapping.value().length > 0) {
                viewPath = requestMapping.value()[0];
                break;
            }
            throw new SHRWebException("can't find " + this.getClass().toString() + "'s request mapping!");
        }
        if (viewPath != null && viewPath.indexOf("Controller") > 0) {
            viewPath = viewPath.substring(0, viewPath.indexOf("Controller"));
        }
        if ((segmentName = request.getParameter("segment")) != null && segmentName.length() > 0) {
            viewPath = viewPath + "_" + "segment" + "_" + segmentName;
        }
        return viewPath;
    }

    public String getConversationID() {
        String conversationID = SHRContext.getInstance().getRequest().getParameter("conversationid");
        if (conversationID != null && conversationID.equals("")) {
            conversationID = null;
        }
        return conversationID;
    }

    @Override
    public OrgUnitInfo getMainOrgInfo() {
        Context ctx = SHRContext.getInstance().getContext();
        if (ctx == null) {
            return null;
        }
        return (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
    }

    @Override
    public OrgType getMainOrgType() {
        return OrgType.ControlUnit;
    }

    @Override
    public boolean isLicenseRequired() {
        return true;
    }

    @Override
    public void setInitalizeStatus(boolean value) throws SHRWebException {
        this.isInitalized = value;
    }

    @Override
    public boolean getInitalizeStatus() throws SHRWebException {
        return this.isInitalized;
    }
}

