/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.exception;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.ShrUIViewNotFoundException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.exception.ShrWebCheckLicenseException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

public class ShrExceptionHandlerResolver
extends DefaultHandlerExceptionResolver {
    private static final Logger logger = Logger.getLogger(ShrExceptionHandlerResolver.class);
    private String errorMsgResourse = "";

    public ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        ModelAndView result = super.doResolveException(request, response, handler, exception);
        if (result != null) {
            return result;
        }
        Context ctx = SHRContext.getInstance().getContext();
        this.errorMsgResourse = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"error_and_download_log", (Context)ctx);
        String permItemUrl = "/dynamic.do?method=downLoadLog#uri=cestools";
        try {
            PermItemInfo permItem = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)permItemUrl);
            SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItem);
        }
        catch (PermissionException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"failure", (Context)ctx)).append(",").append(SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"contact_admin", (Context)ctx));
            this.errorMsgResourse = sb.toString();
        }
        catch (EASBizException e) {
        }
        catch (BOSException e) {
            // empty catch block
        }
        String message = exception.getMessage();
        if (exception.getCause() instanceof PermissionException) {
            logger.error((Object)message);
        } else if (exception.getCause() instanceof ShrWebCheckLicenseException) {
            logger.debug((Object)message);
        } else if (exception instanceof ShrUIViewNotFoundException) {
            logger.info((Object)message);
        } else if (exception instanceof ShrWebBizException && null == exception.getCause()) {
            logger.error((Object)message);
        } else if (exception.getCause() instanceof EASBizException) {
            logger.error((Object)message);
        } else if (exception.getCause() instanceof InvocationTargetException) {
            InvocationTargetException e1 = (InvocationTargetException)exception.getCause();
            if (e1.getTargetException() instanceof EASBizException) {
                logger.error((Object)e1.getTargetException().getMessage());
            } else {
                logger.error((Object)e1.getTargetException().getMessage(), e1.getTargetException());
            }
        } else {
            logger.error((Object)message, (Throwable)exception);
        }
        boolean isPrintStack0 = false;
        try {
            String isPrintStack = ParamManager.getParamValue((Context)ctx, null, (String)"p_error_stack_info");
            if ("true".equals(isPrintStack)) {
                isPrintStack0 = true;
            }
        }
        catch (EASBizException isPrintStack) {
        }
        catch (BOSException isPrintStack) {
            // empty catch block
        }
        if (isPrintStack0) {
            exception.printStackTrace();
        }
        String uri = request.getRequestURI();
        boolean isOsfCall = false;
        if (!StringUtils.isEmpty((String)uri) && uri.indexOf("/shr/msf/service.do") != -1) {
            isOsfCall = true;
        }
        if (this.isRequestAJAX(request) || isOsfCall) {
            return this.handleJSONException(ctx, exception, request);
        }
        return this.handleException(ctx, exception, request);
    }

    private boolean isRequestAJAX(HttpServletRequest request) {
        boolean isAjaxRequest = false;
        if (!StringUtils.isEmpty((String)request.getHeader("x-requested-with")) && request.getHeader("x-requested-with").equals("XMLHttpRequest")) {
            isAjaxRequest = true;
        }
        return isAjaxRequest;
    }

    private ModelAndView handleJSONException(Context ctx, Exception exception, HttpServletRequest request) {
        String message = null;
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            if (cause instanceof ShrWebBizException) {
                message = cause.getMessage();
                break;
            }
            if (cause instanceof EASBizException) {
                EASBizException e = (EASBizException)cause;
                message = e.getMessage(ctx.getLocale());
                continue;
            }
            if (!(cause instanceof BOSException)) continue;
            message = cause.getMessage();
        }
        if (exception != null && message == null) {
            message = exception.getMessage();
        }
        if (StringUtils.isEmpty(message) || this.isSQLException(message) || this.isSystemException(message)) {
            message = this.errorMsgResourse;
        }
        if (exception != null && this.isSaveTooLangForForm(message)) {
            message = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "field_too_long");
        }
        if (exception != null && this.isNoSpaceOnDevice(message)) {
            message = "No space on device";
        }
        JSONUtils.ERROR(message);
        return new ModelAndView();
    }

    private ModelAndView handleException(Context ctx, Exception exception, HttpServletRequest request) {
        InvocationTargetException e1;
        if (exception instanceof ShrWebBizException || exception instanceof EASBizException) {
            return this.assembleModelAndView(ctx, exception, request);
        }
        Throwable throwable = exception.getCause();
        if (throwable instanceof EASBizException || throwable instanceof ShrWebBizException) {
            return this.assembleModelAndView(ctx, throwable, request);
        }
        if (exception.getCause() instanceof InvocationTargetException && ((e1 = (InvocationTargetException)exception.getCause()).getTargetException() instanceof EASBizException || e1.getTargetException() instanceof ShrWebBizException)) {
            return this.assembleModelAndView(ctx, e1.getTargetException(), request);
        }
        if (exception instanceof UndeclaredThrowableException) {
            return this.assembleModelAndView(ctx, exception, request);
        }
        return null;
    }

    private ModelAndView assembleModelAndView(Context ctx, Throwable throwable, HttpServletRequest request) {
        Boolean hasNoWorkPlatform;
        HashMap<String, String> model = new HashMap<String, String>();
        String message = throwable.getMessage();
        if (throwable instanceof EASBizException) {
            EASBizException e = (EASBizException)throwable;
            message = e.getMessage(ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)message) && null != throwable.getCause()) {
            message = throwable.getCause().getMessage();
        }
        if (StringUtils.isEmpty((String)message)) {
            message = this.errorMsgResourse;
        }
        if (!StringUtils.isEmpty((String)(message = message.replaceAll("\"", "&quot;")))) {
            if (this.isSQLException(message) || this.isSystemException(message)) {
                model.put("message", SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "failure"));
            } else {
                model.put("message", message);
            }
        } else {
            model.put("message", message);
        }
        Object obj = request.getAttribute("HasNoWorkPlatform");
        model.put("hasPermission", "false");
        if (null != obj && (hasNoWorkPlatform = (Boolean)obj).booleanValue()) {
            model.put("hasPermission", "true");
        }
        if (throwable.getCause() != null) {
            model.put("exceptionname", throwable.getCause().getClass().getName());
        } else {
            model.put("exceptionname", throwable.getClass().getName());
        }
        try {
            Map m = UIViewUtil.getFreemarkerResouce("framework.ftl");
            model.put("freemarkerMultLan_msg001", (String)m.get("msg001"));
            model.put("freemarkerMultLan_msg002", (String)m.get("msg002"));
            model.put("freemarkerMultLan_msg003", (String)m.get("msg003"));
            model.put("freemarkerMultLan_msg004", (String)m.get("msg004"));
            model.put("freemarkerMultLan_msg005", (String)m.get("msg005"));
            model.put("freemarkerMultLan_msg006", (String)m.get("msg006"));
            model.put("freemarkerMultLan_msg007", (String)m.get("msg007"));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new ModelAndView("/framework/error/error", model);
    }

    private boolean isSQLException(String message) {
        if (message == null) {
            return false;
        }
        return message.indexOf("Sql3 execute exception") > -1 || message.indexOf("Sql execute exception") > -1 || message.indexOf("Sql1 execute exception") > -1;
    }

    private boolean isSystemException(String message) {
        if (message == null) {
            return false;
        }
        return message.indexOf("Unexpected system failure") > -1;
    }

    private boolean isSaveTooLangForForm(String message) {
        if (null == message) {
            return false;
        }
        return message.indexOf("DataLimit") > -1;
    }

    private boolean isNoSpaceOnDevice(String message) {
        if (null == message) {
            return false;
        }
        return message.indexOf("No space left on device") > -1;
    }
}

