/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ShrHttpRequestFilter
implements Filter {
    private static Logger logger = Logger.getLogger(ShrHttpRequestFilter.class);
    private static final String CONVERSATION_SUPPORT = "CONVERSATION_SUPPORT";
    private static final String RESPONSE_BUFFER_SIZE = "RESPONSE_BUFFER_SIZE";
    private FilterConfig config;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.setResponseConfigParam(httpResponse);
        httpResponse.setDateHeader("Expires", 0L);
        filterChain.doFilter(request, response);
    }

    private void setResponseConfigParam(HttpServletResponse httpResponse) {
        int defaultRespBufferSize = 5000;
        String strRespBufferSize = this.config.getInitParameter(RESPONSE_BUFFER_SIZE);
        if (strRespBufferSize != null) {
            try {
                defaultRespBufferSize = Integer.parseInt(strRespBufferSize);
            }
            catch (Exception e) {
                logger.info((Object)"[ ShrHttpRequestFilter setResponseConfigParam Integer.parseInt(strRespBufferSize) error ]");
            }
        }
        if (!httpResponse.isCommitted()) {
            httpResponse.setBufferSize(defaultRespBufferSize);
        } else {
            System.out.println(" httpResponse.getBufferSize(): " + httpResponse.getBufferSize());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }
}

