/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.cache.MLCacheHelper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class UpgradeMonitorFilter
implements Filter {
    private Logger logger = Logger.getLogger((String)UpgradeMonitorFilter.class.getName());
    private static final Integer UPGRADEMONITOR_STATE_DATACENTER_NOTUPGRADED = -1;
    private static final Integer UPGRADEMONITOR_STATE_MOVEDATA_NOTUPGRADED = 0;
    private static final Integer UPGRADEMONITOR_STATE_ALL_UPGRADED = 1;
    private static Set<String> urlWhiteListed = new HashSet<String>();
    private static Set<String> uipkWhiteListed = new HashSet<String>();
    private static Set<String> handlerWhiteListed = new HashSet<String>();
    private static Pattern STRING_PATTERN = Pattern.compile("\\s*|\t|\r|\n");

    public void destroy() {
    }

    private boolean isLinkTopBar(HttpServletRequest request, Context ctx) {
        String servletPath = request.getServletPath();
        if (urlWhiteListed.contains(servletPath)) {
            return Boolean.TRUE;
        }
        String uipk = request.getParameter("uipk");
        String handler = request.getParameter("handler");
        if ("/dynamic.do".equals(servletPath)) {
            if (StringUtils.isEmpty((String)uipk) && StringUtils.isEmpty((String)handler)) {
                return Boolean.TRUE;
            }
            if (!StringUtils.isEmpty((String)uipk) && uipkWhiteListed.contains(uipk)) {
                return Boolean.TRUE;
            }
            if (!StringUtils.isEmpty((String)handler) && handlerWhiteListed.contains(handler)) {
                return Boolean.TRUE;
            }
        }
        String message = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"upgrate_intercept_info", (Context)ctx), servletPath, uipk, handler);
        this.logger.error((Object)SHRCheck.vaildLog((String)message));
        return Boolean.FALSE;
    }

    private void interceptInterview(Context ctx, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (!this.isLinkTopBar(httpRequest, ctx)) {
            httpResponse.sendRedirect("/shr/web_frame/easrpc/login.do?method=upgradeCheck");
        } else {
            try {
                Map m = MLCacheHelper.getResource((Context)ctx, (ResourceType)ResourceType.JSP, (String)"framework.jsp");
                httpRequest.setAttribute("jspMultiLan", (Object)m);
            }
            catch (EASBizException e) {
                httpRequest.setAttribute("jspMultiLan", (Object)Collections.EMPTY_MAP);
                e.printStackTrace();
            }
            catch (BOSException e) {
                httpRequest.setAttribute("jspMultiLan", (Object)Collections.EMPTY_MAP);
                e.printStackTrace();
            }
        }
    }

    private boolean checkDataCenterUpgradeIsFinished(Context ctx) throws BOSException, SQLException {
        int easVersion = 0;
        int shrVersion = -1;
        IRowSet rowset = null;
        StringBuilder ptmSql = new StringBuilder();
        ptmSql.append(" select * from KSQL_USERTABLES where KSQL_TABNAME = 'T_SYS_DatacenterSHR' ");
        rowset = DbUtil.executeQuery((Context)ctx, (String)ptmSql.toString());
        if (!rowset.first()) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select e.FMajor || e.FMinor || e.FBuild || e.FBim  EASVersion, s.FMajor || s.FMinor || s.FBuild || s.FBim SHRVersion ").append(" from T_SYS_Datacenter e, T_SYS_DatacenterSHR s where e.FType = 'BOS_PDT' and s.FType = 'SHR' ");
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowset.next()) {
            easVersion = rowset.getInt("EASVersion");
            shrVersion = rowset.getInt("sHRVersion");
        }
        return easVersion <= shrVersion;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logger.debug((Object)"UpgradeMonitorFilter enter doFilter!");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession httpSession = httpRequest.getSession();
        if (null == httpSession) {
            httpResponse.sendRedirect("/shr/web_frame/easrpc/frame.do?method=logout");
            return;
        }
        if (httpSession.getAttribute("userMonitorSessionInfo") != null) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)httpRequest);
            if (null == ctx) {
                return;
            }
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            int userType = userInfo.getType().getValue();
            Integer upgradeMonitorState = (Integer)httpSession.getAttribute("upgradeMonitorState");
            if (upgradeMonitorState == null || !UPGRADEMONITOR_STATE_ALL_UPGRADED.equals(upgradeMonitorState)) {
                try {
                    if (!this.checkDataCenterUpgradeIsFinished(ctx)) {
                        httpRequest.setAttribute("tooltip", (Object)SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"datacenter_not_complete", (Context)ctx));
                        httpRequest.setAttribute("operation", (Object)"logout");
                        httpSession.setAttribute("upgradeMonitorState", (Object)UPGRADEMONITOR_STATE_DATACENTER_NOTUPGRADED);
                        this.interceptInterview(ctx, httpRequest, httpResponse);
                    } else if (SHRControlMoveDataHelpUtil.checkMovaDataIsFinished((Context)ctx)) {
                        httpSession.setAttribute("upgradeMonitorState", (Object)UPGRADEMONITOR_STATE_ALL_UPGRADED);
                    } else if (userType != 10) {
                        httpRequest.setAttribute("tooltip", (Object)SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"data_not_complete", (Context)ctx));
                        httpRequest.setAttribute("operation", (Object)"logout");
                        httpSession.setAttribute("upgradeMonitorState", (Object)UPGRADEMONITOR_STATE_MOVEDATA_NOTUPGRADED);
                        this.interceptInterview(ctx, httpRequest, httpResponse);
                    } else {
                        httpRequest.setAttribute("tooltip", (Object)SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"enter_upgrate_page", (Context)ctx));
                        httpRequest.setAttribute("operation", (Object)"upgrade");
                        httpSession.setAttribute("upgradeMonitorState", (Object)UPGRADEMONITOR_STATE_MOVEDATA_NOTUPGRADED);
                        this.interceptInterview(ctx, httpRequest, httpResponse);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    httpRequest.setAttribute("tooltip", (Object)SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"upgrate_error", (Context)ctx));
                    httpRequest.setAttribute("operation", (Object)"logout");
                    this.interceptInterview(ctx, httpRequest, httpResponse);
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void init(FilterConfig config) throws ServletException {
        String urlWhiteList = config.getInitParameter("urlWhiteListed");
        String uipkWhiteList = config.getInitParameter("uipkWhiteListed");
        String handlerWhiteList = config.getInitParameter("handlerWhiteListed");
        if (!StringUtils.isEmpty((String)urlWhiteList)) {
            String[] urlWhiteListeds = urlWhiteList.split(",");
            this.initSetValue(urlWhiteListeds, urlWhiteListed);
        }
        if (!StringUtils.isEmpty((String)uipkWhiteList)) {
            String[] uipkWhiteListeds = uipkWhiteList.split(",");
            this.initSetValue(uipkWhiteListeds, uipkWhiteListed);
        }
        if (!StringUtils.isEmpty((String)handlerWhiteList)) {
            String[] handlerWhiteListeds = handlerWhiteList.split(",");
            this.initSetValue(handlerWhiteListeds, handlerWhiteListed);
        }
    }

    private void initSetValue(String[] values, Set<String> set) {
        if (null == values || values.length <= 0) {
            return;
        }
        int total = values.length;
        for (int i = 0; i < total; ++i) {
            Matcher m = STRING_PATTERN.matcher(values[i]);
            set.add(m.replaceAll(""));
        }
    }
}

