/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.propertyeditors;

import com.kingdee.shr.base.syssetting.propertyeditors.WafPropertyEditorSupport;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;

public class CustomEnumEditor
extends WafPropertyEditorSupport {
    private Class enumClass = null;

    public CustomEnumEditor() {
    }

    public CustomEnumEditor(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return this.getValue().toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.length() == 0) {
            this.setValue(null);
        } else {
            Object result = null;
            try {
                Method method;
                if (this.enumClass == null && this.getObject() != null) {
                    String enumMethodName = "get" + this.getProperty().substring(0, 1).toUpperCase() + this.getProperty().substring(1);
                    Method enumMethod = this.getObject().getClass().getMethod(enumMethodName, null);
                    this.enumClass = enumMethod.getReturnType();
                }
                if (this.isSubclass(this.enumClass, IntEnum.class)) {
                    method = this.enumClass.getMethod("getEnum", Integer.TYPE);
                    result = method.invoke((Object)this.enumClass, Integer.parseInt(text));
                } else if (this.isSubclass(this.enumClass, StringEnum.class)) {
                    method = this.enumClass.getMethod("getEnum", String.class);
                    result = method.invoke((Object)this.enumClass, text);
                } else if (this.isSubclass(this.enumClass, LongEnum.class)) {
                    method = this.enumClass.getMethod("getEnum", Long.TYPE);
                    result = method.invoke((Object)this.enumClass, Long.parseLong(text));
                } else if (this.isSubclass(this.enumClass, FloatEnum.class)) {
                    method = this.enumClass.getMethod("getEnum", Float.TYPE);
                    result = method.invoke((Object)this.enumClass, Float.valueOf(Float.parseFloat(text)));
                } else if (this.isSubclass(this.enumClass, DoubleEnum.class)) {
                    method = this.enumClass.getMethod("getEnum", Double.TYPE);
                    result = method.invoke((Object)this.enumClass, Double.parseDouble(text));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setValue(result);
            this.enumClass = null;
        }
    }

    private boolean isSubclass(Class baseClass, Class superClass) {
        try {
            Class ret = baseClass.asSubclass(superClass);
            return ret != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

