/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.permission.util.SHRPermissionParamUtil;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetBatchButtonPermItemIdsService
implements IHRMsfService {
    private final Logger logger = Logger.getLogger(GetBatchButtonPermItemIdsService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String jsonData = String.valueOf(param.get("jsonData"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map> list = new ArrayList<Map>();
        List data = (List)JSONUtils.convertJsonToObject(ctx, jsonData, List.class);
        if (null == data) {
            result.put("data", list);
            result.put("success", Boolean.FALSE);
            result.put("message", MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "data_null"), jsonData));
            return result;
        }
        IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
        PermItemInfo permItemInfo = null;
        for (Map mapData : data) {
            String uipk = String.valueOf(mapData.get("uipk"));
            String method = String.valueOf(mapData.get("methodName"));
            String shruicode = "";
            if (!StringUtils.isEmpty((String)uipk) && uipk.indexOf("&") != -1) {
                String[] shruicode0;
                String[] uipkurl = uipk.split("&");
                uipk = uipkurl[0];
                if (!StringUtils.isEmpty((String)uipkurl[1]) && uipkurl[1].indexOf("=") != -1 && (shruicode0 = uipkurl[1].split("="))[0].equals("shruicode")) {
                    shruicode = shruicode0[1];
                }
            }
            String permItemId = "";
            mapData.put("hasPermission", true);
            if (StringUtils.isEmpty((String)uipk)) {
                mapData.put("message", SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "uipk_null"));
                mapData.put("permItemId", "");
                mapData.put("hasPermission", false);
                continue;
            }
            mapData.put("message", "");
            permItemId = StringUtils.isEmpty((String)method) ? SHRPermissionWebUtils.getPermItemIdByUipkAndInitMethod(ctx, uipk, shruicode) : SHRPermissionWebUtils.getPermItemIdByUipkAndMethod(ctx, uipk, method, shruicode);
            if (StringUtils.isEmpty((String)permItemId)) {
                mapData.put("permItemId", "");
                if (SHRPermissionParamUtil.isSHRPermissionVerificationWithWhiteList((Context)ctx)) {
                    mapData.put("hasPermission", false);
                }
            } else {
                try {
                    permItemInfo = iPermItem.getPermItemInfo((IObjectPK)new ObjectUuidPK(permItemId));
                    SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItemInfo);
                    mapData.put("permItemId", permItemId);
                }
                catch (EASBizException e) {
                    mapData.put("hasPermission", false);
                    mapData.put("message", e.getMessage());
                }
                catch (BOSException e) {
                    mapData.put("hasPermission", false);
                    mapData.put("message", e.getMessage());
                }
                mapData.put("permItemId", permItemId);
            }
            list.add(mapData);
        }
        result.put("data", list);
        result.put("success", Boolean.TRUE);
        result.put("message", "");
        return result;
    }
}

