/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.SnowFlakeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class ImportDecodeUtils {
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    public static final String FIELD_NAME = "uploadAttach";
    private static final Logger logger = Logger.getLogger(ImportDecodeUtils.class);
    public static final String PROPERTIES_PATH = "custom-decodeFile.properties";
    public static final String SOURCE_TEMP = "srctemp";
    public static final String DESTINATION_TEMP = "dsttemp";
    public static final String TEMP = "tempFile";

    public static MultipartFile trans(MultipartFile multipartFile) throws SHRWebException, BOSException {
        Properties properties;
        String propertiesPath = ImportDecodeUtils.getProperitesPath();
        File file = new File(propertiesPath);
        if (!file.exists()) {
            return multipartFile;
        }
        try {
            properties = SHRSyssettingUtil.getPropertiesFileByPath((String)propertiesPath);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        boolean isdecodeFile = false;
        String className = null;
        String methodName = null;
        isdecodeFile = !"false".equals(properties.getProperty("isdecodeFile"));
        className = properties.getProperty("className");
        methodName = properties.getProperty("methodName");
        if (!isdecodeFile || className == null || methodName == null) {
            return multipartFile;
        }
        String originalFilename = multipartFile.getOriginalFilename();
        String extname = originalFilename.substring(originalFilename.lastIndexOf(46), originalFilename.length());
        String tempFilename = SnowFlakeUtils.createID();
        multipartFile.getContentType();
        String srcFilePath = ImportDecodeUtils.getSrcFilePath() + tempFilename + extname;
        String dstFilePath = ImportDecodeUtils.getDstFilePath() + tempFilename + extname;
        try {
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)new File(srcFilePath));
        }
        catch (IllegalStateException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        ImportDecodeUtils.decodeFile(srcFilePath, dstFilePath, className, methodName);
        if (!new File(dstFilePath).exists()) {
            ImportDecodeUtils.deleteTempFile(srcFilePath, dstFilePath);
            return multipartFile;
        }
        MultipartFile dstMultipartFile = null;
        try {
            dstMultipartFile = ImportDecodeUtils.fileToMultipartFile(new File(dstFilePath), originalFilename);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        ImportDecodeUtils.deleteTempFile(srcFilePath, dstFilePath);
        return dstMultipartFile;
    }

    private static void decodeFile(String srcFilePath, String dstFilePath, String className, String methodName) throws SHRWebException, BOSException {
        Class<?> clz;
        block12: {
            clz = null;
            try {
                clz = MsfClassLoaderFactory.forName((String)className);
            }
            catch (ClassNotFoundException e) {
                try {
                    clz = Class.forName(className);
                }
                catch (ClassNotFoundException e1) {
                    throw new ShrWebBizException(e);
                }
                if (clz != null) break block12;
                throw new BOSException((Throwable)e);
            }
        }
        try {
            Method[] method2;
            for (Method method : method2 = clz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                try {
                    try {
                        method.invoke(clz.newInstance(), srcFilePath, dstFilePath);
                    }
                    catch (InstantiationException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static MultipartFile fileToMultipartFile(File file, String name) throws BOSException, IOException {
        FileItem fileItem = ImportDecodeUtils.createFileItem(file, name);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        return multipartFile;
    }

    private static FileItem createFileItem(File file, String name) throws BOSException, IOException {
        File tempFile = new File(ImportDecodeUtils.getTempFilePath());
        FileItem item = null;
        FileInputStream fis = null;
        OutputStream os = null;
        if (!tempFile.exists()) {
            tempFile.mkdir();
        }
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory(10240, tempFile);
            item = factory.createItem(FIELD_NAME, "multipart/form-data", false, name);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            fis = new FileInputStream(file);
            os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return item;
    }

    private static void deleteTempFile(String src, String dst) {
        File srcTempfile = new File(src);
        File dstTempfile = new File(dst);
        if (srcTempfile.exists()) {
            srcTempfile.delete();
        }
        if (dstTempfile.exists()) {
            dstTempfile.delete();
        }
    }

    private static String getProperitesPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRSyssettingUtil.getProperitesPath()).append(File.separator).append(PROPERTIES_PATH);
        return sb.toString();
    }

    private static String getSrcFilePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRSyssettingUtil.getShrWebWarPath()).append(File.separator).append(SOURCE_TEMP).append(File.separator);
        return sb.toString();
    }

    private static String getDstFilePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRSyssettingUtil.getShrWebWarPath()).append(File.separator).append(DESTINATION_TEMP).append(File.separator);
        return sb.toString();
    }

    private static String getTempFilePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(ImportDecodeUtils.getDstFilePath()).append(File.separator).append(TEMP);
        return sb.toString();
    }
}

