/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.exception.ShrWebCheckLicenseException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class LicenseHelper {
    private static Logger logger = Logger.getLogger(LicenseHelper.class);
    private static final String Group_MIXALL = "PRO_BOSRUNTIME_MIXALL";
    private static final String Group_PRO_BOS = "PRO_BOSRUNTIME";
    private static final String Group_MYsHR = "MYsHR";
    private static final String Group_GR_sHR_NewM = "GR_sHR_NewM";
    private static final String Group_PRO_sHR = "PRO_sHR";

    public static void checkLicence(String className, String module) throws ShrWebBizException {
        LicenseUserInfo user = LicenseHelper.getLicenseUserInfo();
        int licenselcFlag = 1;
        ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
        try {
            assert (licenseSrv != null);
            licenselcFlag = licenseSrv.reqeustLicenseByModuleAndUIName(user, module, className);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("checkLicence: licenselcFlag is {0}, module is {1}", licenselcFlag, module));
            }
            LicenseHelper.releaseLicense(className, module);
            String message = LicenseHelper.assembleMsg(licenseSrv, className, licenselcFlag, module);
            switch (licenselcFlag) {
                case 1: {
                    break;
                }
                case 4: {
                    throw new ShrWebCheckLicenseException(message, new LicenseException(message));
                }
                case 2: {
                    throw new ShrWebCheckLicenseException(message, new LicenseException(message));
                }
            }
        }
        catch (ShrWebBizException we) {
            throw we;
        }
        catch (Exception e) {
            logger.warn((Object)"request license error:", (Throwable)e);
            throw new ShrWebBizException(e.getMessage());
        }
    }

    public static int requestLicense(String uipk, String module) {
        int licenselcFlag = 4;
        ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
        assert (licenseSrv != null);
        LicenseUserInfo user = LicenseHelper.getLicenseUserInfo();
        try {
            licenselcFlag = StringUtils.isEmpty((String)module) ? licenseSrv.requestLicense(user, uipk) : licenseSrv.reqeustLicenseByModuleAndUIName(user, module, uipk);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        LicenseHelper.releaseLicense(uipk, module);
        return licenselcFlag;
    }

    public static boolean requestLicenseByUserGroup(String group) {
        int flag = LicenseHelper.requestLicenseByUserGroup0(group);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("requestLicenseByUserGroup:group is {0},flag is {1}", group, flag));
        }
        return 1 == flag;
    }

    public static int requestLicenseByUserGroup0(String group) {
        LicenseUserInfo user = LicenseHelper.getLicenseUserInfo();
        int flag = -1;
        Context ctx = SHRContext.getInstance().getContext();
        try {
            flag = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).requestLicenseByUserAndSubSystem(user, group);
        }
        catch (Exception e) {
            logger.error((Object)"CloudRegistMemoryManager.getInstance() error");
        }
        return flag;
    }

    public static boolean requestLicenseSuccess(String uipk, String module) {
        int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
        return licenselcFlag == 1;
    }

    public static void checkLicence(String className) throws SHRWebException {
        String moduleName = "";
        try {
            int licenselcFlag = 4;
            ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
            assert (licenseSrv != null);
            LicenseUserInfo user = LicenseHelper.getLicenseUserInfo();
            licenselcFlag = licenseSrv.requestLicense(user, className);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("checkLicence: licenselcFlag is {0}", licenselcFlag));
            }
            LicenseHelper.releaseLicense(className);
            String message = LicenseHelper.assembleMsg(licenseSrv, className, licenselcFlag, moduleName);
            switch (licenselcFlag) {
                case 1: {
                    break;
                }
                case 4: {
                    throw new ShrWebCheckLicenseException(message, new LicenseException(message));
                }
                case 2: {
                    throw new ShrWebCheckLicenseException(message, new LicenseException(message));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"request license error:", (Throwable)e);
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    private static String assembleMsg(ILicenseSrvAgent licenseSrv, String className, int licenselcFlag, String moduleName) throws LicenseException {
        StringBuffer buffer = new StringBuffer();
        String module = licenseSrv.getModuleByPackage(className);
        if (!StringUtils.isEmpty((String)moduleName)) {
            module = moduleName;
        }
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "sorry"));
        switch (licenselcFlag) {
            case 4: {
                buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "license_check"));
                break;
            }
            case 2: {
                buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "license_limit"));
            }
        }
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_name") + ":").append("[").append(className).append("]\n");
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "module_name") + ":");
        buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)module)).append("[").append(module).append("]\n");
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "subsystem_name") + ":");
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)module);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("module is " + module + ";subSysName is" + subSysName));
        }
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI")).append("\n");
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName)).append("[").append(subSysName).append("]\n");
        }
        return buffer.toString();
    }

    private static String assembleGroupMsg(String className, int licenselcFlag, List<String> groups) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "sorry")).append("\n");
        switch (licenselcFlag) {
            case 4: {
                buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "license_check"));
                break;
            }
            case 2: {
                buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "license_limit"));
            }
        }
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_name") + ":").append("[").append(className).append("]\n");
        buffer.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "subsystem_name") + ":");
        String orAlias = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "or");
        for (int i = 0; i < groups.size(); ++i) {
            String group = groups.get(i);
            String alias = LicenseClientUtil.getModularAliasNameByModularName((String)group);
            buffer.append(alias).append("[").append(group).append("]\n");
            if (i == groups.size() - 1) continue;
            buffer.append(orAlias);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static void checkLicenseBosRunTimeForMYsHR(String uipk, String module) throws ShrWebCheckLicenseException {
        if (!LicenseHelper.checkBOSRunTimeLicense(uipk, Group_MYsHR) || !LicenseHelper.checkBOSRunTimeLicense(uipk, Group_MIXALL)) {
            if (LicenseHelper.checkBOSRunTimeLicense(uipk, Group_PRO_BOS)) {
                return;
            }
            int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(Group_MYsHR);
            groups.add(Group_MIXALL);
            groups.add(Group_PRO_BOS);
            String msg = LicenseHelper.assembleGroupMsg(uipk, licenselcFlag, groups);
            throw new ShrWebCheckLicenseException(msg);
        }
    }

    public static void checkLicenseBosRunTimeForManagerAndTeamM(String uipk, String module) throws ShrWebCheckLicenseException {
        if (!LicenseHelper.checkBOSRunTimeLicense(uipk, Group_GR_sHR_NewM) || !LicenseHelper.checkBOSRunTimeLicense(uipk, Group_MIXALL)) {
            if (LicenseHelper.checkBOSRunTimeLicense(uipk, Group_PRO_BOS)) {
                return;
            }
            int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(Group_GR_sHR_NewM);
            groups.add(Group_MIXALL);
            groups.add(Group_PRO_BOS);
            String msg = LicenseHelper.assembleGroupMsg(uipk, licenselcFlag, groups);
            throw new ShrWebCheckLicenseException(msg);
        }
    }

    public static void checkLicenseBosRunTimeForsHR(String uipk, String module) throws ShrWebCheckLicenseException {
        if (!LicenseHelper.checkBOSRunTimeLicense(uipk, Group_PRO_sHR) || !LicenseHelper.checkBOSRunTimeLicense(uipk, Group_MIXALL)) {
            if (LicenseHelper.checkBOSRunTimeLicense(uipk, Group_PRO_BOS)) {
                return;
            }
            int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(Group_PRO_sHR);
            groups.add(Group_MIXALL);
            groups.add(Group_PRO_BOS);
            String msg = LicenseHelper.assembleGroupMsg(uipk, licenselcFlag, groups);
            throw new ShrWebCheckLicenseException(msg);
        }
    }

    public static void checkLicenseBosRunTime(String uipk, String module) throws ShrWebCheckLicenseException {
        if (!LicenseHelper.requestLicenseByUserGroup(Group_PRO_BOS)) {
            int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(Group_PRO_BOS);
            String msg = LicenseHelper.assembleGroupMsg(uipk, licenselcFlag, groups);
            throw new ShrWebCheckLicenseException(msg);
        }
    }

    public static boolean checkBOSRunTimeLicense(String uipk, String group) {
        if (!LicenseHelper.requestLicenseSuccess(uipk, "") && !LicenseHelper.requestLicenseByUserGroup(group)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"checkBOSRunTimeLicense requestLicense false");
            }
            return false;
        }
        return true;
    }

    private static ILicenseSrvAgent getLicenseSrvAgent() {
        LicenseSrvAgent licenseSrv = null;
        String url = "localhost";
        try {
            ORMServiceLocation loc = new ORMServiceLocation("license");
            if (!loc.isLocal()) {
                url = loc.getServiceURL();
                if (url == null || url.trim().length() == 0) {
                    url = "tcp://localhost";
                }
                licenseSrv = (ILicenseSrvAgent)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.base.license.agent.LicenseSrvAgent", ILicenseSrvAgent.class);
            } else {
                licenseSrv = new LicenseSrvAgent();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalidate config file! please make sure you have the config item about UserMonitor! Error url is: " + url), (Throwable)e);
        }
        return licenseSrv;
    }

    public static void releaseLicense(String className, String module) {
        if (!StringUtils.isEmpty((String)module)) {
            LicenseHelper.doReleaseLicenseByModuleAndUIName(className, module);
        } else {
            LicenseHelper.releaseLicense(className);
        }
    }

    public static void doReleaseLicenseByModuleAndUIName(String className, String module) {
        try {
            ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
            Context ctx = SHRContext.getInstance().getContext();
            licenseSrv.releaseLicenseByModuleAndUIName(ctx.getContextID(), module, className);
        }
        catch (LicenseException e) {
            logger.warn((Object)"release license error:", (Throwable)e);
        }
    }

    public static void releaseLicense(String className) {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
            licenseSrv.releaseLicense(ctx.getContextID(), className);
        }
        catch (Exception e) {
            logger.warn((Object)"release license error:", (Throwable)e);
        }
    }

    public static void releaseLicenseBySessionID() {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
            if (licenseSrv != null) {
                licenseSrv.releaseLicenseBySessionID(ctx.getContextID());
            }
        }
        catch (LicenseException e) {
            logger.warn((Object)"release license by session id error:", (Throwable)e);
        }
    }

    public static LicenseUserInfo getLicenseUserInfo() {
        Context ctx = SHRContext.getInstance().getContext();
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(ctx.getContextID());
        info.setUserID(ctx.getCaller().toString());
        info.setUserIP(ctx.getClientHostIP());
        info.setUserLoginAis(ctx.getAIS());
        info.setUserName(ctx.getUserName());
        info.setUserLoginTime(new Date());
        info.setUserCompany(ContextUtil.getCurrentOrgUnit((Context)ctx) == null ? SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "this_company") : ContextUtil.getCurrentOrgUnit((Context)ctx).getName());
        return info;
    }

    public static boolean isPrivateCloudAndConcurrentMode() {
        try {
            EASCloudEnum easCloudEnum;
            ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
            String sHRCloud = iLicenseSrvAgent.getLicenseBaseInfo().getSign();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("isPrivateCloudAndConcurrentMode : LicenseCloudVersion is {0}", sHRCloud));
            }
            if (EASCloudEnum.CLOUD_PRIVATE.equals((Object)(easCloudEnum = iLicenseSrvAgent.getRemoteEASCloudVersion())) && !iLicenseSrvAgent.isRegister() || "kingdee s-HR cloud V8.8".equals(sHRCloud) || "kingdee s-HR cloud V9.0".equals(sHRCloud)) {
                return true;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isCloudMode() {
        try {
            ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
            EASCloudEnum easCloudEnum = iLicenseSrvAgent.getRemoteEASCloudVersion();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("isCloudMode : easCloudEnum is {0}", easCloudEnum));
            }
            if (EASCloudEnum.CLOUD_PRIVATE.equals((Object)easCloudEnum) && iLicenseSrvAgent.isRegister() || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.equals((Object)easCloudEnum) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.equals((Object)easCloudEnum) || EASCloudEnum.CLOUD_HYBRID.equals((Object)easCloudEnum) || EASCloudEnum.CLOUD_PUBLIC.equals((Object)easCloudEnum)) {
                return true;
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Deprecated
    public static boolean isIncludeProModel(String uipk) {
        boolean falg;
        block4: {
            HashSet<String> models = new HashSet<String>();
            models.add("PRO_sHR_SSC");
            models.add("PRO_sHR_PerAtt");
            models.add("PRO_sHR_PerAttPay");
            models.add("o_SYS_sHR_KQGK");
            falg = false;
            try {
                ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
                String subSystemMap = "";
                if (licenseSrv != null) {
                    subSystemMap = licenseSrv.getSubSystemMapByUIClassName(uipk);
                }
                if (StringUtils.isEmpty((String)subSystemMap)) break block4;
                for (String subItem : subSystemMap.split(",")) {
                    if (!models.contains(subItem)) continue;
                    falg = true;
                    break;
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
            }
        }
        return falg;
    }

    public static boolean isInControl(String uipk, String module) {
        int licenselcFlag = LicenseHelper.requestLicense(uipk, module);
        boolean flag = true;
        if (7 == licenselcFlag || 8 == licenselcFlag || 9 == licenselcFlag || 74 == licenselcFlag) {
            flag = false;
        } else {
            ILicenseSrvAgent licenseSrv = LicenseHelper.getLicenseSrvAgent();
            if (StringUtils.isEmpty((String)module) && licenseSrv != null) {
                try {
                    String module0 = licenseSrv.getModuleByPackage(uipk);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("isInControl : module0 is {0}", module0));
                    }
                    if (!StringUtils.isEmpty((String)module0) && module0.indexOf("BOSRUNTIME") > -1) {
                        flag = false;
                    }
                }
                catch (LicenseException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }
}

