/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.BaseMultiLangUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class MultiLangUtils
extends BaseMultiLangUtils {
    protected static Logger logger = Logger.getLogger(MultiLangUtils.class);
    private static final String MODEL = "model";
    private static final String PROP_NAME = "propName";
    private static final String VALUE = "value";

    public static String getValue(JspContext jc, boolean displayAsHTML) {
        Object valueObj = jc.getAttribute(VALUE);
        if (valueObj != null) {
            return valueObj.toString();
        }
        String attribute = (String)jc.getAttribute(PROP_NAME);
        Object obj = jc.getAttribute(MODEL);
        Context ctx = SHRContext.getInstance().getContext();
        if (attribute != null && obj != null && obj instanceof IObjectValue) {
            Locale[] supportedLocales;
            HashMap<String, Object> m = new HashMap<String, Object>();
            IObjectValue model = (IObjectValue)obj;
            for (Locale locale : supportedLocales = BOSLocaleUtil.getSupportedLocales()) {
                String key = BOSLocaleUtil.getShortCode((Locale)locale);
                if (key == null) continue;
                Object localeValue = model.get(attribute, locale);
                if (localeValue instanceof String && displayAsHTML) {
                    localeValue = StringEscapeUtils.escapeHtml((String)((String)localeValue)).replaceAll("(\r\n|\n)", "<br/>").replaceAll(" ", "&nbsp");
                }
                m.put(key, localeValue);
            }
            return JSONUtils.convertObjectToJson(ctx, m);
        }
        return null;
    }

    public static void mergeSystemMultiLangOption(JspContext jc) {
        SHRContext instance = SHRContext.getInstance();
        if (instance != null) {
            boolean supportMultiLang = instance.isSupportMultiLang();
            jc.setAttribute("supportMultiLang", (Object)supportMultiLang);
            Object langs = jc.getAttribute("langs");
            Map systemLangs = null;
            if (langs == null && (systemLangs = instance.getLangs()) != null) {
                langs = JSONUtils.convertObjectToJson(instance.getContext(), systemLangs);
                jc.setAttribute("langs", langs);
            }
            Object defaultLang = jc.getAttribute("defaultLang");
            Context context = instance.getContext();
            Locale locale = null;
            String language = null;
            if (defaultLang == null && context != null && (locale = context.getLocale()) != null && (language = locale.getLanguage()) != null) {
                jc.setAttribute("defaultLang", (Object)language);
            }
        }
    }

    public static boolean isMultiLangEntityProperty(BOSObjectType bosObjectType, String property) {
        return MultiLangUtils.isMultiLangEntityProperty((Context)SHRContext.getInstance().getContext(), (BOSObjectType)bosObjectType, (String)property);
    }

    public static void setMultiLanValue(HttpServletRequest request, IObjectValue value) throws SHRWebException {
        if (null == value) {
            return;
        }
        if (!(value instanceof CoreBaseInfo)) {
            return;
        }
        Context ctx = SHRContext.getInstance().getContext();
        CoreBaseInfo info = (CoreBaseInfo)value;
        if (null != info.get("IS_SET_MULTILAN_VALUE")) {
            return;
        }
        String uipk = UIViewUtil.getUipk((ServletRequest)request);
        UIViewInfo uiviewInfo = null;
        uiviewInfo = "hr.ssc.resumeaudit".equals(uipk) || "hr.ssc.resumeview".equals(uipk) ? UIViewUtil.getUIViewInfoByUIPK(ctx, "hr.emp.resume.preEntry") : UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (null == uiviewInfo) {
            return;
        }
        List<FieldInfo> l = uiviewInfo.getFields();
        if (null == l || l.isEmpty()) {
            return;
        }
        for (FieldInfo fi : l) {
            OwnPropertyInfo own;
            PropertyInfo property = fi.getProperty();
            if (!(property instanceof OwnPropertyInfo) || !(own = (OwnPropertyInfo)property).isMultilingual()) continue;
            MultiLangUtils.multiLanValueSet(ctx, fi.getName(), info);
        }
        info.put("IS_SET_MULTILAN_VALUE", (Object)"true");
    }

    private static void multiLanValueSet(Context ctx, String fieldName, CoreBaseInfo model) {
        List lml = BOSConfigUtil.getLanguageMapingList();
        if (null == model || StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (fieldName.indexOf(".") != -1) {
            CoreBaseInfo tempCoreBaseInfo = null;
            String parentName = fieldName.substring(0, fieldName.indexOf("."));
            String currentName = fieldName.substring(fieldName.indexOf(".") + 1, fieldName.length());
            IObjectCollection tempCoreBaseCollection = null;
            if (model.get(parentName) instanceof CoreBaseInfo) {
                tempCoreBaseInfo = (CoreBaseInfo)model.get(parentName);
                if (StringUtils.isEmpty((String)currentName)) {
                    return;
                }
                if (!(tempCoreBaseInfo.get(currentName) instanceof String)) {
                    return;
                }
                MultiLangUtils.multiLanValueSet(ctx, currentName, tempCoreBaseInfo);
            } else if (model.get(parentName) instanceof IObjectCollection) {
                if (StringUtils.isEmpty((String)currentName)) {
                    return;
                }
                tempCoreBaseCollection = (IObjectCollection)model.get(parentName);
                int total = tempCoreBaseCollection.size();
                for (int i = 0; i < total; ++i) {
                    tempCoreBaseInfo = (CoreBaseInfo)tempCoreBaseCollection.getObject(i);
                    MultiLangUtils.multiLanValueSet(ctx, currentName, tempCoreBaseInfo);
                }
            }
        }
        if (MultiLangUtils.isMultiLangEntityProperty((Context)ctx, (BOSObjectType)model.getBOSType(), (String)fieldName)) {
            String currentNameValue = (String)model.get(fieldName);
            if (!StringUtils.isEmpty((String)currentNameValue) && currentNameValue.startsWith("{") && currentNameValue.endsWith("}")) {
                return;
            }
            HashMap multiLan = new HashMap();
            Map lang = null;
            int total = lml.size();
            for (int i = 0; i < total; ++i) {
                lang = (Map)lml.get(i);
                if (null == model.get(fieldName, LocaleUtils.getLocale((String)((String)lang.get("lang")))) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.getLocale((String)((String)lang.get("lang")))))) {
                    multiLan.put(lang.get("lang"), "");
                    continue;
                }
                multiLan.put(lang.get("lang"), (String)model.get(fieldName, LocaleUtils.getLocale((String)((String)lang.get("lang")))));
            }
            model.put(fieldName, (Object)JSONUtils.convertObjectToJson(ctx, multiLan));
        }
    }
}

