/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NetCtrlHelper {
    protected static Logger logger = Logger.getLogger(NetCtrlHelper.class);

    public static final boolean requestObjIDForUpdate(String dataId) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        String userName = SHRContext.getInstance().getContext().getUserName();
        boolean flag = mutexService.requestObjIDForUpdate(dataId, userName);
        logger.info((Object)("NetCtrlService........dataId :" + SHRCheck.vaildLog((String)dataId) + ";userName," + userName + " request net ctrl " + flag));
        return flag;
    }

    public static final Map batchRequestObjIDForUpdate(List dataList) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        String userName = SHRContext.getInstance().getContext().getUserName();
        Map map = mutexService.batchRequestObjIDForUpdate(dataList);
        logger.info((Object)("NetCtrlService........dataId :" + SHRCheck.vaildLog((String)dataList.toString()) + ";userName," + userName + " request net ctrl " + map.toString()));
        return map;
    }

    public static final void releaseObjIDForUpdate(String objId) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseObjIDForUpdate(objId);
    }

    public static final void batchReleaseObjIDForUpdate(List dataList) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.batchReleaseObjIDForUpdate(dataList);
    }

    public static final void releaseAllMutexBySessionID() throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        Context ctx = SHRContext.getInstance().getContext();
        mutexService.releaseAllFuncMutexAndObjLocks(ctx.getContextID());
    }
}

