/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.ServiceCollection;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.WorkPlatformFactory;
import com.kingdee.shr.base.syssetting.action.DataPlatformAction;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.LicenseHelper;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import com.kingdee.shr.common.model.RemoteCallMessage;
import com.kingdee.shr.pageset.util.PageSetUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public final class SHRLicenseControlPolicyHelper {
    private static Logger logger = Logger.getLogger(SHRLicenseControlPolicyHelper.class);
    private static final String SHRF7PATTERN = "/promptF7.do";
    private static final String SERVICECATEGORY_PER_SELF_ID = "5mGQU3WGQ+6dmhwiREYwEaYoOi4=";
    private static final String SERVICECATEGORY_MGR_ID = "8r0AAAAPSiqmKDou";
    private static final String SERVICECATEGORY_TEAM_ID = "3rMAAAABnqCmKDou";
    private static final String MGR_NEW_UIPK = "shr.manager.homepage.new";
    private static final String PER_SELF_NEW_UIPK = "shr.perself.homepage.new";
    private static final String MY_WORKPLATFORM_UIPK = "shr.myworkplatform.homepage";
    private static final Set<String> SANYI_EXT_UIPK = new HashSet<String>();

    public static void checkLicence(HttpServletRequest request, String uipk) throws SHRWebException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("uipk is {0}", uipk));
        }
        if (SHRLicenseControlPolicyHelper.isSHRF7Request(request) || SHRLicenseControlPolicyHelper.sanyiExtUIPK(uipk)) {
            return;
        }
        String module = request.getParameter("module");
        String pageUipk = SHRLicenseControlPolicyHelper.getReallyUipk(request, uipk);
        boolean isInControl = false;
        if (!StringUtils.isEmpty((String)pageUipk) && !pageUipk.equals(uipk)) {
            isInControl = SHRLicenseControlPolicyHelper.isInControl(pageUipk, module);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("pageUipk is {0}", pageUipk));
            }
        } else {
            isInControl = SHRLicenseControlPolicyHelper.isInControl(uipk, module);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("isInControl is {0}", isInControl));
        }
        if (!isInControl) {
            if (SHRLicenseControlPolicyHelper.isInService(uipk) || SHRLicenseControlPolicyHelper.isInNewWorkPlatform(uipk)) {
                if (SHRLicenseControlPolicyHelper.isPrivateCloudAndConcurrentMode()) {
                    SHRLicenseControlPolicyHelper.doCheckLicense(request, SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk));
                } else if (SHRLicenseControlPolicyHelper.isCloudMode()) {
                    ServiceInfo serviceInfo = SHRLicenseControlPolicyHelper.getServiceByUipk(uipk);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"isCloudMode is true");
                        if (null != serviceInfo) {
                            logger.debug((Object)MessageFormat.format("serviceName is {0}", serviceInfo.getName()));
                        }
                    }
                    if (SHRLicenseControlPolicyHelper.isPerSelf(serviceInfo) || PER_SELF_NEW_UIPK.equals(uipk) || MY_WORKPLATFORM_UIPK.equals(uipk)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"checkLicenseBosRunTimeForMYsHR");
                        }
                        LicenseHelper.checkLicenseBosRunTimeForMYsHR(SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk), "");
                    } else if (SHRLicenseControlPolicyHelper.isManger(serviceInfo) || MGR_NEW_UIPK.equals(uipk) || SHRLicenseControlPolicyHelper.isTeam(serviceInfo)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"checkLicenseBosRunTimeForManagerAndTeamM");
                        }
                        LicenseHelper.checkLicenseBosRunTimeForManagerAndTeamM(SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk), "");
                    } else if (null != serviceInfo && !SHRLicenseControlPolicyHelper.isPerSelf(serviceInfo) && !SHRLicenseControlPolicyHelper.isManger(serviceInfo) && !SHRLicenseControlPolicyHelper.isTeam(serviceInfo) && SHRLicenseControlPolicyHelper.isStandardServiceCategoryId(serviceInfo.getSubCategory().getServiceCategory().getId().toString())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"checkLicenseBosRunTimeForsHR");
                        }
                        LicenseHelper.checkLicenseBosRunTimeForsHR(SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk), "");
                    } else if (null != serviceInfo && !SHRLicenseControlPolicyHelper.isStandardServiceCategoryId(serviceInfo.getSubCategory().getServiceCategory().getId().toString())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"checkLicenseBosRunTime");
                        }
                        LicenseHelper.checkLicenseBosRunTime(SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk), "");
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"DoCheckLicense BaseOne");
                    }
                    SHRLicenseControlPolicyHelper.doCheckLicense(request, SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk));
                }
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DoCheckLicense BaseTwo");
            }
            SHRLicenseControlPolicyHelper.doCheckLicense(request, SHRLicenseControlPolicyHelper.tranUipk(uipk, pageUipk));
        }
    }

    private static String tranUipk(String uipk, String pageUipk) {
        String reallyUipk = uipk;
        if (!StringUtils.isEmpty((String)pageUipk)) {
            reallyUipk = pageUipk;
        }
        return reallyUipk;
    }

    private static boolean isPrivateCloudAndConcurrentMode() {
        return LicenseHelper.isPrivateCloudAndConcurrentMode();
    }

    private static boolean isCloudMode() {
        return LicenseHelper.isCloudMode();
    }

    private static void doCheckLicense(HttpServletRequest request, String uipk) throws SHRWebException {
        String module = request.getParameter("module");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("doCheckLicense : uipk is {0}", uipk));
        }
        if (StringUtils.isEmpty((String)module)) {
            LicenseHelper.checkLicence(uipk);
        } else {
            LicenseHelper.checkLicence(uipk, module);
        }
    }

    public static boolean isSHRF7Request(HttpServletRequest request) {
        String _uri = request.getRequestURI();
        boolean isSHRF7 = false;
        if (!StringUtils.isEmpty((String)_uri)) {
            isSHRF7 = _uri.indexOf(SHRF7PATTERN) > 0;
        }
        return isSHRF7;
    }

    private static boolean sanyiExtUIPK(String uipk) {
        return SANYI_EXT_UIPK.contains(uipk);
    }

    public static boolean isStandardUipk(String uipk) {
        return false;
    }

    public static boolean isInControl(String uipk, String module) {
        return LicenseHelper.isInControl(uipk, module);
    }

    private static boolean isInService(String uipk) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getUrlTypeServiceSql((String)uipk), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("urlType", (Object)"view", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("urlValue", (Object)uipk, CompareType.EQUALS));
        filter.setMaskString("#0 or (#1 and #2)");
        boolean flag = false;
        try {
            flag = ServiceFactory.getRemoteInstance().exists(filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean isInNewWorkPlatform(String uipk) throws SHRWebException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("uipk", (Object)uipk, CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("isNew", (Object)1, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        filter.getFilterItems().add(filterItem1);
        boolean flag = false;
        try {
            flag = WorkPlatformFactory.getRemoteInstance().exists(filter);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return flag;
    }

    public static ServiceInfo getServiceByUipk(String uipk) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("urlValue", (Object)uipk, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem0);
        FilterItemInfo filterItem1 = new FilterItemInfo("urlValue", (Object)MessageFormat.format("%uipk={0}%", uipk), CompareType.LIKE);
        filter.getFilterItems().add(filterItem1);
        filter.setMaskString("#0 or #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("urlValue"));
        sic.add(new SelectorItemInfo("subCategory.id"));
        sic.add(new SelectorItemInfo("subCategory.serviceCategory.id"));
        view.setSelector(sic);
        ServiceInfo serviceInfo = null;
        ServiceCollection coll = null;
        try {
            coll = ServiceFactory.getRemoteInstance().getServiceCollection(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != coll && coll.size() > 0) {
            serviceInfo = coll.get(0);
        }
        return serviceInfo;
    }

    public static boolean isPerSelf(ServiceInfo serviceInfo) {
        return SHRLicenseControlPolicyHelper.findService0(serviceInfo, SERVICECATEGORY_PER_SELF_ID);
    }

    public static boolean isManger(ServiceInfo serviceInfo) {
        return SHRLicenseControlPolicyHelper.findService0(serviceInfo, SERVICECATEGORY_MGR_ID);
    }

    public static boolean isTeam(ServiceInfo serviceInfo) {
        return SHRLicenseControlPolicyHelper.findService0(serviceInfo, SERVICECATEGORY_TEAM_ID);
    }

    private static boolean findService0(ServiceInfo serviceInfo, String id) {
        if (null == serviceInfo) {
            return false;
        }
        return id.equals(serviceInfo.getSubCategory().getServiceCategory().getId().toString());
    }

    public static boolean isStandardServiceCategoryId(String id) {
        Set<String> set = SHRLicenseControlPolicyHelper.getInnerServiceCategoryId();
        return set.contains(id);
    }

    private static Set<String> getInnerServiceCategoryId() {
        HashSet<String> set = new HashSet<String>();
        set.add(SERVICECATEGORY_MGR_ID);
        set.add("8zxZxwccQMy14rB+1iXTHaYoOi4=");
        set.add("aM2+2JxCTXG28sNnguewbqYoOi4=");
        set.add("BNSMehpVSpGBrUrWidtBgKYoOi4=");
        set.add("CLG55p3BR/6uyLuSNa/PyqYoOi4=");
        set.add("h6JBLKJOSgKf5UgZTj8BBqYoOi4=");
        set.add("Z4Ap5CbeQR+EAYEy/OZtWKYoOi4=");
        set.add("pnP9I/yiQ76SqVv6l1ULj6YoOi4=");
        set.add("e74AAAAmg4qmKDou");
        set.add("VO/MaNX/Syu+QkQHMJ6emKYoOi4=");
        set.add(SERVICECATEGORY_PER_SELF_ID);
        set.add("e74AAACCbqCmKDou");
        set.add("8RztooMYQ/KzKDIof5PxUKYoOi4=");
        set.add("uR1PyS+kRoCCb4eebjPW1KYoOi4=");
        set.add("DoVousUYR6WwI2uFA3TStKYoOi4=");
        set.add("eYkAAAAAPxKmKDou");
        set.add(SERVICECATEGORY_TEAM_ID);
        return set;
    }

    private static String getReallyUipk(HttpServletRequest request, String uipk) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            if (!StringUtils.isEmpty((String)PageSetUtils.getPageInfoIdByUipk((Context)ctx, (String)uipk)) && "dataplatformService".equals(request.getParameter("method"))) {
                RemoteCallMessage remoteCallMessage = DataPlatformAction.initMessage(ctx, request);
                Map params = remoteCallMessage.getParams();
                if ("/dataplateform/page.do".equals(remoteCallMessage.getServiceType()) && "init".equals(params.get("method"))) {
                    String pageId = (String)params.get("pageId");
                    return PageSetUtils.getUipkById((Context)ctx, (String)pageId);
                }
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return null;
    }

    static {
        SANYI_EXT_UIPK.add("com.kingdee.shr.base.syssetting.app.WaterMarkConfig.form");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.OrgAdd.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.OrgNameModify.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.Orgsplit.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.OrgMerge.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.StandardPosition.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.HumanPlanRevise.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.PersonClassMange.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.RankChangeBillAll.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.SscJobDetails.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.GreatWelfare.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.HighMealMange.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.IntegralManagement.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.RewardPublishMgr.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.RewardPublishMgr1");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.DifferentSafePay.list");
        SANYI_EXT_UIPK.add("com.kingdee.eas.hr.affair.app.JobInjuryRecord.list");
        SANYI_EXT_UIPK.add("com.kingdee.shr.ml.app.CodeCheck.list");
        SANYI_EXT_UIPK.add("com.kingdee.shr.base.syssetting.app.InteCQConfig.list");
        SANYI_EXT_UIPK.add("com.kingdee.shr.base.syssetting.app.InteCQLog.list");
    }
}

