/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentSecurityFactory;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentManagerFacade;
import com.kingdee.eas.base.attachment.IAttachmentSecurity;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.security.PlainFileInfo;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.IPersonBlackList;
import com.kingdee.eas.hr.base.PersonBlackListCollection;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.permission.util.SHRPermissionParamUtil;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.log.IOperateLogService;
import com.kingdee.shr.base.syssetting.log.OperateLogManager;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.CheckFunctionPermissionUtil;
import com.kingdee.shr.base.syssetting.permission.button.SHRButtonDataPermissionHelper;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.base.syssetting.util.ImportDecodeUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.AttachMentInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.common.util.XssFilterUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/attachmentUpload"})
public class AttachmentUploadController
extends WebComponentController {
    private static final String ASSOTYPE = "Added Accessories";
    private static Logger logger = LoggerFactory.getLogger(AttachmentUploadController.class);
    private static final String ATTACHMENT_ID = "attachment.id";
    private static final String ATTACHMENT_SIZE = "attachment.size";
    private static final String ATTACHMENT_NAME = "attachment.name";
    private static final String ATTACHMENT_SIMPLENAME = "attachment.simplename";
    private static final String ATTACHMENT_DESC = "attachment.description";
    private static final String ATTACHMENT_CREATOR = "attachment.creator.name";
    private static final String ATTACHMENT_CREATOR_TIME = "attachment.createTime";
    private static final String NAME = "name";
    private static final List<String> EXECLUDEUIPK_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("com.kingdee.shr.compensation.app.SHRWordTemplate.form");
        }
    };
    private static final List<String> EXECLUDEFILETYPE_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("xls");
            this.add("doc");
        }
    };

    @RequestMapping(params={"method=uploadAttachment"})
    @Action
    public void uploadAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, IOException, BOSException, EASBizException {
        String contentType = request.getContentType();
        String uipk = request.getParameter("uipk");
        String field = request.getParameter("field");
        String description = request.getParameter("description");
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            PrintWriter pw;
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("uploadAttach");
            multipartFile = ImportDecodeUtils.trans(multipartFile);
            ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            String originalFilename = multipartFile.getOriginalFilename();
            XssFilterUtil.stripXSS((String)originalFilename, (String)"filename");
            XssFilterUtil.stripXSS((String)multipartFile.getName(), (String)"filename");
            XssFilterUtil.stripXSS((String)uipk, (String)"filename");
            XssFilterUtil.stripXSS((String)field, (String)"filename");
            XssFilterUtil.stripXSS((String)description, (String)"filename");
            this.checkFileType(ctx, multipartFile, uipk, field);
            SHRAttachmentExtInfo attchExt = this.getSimpleAttachment(ctx, request, multipartFile);
            shrAttchExt.addnew((CoreBaseInfo)attchExt);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", attchExt.getAttachment().getId().toString());
            data.put("filename", originalFilename);
            data.put("uploader", ContextUtil.getCurrentUserInfo((Context)ctx).getName(this.getLocale()));
            String uploadDateTime = UserNantionalUtil.getUserDateStr((Context)ctx, (Date)attchExt.getCreateTime());
            data.put("uploadDateTime", uploadDateTime);
            data.put("remark", "");
            response.setContentType("text/html;charset=UTF-8");
            try {
                pw = response.getWriter();
            }
            catch (IOException e) {
                throw new SHRWebException("can't open the output stream!");
            }
            StringBuilder strSuccessJson = new StringBuilder();
            strSuccessJson.append("{");
            strSuccessJson.append("\"result\":\"");
            strSuccessJson.append("success");
            strSuccessJson.append("\",\"data\":");
            strSuccessJson.append(JSONUtils.convertObjectToJson(ctx, data).toString());
            String successMessage = (String)request.getAttribute("successMessage");
            if (!StringUtils.isEmpty((String)successMessage)) {
                strSuccessJson.append(",\"successMessage\":\"");
                strSuccessJson.append(successMessage);
                strSuccessJson.append("\"");
            }
            strSuccessJson.append("}");
            pw.flush();
            pw.write(strSuccessJson.toString());
            pw.flush();
        }
    }

    public void checkFileType(Context ctx, MultipartFile multipartFile, String uipk, String field) throws SHRWebException {
        String originalFilename = multipartFile.getOriginalFilename();
        String fileType = null;
        UIViewInfo viewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        Map<String, String> includeAndexcludeFiletype = this.getAttachFileType(viewInfo, field);
        String includeFileType = includeAndexcludeFiletype.get("includeFileType");
        String excludeFileType = this.distinct(includeAndexcludeFiletype.get("excludeFileType"));
        String[] excludeFiletypes = excludeFileType.split(",");
        String maxSize = includeAndexcludeFiletype.get("maxSize");
        if (!StringUtils.isEmpty((String)maxSize) && multipartFile.getSize() > Long.parseLong(maxSize) * 1024L * 1024L) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_file_size", maxSize + "M"));
        }
        if (!StringUtils.isEmpty((String)originalFilename)) {
            fileType = originalFilename.substring(originalFilename.lastIndexOf(".") + ".".length(), originalFilename.length());
        }
        for (String type : excludeFiletypes) {
            if (!type.equalsIgnoreCase(fileType)) continue;
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "type_forbid"), excludeFileType));
        }
        if (!StringUtils.isEmpty((String)includeFileType) && !StringUtils.isEmpty((String)fileType) && includeFileType.toLowerCase().indexOf(fileType.toLowerCase()) == -1) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "type_forbid"), fileType));
        }
        if (EXECLUDEUIPK_LIST.contains(uipk) && EXECLUDEFILETYPE_LIST.contains(fileType)) {
            return;
        }
        try {
            IAttachment ia = AttachmentFactory.getLocalInstance((Context)ctx);
            PlainFileInfo plainInfo = new PlainFileInfo(originalFilename, multipartFile.getInputStream());
            IAttachmentSecurity security = AttachmentSecurityFactory.getInstance();
            StringUtil4File.checkFile((IAttachment)ia, (byte[])multipartFile.getBytes());
            StringUtil4File.checkInvalidCharsInFileName((String)originalFilename);
            security.check(plainInfo);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private SHRAttachmentExtInfo getSimpleAttachment(Context ctx, HttpServletRequest request, MultipartFile multipartFile) throws BOSException, EASBizException, IOException, ShrWebBizException {
        IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
        IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        String boID = request.getParameter("boID");
        String onlyone = request.getParameter("onlyone");
        String propertyName = request.getParameter("field");
        String isFromWF = request.getParameter("isFromWF");
        String fileUUID = request.getParameter("fileUUID");
        if (StringUtils.isEmpty((String)propertyName)) {
            propertyName = "null0";
        }
        String description = request.getParameter("description");
        String uipk = request.getParameter("uipk");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String bunding = this.getBunding(fileUUID, uipk, userId);
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        if (Boolean.valueOf(onlyone).booleanValue()) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bunding", (Object)bunding));
            filterInfo.getFilterItems().add(new FilterItemInfo("propertyName", (Object)propertyName));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (!StringUtils.isEmpty((String)boID)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)boID));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
            }
            entityViewInfo.setFilter(filterInfo);
            ISHRAttachmentExt SHRAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            SHRAttachmentExtCollection collection = SHRAttchExt.getSHRAttachmentExtCollection(entityViewInfo);
            SHRAttchExt.delete(filterInfo);
            for (int i = 0; i < collection.size(); ++i) {
                String attId = collection.get(i).getAttachment().getId().toString();
                if (!StringUtils.isEmpty((String)boID)) {
                    attchAsso.delete(MessageFormat.format(" where attachment = ''{0}''", attId));
                    continue;
                }
                attachment.delete((IObjectPK)new ObjectUuidPK(attId));
            }
        }
        String fullname = multipartFile.getOriginalFilename();
        if (!(fullname = this.checkScriptAttack(fullname)).contains(".")) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_file_type"));
        }
        String mainname = fullname.substring(0, fullname.lastIndexOf(46));
        String extname = fullname.substring(fullname.lastIndexOf(46) + 1, fullname.length());
        extname = extname.toLowerCase();
        byte[] content = multipartFile.getBytes();
        AttachmentInfo ai = new AttachmentInfo();
        this.setAttMulNameAndDesc(ctx, ai, mainname, description);
        ai.setSimpleName(extname);
        ai.setFile(content);
        ai.setIsShared(false);
        ai.setGroupType(propertyName);
        ai.setSharedDesc(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false"));
        int size = (int)multipartFile.getSize();
        if (size < 1024) {
            ai.setSize(size + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "byte"));
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        SecureRandom rd = new SecureRandom();
        int rdValue = rd.nextInt(100);
        String attchId = String.valueOf(System.currentTimeMillis());
        attchId = rdValue >= 10 ? attchId + rdValue : attchId + "0" + rdValue;
        if (logger.isDebugEnabled()) {
            logger.debug("attchId:" + attchId);
        }
        ai.setAttachID(attchId);
        ai.setType(this.getFileType(fullname));
        ai.setBeizhu(uipk);
        attchExt.setAttachment(ai);
        this.setAttExtMulNameAndDesc(ctx, attchExt, fullname, null);
        attchExt.setPropertyName(propertyName);
        if (propertyName.startsWith("null")) {
            attchExt.setType(AttachmentTypeEnum.FORM);
        } else {
            attchExt.setType(AttachmentTypeEnum.PROPERTY);
        }
        attchExt.setState(AttachmentState.UNSAVE);
        attchExt.setBunding(bunding);
        attchExt.setBoID(boID);
        IObjectPK pk0 = null;
        try {
            pk0 = attachment.addnew(ai);
            if (null == ai.getId()) {
                ai.setId(BOSUuid.read((String)pk0.toString()));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "upload_error"), e);
        }
        if (Boolean.valueOf(onlyone).booleanValue() && !StringUtils.isEmpty((String)boID) || !StringUtils.isEmpty((String)isFromWF) && Boolean.valueOf(isFromWF).booleanValue()) {
            attchExt.setState(AttachmentState.SAVE);
            BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
            boAttchAssoInfo.setBoID(boID);
            boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
            boAttchAssoInfo.setAssoType(ASSOTYPE, LocaleUtils.locale_l1);
            boAttchAssoInfo.setAssoType(ASSOTYPE, LocaleUtils.locale_l2);
            boAttchAssoInfo.setAssoType(ASSOTYPE, LocaleUtils.locale_l3);
            boAttchAssoInfo.setAttachment(ai);
            attchAsso.addnew(boAttchAssoInfo);
        }
        return attchExt;
    }

    private String checkScriptAttack(String str) {
        String checkString = "";
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains("<")) {
                checkString = str.replaceAll("<", "&lt;");
            }
            if (str.contains(">")) {
                checkString = str.replaceAll(">", "&gt;");
            }
            if (StringUtils.isEmpty((String)checkString)) {
                checkString = str;
            }
        }
        return checkString;
    }

    private void setAttMulNameAndDesc(Context ctx, AttachmentInfo att, String name, String desc) {
        if (att == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)NAME, (IObjectValue)att, (String)name);
        MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"description", (IObjectValue)att, (String)desc);
    }

    private void setAttExtMulNameAndDesc(Context ctx, SHRAttachmentExtInfo info, String name, String desc) {
        if (info == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        Locale locale = ctx.getLocale();
        info.setName(name, LocaleUtils.locale_l1);
        info.setDescription(desc, LocaleUtils.locale_l1);
        if (LocaleUtils.locale_l1.getDisplayName().equals(LocaleUtils.getLocaleString((Locale)locale))) {
            info.setName(name, LocaleUtils.locale_l2);
            info.setName(name, LocaleUtils.locale_l3);
            info.setDescription(desc, LocaleUtils.locale_l2);
            info.setDescription(desc, LocaleUtils.locale_l3);
        } else if (LocaleUtils.locale_l2.getDisplayName().equals(LocaleUtils.getLocaleString((Locale)locale))) {
            info.setName(name, LocaleUtils.locale_l2);
            info.setName(STConverter.sc2tc((String)name), LocaleUtils.locale_l3);
            if (!StringUtils.isEmpty((String)desc)) {
                info.setDescription(desc, LocaleUtils.locale_l2);
                info.setDescription(STConverter.sc2tc((String)desc), LocaleUtils.locale_l3);
            }
        } else {
            info.setName(STConverter.tc2sc((String)name), LocaleUtils.locale_l2);
            info.setName(name, LocaleUtils.locale_l3);
            if (!StringUtils.isEmpty((String)desc)) {
                info.setDescription(STConverter.tc2sc((String)desc), LocaleUtils.locale_l2);
                info.setDescription(desc, LocaleUtils.locale_l3);
            }
        }
    }

    private String getFileType(String fullname) {
        String extname = fullname.substring(fullname.lastIndexOf(46) + 1, fullname.length());
        if ("doc".equalsIgnoreCase(extname) || "docx".equalsIgnoreCase(extname)) {
            return SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "microsoft_word");
        }
        if ("xls".equalsIgnoreCase(extname) || "xlsx".equalsIgnoreCase(extname) || "xlsm".equalsIgnoreCase(extname) || "xlsb".equalsIgnoreCase(extname)) {
            return SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "microsoft_excel");
        }
        if ("ppt".equalsIgnoreCase(extname) || "pptx".equalsIgnoreCase(extname) || "pptm".equalsIgnoreCase(extname)) {
            return SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "microsoft_ppt");
        }
        if ("txt".equalsIgnoreCase(extname)) {
            return SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "text");
        }
        return MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unknow_type"), extname);
    }

    @RequestMapping(params={"method=initialAttachment"})
    @Action
    public void initialAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException, IOException {
        Context ctx = SHRContext.getInstance().getContext();
        String isMountFlowAttachment = request.getParameter("isMountFlowAttachment");
        String fileUUID = request.getParameter("fileUUID");
        this.checkPermission(ctx, request, response);
        String formId = request.getParameter("formId");
        String propertyName = request.getParameter("propertyName");
        String uipk = request.getParameter("uipk");
        String sorter = request.getParameter("sorter");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String bunding = this.getBunding(fileUUID, uipk, userId);
        this.deleteUnsaveAttachment(ctx, bunding, formId);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)10));
        if (!StringUtils.isEmpty((String)propertyName)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("propertyName", (Object)propertyName));
        }
        if (StringUtils.isEmpty((String)formId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bunding", (Object)bunding));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        entityViewInfo.setSelector(sic);
        if (!StringUtils.isEmpty((String)sorter)) {
            SorterItemCollection sorters = this.getSorters(sorter);
            entityViewInfo.setSorter(sorters);
        }
        List<Map<String, String>> attachInfoList = this.getAttachmentByBoIdAndPropertyName(ctx, entityViewInfo, formId, propertyName, bunding, isMountFlowAttachment);
        JSONUtils.SUCCESS(attachInfoList);
    }

    private String getBunding(String fileUUID, String uipk, String userId) {
        String bunding = userId + "#" + uipk;
        if (!StringUtils.isEmpty((String)fileUUID)) {
            bunding = bunding + "#" + fileUUID;
        }
        return bunding;
    }

    private SorterItemCollection getSorters(String sorter) {
        String[] strs;
        SorterItemCollection sorters = new SorterItemCollection();
        for (String sort : strs = sorter.split(",")) {
            String[] sorts = sort.split("\\s+");
            if (sorts.length != 2) continue;
            SorterItemInfo itemInfo = new SorterItemInfo(sorts[0]);
            itemInfo.setSortType(SortType.ASCEND.toString().equals(sorts[1]) ? SortType.ASCEND : SortType.DESCEND);
            sorters.add(itemInfo);
        }
        return sorters;
    }

    private void updateAppAttachment2ShrAttachmentExt(Context ctx, String formId, String propertyName, String bunding) throws BOSException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String cuid = HRFilterUtils.getCurrentCUID((Context)ctx);
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into T_HR_SHRAttachmentExt(FAttachment,FPropertyName,FType,FState,FBunding,FBoID,FName_l1,FName_l2,FName_l3,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID) ");
        insertSql.append(" SELECT distinct T0.fid FAttachment,fgrouptype FPropertyName,'").append("property").append("' FType,");
        insertSql.append(10).append(" FState,'").append(bunding).append("'FBunding,t1.FBOID  FBOID, t0.FNAME_l1 FName_l1,t0.FNAME_l2 FName_l2,t0.FNAME_l3 FName_l3,'");
        insertSql.append(userId).append("' FCreatorID,t0.FCREATETIME FCREATETIME,'").append(userId).append("' FLastUpdateUserID ,now() FLastUpdateTime, '");
        insertSql.append(cuid).append("' FControlUnitID, newbosid('E367B1FA') fid ");
        insertSql.append(" FROM  T_BAS_Attachment T0 inner join T_BAS_BoAttchAsso T1 on T0.FID = T1.FATTACHMENTID ");
        insertSql.append(" where T1.FBOID = '").append(formId).append("' and fgrouptype is not null ");
        insertSql.append(" and not exists(SELECT 1 FROM T_HR_SHRAttachmentExt t2 where t2.FATTACHMENT =t0.fid and t2.FBOID =t1.FBOID and t2.FPROPERTYNAME =t0.fgrouptype)");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private List<Map<String, String>> getAttachmentByBoIdAndPropertyName(Context ctx, EntityViewInfo entityViewInfo, String formId, String propertyName, String bunding, String isMountFlowAttachment) throws BOSException, EASBizException, SHRWebException {
        List<AttachmentInfo> list;
        this.updateAppAttachment2ShrAttachmentExt(ctx, formId, propertyName, bunding);
        boolean isMount = "true".equals(isMountFlowAttachment);
        ArrayList<Map<String, String>> attachInfoList = new ArrayList<Map<String, String>>();
        SHRAttachmentExtCollection aextColl = new SHRAttachmentExtCollection();
        SHRAttachmentExtCollection extColl = this.getSHRAttchExtColByBoID(ctx, formId);
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        ISHRAttachmentExt shrAttachment = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        HashSet<String> attachIdSet = new HashSet<String>();
        for (int i = 0; i < extColl.size(); ++i) {
            SHRAttachmentExtInfo shrAttach = extColl.get(i);
            AttachmentInfo ai = shrAttach.getAttachment();
            String id = "";
            if (ai != null && ai.getId() != null) {
                id = ai.getId().toString();
                attachIdSet.add(id);
                aextColl.add(shrAttach);
            }
            try {
                if (!iAttachment.exists((IObjectPK)new ObjectUuidPK(id))) continue;
                aextColl.add(shrAttach);
                continue;
            }
            catch (ObjectNotFoundException e) {
                logger.error("attachment not found, attachment id :" + id, (Throwable)e);
                try {
                    shrAttachment.delete(MessageFormat.format(" where id = ''{0}''", shrAttach.getId().toString()));
                    boAttchAsso.delete(MessageFormat.format(" where attachment = ''{0}''", id));
                    continue;
                }
                catch (Exception e1) {
                    logger.error("attachment not found, attachment id :" + id, (Throwable)e1);
                }
            }
        }
        BoAttchAssoCollection boColl = this.getBoAttchAssoCol(ctx, formId);
        if (isMount && !(list = this.getNoPropertyNameAttch(aextColl, boColl)).isEmpty()) {
            for (AttachmentInfo ai : list) {
                SHRAttachmentExtInfo shrAttch = new SHRAttachmentExtInfo();
                shrAttch.setPropertyName(propertyName);
                shrAttch.setAttachment(ai);
                shrAttch.setName(ai.getName());
                shrAttch.setBoID(formId);
                shrAttch.setBunding(bunding);
                if (propertyName.startsWith("null")) {
                    shrAttch.setType(AttachmentTypeEnum.FORM);
                } else {
                    shrAttch.setType(AttachmentTypeEnum.PROPERTY);
                }
                shrAttch.setState(AttachmentState.SAVE);
                shrAttch.setCreator(ai.getCreator());
                shrAttch.setCreateTime(ai.getCreateTime());
                shrAttchExt.addnew((CoreBaseInfo)shrAttch);
            }
        }
        SHRAttachmentExtCollection coll = shrAttchExt.getSHRAttachmentExtCollection(entityViewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            SHRAttachmentExtInfo shrAttach = coll.get(i);
            AttachmentInfo attachmentInfo = shrAttach.getAttachment();
            if (attachmentInfo == null) continue;
            try {
                Map<String, String> map = this.generateAttMap(ctx, attachmentInfo);
                map.put("remark", shrAttach.getDescription());
                attachInfoList.add(map);
                continue;
            }
            catch (Exception e) {
                logger.error("attachmentInfo:" + attachmentInfo.getId());
                e.printStackTrace();
            }
        }
        String displayPropertyName = this.getPropertyNameForDisplay(ctx, bunding);
        if (null != boColl && !boColl.isEmpty() && !isMount && displayPropertyName.equals(propertyName)) {
            int total = boColl.size();
            for (int i = 0; i < total; ++i) {
                BoAttchAssoInfo bai = boColl.get(i);
                AttachmentInfo attachmentInfo = bai.getAttachment();
                if (attachIdSet.contains(attachmentInfo.getId().toString())) continue;
                Map<String, String> map = this.generateAttMap(ctx, attachmentInfo);
                map.put("remark", "");
                attachInfoList.add(map);
            }
        }
        return attachInfoList;
    }

    private String getPropertyNameForDisplay(Context ctx, String bunding) {
        String uipk;
        String propertyName = "null0";
        if (!StringUtils.isEmpty((String)bunding) && !StringUtils.isEmpty((String)(uipk = bunding.split("#")[1]))) {
            uipk = SHRPermissionWebUtils.getRealUipk(uipk);
            try {
                UIViewInfo uiviewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                if (null != uiviewInfo) {
                    Map<String, List<AttachMentInfo>> m = uiviewInfo.getAttachMents();
                    if (null == m || m.containsKey(propertyName)) {
                        return propertyName;
                    }
                    for (Map.Entry<String, List<AttachMentInfo>> entry : m.entrySet()) {
                        List<AttachMentInfo> l = entry.getValue();
                        AttachMentInfo a = l.get(0);
                        if (!a.isFirstAttachment()) continue;
                        return entry.getKey();
                    }
                }
            }
            catch (SHRWebException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return propertyName;
    }

    private Map<String, String> generateAttMap(Context ctx, AttachmentInfo attachmentInfo) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", attachmentInfo.getId().toString());
        map.put(NAME, attachmentInfo.getName());
        map.put("simpleName", attachmentInfo.getSimpleName());
        map.put("size", attachmentInfo.getSize());
        map.put("uploader", attachmentInfo.getCreator().getName());
        map.put("uploadDateTime", UserNantionalUtil.getUserDateStr((Context)ctx, (Date)attachmentInfo.getCreateTime()));
        return map;
    }

    private void deleteUnsaveAttachment(Context ctx, String bunding, String formId) throws BOSException, EASBizException {
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bunding", (Object)bunding));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        if (!StringUtils.isEmpty((String)formId)) {
            filter.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        }
        if (shrAttchExt.exists(filter)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SHRAttachmentExtCollection col = shrAttchExt.getSHRAttachmentExtCollection(view);
            shrAttchExt.delete(filter);
            for (int i = 0; i < col.size(); ++i) {
                attachment.delete((IObjectPK)new ObjectUuidPK(col.get(i).getAttachment().getId().toString()));
            }
        }
    }

    private List<AttachmentInfo> getNoPropertyNameAttch(SHRAttachmentExtCollection extColl, BoAttchAssoCollection boColl) {
        ArrayList<AttachmentInfo> list = new ArrayList<AttachmentInfo>();
        ArrayList<String> attchIds = new ArrayList<String>();
        if (extColl.size() == boColl.size()) {
            return list;
        }
        if (extColl.size() > 0) {
            for (int j = 0; j < extColl.size(); ++j) {
                AttachmentInfo attj = extColl.get(j).getAttachment();
                if (attj == null || attj.getId() == null) continue;
                attchIds.add(attj.getId().toString());
            }
        }
        if (boColl.size() > 0) {
            for (int i = 0; i < boColl.size(); ++i) {
                AttachmentInfo atti = boColl.get(i).getAttachment();
                if (atti == null || atti.getId() == null || attchIds.contains(atti.getId().toString())) continue;
                list.add(atti);
            }
        }
        return list;
    }

    private SHRAttachmentExtCollection getSHRAttchExtColByBoID(Context ctx, String formId) throws BOSException {
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)formId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(this.getAttachmentExtSelector());
        return shrAttchExt.getSHRAttachmentExtCollection(entityViewInfo);
    }

    private AttachmentCollection getAttachmentColByAttachId(Context ctx, String[] attachIds) throws BOSException {
        IAttachment attchment = AttachmentFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)DataValueTranslatorUtil.stringArray2String((String[])attachIds), CompareType.INNER));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(this.getAttachmentExtSelector());
        return attchment.getAttachmentCollection(entityViewInfo);
    }

    private SelectorItemCollection getAttachmentExtSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_DESC));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        return sic;
    }

    public static String StringFilter(String str) throws PatternSyntaxException {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    @RequestMapping(params={"method=downloadAttachment"})
    @Action
    public void downloadAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String fullFileName = this.writeAttachementFile(ctx, request);
        JSONUtils.SUCCESS(fullFileName);
    }

    @RequestMapping(params={"method=deleteAttachment"})
    @Action
    public void deleteAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws EASBizException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String isDeleteFile = request.getParameter("isDeleteFile");
        String attachId = request.getParameter("attachId");
        String boID = request.getParameter("boID");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("attachment", (Object)BOSUuid.read((String)attachId)));
        IOperateLogService service = null;
        try {
            service = OperateLogManager.getIOperateLogService(ctx, OperateLogManager.getAttachMentLogConfigBean(ctx));
            if (null != service) {
                service.preLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ISHRAttachmentExt ishrAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            if (!StringUtils.isEmpty((String)isDeleteFile) && Boolean.valueOf(isDeleteFile).booleanValue()) {
                ishrAttachmentExt.delete(filterInfo);
                iBoAttchAsso.delete(filterInfo);
                AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(attachId));
            } else {
                FilterItemInfo filterItemInfo = null;
                if (!StringUtils.isEmpty((String)boID)) {
                    filterItemInfo = new FilterItemInfo("boID", (Object)boID);
                    filterInfo.getFilterItems().add(filterItemInfo);
                }
                ishrAttachmentExt.delete(filterInfo);
                iBoAttchAsso.delete(filterInfo);
                if (filterItemInfo != null) {
                    filterInfo.getFilterItems().remove(filterItemInfo);
                }
                if (!ishrAttachmentExt.exists(filterInfo) && !iBoAttchAsso.exists(filterInfo)) {
                    AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(attachId));
                }
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "delete_fail"), e);
        }
        catch (BOSException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "delete_fail"), e);
        }
        try {
            if (null != service) {
                service.postLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"method=download"})
    public String downloadAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        this.writeAttachementFile(ctx, request, response);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String writeAttachementFile(Context ctx, HttpServletRequest request) throws ShrWebBizException, BOSException, EASBizException {
        String attachId = request.getParameter("id");
        if (StringUtils.isEmpty((String)attachId)) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_fail"), "id"));
        }
        AttachmentInfo ai = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachId));
        String serverPath = request.getSession().getServletContext().getRealPath(File.separator);
        String fileDir = "newAttachmentFoler" + File.separator + AttachmentUploadController.StringFilter(attachId) + File.separator;
        String realFileDir = serverPath + fileDir;
        File file = new File(SHRCheck.checkFilePath((String)realFileDir));
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = ai.getName() + "." + ai.getSimpleName();
        String realFileName = realFileDir + fileName;
        file = new File(SHRCheck.checkFilePath((String)realFileName));
        FileOutputStream out = null;
        try {
            IAttachmentManagerFacade iAttachmentManagerFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            byte[] content = iAttachmentManagerFacade.downLoad(attachId);
            out = new FileOutputStream(file);
            ((OutputStream)out).write(content);
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
                catch (BOSException e2) {
                    if (!e2.getMessage().contains("Connection refused")) throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e2);
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "linked_error"), e2);
                }
            }
            catch (Throwable throwable) {
                this.closeStream(out);
                throw throwable;
            }
        }
        this.closeStream(out);
        return fileDir + fileName;
    }

    private String writeAttachementFile(Context ctx, HttpServletRequest request, HttpServletResponse response) throws ShrWebBizException, BOSException, EASBizException {
        String attachId = request.getParameter("id");
        if (logger.isDebugEnabled()) {
            logger.debug("++++++ attachment downloadAction : attachId = " + attachId);
        }
        if (StringUtils.isEmpty((String)attachId)) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_fail"), "id"));
        }
        AttachmentInfo ai = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachId));
        String fileName = ai.getName() + "." + ai.getSimpleName();
        ServletOutputStream out = null;
        try {
            response.reset();
            this.setResponseHeader(request, response, fileName);
            IAttachmentManagerFacade iAttachmentManagerFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            byte[] content = iAttachmentManagerFacade.downLoad(attachId);
            out = response.getOutputStream();
            out.write(content);
            out.close();
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
            }
            catch (Throwable throwable) {
                this.closeStream(new Closeable[]{out});
                throw throwable;
            }
        }
        this.closeStream(new Closeable[]{out});
        return null;
    }

    @RequestMapping(params={"method=downloadByName"})
    public String downloadByNameAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        String name = request.getParameter(NAME);
        Context ctx = SHRContext.getInstance().getContext();
        if (StringUtils.isEmpty((String)name)) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"download_fail", (Context)ctx), "(name)"));
        }
        StringBuffer file0 = new StringBuffer();
        StringBuffer common = new StringBuffer();
        common.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append("document");
        StringBuffer sbSHRModelManualConfig = new StringBuffer();
        sbSHRModelManualConfig.append(common.toString()).append(File.separator).append("sHR_model_Manual_config.xml");
        StringBuffer local = new StringBuffer();
        String lang = BOSConfigUtil.getOriginLocaleContextLanguage((Context)ctx);
        local.append(common.toString()).append(File.separator).append("Manual_config_").append(lang).append(".properties");
        Map<String, Map<String, String>> map = this.getDocumentMap(sbSHRModelManualConfig.toString());
        try {
            Properties p = SHRSyssettingUtil.getPropertiesFileByPath((String)local.toString());
            if ("allDocuments".equals(name)) {
                this.initAllZipDocuments(common.toString(), name, map, p, lang);
            }
            this.setResponseHeader(request, response, (String)p.get(name + ".name"));
            response.setContentType("application/octet-stream");
            String fileName = this.getHelperFileName(map.get(name).get(NAME), lang);
            file0.append(common.toString()).append(File.separator).append(fileName);
            this.downloadByNameAttachment((OutputStream)response.getOutputStream(), file0.toString(), p);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"download_error", (Context)ctx), e);
        }
        return null;
    }

    private String getHelperFileName(String fileName, String lang) {
        int i = fileName.lastIndexOf(".");
        return MessageFormat.format("{0}_{1}.{2}", fileName.substring(0, i), lang, fileName.substring(i + 1));
    }

    private Map<String, Map<String, String>> getDocumentMap(String path) throws ShrWebBizException {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        try {
            SAXBuilder builder = new SAXBuilder();
            XMLUtil.setReaderFeature((SAXBuilder)builder);
            Document doc = builder.build(path);
            Element root = doc.getRootElement();
            List eles = root.getChildren("model");
            for (Element e : eles) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("id", e.getChildText("id"));
                m.put(NAME, e.getChildText(NAME));
                map.put(e.getChildText("id"), m);
            }
        }
        catch (Exception e) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "get_config_error"), path), e);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initAllZipDocuments(String dir, String name, Map<String, Map<String, String>> map, Properties p, String lang) throws ShrWebBizException {
        String text = "";
        String fileName0 = this.getHelperFileName(map.get(name).get(NAME), lang);
        File zipfile = new File(SHRCheck.checkFilePath((String)(dir + File.separator + fileName0)));
        if (zipfile.exists()) {
            zipfile.delete();
        }
        ZipOutputStream zipOut = null;
        FileInputStream in = null;
        BufferedInputStream bi = null;
        try {
            zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(zipfile));
            zipOut.setEncoding("GBK");
            byte[] buf = new byte[5120];
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                String key = entry.getKey();
                Map<String, String> value = entry.getValue();
                if (name.equals(key)) continue;
                String fileName = this.getHelperFileName(value.get(NAME), lang);
                File file = new File(SHRCheck.checkFilePath((String)(dir + File.separator + fileName)));
                if (!file.exists()) {
                    if (StringUtils.isEmpty((String)text)) {
                        text = fileName;
                    }
                    text = text + "," + fileName;
                }
                try {
                    int len;
                    in = new FileInputStream(file);
                    bi = new BufferedInputStream(in);
                    zipOut.putNextEntry(new ZipEntry((String)p.get(key + ".name")));
                    while ((len = in.read(buf)) != -1) {
                        zipOut.write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    this.closeStream(bi, in);
                    throw throwable;
                }
                this.closeStream(bi, in);
            }
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
            }
            catch (Throwable throwable) {
                this.closeStream(new Closeable[]{bi, in, zipOut});
                throw throwable;
            }
        }
        this.closeStream(new Closeable[]{bi, in, zipOut});
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        throw new ShrWebBizException(text + SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operation_file_not_exist"));
    }

    private void downloadByNameAttachment(OutputStream out, String path, Properties p) throws ShrWebBizException {
        File file = new File(path);
        if (!file.exists()) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "path_not_exist"), path));
        }
        FileInputStream in = null;
        BufferedInputStream bis = null;
        try {
            int len;
            in = new FileInputStream(path);
            bis = new BufferedInputStream(in);
            byte[] buffer = new byte[5120];
            while ((len = bis.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
            }
            catch (Throwable throwable) {
                this.closeStream(out, bis, in);
                throw throwable;
            }
        }
        this.closeStream(out, bis, in);
    }

    private void setResponseHeader(HttpServletRequest request, HttpServletResponse response, String filename) throws UnsupportedEncodingException {
        String encodeFileName = URLEncoder.encode(filename, "UTF-8");
        encodeFileName = encodeFileName.replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";");
        encodeFileName = encodeFileName.replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,");
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        if (!StringUtils.isEmpty((String)userAgent) && userAgent.contains("safari") && !userAgent.contains("chrome")) {
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + SHRCheck.checkFileNameForSetResponseHeader((String)encodeFileName));
        } else {
            response.setContentType("application/x-download");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", SHRCheck.checkFileNameForSetResponseHeader((String)encodeFileName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"method=batchImportResignProof"})
    @Action
    public void batchImportResignProofAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("batchImportPackage");
            String onlyone = request.getParameter("onlyone");
            String serverPath = SHRSyssettingUtil.getShrWebWarPath() + File.separator + "newAttachmentFoler" + File.separator;
            this.deletedFile(serverPath);
            File newFolder = new File(serverPath);
            newFolder.mkdir();
            String fileType = "";
            String originalFilename = multipartFile.getOriginalFilename();
            if (!StringUtils.isEmpty((String)originalFilename)) {
                fileType = originalFilename.substring(originalFilename.lastIndexOf(".") + ".".length(), originalFilename.length());
            }
            if (!"zip".equals(fileType)) {
                throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"type_forbid", (Context)ctx, (Object[])new Object[]{fileType}));
            }
            File unZipFile = new File(serverPath + originalFilename);
            FileOutputStream ops = null;
            int inslen = 0;
            byte[] insbuf = new byte[1024];
            try {
                ops = new FileOutputStream(unZipFile);
                InputStream inputs = multipartFile.getInputStream();
                while ((inslen = inputs.read(insbuf, 0, 1024)) != -1) {
                    ((OutputStream)ops).write(insbuf, 0, inslen);
                }
            }
            finally {
                if (ops != null) {
                    ((OutputStream)ops).close();
                }
            }
            ZipFile zfile = new ZipFile(unZipFile, "GBK");
            Enumeration zList = zfile.getEntries();
            ZipEntry ze = null;
            ArrayList<String> errorfileList = new ArrayList<String>();
            PersonBlackListInfo blackListInfo = null;
            String boid = null;
            IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
            String unit = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "byte");
            while (zList.hasMoreElements()) {
                ze = (ZipEntry)zList.nextElement();
                String[] fileNameArr = ze.getName().split("\\.");
                if (ze.isDirectory()) continue;
                InputStream zeStream = null;
                ByteArrayOutputStream out = null;
                try {
                    zeStream = new BufferedInputStream(zfile.getInputStream(ze));
                    out = new ByteArrayOutputStream();
                    while ((inslen = zeStream.read(insbuf, 0, 1024)) != -1) {
                        out.write(insbuf, 0, inslen);
                    }
                    if (Boolean.valueOf(onlyone).booleanValue()) {
                        blackListInfo = this.getBlackListByPersonNo(ctx, fileNameArr[0]);
                        if (blackListInfo == null) {
                            errorfileList.add(ze.getName());
                            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_in_black"), fileNameArr[0]));
                        }
                        boid = blackListInfo.getId().toString();
                        BoAttchAssoCollection coll = this.getBoAttchAssoCol(ctx, boid);
                        if (coll != null && coll.size() > 0) {
                            BoAttchAssoInfo boAttchAssoInfo = coll.get(0);
                            AttachmentInfo oldAttachmentInfo = boAttchAssoInfo.getAttachment();
                            int size = (int)ze.getSize();
                            if (size < 1024) {
                                oldAttachmentInfo.setSize(size + unit);
                            } else {
                                oldAttachmentInfo.setSize(size / 1024 + "KB");
                            }
                            oldAttachmentInfo.setSizeInByte(size);
                            oldAttachmentInfo.setFile(out.toByteArray());
                            oldAttachmentInfo.setName(fileNameArr[0]);
                            oldAttachmentInfo.setSimpleName(fileNameArr[1]);
                            oldAttachmentInfo.setAttachID("" + System.currentTimeMillis());
                            oldAttachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
                            oldAttachmentInfo.setType(fileNameArr[1]);
                            attachment.save((CoreBaseInfo)oldAttachmentInfo);
                            boAttchAsso.save((CoreBaseInfo)boAttchAssoInfo);
                            continue;
                        }
                        AttachmentInfo attachmentInfo = new AttachmentInfo();
                        attachmentInfo.setName(fileNameArr[0]);
                        attachmentInfo.setSimpleName(fileNameArr[1]);
                        int size = (int)ze.getSize();
                        if (size < 1024) {
                            attachmentInfo.setSize(size + unit);
                        } else {
                            attachmentInfo.setSize(size / 1024 + "KB");
                        }
                        attachmentInfo.setSizeInByte(size);
                        attachmentInfo.setFile(out.toByteArray());
                        attachmentInfo.setAttachID("" + System.currentTimeMillis());
                        attachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
                        attachmentInfo.setType(fileNameArr[1]);
                        attachment.addnew(attachmentInfo);
                        BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
                        boAttchAssoInfo.setBoID(boid);
                        boAttchAssoInfo.setAssoBusObjType(BOSUuid.getBOSObjectType((String)boid, (boolean)true) + "");
                        boAttchAssoInfo.setAssoType(ASSOTYPE);
                        boAttchAssoInfo.setAttachment(attachmentInfo);
                        boAttchAsso.addnew(boAttchAssoInfo);
                        continue;
                    }
                    AttachmentInfo attachmentInfo = new AttachmentInfo();
                    attachmentInfo.setName(fileNameArr[0]);
                    attachmentInfo.setSimpleName(fileNameArr[1]);
                    int size = (int)ze.getSize();
                    if (size < 1024) {
                        attachmentInfo.setSize(size + unit);
                    } else {
                        attachmentInfo.setSize(size / 1024 + "KB");
                    }
                    attachmentInfo.setSizeInByte(size);
                    attachmentInfo.setFile(out.toByteArray());
                    attachmentInfo.setAttachID("" + System.currentTimeMillis());
                    attachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
                    attachmentInfo.setType(fileNameArr[1]);
                    attachment.addnew(attachmentInfo);
                    BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
                    boAttchAssoInfo.setBoID(boid);
                    boAttchAssoInfo.setAssoBusObjType(BOSUuid.getBOSObjectType((String)boid, (boolean)true) + "");
                    boAttchAssoInfo.setAssoType(ASSOTYPE);
                    boAttchAssoInfo.setAttachment(attachmentInfo);
                    boAttchAsso.addnew(boAttchAssoInfo);
                }
                finally {
                    if (zeStream != null) {
                        zeStream.close();
                    }
                    if (out == null) continue;
                    out.close();
                }
            }
            zfile.close();
            JSONUtils.SUCCESS(errorfileList);
        }
    }

    public void deletedFile(String subPath) {
        File deletedFile = new File(subPath);
        File[] files = deletedFile.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].exists() || !files[i].isFile()) continue;
                files[i].delete();
            }
        }
        if (deletedFile.exists()) {
            deletedFile.delete();
        }
    }

    private PersonBlackListInfo getBlackListByPersonNo(Context ctx, String personNo) throws BOSException {
        PersonBlackListInfo blackListInfo = new PersonBlackListInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)personNo));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        IPersonBlackList iBackList = PersonBlackListFactory.getLocalInstance((Context)ctx);
        PersonBlackListCollection col = iBackList.getPersonBlackListCollection(view);
        if (col != null) {
            blackListInfo = col.get(0);
        }
        return blackListInfo;
    }

    public BoAttchAssoCollection getBoAttchAssoCol(Context ctx, String boid) throws BOSException {
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIZE));
        sic.add(new SelectorItemInfo(ATTACHMENT_ID));
        sic.add(new SelectorItemInfo(ATTACHMENT_NAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_SIMPLENAME));
        sic.add(new SelectorItemInfo(ATTACHMENT_DESC));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR));
        sic.add(new SelectorItemInfo(ATTACHMENT_CREATOR_TIME));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    @RequestMapping(params={"method=downloadAllAttachment"})
    @Action
    public void downloadAllAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String fileName = request.getParameter("fileName");
        String formId = request.getParameter("formId");
        String attachIds = request.getParameter("attachIds");
        SHRAttachmentExtCollection coll = null;
        AttachmentCollection attachmentColl = null;
        ArrayList<AttachmentInfo> attachInfoList = null;
        try {
            if (!StringUtils.isEmpty((String)formId)) {
                coll = this.getSHRAttchExtColByBoID(ctx, formId);
                if (null == coll || coll.isEmpty()) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_file_download"));
                }
                int collSize = coll.size();
                attachInfoList = new ArrayList<AttachmentInfo>(collSize);
                for (int i = 0; i < collSize; ++i) {
                    SHRAttachmentExtInfo boAttchAssoInfo = coll.get(i);
                    AttachmentInfo ai = boAttchAssoInfo.getAttachment();
                    attachInfoList.add(ai);
                }
            } else if (!StringUtils.isEmpty((String)attachIds)) {
                attachmentColl = this.getAttachmentColByAttachId(ctx, attachIds.split(","));
                if (null == attachmentColl || attachmentColl.isEmpty()) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_file_download"));
                }
                int attachmentCollSize = attachmentColl.size();
                attachInfoList = new ArrayList(attachmentCollSize);
                for (int i = 0; i < attachmentCollSize; ++i) {
                    AttachmentInfo ai = attachmentColl.get(i);
                    attachInfoList.add(ai);
                }
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        boolean success = this.packAllAttachment(response, ctx, attachInfoList, fileName);
        JSONUtils.SUCCESS(success);
    }

    @RequestMapping(params={"method=previewAttachment"})
    @Action
    public void previewAttachment(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException {
        String attachId = request.getParameter("attachId");
        Context ctx = SHRContext.getInstance().getContext();
        if (StringUtils.isEmpty((String)attachId)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "preview_error"));
        }
        this.checkPermission(ctx, request, response);
        OutputStream outputStream = null;
        try {
            AttachmentInfo ai = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachId));
            response.reset();
            this.setPreviewHeader(response, ai.getName(), ai.getSimpleName());
            outputStream = response.getOutputStream();
            IAttachmentManagerFacade iAttachmentManagerFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            byte[] content = iAttachmentManagerFacade.downLoad(attachId);
            if ("txt".equalsIgnoreCase(ai.getSimpleName())) {
                CharsetDetector cd = new CharsetDetector();
                cd.setText(content);
                String charsetName = cd.detect().getName();
                String s = new String(content, charsetName);
                content = s.getBytes();
            }
            outputStream.write(content);
            outputStream.flush();
        }
        catch (Exception e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "preview_fail"), e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void checkPermission(Context ctx, HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        this.checkFunctionPermission(ctx, request, response);
    }

    private void checkFunctionPermission(Context ctx, HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request)) {
            return;
        }
        String url = SHRPermissionWebUtils.assemblePermissionURL(request);
        String uipk = request.getParameter("uipk");
        if (!CheckFunctionPermissionUtil.isNeedCheckFunctionPermission(uipk, url)) {
            return;
        }
        String permItemId = request.getParameter("permItemId");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        try {
            PermItemInfo permItem = null;
            permItem = !SHRPermissionParamUtil.isSHRPermissionVerificationWithWhiteList((Context)ctx) && !StringUtils.isEmpty((String)permItemId) ? PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo(MessageFormat.format(" where id = ''{0}''", permItemId)) : (StringUtils.isEmpty((String)url) ? null : SHRPermissionWebUtils.getCurrentPagePermItemByRequest(ctx, request, url));
            if (permItem == null) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            SHRFunctionPermissionService.checkFunctionPermission((Context)ctx, (String)userId, (PermItemInfo)permItem);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    private void checkDataPermission(Context ctx, HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request)) {
            return;
        }
        SHRButtonDataPermissionHelper.checkButtonDataPermission(request);
    }

    private boolean packAllAttachment(HttpServletResponse response, Context ctx, List<AttachmentInfo> attachInfoList, String packFileName) throws SHRWebException {
        if (attachInfoList == null || attachInfoList.size() == 0) {
            return false;
        }
        OutputStream outputStream = null;
        ByteArrayOutputStream baos = null;
        ZipOutputStream zipOutputStream = null;
        try {
            String attFileName = URLEncoder.encode(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "attachment"), "UTF-8") + ".zip";
            if (!StringUtils.isEmpty((String)packFileName)) {
                attFileName = packFileName + ".zip";
            }
            outputStream = response.getOutputStream();
            response.setContentType("application/x-download");
            response.setHeader("Content-disposition", "attachment;filename=" + SHRCheck.checkFileNameForSetResponseHeader((String)attFileName));
            baos = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream((OutputStream)baos);
            zipOutputStream.setEncoding("GBK");
            IAttachmentManagerFacade iAttachmentManagerFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            for (AttachmentInfo ai : attachInfoList) {
                String fileName = ai.getName() + "." + ai.getSimpleName();
                String folder = ai.getDescription();
                if (folder == null || "".equals(folder.trim())) {
                    folder = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "attachment_upload");
                }
                ZipEntry zipEntry = new ZipEntry(folder + "/" + fileName);
                byte[] content = iAttachmentManagerFacade.downLoad(ai.getId().toString());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(content, 0, content.length);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.finish();
            outputStream.write(baos.toByteArray());
            outputStream.flush();
        }
        catch (BOSException e) {
            if (e.getMessage().contains("Connection refused")) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "linked_error"), e);
            }
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
        }
        catch (Exception e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), e);
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.closeEntry();
                    zipOutputStream.close();
                }
                if (null != outputStream) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (null != baos) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                logger.error(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "download_error"), (Throwable)e);
            }
        }
        return true;
    }

    @RequestMapping(params={"method=updateAttachmentDescription"})
    @Action
    public void updateAttachmentDescription(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, IOException, BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String attachId = request.getParameter("attachId");
        String remarkText = request.getParameter("remarkText");
        String formId = request.getParameter("formId");
        String strWhere = !StringUtils.isEmpty((String)formId) ? MessageFormat.format(" where attachment = ''{0}'' and boid = ''{1}''", attachId, formId) : MessageFormat.format(" where attachment = ''{0}''", attachId);
        ISHRAttachmentExt hrAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        SHRAttachmentExtInfo shrAttachmentExtInfo = hrAttachmentExt.getSHRAttachmentExtInfo(strWhere);
        if (null != shrAttachmentExtInfo) {
            String desc1 = shrAttachmentExtInfo.getDescription(LocaleUtils.locale_l1);
            String desc2 = shrAttachmentExtInfo.getDescription(LocaleUtils.locale_l2);
            String desc3 = shrAttachmentExtInfo.getDescription(LocaleUtils.locale_l3);
            SHRAttachmentExtInfo shrAttachmentExtInfoNew = new SHRAttachmentExtInfo();
            shrAttachmentExtInfoNew.setId(shrAttachmentExtInfo.getId());
            if (StringUtils.isEmpty((String)desc1)) {
                shrAttachmentExtInfoNew.setDescription(remarkText, LocaleUtils.locale_l1);
            }
            if (StringUtils.isEmpty((String)desc2)) {
                shrAttachmentExtInfoNew.setDescription(remarkText, LocaleUtils.locale_l2);
            }
            if (StringUtils.isEmpty((String)desc3)) {
                shrAttachmentExtInfoNew.setDescription(remarkText, LocaleUtils.locale_l3);
            }
            Locale locale = ctx.getLocale();
            shrAttachmentExtInfoNew.setDescription(remarkText, locale);
            hrAttachmentExt.update((IObjectPK)new ObjectUuidPK(shrAttachmentExtInfo.getId()), (CoreBaseInfo)shrAttachmentExtInfoNew);
            JSONUtils.SUCCESS("update success");
        } else {
            JSONUtils.ERROR("No information found");
        }
    }

    @RequestMapping(params={"method=updateAttachmentName"})
    @Action
    public void updateAttachmentName(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, IOException, BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        this.checkPermission(ctx, request, response);
        String attachId = request.getParameter("attachId");
        String name = request.getParameter(NAME);
        String formId = request.getParameter("formId");
        IOperateLogService service = null;
        try {
            service = OperateLogManager.getIOperateLogService(ctx, OperateLogManager.getAttachMentReNameConfigBean(ctx));
            if (null != service) {
                service.preLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String strWhere = !StringUtils.isEmpty((String)formId) ? MessageFormat.format(" where attachment = ''{0}'' and boid = ''{1}''", attachId, formId) : MessageFormat.format(" where attachment = ''{0}''", attachId);
        ISHRAttachmentExt hrAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        SHRAttachmentExtInfo shrAttachmentExtInfo = hrAttachmentExt.getSHRAttachmentExtInfo(strWhere);
        if (null != shrAttachmentExtInfo) {
            String name1 = shrAttachmentExtInfo.getName(LocaleUtils.locale_l1);
            String name2 = shrAttachmentExtInfo.getName(LocaleUtils.locale_l2);
            String name3 = shrAttachmentExtInfo.getName(LocaleUtils.locale_l3);
            SHRAttachmentExtInfo shrAttachmentExtInfoNew = new SHRAttachmentExtInfo();
            shrAttachmentExtInfoNew.setId(shrAttachmentExtInfo.getId());
            if (!StringUtils.isEmpty((String)name1)) {
                shrAttachmentExtInfoNew.setName(name, LocaleUtils.locale_l1);
            }
            if (!StringUtils.isEmpty((String)name2)) {
                shrAttachmentExtInfoNew.setName(name, LocaleUtils.locale_l2);
            }
            if (!StringUtils.isEmpty((String)name3)) {
                shrAttachmentExtInfoNew.setName(name, LocaleUtils.locale_l3);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo(NAME));
            hrAttachmentExt.updatePartial((CoreBaseInfo)shrAttachmentExtInfoNew, sic);
            if (shrAttachmentExtInfo.getAttachment().getId() != null) {
                String sql = "update T_BAS_Attachment set FName_l2 = '" + name + "',FName_l1 ='" + name + "', FName_l3 ='" + name + "' where fid = '" + shrAttachmentExtInfo.getAttachment().getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            JSONUtils.SUCCESS("update success");
        } else {
            JSONUtils.ERROR("No information found");
        }
        try {
            if (null != service) {
                service.postLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeStream(Closeable ... sList) {
        for (Closeable s : sList) {
            try {
                if (s == null) continue;
                s.close();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setPreviewHeader(HttpServletResponse response, String fileName, String extendName) {
        String ext = extendName;
        if ("JPEG".equalsIgnoreCase(ext) || "JPG".equalsIgnoreCase(ext) || "JPE".equalsIgnoreCase(ext)) {
            response.setContentType("image/jpeg");
        } else if ("PNG".equalsIgnoreCase(ext)) {
            response.setContentType("image/png");
        } else if ("GIF".equalsIgnoreCase(ext)) {
            response.setContentType("image/gif");
        } else if ("BMP".equalsIgnoreCase(ext)) {
            response.setContentType("image/bmp");
        } else if ("ICO".equalsIgnoreCase(ext)) {
            response.setContentType("image/x-icon");
        } else if ("MAC".equalsIgnoreCase(ext)) {
            response.setContentType("image/x-macpaint");
        } else if ("PBM".equalsIgnoreCase(ext)) {
            response.setContentType("image/x-portable-bitmap");
        } else if ("TXT".equalsIgnoreCase(ext)) {
            response.setContentType("text/plain;charset=UTF-8");
        } else if ("PDF".equalsIgnoreCase(ext)) {
            response.setContentType("application/pdf");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
    }

    private Map<String, String> getAttachFileType(UIViewInfo uiviewInfo, String field) throws SHRWebException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != uiviewInfo) {
            Map<String, List<AttachMentInfo>> m = uiviewInfo.getAttachMents();
            if (null == m) {
                return map;
            }
            for (Map.Entry<String, List<AttachMentInfo>> entry : m.entrySet()) {
                List<AttachMentInfo> list = entry.getValue();
                for (AttachMentInfo attachMentInfo : list) {
                    if (!attachMentInfo.getField().equals(field)) continue;
                    map.put("includeFileType", attachMentInfo.getFileType());
                    map.put("excludeFileType", attachMentInfo.getExcludeFileType());
                    map.put("maxSize", attachMentInfo.getMaxSize());
                    return map;
                }
            }
        }
        return map;
    }

    private String distinct(String str) {
        String[] arr;
        if (StringUtils.isEmpty((String)str)) {
            return "exe,js,sh,jsp,ftl,bat,php,py,go,cpp,java,class,aspx";
        }
        StringBuffer strb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        for (String ari : arr = str.split(",")) {
            if (set.add(ari)) {
                strb.append(ari);
            }
            strb.append(",");
        }
        return strb.toString();
    }
}

