/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.ServiceCategoryInfo;
import com.kingdee.shr.base.syssetting.ServiceCollection;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.ServiceSubCategoryInfo;
import com.kingdee.shr.base.syssetting.WorkPlatformCollection;
import com.kingdee.shr.base.syssetting.WorkPlatformFactory;
import com.kingdee.shr.base.syssetting.WorkPlatformInfo;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.service.ServiceUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.WorkPlatformUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/serviceMenu"})
public class ServiceMenuController
extends WebComponentController {
    private static Map<String, String> map;
    private static String MENU_BY_LANG_FILTER_FILENAME;
    private static Logger logger;

    @RequestMapping(params={"method=getAllServiceItems"})
    @Action
    public void getServiceItems(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String dbCacheTime = MenuCacheFactory.getLocalInstance((Context)ctx).getCacheTimeByUserid(userInfo.getId().toString());
        String cacheTime = request.getParameter("serviceCacheTime");
        if (!StringUtils.isEmpty((String)cacheTime) && !"null".equals(cacheTime) && dbCacheTime != null && dbCacheTime.equals(cacheTime)) {
            JSONUtils.SUCCESS("serviceCacheData");
            return;
        }
        ServiceCollection userServices = ServiceFactory.getLocalInstance((Context)ctx).getMyProfessionMenuItems();
        List<Map<String, Object>> list = this.assembleServiceData(ctx, userServices);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("list", list);
        result.put("cacheTimeStr", dbCacheTime);
        JSONUtils.SUCCESS(result);
    }

    @RequestMapping(params={"method=getHomePageAllServiceItems"})
    @Action
    public void getWorkPlatformServiceItems(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String currentWorkPlatformId0 = (String)request.getSession().getAttribute("currentWorkPlatformId");
        String isAllStr = request.getParameter("isAll");
        Boolean isAll = StringUtils.isEmpty((String)isAllStr) ? false : Boolean.parseBoolean(isAllStr);
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String dbCacheTime = MenuCacheFactory.getLocalInstance((Context)ctx).getCacheTimeByUserid(userInfo.getId().toString());
        String defaultWorkPlatformId = "";
        String currentWorkPlatformId = "";
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkPlatformInfo defaultWorkPlatformInfo = WorkPlatformUtils.getUserRedirectWorkPlatform(request, ctx, null);
        if (defaultWorkPlatformInfo != null) {
            defaultWorkPlatformId = defaultWorkPlatformInfo.getId().toString();
        }
        result.put("defaultWorkPlatformId", defaultWorkPlatformId);
        String cacheTime = request.getParameter("serviceCacheTime");
        String uipk = request.getParameter("uipk");
        currentWorkPlatformId = WorkPlatformUtils.getCurrentWorkPlatformIdByUipk(ctx, uipk);
        IObjectPK pk = null;
        pk = WorkPlatformUtil.isShowOldWorkbench((Context)ctx) ? WorkPlatformUtil.getNew2OldTransPk((String)currentWorkPlatformId0) : WorkPlatformUtil.getOld2NewTransPk((String)currentWorkPlatformId0);
        if (null != pk) {
            currentWorkPlatformId0 = pk.toString();
        }
        if (StringUtils.isEmpty((String)currentWorkPlatformId)) {
            currentWorkPlatformId = !StringUtils.isEmpty((String)currentWorkPlatformId0) ? currentWorkPlatformId0 : defaultWorkPlatformId;
        }
        result.put("currentWorkPlatformId", currentWorkPlatformId);
        request.getSession().setAttribute("currentWorkPlatformId", (Object)currentWorkPlatformId);
        if (!StringUtils.isEmpty((String)cacheTime) && !"null".equals(cacheTime) && dbCacheTime != null && dbCacheTime.equals(cacheTime)) {
            result.put("cacheFlag", "serviceCacheData");
            JSONUtils.SUCCESS(result);
            return;
        }
        ServiceCollection userServices = null;
        userServices = isAll != false ? ServiceFactory.getLocalInstance((Context)ctx).getAllMenuItems(null) : ServiceFactory.getLocalInstance((Context)ctx).getMyMenuItems();
        List<Map<String, Object>> list = this.assembleServiceDataForWorkPlatform(ctx, userServices, isAll);
        result.put("list", list);
        result.put("cacheTimeStr", dbCacheTime);
        JSONUtils.SUCCESS(result, (ServletResponse)response);
    }

    private List<Map<String, Object>> assembleServiceData(Context ctx, ServiceCollection userServices) throws BOSException, JDOMException, IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Map<String, Object>> all = new HashMap<String, Map<String, Object>>();
        ServiceInfo serviceInfo = null;
        ServiceCategoryInfo categoryInfo = null;
        ServiceSubCategoryInfo subCategoryInfo = null;
        Map<String, Object> categoryItem = null;
        Map<String, Object> subCategoryItem = null;
        List children = null;
        String id = null;
        Set<String> set = this.serviceMenuFilter(ctx);
        int size = userServices.size();
        for (int i = 0; i < size; ++i) {
            serviceInfo = userServices.get(i);
            String serviceId = String.valueOf(serviceInfo.getId());
            if (set.contains(serviceId) || (categoryInfo = serviceInfo.getCategory()) == null) continue;
            id = categoryInfo.getId().toString();
            categoryItem = (Map<String, Object>)all.get(id);
            if (categoryItem == null) {
                categoryItem = this.assembleServiceCategoryData(categoryInfo);
                all.put(id, categoryItem);
                list.add(categoryItem);
            }
            if ((subCategoryInfo = serviceInfo.getSubCategory()) != null) {
                id = subCategoryInfo.getId().toString();
                subCategoryItem = (Map<String, Object>)all.get(id);
                if (subCategoryItem == null) {
                    subCategoryItem = this.assembleServiceCategoryData(subCategoryInfo);
                    all.put(id, subCategoryItem);
                    ((List)categoryItem.get("children")).add(subCategoryItem);
                }
                children = (List)subCategoryItem.get("children");
                children.add(serviceInfo);
            } else {
                ((List)categoryItem.get("children")).add(serviceInfo);
            }
            serviceInfo.setCategory(null);
            serviceInfo.setSubCategory(null);
            categoryItem = null;
            subCategoryItem = null;
        }
        return list;
    }

    private Set<String> getUIViewDynamicListSet(Context ctx) throws BOSException {
        HashSet<String> s = new HashSet<String>();
        String sql = "SELECT FUIPK FROM S_BS_UIVIEW WHERE FTYPE = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"dynamicList"});
        try {
            while (rs.next()) {
                s.add(rs.getString("FUIPK"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return s;
    }

    private List<Map<String, Object>> assembleServiceDataForWorkPlatform(Context ctx, ServiceCollection userServices, Boolean isAll) throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Map<String, Object>> all = new HashMap<String, Map<String, Object>>();
        ServiceInfo serviceInfo = null;
        ServiceCategoryInfo categoryInfo = null;
        ServiceSubCategoryInfo subCategoryInfo = null;
        Map<String, Object> workplatformItem = null;
        Map<String, Object> categoryItem = null;
        Map<String, Object> subCategoryItem = null;
        HashMap<String, WorkPlatformInfo> workPlatformMapping = new HashMap<String, WorkPlatformInfo>();
        List children = null;
        String id = null;
        boolean isShowOldWorkbench = WorkPlatformUtil.isShowOldWorkbench((Context)ctx);
        Set<String> dynamicListSet = null;
        Map<String, String> uiviewMp = null;
        if (isAll.booleanValue()) {
            dynamicListSet = this.getUIViewDynamicListSet(ctx);
            uiviewMp = this.getUIViewMap(ctx);
        }
        int size = userServices.size();
        for (int i = 0; i < size; ++i) {
            WorkPlatformInfo workPlatformInfoSrc;
            serviceInfo = userServices.get(i);
            categoryInfo = serviceInfo.getCategory();
            serviceInfo.put("serviceId", (Object)serviceInfo.getId().toString());
            if (isAll.booleanValue() && null != uiviewMp) {
                serviceInfo.put("isDynamicList", (Object)false);
                String uipk = ServiceUtil.getUipk((String)serviceInfo.getUrlValue());
                if (!StringUtils.isEmpty((String)uipk) && null != dynamicListSet && dynamicListSet.contains(uipk)) {
                    serviceInfo.put("isDynamicList", (Object)true);
                }
                serviceInfo.put("model", (Object)uiviewMp.get(uipk));
                if (StringUtils.isEmpty((String)uiviewMp.get(uipk))) {
                    serviceInfo.put("model", (Object)"");
                }
            }
            if (categoryInfo == null || (workPlatformInfoSrc = categoryInfo.getWorkPlatform()) == null) continue;
            WorkPlatformInfo workPlatformInfo = this.getRealWorkPlatformInfo(workPlatformInfoSrc, workPlatformMapping, isShowOldWorkbench);
            id = workPlatformInfo.getId().toString();
            workplatformItem = (Map<String, Object>)all.get(id);
            if (workplatformItem == null) {
                workplatformItem = this.assembleServiceCategoryData(workPlatformInfo);
                all.put(id, workplatformItem);
                list.add(workplatformItem);
            }
            if ((categoryItem = (Map<String, Object>)all.get(id = categoryInfo.getId().toString())) == null) {
                categoryItem = this.assembleServiceCategoryData(categoryInfo);
                all.put(id, categoryItem);
                ((List)workplatformItem.get("children")).add(categoryItem);
            }
            if ((subCategoryInfo = serviceInfo.getSubCategory()) != null) {
                id = subCategoryInfo.getId().toString();
                subCategoryItem = (Map<String, Object>)all.get(id);
                if (subCategoryItem == null) {
                    subCategoryItem = this.assembleServiceCategoryData(subCategoryInfo);
                    all.put(id, subCategoryItem);
                    ((List)categoryItem.get("children")).add(subCategoryItem);
                }
                children = (List)subCategoryItem.get("children");
                children.add(serviceInfo);
            } else {
                ((List)categoryItem.get("children")).add(serviceInfo);
            }
            serviceInfo.setCategory(null);
            serviceInfo.setSubCategory(null);
            categoryItem = null;
            subCategoryItem = null;
        }
        if (!isShowOldWorkbench) {
            this.assembleNewWorkPlatfromData(list, workPlatformMapping);
        }
        SorterCompartor sorterCompartor = new SorterCompartor();
        Collections.sort(list, sorterCompartor);
        return list;
    }

    private Map<String, String> getUIViewMap(Context ctx) throws BOSException {
        HashMap<String, String> mp = new HashMap<String, String>();
        String sql = "SELECT FUIPK,FModel FROM S_BS_UIVIEW ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                mp.put(rs.getString("FUIPK"), rs.getString("FModel"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mp;
    }

    private WorkPlatformInfo getRealWorkPlatformInfo(WorkPlatformInfo workPlatformInfoSrc, Map<String, WorkPlatformInfo> workPlatformMapping, boolean isShowOldWorkbench) throws EASBizException, BOSException {
        IObjectPK pk;
        WorkPlatformInfo result = workPlatformInfoSrc;
        if (!isShowOldWorkbench && null != (pk = WorkPlatformUtil.getOld2NewTransPk((String)workPlatformInfoSrc.getId().toString()))) {
            if (workPlatformMapping.containsKey(workPlatformInfoSrc.getId().toString())) {
                result = workPlatformMapping.get(workPlatformInfoSrc.getId().toString());
            } else {
                result = WorkPlatformFactory.getLocalInstance((Context)SHRContext.getInstance().getContext()).getWorkPlatformInfo(pk);
                workPlatformMapping.put(workPlatformInfoSrc.getId().toString(), result);
            }
        }
        return result;
    }

    private void assembleNewWorkPlatfromData(List<Map<String, Object>> list, Map<String, WorkPlatformInfo> workPlatformMapping) throws BOSException, EASBizException {
        Context ctx = SHRContext.getInstance().getContext();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getNewMyWorkPlatformIdSql((String)permissionSql), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("index");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorter.add(sorterItemInfo);
        entityViewInfo.setSorter(sorter);
        entityViewInfo.setFilter(filter);
        WorkPlatformCollection wfcc = WorkPlatformFactory.getLocalInstance((Context)ctx).getWorkPlatformCollection(entityViewInfo);
        if (null != wfcc && !wfcc.isEmpty()) {
            for (int i = 0; i < wfcc.size(); ++i) {
                if (this.checkExists(wfcc.get(i), workPlatformMapping)) continue;
                list.add(this.assembleServiceCategoryData(wfcc.get(i)));
            }
        }
    }

    private boolean checkExists(WorkPlatformInfo workPlatformInfo, Map<String, WorkPlatformInfo> workPlatformMapping) {
        for (Map.Entry<String, WorkPlatformInfo> entry : workPlatformMapping.entrySet()) {
            if (!entry.getValue().getId().toString().equals(workPlatformInfo.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> assembleServiceCategoryData(WorkPlatformInfo workPlatformInfo) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("name", workPlatformInfo.getName());
        item.put("id", workPlatformInfo.getId());
        item.put("number", workPlatformInfo.getNumber());
        item.put("index", workPlatformInfo.getIndex());
        item.put("url", workPlatformInfo.getUrl());
        item.put("isProfessionalPlatform", this.isProfessionalPlatform(workPlatformInfo));
        item.put("isNew", workPlatformInfo.isIsNew());
        item.put("children", new ArrayList());
        return item;
    }

    private boolean isProfessionalPlatform(WorkPlatformInfo workPlatformInfo) {
        return "/home.do".equals(workPlatformInfo.getUrl());
    }

    private Map<String, Object> assembleServiceCategoryData(ServiceCategoryInfo categoryInfo) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("name", categoryInfo.getName());
        item.put("id", categoryInfo.getId());
        item.put("number", categoryInfo.getNumber());
        item.put("iconName", categoryInfo.getIconName());
        item.put("children", new ArrayList());
        return item;
    }

    private Map<String, Object> assembleServiceCategoryData(ServiceSubCategoryInfo categoryInfo) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("name", categoryInfo.getName());
        item.put("id", categoryInfo.getId());
        item.put("number", categoryInfo.getNumber());
        item.put("children", new ArrayList());
        return item;
    }

    @RequestMapping(params={"method=getAllServiceItems2"})
    @Action
    public void getAllServiceItems(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("category.*"));
        entityViewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("category.index"));
        sorter.add(new SorterItemInfo("index"));
        entityViewInfo.setSorter(sorter);
        CoreBaseCollection serviceColl = ServiceFactory.getLocalInstance((Context)SHRContext.getInstance().getContext()).getCollection(entityViewInfo);
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < serviceColl.size(); ++i) {
            List<ServiceInfo> tempList;
            ServiceInfo si = (ServiceInfo)serviceColl.get(i);
            ServiceCategoryInfo sc = si.getCategory();
            if (sc == null) continue;
            if (map.keySet().contains(sc)) {
                tempList = (List)map.get(sc);
                tempList.add(si);
                continue;
            }
            tempList = new ArrayList();
            tempList.add(si);
            map.put(sc, tempList);
        }
        ArrayList list = new ArrayList();
        for (ServiceCategoryInfo sc : map.keySet()) {
            LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
            mp.put("name", sc.getName());
            mp.put("id", (String)sc.getId());
            mp.put("number", sc.getNumber());
            mp.put("children", (String)map.get(sc));
            list.add(mp);
        }
        JSONUtils.SUCCESS(list);
    }

    private Set<String> serviceMenuFilter(Context ctx) {
        HashSet<String> set = new HashSet<String>();
        String langCtx = LocaleUtils.getLocal((Context)ctx);
        Set<String> langs = map.keySet();
        if (langs.contains(langCtx)) {
            String[] menus;
            String serviceIds = map.get(langCtx);
            for (String menu : menus = serviceIds.split(",")) {
                set.add(menu);
            }
        }
        return set;
    }

    static {
        block6: {
            map = new HashMap<String, String>();
            MENU_BY_LANG_FILTER_FILENAME = "menuByLangFilter.xml";
            logger = Logger.getLogger(ServiceMenuController.class);
            StringBuffer sb = new StringBuffer();
            sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append(MENU_BY_LANG_FILTER_FILENAME);
            try {
                File f = new File(sb.toString());
                if (f.exists()) {
                    Document doc = SHRSyssettingUtil.getXmlFileByPath((String)sb.toString());
                    Element root = doc.getRootElement();
                    List children = root.getChildren("item");
                    for (Element element : children) {
                        String lang = element.getAttributeValue("lang");
                        String serviceIds = element.getAttributeValue("serviceIds");
                        if (StringUtils.isEmpty((String)lang) || StringUtils.isEmpty((String)serviceIds)) continue;
                        map.put(lang.trim(), serviceIds.trim());
                    }
                }
            }
            catch (JDOMException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    class SorterCompartor
    implements Comparator {
        SorterCompartor() {
        }

        public int compare(Object o1, Object o2) {
            Map map1 = (Map)o1;
            Map map2 = (Map)o2;
            return ((Integer)map1.get("index")).compareTo((Integer)map2.get("index"));
        }
    }
}

