/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.TagLibraryCollection;
import com.kingdee.eas.basedata.hraux.TagLibraryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.TagInfoControllerBean;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="com.kingdee.shr.base.syssetting.web.TagsController")
@RequestMapping(value={"/tags"})
public class TagsController
extends WebPageController {
    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return "/tags";
    }

    @RequestMapping(params={"method=addTag"})
    @Action
    protected String addTagAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        String tagLibraryIDs = request.getParameter("tagLibraryIDs");
        String objectId = request.getParameter("objectId");
        ArrayList collection = (ArrayList)JSONUtils.convertJsonToObject(ctx, tagLibraryIDs, ArrayList.class);
        TagInfoControllerBean controller = new TagInfoControllerBean();
        if (collection != null) {
            for (String tagLibraryID : collection) {
                if (tagLibraryID.isEmpty()) continue;
                controller.addTag(ctx, tagLibraryID, objectId, new Date());
            }
        }
        JSONUtils.SUCCESS(null);
        return null;
    }

    @RequestMapping(params={"method=getObjectTag"})
    @Action
    protected String getObjectTagAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        String objectId = request.getParameter("objectId");
        ArrayList tags = new ArrayList();
        TagInfoControllerBean controller = new TagInfoControllerBean();
        TagLibraryCollection collection = controller.getObjectTag(ctx, objectId, new Date());
        if (collection != null) {
            for (TagLibraryInfo tagLibrary : collection) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", tagLibrary.getId().toString());
                data.put("name", tagLibrary.getName());
                tags.add(data);
            }
        }
        JSONUtils.SUCCESS(tags);
        return null;
    }

    @RequestMapping(params={"method=removeTag"})
    @Action
    protected String removeTagAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        String tagLibraryID = request.getParameter("tagLibraryID");
        String objectId = request.getParameter("objectId");
        TagInfoControllerBean controller = new TagInfoControllerBean();
        controller.removeTag(ctx, tagLibraryID, objectId, new Date());
        JSONUtils.SUCCESS(null);
        return null;
    }
}

