/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicModelInfo;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DynamicModelHelper {
    HashMap properties = new HashMap();
    String scheme = null;

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public DynamicModelInfo getValue(String billId, SelectorItemCollection sic) throws EASBizException, BOSException {
        return this.groupModel(billId, sic);
    }

    private DynamicModelInfo groupModel(String billId, SelectorItemCollection sic) throws EASBizException, BOSException {
        DynamicModelInfo dyModelInfo = this.getValueEntityView(billId, sic);
        Context ctx2 = SHRContext.getInstance().getContext();
        HashMap<String, IObjectValue> valueMap = this.getValueAndGroup(ctx2, dyModelInfo);
        HashMap<String, IObjectValue> model = new HashMap<String, IObjectValue>();
        for (Map.Entry<String, String> entry : dyModelInfo.getKeyReverseMap().entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            String[] strs = value.split(":");
            CoreBaseInfo info = (CoreBaseInfo)valueMap.get(strs[0]);
            if (info != null) {
                model.put(key, (IObjectValue)info.get(strs[1]));
                continue;
            }
            model.put(key, null);
        }
        dyModelInfo.setValueMap(model);
        return dyModelInfo;
    }

    private DynamicModelInfo getValueEntityView(String billId, SelectorItemCollection sic) throws BOSException, EASBizException {
        DynamicModelInfo dyModelInfo = new DynamicModelInfo();
        dyModelInfo.setId(billId);
        Context ctx = SHRContext.getInstance().getContext();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)ctx, (String)this.getScheme());
        String mainEntity = main.getEntityName();
        for (int i = 0; i < sic.size(); ++i) {
            EntityViewInfo viewInfo;
            QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)sic.get(i).getPropertyName());
            if (fieldInfo == null) continue;
            String entityName = null;
            String propName = null;
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                EntityViewInfo viewInfo2;
                StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
                entityName = parentInfo.getEntityName();
                String path = propName = this.getRelationPropertyName(ctx, fieldInfo);
                if (parentInfo.isBaseData()) continue;
                if (!dyModelInfo.getViewModelEnityViewMap().containsKey(entityName)) {
                    viewInfo2 = new EntityViewInfo();
                    SelectorItemCollection tempsic = new SelectorItemCollection();
                    viewInfo2.setSelector(tempsic);
                    FilterInfo filter = new FilterInfo();
                    if (mainEntity.equals(entityName)) {
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
                    } else {
                        parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)parentInfo.getId().toString(), (String)this.getScheme());
                        String relation = this.getRelation(parentInfo);
                        EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
                        PropertyInfo propInfo = entityObjInfo.getPropertyByName(relation);
                        if (propInfo != null) {
                            filter.getFilterItems().add(new FilterItemInfo(relation, (Object)billId));
                        } else {
                            System.out.println("=======com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicModelHelper:entityName:" + entityName + ",error property:" + relation);
                            continue;
                        }
                    }
                    viewInfo2.setFilter(filter);
                    viewInfo2.getSelector().add("id");
                    dyModelInfo.getViewModelEnityViewMap().put(entityName, viewInfo2);
                }
                dyModelInfo.getKeyReverseMap().put(sic.get(i).getPropertyName(), entityName + ":" + propName);
                viewInfo2 = dyModelInfo.getViewModelEnityViewMap().get(entityName);
                viewInfo2.getSelector().add(propName + ".*");
                viewInfo2.getSelector().add(propName);
                continue;
            }
            entityName = fieldInfo.getFactField().getStructureConfig().getEntityName();
            propName = fieldInfo.getFactField().getNumber();
            if (!dyModelInfo.getViewModelEnityViewMap().containsKey(entityName)) {
                viewInfo = new EntityViewInfo();
                SelectorItemCollection tempsic = new SelectorItemCollection();
                tempsic.add(new SelectorItemInfo("id"));
                viewInfo.setSelector(tempsic);
                FilterInfo filter = new FilterInfo();
                if (fieldInfo.getFactField().getStructureConfig().getParent() == null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
                } else {
                    String relationName = this.getRelationPropertyName(ctx, fieldInfo);
                    filter.getFilterItems().add(new FilterItemInfo(relationName, (Object)billId));
                    viewInfo.getSelector().add(new SelectorItemInfo(relationName));
                    dyModelInfo.getRelateModel().put(entityName, relationName);
                    String singleCondition = this.getMultiRowSingleView(ctx, fieldInfo);
                    if (!StringUtils.isEmpty((String)singleCondition)) {
                        dyModelInfo.getMultiRowOneColumnMap().put(entityName, singleCondition);
                        FilterInfo filterInfo = null;
                        try {
                            filterInfo = new FilterInfo(singleCondition);
                            filter.mergeFilter(filterInfo, "and");
                        }
                        catch (ParserException e) {
                            e.printStackTrace();
                        }
                    }
                }
                viewInfo.setFilter(filter);
                dyModelInfo.getViewModelEnityViewMap().put(entityName, viewInfo);
            }
            viewInfo = dyModelInfo.getViewModelEnityViewMap().get(entityName);
            viewInfo.getSelector().add(propName);
            dyModelInfo.getKeyReverseMap().put(sic.get(i).getPropertyName(), entityName + ":" + propName);
        }
        return dyModelInfo;
    }

    private HashMap<String, IObjectValue> getValueAndGroup(Context ctx, DynamicModelInfo dyModelInfo) throws BOSException {
        HashMap<String, IObjectValue> valueMap = new HashMap<String, IObjectValue>();
        for (Map.Entry<String, EntityViewInfo> entry : dyModelInfo.getViewModelEnityViewMap().entrySet()) {
            String entityName = entry.getKey().toString();
            EntityViewInfo viewInfo = entry.getValue();
            ICoreBase icorebase = this.getInterface(entityName, null);
            try {
                CoreBaseCollection coreBaseColl = icorebase.getCollection(viewInfo);
                if (coreBaseColl == null) continue;
                CoreBaseInfo coreBaseInfo = coreBaseColl.get(0);
                valueMap.put(entityName, (IObjectValue)coreBaseInfo);
            }
            catch (Exception e) {
                valueMap.put("id", null);
                e.printStackTrace();
            }
        }
        return valueMap;
    }

    public ICoreBase getInterface(String entityName, CoreBaseInfo baseInfo) throws BOSException {
        ICoreBase iCoreBase;
        MetaDataPK entityPK = new MetaDataPK(entityName);
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)entityPK);
        if (!StringUtils.isEmpty((String)entityInfo.getExtendedProperty("commonControllerName"))) {
            if (baseInfo != null && baseInfo instanceof ICommonBOSType) {
                ((ICommonBOSType)baseInfo).setBOSType(entityInfo.getType());
                ((ICommonBOSType)baseInfo).setPK((IMetaDataPK)entityPK);
            }
            iCoreBase = (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)entityPK);
        } else {
            Class<?> classObj;
            try {
                classObj = Class.forName(entityInfo.getBusinessInterface());
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            iCoreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)entityInfo.getType(), classObj);
        }
        return iCoreBase;
    }

    public DynamicModelInfo convertToObject(String billId) throws EASBizException, BOSException {
        DynamicModelInfo dyModelInfo = new DynamicModelInfo();
        Iterator it = this.properties.entrySet().iterator();
        SelectorItemCollection sic = new SelectorItemCollection();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = entry.getKey().toString();
            sic.add(new SelectorItemInfo(key));
        }
        dyModelInfo = this.getValueEntityView(billId, sic);
        this.loadAllExistingInfo(dyModelInfo);
        Context ctx = SHRContext.getInstance().getContext();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)ctx, (String)this.getScheme());
        String mainEntityName = main.getEntityName();
        HashMap<String, IObjectValue> tempObjMap = dyModelInfo.getValueMap();
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)key);
            if (fieldInfo == null) continue;
            String entityName = null;
            String propName = null;
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
                entityName = parentInfo.getEntityName();
                propName = this.getRelationPropertyName(ctx, fieldInfo);
                if (parentInfo.isBaseData()) {
                    continue;
                }
            } else {
                entityName = fieldInfo.getFactField().getStructureConfig().getEntityName();
                propName = fieldInfo.getFactField().getNumber();
            }
            if (!tempObjMap.containsKey(entityName)) {
                EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
                IObjectValue objInfo = Utils.newObjectValueInstance((EntityObjectInfo)entityObjInfo);
                if (dyModelInfo.getRelateModel().containsKey(entityName)) {
                    String relate = dyModelInfo.getRelateModel().get(entityName);
                    IObjectValue mainValue = tempObjMap.get(mainEntityName);
                    if (mainValue != null) {
                        objInfo.put(relate, (Object)mainValue);
                    }
                }
                if (dyModelInfo.getMultiRowOneColumnMap().containsKey(entityName)) {
                    FilterInfo filterInfo = null;
                    try {
                        filterInfo = new FilterInfo(dyModelInfo.getMultiRowOneColumnMap().get(entityName).toString());
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                    if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
                        FilterItemCollection filterItemColl = filterInfo.getFilterItems();
                        for (int i = 0; i < filterItemColl.size(); ++i) {
                            String fieldName = filterItemColl.get(i).getPropertyName();
                            Object value = filterItemColl.get(i).getCompareValue();
                            objInfo.put(fieldName, value);
                        }
                    }
                }
                tempObjMap.put(entityName, objInfo);
            }
            IObjectValue valueInfo = tempObjMap.get(entityName);
            valueInfo.put(propName, entry.getValue());
        }
        if (tempObjMap.containsKey(mainEntityName)) {
            dyModelInfo.getSaveModelMap().put(mainEntityName, tempObjMap.get(mainEntityName));
            tempObjMap.remove(mainEntityName);
        }
        dyModelInfo.getSaveModelMap().putAll(tempObjMap);
        return dyModelInfo;
    }

    public DynamicModelInfo convertToObjectNoBillId(String billId) throws EASBizException, BOSException {
        DynamicModelInfo dyModelInfo = this.convertToObjectAll(billId);
        Context ctx = SHRContext.getInstance().getContext();
        LinkedHashMap<String, IObjectValue> saveModelMap = dyModelInfo.getSaveModelMap();
        LinkedHashMap<String, IObjectValue> tempObjMap = new LinkedHashMap<String, IObjectValue>();
        HashMap<String, Object> infoNameKeys = dyModelInfo.getInfoNameKeysMap();
        Iterator iter = ((HashMap)saveModelMap).keySet().iterator();
        QueryConfigFieldInfo fieldInfo = null;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (infoNameKeys.get(key) == null) {
                tempObjMap.put(key, (IObjectValue)((HashMap)saveModelMap).get(key));
                continue;
            }
            String firstkey = (String)((HashMap)infoNameKeys.get(key)).keySet().iterator().next();
            fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)firstkey);
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) continue;
            tempObjMap.put(key, (IObjectValue)((HashMap)saveModelMap).get(key));
        }
        dyModelInfo.setSaveModelMap(tempObjMap);
        return dyModelInfo;
    }

    public DynamicModelInfo convertToObjectAll(String billId) throws EASBizException, BOSException {
        DynamicModelInfo dyModelInfo = new DynamicModelInfo();
        Iterator it = this.properties.entrySet().iterator();
        SelectorItemCollection sic = new SelectorItemCollection();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = entry.getKey().toString();
            sic.add(new SelectorItemInfo(key));
        }
        Context ctx = SHRContext.getInstance().getContext();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)ctx, (String)this.getScheme());
        String mainEntityName = main.getEntityName();
        CoreBaseInfo mainInfo = null;
        if (billId == null) {
            try {
                mainInfo = this.createInfo(mainEntityName);
                mainInfo.setId(BOSUuid.create((BOSObjectType)mainInfo.getBOSType()));
                billId = mainInfo.getId().toString();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        ICoreBase coreBase = this.getInterface(mainEntityName, null);
        CoreBaseCollection coll = coreBase.getCollection("where id = '" + billId + "'");
        if (coll != null && coll.size() == 1) {
            mainInfo = coll.get(0);
        } else {
            try {
                mainInfo = this.createInfo(mainEntityName);
                mainInfo.setId(BOSUuid.create((String)billId));
                billId = mainInfo.getId().toString();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        dyModelInfo = this.pareObjectInfo(billId, sic);
        HashMap<String, IObjectValue> valueMap = new HashMap<String, IObjectValue>();
        valueMap.put(mainEntityName, (IObjectValue)mainInfo);
        dyModelInfo.setValueMap(valueMap);
        this.loadExistingInfo(dyModelInfo);
        this.setInfoValue(ctx, dyModelInfo, mainEntityName);
        return dyModelInfo;
    }

    private void setInfoValue(Context ctx, DynamicModelInfo dyModelInfo, String mainEntityName) throws EASBizException, BOSException {
        HashMap<String, IObjectValue> tempObjMap = dyModelInfo.getValueMap();
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)key);
            if (fieldInfo == null) continue;
            String entityName = null;
            String propName = null;
            String dataType = null;
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
                entityName = parentInfo.getEntityName();
                propName = this.getRelationPropertyName(ctx, fieldInfo);
                dataType = "String";
                if (parentInfo.isBaseData()) {
                    continue;
                }
            } else {
                entityName = fieldInfo.getFactField().getStructureConfig().getEntityName();
                propName = fieldInfo.getFactField().getNumber();
                dataType = fieldInfo.getFactField().getDataType();
            }
            if (!tempObjMap.containsKey(entityName)) {
                EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
                IObjectValue objInfo = Utils.newObjectValueInstance((EntityObjectInfo)entityObjInfo);
                if (dyModelInfo.getRelateModel().containsKey(entityName)) {
                    String relate = dyModelInfo.getRelateModel().get(entityName);
                    IObjectValue mainValue = tempObjMap.get(mainEntityName);
                    if (mainValue != null) {
                        objInfo.put(relate, (Object)mainValue);
                    }
                }
                if (dyModelInfo.getMultiRowOneColumnMap().containsKey(entityName)) {
                    FilterInfo filterInfo = null;
                    try {
                        filterInfo = new FilterInfo(dyModelInfo.getMultiRowOneColumnMap().get(entityName).toString());
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                    if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
                        FilterItemCollection filterItemColl = filterInfo.getFilterItems();
                        for (int i = 0; i < filterItemColl.size(); ++i) {
                            String fieldName = filterItemColl.get(i).getPropertyName();
                            Object value = filterItemColl.get(i).getCompareValue();
                            objInfo.put(fieldName, value);
                        }
                    }
                }
                tempObjMap.put(entityName, objInfo);
            }
            IObjectValue valueInfo = tempObjMap.get(entityName);
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                if (entry.getValue() != null && "\\".equals(entry.getValue())) {
                    valueInfo.put(propName, null);
                    continue;
                }
                String pEntity = fieldInfo.getFactField().getStructureConfig().getEntityName();
                if (tempObjMap.get(pEntity) != null) {
                    if (mainEntityName != null && mainEntityName.equals(pEntity)) {
                        ICoreBase coreBase;
                        CoreBaseCollection coll;
                        String value = String.valueOf(entry.getValue());
                        String numberValue = null;
                        String nameValue = null;
                        if (value != null && value.indexOf("#") > 0) {
                            String[] str = value.split("#");
                            numberValue = str[0];
                            nameValue = str[1];
                        } else {
                            numberValue = value;
                            nameValue = value;
                        }
                        if ((coll = (coreBase = this.getInterface(mainEntityName, null)).getCollection("where name = '" + nameValue + "' or number = '" + numberValue + "'")) == null) continue;
                        if (coll.size() == 0) {
                            valueInfo.put(propName, null);
                            continue;
                        }
                        if (coll.size() == 1) {
                            valueInfo.put(propName, (Object)coll.get(0));
                            continue;
                        }
                        throw new BOSException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "many_records_return"));
                    }
                    valueInfo.put(propName, (Object)tempObjMap.get(fieldInfo.getFactField().getStructureConfig().getEntityName()));
                    continue;
                }
                valueInfo.put(propName, (Object)tempObjMap.get(fieldInfo.getFactField().getStructureConfig().getEntityName() + "@" + fieldInfo.getFactField().getStructureConfig().getClientNumber()));
                continue;
            }
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            if (entry.getValue() != null && "\\".equals(entry.getValue())) {
                if (valueInfo.containsKey(propName + "_" + LocaleUtils.locale_l2.getDisplayName())) {
                    valueInfo.put(propName + "_" + LocaleUtils.locale_l2.getDisplayName(), null);
                }
                valueInfo.put(propName, null);
                continue;
            }
            if (valueInfo.containsKey(propName + "_" + LocaleUtils.locale_l2.getDisplayName())) {
                valueInfo.put(propName + "_" + LocaleUtils.locale_l2.getDisplayName(), entry.getValue());
            }
            valueInfo.put(propName, entry.getValue());
        }
        if (tempObjMap.containsKey(mainEntityName)) {
            dyModelInfo.getSaveModelMap().put(mainEntityName, tempObjMap.get(mainEntityName));
            tempObjMap.remove(mainEntityName);
        }
        dyModelInfo.getSaveModelMap().putAll(tempObjMap);
    }

    private DynamicModelInfo pareObjectInfo(String billId, SelectorItemCollection sic) throws BOSException, EASBizException {
        DynamicModelInfo dyModelInfo = new DynamicModelInfo();
        Context ctx = SHRContext.getInstance().getContext();
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)ctx, (String)this.getScheme());
        String mainEntity = main.getEntityName();
        for (int i = 0; i < sic.size(); ++i) {
            HashMap keys;
            QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)sic.get(i).getPropertyName());
            if (fieldInfo == null) continue;
            String entityName = null;
            String propName = null;
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                EntityViewInfo viewInfo;
                StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
                entityName = parentInfo.getEntityName();
                String path = propName = this.getRelationPropertyName(ctx, fieldInfo);
                if (parentInfo.isBaseData()) continue;
                if (!dyModelInfo.getViewModelEnityViewMap().containsKey(entityName)) {
                    viewInfo = new EntityViewInfo();
                    SelectorItemCollection tempsic = new SelectorItemCollection();
                    viewInfo.setSelector(tempsic);
                    FilterInfo filter = new FilterInfo();
                    if (mainEntity.equals(entityName)) {
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
                    } else {
                        parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)parentInfo.getId().toString(), (String)this.getScheme());
                        String relation = this.getRelation(parentInfo);
                        filter.getFilterItems().add(new FilterItemInfo(relation, (Object)billId));
                    }
                    viewInfo.setFilter(filter);
                    viewInfo.getSelector().add("id");
                    dyModelInfo.getViewModelEnityViewMap().put(entityName, viewInfo);
                }
                dyModelInfo.getKeyReverseMap().put(sic.get(i).getPropertyName(), entityName + ":" + propName);
                viewInfo = dyModelInfo.getViewModelEnityViewMap().get(entityName);
                viewInfo.getSelector().add(propName + ".*");
                viewInfo.getSelector().add(propName);
            } else {
                EntityViewInfo viewInfo;
                entityName = fieldInfo.getFactField().getStructureConfig().getEntityName();
                propName = fieldInfo.getFactField().getNumber();
                if (!dyModelInfo.getViewModelEnityViewMap().containsKey(entityName)) {
                    viewInfo = new EntityViewInfo();
                    SelectorItemCollection tempsic = new SelectorItemCollection();
                    tempsic.add(new SelectorItemInfo("id"));
                    viewInfo.setSelector(tempsic);
                    FilterInfo filter = new FilterInfo();
                    if (fieldInfo.getFactField().getStructureConfig().getParent() == null) {
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
                    } else {
                        String relationName = this.getRelationPropertyName(ctx, fieldInfo);
                        filter.getFilterItems().add(new FilterItemInfo(relationName, (Object)billId));
                        viewInfo.getSelector().add(new SelectorItemInfo(relationName));
                        dyModelInfo.getRelateModel().put(entityName, relationName);
                        String singleCondition = this.getMultiRowSingleView(ctx, fieldInfo);
                        if (!StringUtils.isEmpty((String)singleCondition)) {
                            dyModelInfo.getMultiRowOneColumnMap().put(entityName, singleCondition);
                            FilterInfo filterInfo = null;
                            try {
                                filterInfo = new FilterInfo(singleCondition);
                                filter.mergeFilter(filterInfo, "and");
                            }
                            catch (ParserException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    viewInfo.setFilter(filter);
                    dyModelInfo.getViewModelEnityViewMap().put(entityName, viewInfo);
                }
                viewInfo = dyModelInfo.getViewModelEnityViewMap().get(entityName);
                viewInfo.getSelector().add(propName);
                dyModelInfo.getKeyReverseMap().put(sic.get(i).getPropertyName(), entityName + ":" + propName);
            }
            if (dyModelInfo.getInfoNameKeysMap().containsKey(fieldInfo.getFactField().getStructureConfig().getEntityName())) {
                keys = (HashMap)dyModelInfo.getInfoNameKeysMap().get(fieldInfo.getFactField().getStructureConfig().getEntityName());
                keys.put(sic.get(i).getPropertyName(), null);
                continue;
            }
            keys = new HashMap();
            keys.put(sic.get(i).getPropertyName(), null);
            dyModelInfo.getInfoNameKeysMap().put(fieldInfo.getFactField().getStructureConfig().getEntityName(), keys);
        }
        return dyModelInfo;
    }

    private void loadExistingInfo(DynamicModelInfo dyModelInfo) throws BOSException, EASBizException {
        HashMap<String, Object> infoNameMap = dyModelInfo.getInfoNameKeysMap();
        Iterator<Map.Entry<String, Object>> iter = infoNameMap.entrySet().iterator();
        Context ctx = SHRContext.getInstance().getContext();
        HashMap<String, IObjectValue> valueMap = dyModelInfo.getValueMap();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            try {
                String entityName = entry.getKey().toString();
                HashMap keys = (HashMap)dyModelInfo.getInfoNameKeysMap().get(entityName);
                Iterator keyIter = keys.keySet().iterator();
                String key = null;
                QueryConfigFieldInfo fieldInfo = null;
                while (keyIter.hasNext()) {
                    key = keyIter.next().toString();
                    fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)key);
                    String singleSign = fieldInfo.getFactField().getStructureConfig().getSingleFields();
                    String infoStr = fieldInfo.getFactField().getStructureConfig().getClientNumber();
                    if (valueMap.containsKey(entityName) || valueMap.containsKey(entityName + "@" + infoStr)) continue;
                    if (singleSign == null || "".equals(singleSign)) {
                        singleSign = "name";
                    }
                    String[] singles = singleSign.split(";");
                    FilterInfo filter = new FilterInfo();
                    if (!fieldInfo.getFactField().getStructureConfig().isBaseData()) continue;
                    String infoMsg = "";
                    for (int i = 0; i < singles.length; ++i) {
                        if (!keys.containsKey(infoStr + "." + singles[i]) && !"number".equalsIgnoreCase(singles[i])) {
                            throw new BOSException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_contain_primary_field"));
                        }
                        Object tempValue = this.properties.get(key);
                        if (tempValue != null && tempValue instanceof CoreBaseInfo) {
                            valueMap.put(entityName, (IObjectValue)tempValue);
                            break;
                        }
                        filter.getFilterItems().add(new FilterItemInfo(singles[i], this.properties.get(key)));
                        infoMsg = infoMsg + this.properties.get(infoStr + "." + singles[i]) + ",";
                    }
                    if (infoMsg.length() > 0) {
                        infoMsg = infoMsg.substring(0, infoMsg.length() - 1);
                    }
                    if (valueMap.containsKey(entityName)) continue;
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(filter);
                    ICoreBase iCoreBase = this.getInterface(entityName, null);
                    CoreBaseCollection coreBaseColl = iCoreBase.getCollection(view);
                    if (coreBaseColl != null && coreBaseColl.size() == 1) {
                        valueMap.put(entityName + "@" + infoStr, (IObjectValue)coreBaseColl.get(0));
                        continue;
                    }
                    if (coreBaseColl != null && coreBaseColl.size() > 1) {
                        throw new BOSException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "primary_not_ensure"), fieldInfo.getAlias(), infoMsg));
                    }
                    throw new BOSException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_found"), fieldInfo.getAlias()));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        for (Map.Entry<String, Object> entry : infoNameMap.entrySet()) {
            try {
                this.prepareInfo(ctx, entry.getKey().toString(), dyModelInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void prepareInfo(Context ctx, String entityName, DynamicModelInfo dyModelInfo) throws BOSException, EASBizException, Exception {
        HashMap keys = (HashMap)dyModelInfo.getInfoNameKeysMap().get(entityName);
        Iterator iter = keys.keySet().iterator();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)key);
            String singleSign = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)fieldInfo.getFactField().getStructureConfig().getId().toString(), (String)this.getScheme()).getSingleFields();
            String infoStr = fieldInfo.getFactField().getStructureConfig().getClientNumber();
            if (singleSign == null || "".equals(singleSign)) {
                singleSign = "name";
            }
            String[] singles = singleSign.split(";");
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                this.handlerBaseType(ctx, entityName, dyModelInfo, fieldInfo, infoStr);
                continue;
            }
            this.handlerNoBaseType(ctx, entityName, dyModelInfo, fieldInfo, infoStr, singles, keys);
        }
    }

    private void handlerNoBaseType(Context ctx, String entityName, DynamicModelInfo dyModelInfo, QueryConfigFieldInfo fieldInfo, String infoStr, String[] singles, HashMap keys) throws Exception {
        HashMap<String, IObjectValue> valueMap = dyModelInfo.getValueMap();
        HashMap<String, Object> infoNameMap = dyModelInfo.getInfoNameKeysMap();
        FilterInfo filter = new FilterInfo();
        if (valueMap.containsKey(entityName) || valueMap.containsKey(entityName + "@" + infoStr)) {
            return;
        }
        MetaDataPK metaDataPK = new MetaDataPK(entityName);
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
        boolean isPersonBaseData = false;
        if ("com.kingdee.eas.hr.base.app.EmpInfoSinglePage".equals(entityInfo.getBaseEntity().getFullName()) || "com.kingdee.eas.hr.base.app.EmpInfoMultiPage".equals(entityInfo.getBaseEntity().getFullName())) {
            isPersonBaseData = true;
        }
        for (int i = 0; i < singles.length; ++i) {
            if (!keys.containsKey(infoStr + "." + singles[i])) {
                PropertyInfo property = entityInfo.getPropertyByName(singles[i]);
                if (property != null && property instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)property;
                    RelationshipInfo relaShip = linkPropertyInfo.getRelationship();
                    EntityObjectInfo supplier = relaShip.getSupplierObject();
                    String supplierEntity = supplier.getFullName();
                    if (valueMap.containsKey(supplierEntity)) {
                        filter.getFilterItems().add(new FilterItemInfo(singles[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                        continue;
                    }
                    if (infoNameMap.containsKey(supplierEntity)) {
                        this.prepareInfo(ctx, supplierEntity, dyModelInfo);
                        if (valueMap.containsKey(entityName)) {
                            return;
                        }
                        if (valueMap.containsKey(supplierEntity)) {
                            filter.getFilterItems().add(new FilterItemInfo(singles[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                            continue;
                        }
                        filter.getFilterItems().add(new FilterItemInfo(singles[i], null));
                        continue;
                    }
                    filter.getFilterItems().add(new FilterItemInfo(singles[i], null));
                    continue;
                }
                if (!DynamicModelHelper.checkIfHaveName(entityName)) continue;
                filter.getFilterItems().add(new FilterItemInfo(singles[i], this.properties.get(infoStr + "." + singles[i])));
                continue;
            }
            filter.getFilterItems().add(new FilterItemInfo(singles[i], this.properties.get(infoStr + "." + singles[i])));
        }
        StructureConfigInfo parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)fieldInfo.getFactField().getStructureConfig().getId().toString(), (String)this.getScheme());
        String parentEntityName = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)fieldInfo.getFactField().getStructureConfig().getParent().getId().toString(), (String)this.getScheme()).getEntityName();
        String propName = this.getRelationPropertyName(ctx, fieldInfo);
        DynamicModelHelper.checkFilterCanNotImportEntity(entityName, parentEntityName);
        if (isPersonBaseData) {
            filter.getFilterItems().add(new FilterItemInfo(propName, (Object)((CoreBaseInfo)valueMap.get(parentEntityName)).getId().toString()));
        }
        if ("com.kingdee.eas.hr.emp.app.EmployeeContract".equals(entityName) || "com.kingdee.eas.hr.emp.app.PersonOtherInfo".equals(entityName)) {
            filter.getFilterItems().add(new FilterItemInfo(propName, (Object)((CoreBaseInfo)valueMap.get(parentEntityName)).getId().toString()));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ICoreBase coreBase = this.getInterface(entityName, null);
        CoreBaseCollection coreBaseColl = coreBase.getCollection(view);
        if (coreBaseColl != null && coreBaseColl.size() == 1) {
            valueMap.put(entityName, (IObjectValue)coreBaseColl.get(0));
        } else {
            if (coreBaseColl != null && coreBaseColl.size() > 1) {
                throw new BOSException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "check_primary_setting"), entityInfo.getAlias()));
            }
            CoreBaseInfo coreInfo = this.createInfo(entityName);
            coreInfo.setId(BOSUuid.create((BOSObjectType)coreInfo.getBOSType()));
            if (parentInfo.isMultiRow()) {
                coreInfo.put(propName, (Object)valueMap.get(parentEntityName));
            } else if (isPersonBaseData) {
                coreInfo.put(propName, (Object)valueMap.get(parentEntityName));
            }
            valueMap.put(entityName, (IObjectValue)coreInfo);
            this.handlerLinkProperty(singles, entityInfo, valueMap, coreInfo);
        }
    }

    private void handlerBaseType(Context ctx, String entityName, DynamicModelInfo dyModelInfo, QueryConfigFieldInfo fieldInfo, String infoStr) throws Exception {
        String propName;
        HashMap<String, IObjectValue> valueMap = dyModelInfo.getValueMap();
        HashMap<String, Object> infoNameMap = dyModelInfo.getInfoNameKeysMap();
        EntityViewInfo view = new EntityViewInfo();
        ICoreBase coreBase = null;
        CoreBaseCollection coreBaseColl = null;
        StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
        String parentEntityName = parentInfo.getEntityName();
        String path = propName = this.getRelationPropertyName(ctx, fieldInfo);
        String fieldStr = fieldInfo.getFactField().getStructureConfig().getClientNumber();
        if (parentInfo.isBaseData()) {
            return;
        }
        if (valueMap.containsKey(parentEntityName)) {
            valueMap.get(parentEntityName).put(propName, (Object)valueMap.get(entityName + "@" + infoStr));
        } else if (valueMap.containsKey(parentEntityName + "@" + parentInfo.getClientNumber())) {
            valueMap.get(parentEntityName + "@" + parentInfo.getClientNumber()).put(propName, (Object)valueMap.get(entityName + "@" + infoStr));
        } else {
            LinkPropertyInfo linkPropertyInfo;
            PropertyInfo property;
            int i;
            parentInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)parentInfo.getId().toString(), (String)this.getScheme());
            String singleStr = parentInfo.getSingleFields();
            infoStr = fieldInfo.getFactField().getStructureConfig().getParent().getClientNumber();
            if (infoStr == null) {
                infoStr = parentInfo.getClientNumber();
            }
            HashMap selects = (HashMap)infoNameMap.get(parentEntityName);
            boolean isPersonBaseData = false;
            MetaDataPK metaDataPK = new MetaDataPK(parentEntityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
            if ("com.kingdee.eas.hr.base.app.EmpInfoSinglePage".equals(entityInfo.getBaseEntity().getFullName()) || "com.kingdee.eas.hr.base.app.EmpInfoMultiPage".equals(entityInfo.getBaseEntity().getFullName())) {
                isPersonBaseData = true;
            }
            if (singleStr == null || "".equals(singleStr)) {
                singleStr = "com.kingdee.eas.hr.base.app.EmpInfoSinglePage".equals(entityInfo.getBaseEntity().getFullName()) ? "person" : "name";
            }
            String[] singleStrs = singleStr.split(";");
            FilterInfo singleFilter = new FilterInfo();
            if (selects == null) {
                for (i = 0; i < singleStrs.length; ++i) {
                    if (propName.equalsIgnoreCase(singleStrs[i])) {
                        if (valueMap.get(entityName) != null) {
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(entityName)).getId().toString()));
                            continue;
                        }
                        singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(entityName + "@" + fieldStr)).getId().toString()));
                        continue;
                    }
                    property = entityInfo.getPropertyByName(singleStrs[i]);
                    if (property instanceof LinkPropertyInfo) {
                        linkPropertyInfo = (LinkPropertyInfo)property;
                        RelationshipInfo relaShip = linkPropertyInfo.getRelationship();
                        EntityObjectInfo supplier = relaShip.getSupplierObject();
                        String supplierEntity = supplier.getFullName();
                        if (valueMap.containsKey(supplierEntity)) {
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                            continue;
                        }
                        if (infoNameMap.containsKey(supplierEntity)) {
                            this.prepareInfo(ctx, supplierEntity, dyModelInfo);
                            if (valueMap.containsKey(parentEntityName)) {
                                return;
                            }
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                            continue;
                        }
                        singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], null));
                        continue;
                    }
                    if (this.properties.containsKey(infoStr + "." + singleStrs[i])) {
                        singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], this.properties.get(infoStr + "." + singleStrs[i])));
                        continue;
                    }
                    singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], null));
                }
            } else {
                for (i = 0; i < singleStrs.length; ++i) {
                    if (!selects.containsKey(infoStr + "." + singleStrs[i])) {
                        if (propName.equalsIgnoreCase(singleStrs[i])) {
                            if (valueMap.get(entityName + "@" + fieldStr) != null) {
                                singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(entityName + "@" + fieldStr)).getId().toString()));
                                continue;
                            }
                            if (valueMap.get(entityName) != null) {
                                singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(entityName)).getId().toString()));
                                continue;
                            }
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], null));
                            continue;
                        }
                        property = entityInfo.getPropertyByName(singleStrs[i]);
                        if (property instanceof LinkPropertyInfo) {
                            linkPropertyInfo = (LinkPropertyInfo)property;
                            RelationshipInfo relaShip = linkPropertyInfo.getRelationship();
                            EntityObjectInfo supplier = relaShip.getSupplierObject();
                            String supplierEntity = supplier.getFullName();
                            if (valueMap.containsKey(supplierEntity)) {
                                singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                                continue;
                            }
                            if (infoNameMap.containsKey(supplierEntity)) {
                                this.prepareInfo(ctx, supplierEntity, dyModelInfo);
                                if (valueMap.containsKey(parentEntityName)) {
                                    return;
                                }
                                singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], (Object)((CoreBaseInfo)valueMap.get(supplierEntity)).getId().toString()));
                                continue;
                            }
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], null));
                            continue;
                        }
                        if (this.properties.containsKey(infoStr + "." + singleStrs[i])) {
                            singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], this.properties.get(infoStr + "." + singleStrs[i])));
                            continue;
                        }
                        if (!DynamicModelHelper.checkIfHaveName(parentEntityName)) continue;
                        singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], null));
                        continue;
                    }
                    singleFilter.getFilterItems().add(new FilterItemInfo(singleStrs[i], this.properties.get(infoStr + "." + singleStrs[i])));
                }
            }
            String preEntityName = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)parentInfo.getParent().getId().toString(), (String)this.getScheme()).getEntityName();
            String prePropName = this.getRelation(parentInfo);
            DynamicModelHelper.checkFilterCanNotImportEntity(entityName, preEntityName);
            if (isPersonBaseData) {
                if (valueMap.get(preEntityName) != null) {
                    singleFilter.getFilterItems().add(new FilterItemInfo(prePropName, (Object)((CoreBaseInfo)valueMap.get(preEntityName)).getId().toString()));
                } else {
                    singleFilter.getFilterItems().add(new FilterItemInfo(prePropName, (Object)((CoreBaseInfo)valueMap.get(preEntityName + "@" + fieldStr)).getId().toString()));
                }
            }
            if (parentInfo.isMultiRow() && "com.kingdee.eas.hr.emp.app.EmployeeContract".equals(parentEntityName)) {
                singleFilter.getFilterItems().add(new FilterItemInfo(prePropName, (Object)((CoreBaseInfo)valueMap.get(preEntityName)).getId().toString()));
            }
            view = new EntityViewInfo();
            view.setFilter(singleFilter);
            coreBase = this.getInterface(parentEntityName, null);
            coreBaseColl = coreBase.getCollection(view);
            if (coreBaseColl != null && coreBaseColl.size() == 1) {
                valueMap.put(parentEntityName, (IObjectValue)coreBaseColl.get(0));
            } else {
                if (coreBaseColl != null && coreBaseColl.size() > 1) {
                    throw new BOSException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "check_primary_setting"), entityInfo.getAlias()));
                }
                CoreBaseInfo model = this.createInfo(parentEntityName);
                model.setId(BOSUuid.create((BOSObjectType)model.getBOSType()));
                if (valueMap.get(entityName) != null) {
                    model.put(propName, (Object)valueMap.get(entityName));
                } else {
                    model.put(propName, (Object)valueMap.get(entityName + "@" + fieldStr));
                }
                if (isPersonBaseData) {
                    model.put(prePropName, (Object)valueMap.get(preEntityName));
                }
                valueMap.put(parentEntityName, (IObjectValue)model);
                metaDataPK = new MetaDataPK(parentEntityName);
                entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
                this.handlerLinkProperty(singleStrs, entityInfo, valueMap, model);
            }
        }
    }

    private void handlerLinkProperty(String[] singleStrs, EntityObjectInfo entityInfo, HashMap<String, IObjectValue> valueMap, CoreBaseInfo model) {
        for (int i = 0; i < singleStrs.length; ++i) {
            LinkPropertyInfo linkPropertyInfo;
            RelationshipInfo relaShip;
            EntityObjectInfo supplier;
            String supplierEntity;
            PropertyInfo property = entityInfo.getPropertyByName(singleStrs[i]);
            if (!(property instanceof LinkPropertyInfo) || !valueMap.containsKey(supplierEntity = (supplier = (relaShip = (linkPropertyInfo = (LinkPropertyInfo)property).getRelationship()).getSupplierObject()).getFullName())) continue;
            model.put(singleStrs[i], (Object)valueMap.get(supplierEntity));
        }
    }

    private CoreBaseInfo createInfo(String entityName) throws Exception {
        String clazz = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(entityName)).getObjectValueClass();
        Class<?> modelClass = Class.forName(clazz);
        CoreBaseInfo model = (CoreBaseInfo)modelClass.newInstance();
        if (!StringUtils.isEmpty((String)entityName)) {
            MetaDataPK metaDataPK = new MetaDataPK(entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
            if (entityInfo.isDynamic() && model instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)model;
                commonObject.setBOSType(entityInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        return model;
    }

    public void saveModelDatas(DynamicModelInfo model) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        Iterator<Map.Entry<String, IObjectValue>> iter = model.getSaveModelMap().entrySet().iterator();
        HashMap<String, Object> infoNameKeys = model.getInfoNameKeysMap();
        ICoreBase coreBase = null;
        QueryConfigFieldInfo fieldInfo = null;
        while (iter.hasNext()) {
            Map.Entry<String, IObjectValue> entry = iter.next();
            String key = entry.getKey();
            if (infoNameKeys.get(key) == null) {
                coreBase = this.getInterface(key, null);
                coreBase.save((CoreBaseInfo)entry.getValue());
                continue;
            }
            String firstkey = (String)((HashMap)infoNameKeys.get(key)).keySet().iterator().next();
            fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)firstkey);
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) continue;
            coreBase = this.getInterface(key, null);
            coreBase.save((CoreBaseInfo)entry.getValue());
        }
    }

    private void loadAllExistingInfo(DynamicModelInfo dyModelInfo) throws BOSException {
        for (Map.Entry<String, EntityViewInfo> entry : dyModelInfo.getViewModelEnityViewMap().entrySet()) {
            EntityViewInfo viewInfo = entry.getValue();
            SelectorItemCollection allsic = new SelectorItemCollection();
            allsic.add(new SelectorItemInfo("*"));
            viewInfo.setSelector(allsic);
        }
        Context ctx2 = SHRContext.getInstance().getContext();
        HashMap<String, IObjectValue> valueMap = this.getValueAndGroup(ctx2, dyModelInfo);
        dyModelInfo.setValueMap(valueMap);
    }

    public String getPropertyName(String propKey) {
        Context ctx = SHRContext.getInstance().getContext();
        QueryConfigFieldInfo fieldInfo = null;
        try {
            fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)propKey);
            return fieldInfo.getAlias();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PropertyInfo getPropertyInfo(String propKey) throws EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        QueryConfigFieldInfo fieldInfo = null;
        try {
            fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)propKey);
            if (fieldInfo == null) {
                return null;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String entityName = null;
        String propName = null;
        if (fieldInfo != null) {
            if (fieldInfo.getFactField().getStructureConfig().isBaseData()) {
                StructureConfigInfo parentInfo = fieldInfo.getFactField().getStructureConfig().getParent();
                entityName = parentInfo.getEntityName();
                propName = this.getRelationPropertyName(ctx, fieldInfo);
            } else {
                entityName = fieldInfo.getFactField().getStructureConfig().getEntityName();
                propName = fieldInfo.getFactField().getNumber();
            }
        }
        EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return entityObjInfo.getPropertyByNameRuntime(propName);
    }

    private String getMultiRowSingleView(Context ctx, QueryConfigFieldInfo fieldInfo) throws EASBizException, BOSException {
        StructureConfigInfo clientInfo = fieldInfo.getFactField().getStructureConfig();
        if ((clientInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)clientInfo.getId().toString(), (String)clientInfo.getScheme().getNumber())).isMultiRow() && clientInfo.isSupportSingleView()) {
            return clientInfo.getSingleCondition();
        }
        return null;
    }

    private String getRelationPropertyName(Context ctx, QueryConfigFieldInfo fieldInfo) throws EASBizException, BOSException {
        StructureConfigInfo clientInfo = fieldInfo.getFactField().getStructureConfig();
        clientInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)ctx, (String)clientInfo.getId().toString(), (String)clientInfo.getScheme().getNumber());
        return this.getRelation(clientInfo);
    }

    private String getRelation(StructureConfigInfo clientInfo) {
        for (int i = 0; i < clientInfo.getFilterColumn().size(); ++i) {
            if (clientInfo.getFilterColumn().get(i).getParentColumn() != null && "id".equalsIgnoreCase(clientInfo.getFilterColumn().get(i).getClientColumn())) {
                return clientInfo.getFilterColumn().get(i).getParentColumn();
            }
            if (clientInfo.getFilterColumn().get(i).getParentColumn() == null || !"id".equalsIgnoreCase(clientInfo.getFilterColumn().get(i).getParentColumn())) continue;
            return clientInfo.getFilterColumn().get(i).getClientColumn();
        }
        return null;
    }

    public Object getValueByType(Object value, PropertyInfo propertyInfo) {
        return null;
    }

    public Object handlerValueType(String key, Object value) throws Exception {
        if (value == null) {
            return value;
        }
        if ("\\".equals(value.toString())) {
            return value.toString();
        }
        Context ctx = SHRContext.getInstance().getContext();
        QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)key);
        Object returnValue = null;
        String type = fieldInfo.getFactField().getDataType();
        if (type == null) {
            returnValue = value instanceof String ? value : value.toString();
        } else if ("String".equals(type)) {
            returnValue = value instanceof String ? value : value.toString();
        } else if ("Date".equals(type)) {
            returnValue = value instanceof Date ? value : DateTimeUtils.parseDate((String)value.toString(), (String)"yyyy-MM-dd");
        } else if ("TimeStamp".equals(type)) {
            returnValue = value instanceof Date ? value : DateTimeUtils.parseDate((String)value.toString());
        } else if ("Boolean".equals(type)) {
            returnValue = value instanceof Boolean ? value : (SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true").equals(value) ? Boolean.valueOf(true) : (SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false").equals(value) ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(value.toString()))));
        } else if ("Integer".equals(type)) {
            returnValue = value instanceof Integer ? value : Integer.valueOf(Integer.parseInt(value.toString()));
        } else if ("Float".equals(type)) {
            returnValue = value instanceof Float ? value : Float.valueOf(Float.parseFloat(value.toString()));
        } else if ("Double".equals(type)) {
            returnValue = value instanceof Double ? value : Double.valueOf(Double.parseDouble(value.toString()));
        } else if ("BigDecimal".equals(type)) {
            returnValue = value instanceof BigDecimal ? value : new BigDecimal(value.toString());
        } else if ("BOSUuid".equals(type)) {
            returnValue = value instanceof BOSUuid ? value : BOSUuid.read((String)value.toString());
        } else if (type.contains("Enum")) {
            String enumClass = fieldInfo.getFactField().getEnumSource();
            if (enumClass == null) {
                returnValue = null;
            } else {
                Map enumValue = EnumUtils.getEnumMap(Class.forName(enumClass));
                Iterator iterator = enumValue.values().iterator();
                Object enumObject = null;
                while (iterator.hasNext()) {
                    enumObject = iterator.next();
                    if (!enumObject.toString().equals(value.toString())) continue;
                    returnValue = enumObject;
                    break;
                }
            }
        }
        return returnValue;
    }

    private static boolean checkIfHaveName(String entityName) {
        MetaDataPK entityPk = MetaDataPK.create((String)entityName);
        Context ctx = SHRContext.getInstance().getContext();
        EntityObjectInfo entityObject = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)entityPk);
        PropertyCollection propColl = entityObject.getEntityProperties();
        String propName = "";
        boolean ifHaveName = false;
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo info = propColl.get(i);
            propName = info.getName();
            if (!"name".equals(propName)) continue;
            ifHaveName = true;
        }
        return ifHaveName;
    }

    private static void checkFilterCanNotImportEntity(String entityName, String parentEntityName) throws BOSException {
        if (entityName.equals("com.kingdee.eas.hr.base.app.EmpLaborRelation") || parentEntityName.equals("com.kingdee.eas.hr.base.app.EmpLaborRelation")) {
            throw new BOSException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "relation_unable_import"));
        }
        if (entityName.equals("com.kingdee.eas.hr.base.app.EmpPosOrgRelation") || parentEntityName.equals("com.kingdee.eas.hr.base.app.EmpPosOrgRelation")) {
            throw new BOSException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "hispos_unable_import"));
        }
    }
}

