/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.shr.base.syssetting.SystemConfigSolutionInfo;
import com.kingdee.shr.base.syssetting.app.cache.SystemSHRCache;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.FileOperateUtil;
import com.kingdee.shr.base.syssetting.util.FileVaildUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.MD5;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.AESUtil;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.ml.util.TimeZoneTransfer;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportHelper {
    private static final Logger logger = Logger.getLogger(ExportHelper.class);
    private static final int DEFAULT_SCALE = 2;
    private static final String INTEGER_FORMAT = "0";
    private static final String INTEGER_FORMAT_CENTER = "intCenter";
    private static final String DECIMAL_FORMAT = "0.00";
    private static final String STR_STYLE = "StrStyle";
    private boolean isAsyn = false;
    public static final String FILE_DIR = "shrExport";
    private static final List<String> UIPK_WHITE_LIST_IGNORE_PASSWORD = new ArrayList<String>();

    public ExportHelper() {
    }

    public ExportHelper(boolean isAsyn) {
        this.isAsyn = isAsyn;
    }

    public Map<String, Object> createExcel(HttpServletRequest request, Map<String, Object> params) throws SHRWebException {
        HashMap<String, Object> excelConfig = new HashMap<String, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        String title = (String)params.get("title");
        String columnModelStr = (String)params.get("columnModel");
        String groupHeaders = (String)params.get("groupHeaders");
        UIViewInfo uiViewInfo = (UIViewInfo)params.get("uiViewObject");
        List<Map<String, Object>> columnModel = this.assembleColumnModel(ctx, columnModelStr, uiViewInfo);
        WebUtil.getExcelTempDir();
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("-----------title---------------:" + title));
        }
        Sheet sheet = workbook.createSheet(title);
        String config = " ";
        try {
            SystemConfigSolutionInfo configInfo = SystemSHRCache.getSystemConfigSolutionInfo((Context)ctx);
            if (null != configInfo && !StringUtils.isEmpty((String)configInfo.getConfig())) {
                config = configInfo.getConfig();
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        Map configMap = (Map)JSON.parse((String)config);
        String isRemoveTitle = (String)configMap.get("isRemoveTitle");
        if (StringUtils.isEmpty((String)isRemoveTitle) || !Boolean.parseBoolean(isRemoveTitle)) {
            this.fillTitle(sheet, title);
        }
        int headerRows = this.fillHeader(sheet, columnModel, groupHeaders);
        int currentDataRowIndex = 1 + headerRows;
        excelConfig.put("workbook", workbook);
        excelConfig.put("title", title);
        excelConfig.put("currentDataRowIndex", currentDataRowIndex);
        excelConfig.put("columnModel", columnModel);
        excelConfig.put("groupHeaders", groupHeaders);
        excelConfig.put("session", request.getSession());
        try {
            excelConfig.put("timeZone", UserNantionalUtil.getTimeZoneIDForSunJDK((Context)ctx));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return excelConfig;
    }

    public Map<String, Object> assembleHandleParam(HttpServletRequest request) throws SHRWebException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("columnModel", request.getParameter("queryMode"));
        params.put("groupHeaders", request.getParameter("groupHeaders"));
        String title = request.getParameter("title");
        if (StringUtils.isEmpty((String)title)) {
            title = (String)request.getAttribute("title");
        }
        if (!StringUtils.isEmpty((String)title)) {
            title = title.trim();
        }
        params.put("title", title);
        params.put("uiViewObject", UIViewUtil.getCurrentUIViewInfo((ServletRequest)request));
        return params;
    }

    public void fillData(Map<String, Object> excelConfig, List<Map<String, Object>> datas) throws SHRWebException {
        int limitRowCount = 1000000;
        if (datas == null || datas.isEmpty()) {
            return;
        }
        String title = (String)excelConfig.get("title");
        List columnModel = (List)excelConfig.get("columnModel");
        String groupHeaders = (String)excelConfig.get("groupHeaders");
        long start = 0L;
        long end = 0L;
        if (logger.isDebugEnabled()) {
            start = new Date().getTime();
        }
        int rowCount = datas.size();
        int times = rowCount / limitRowCount;
        if (rowCount % limitRowCount != 0) {
            ++times;
        }
        String path = "";
        for (int i = 0; i < times; ++i) {
            SXSSFWorkbook workbook = null;
            int currentDataRowIndex = (Integer)excelConfig.get("currentDataRowIndex");
            if (i == 0) {
                workbook = (SXSSFWorkbook)excelConfig.get("workbook");
                currentDataRowIndex = (Integer)excelConfig.get("currentDataRowIndex");
            } else {
                workbook = new SXSSFWorkbook(100);
                String newTitle = title + i;
                excelConfig.put("title", newTitle);
                SXSSFSheet sheet = workbook.createSheet(newTitle);
                this.fillTitle((Sheet)sheet, title);
                this.fillHeader((Sheet)sheet, columnModel, groupHeaders);
            }
            int count = (i + 1) * limitRowCount < rowCount ? (i + 1) * limitRowCount : rowCount;
            HashMap<Integer, Boolean> markStyle = new HashMap<Integer, Boolean>();
            Map<String, CellStyle> styles = this.getStyle(workbook);
            for (int j = i * limitRowCount; j < count; ++j) {
                this.fillExcel(workbook, styles, datas.get(j), currentDataRowIndex, columnModel, rowCount, markStyle, j);
                ++currentDataRowIndex;
            }
            if (times <= 1) continue;
            excelConfig.put("workbook", workbook);
            path = this.saveExcelToFile((HttpSession)excelConfig.get("session"), excelConfig);
        }
        if (times > 1) {
            excelConfig.put("isMuti", true);
            excelConfig.put("pathDir", path);
            excelConfig.put("title", title);
        }
        if (logger.isDebugEnabled()) {
            end = new Date().getTime();
            logger.debug((Object)MessageFormat.format("{0} fill excel data, cost: {1}", this.getClass().getName(), end - start));
        }
    }

    public void fillData0(Map<String, Object> excelConfig, List<Map<String, Object>> datas) throws SHRWebException {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        String title = (String)excelConfig.get("title");
        List columnModel = (List)excelConfig.get("columnModel");
        String groupHeaders = (String)excelConfig.get("groupHeaders");
        long start = 0L;
        long end = 0L;
        if (logger.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        String path = "";
        SXSSFWorkbook workbook = (SXSSFWorkbook)excelConfig.get("workbook");
        int currentDataRowIndex = (Integer)excelConfig.get("currentDataRowIndex");
        SXSSFSheet sheet = workbook.getSheetAt(0);
        HashMap<Integer, Boolean> markStyle = new HashMap();
        Map styles = this.getStyle(workbook);
        Object sheetIndex = excelConfig.get("sheetIndex");
        Object styles0 = excelConfig.get("styles");
        Object markStyle0 = excelConfig.get("markStyle");
        int titleIndex = 1;
        if (null != sheetIndex) {
            titleIndex = (Integer)sheetIndex;
        }
        if (styles0 != null) {
            styles = (Map)styles0;
        }
        if (null != markStyle0) {
            markStyle = (Map)markStyle0;
        }
        if (excelConfig.get("excelIndex") == null) {
            excelConfig.put("excelIndex", 0);
        }
        int excelIndex = (Integer)excelConfig.get("excelIndex");
        int total = datas.size();
        for (int i = 0; i < total; ++i) {
            this.fillExcel0(workbook, styles, datas.get(i), currentDataRowIndex, (Sheet)sheet, markStyle, columnModel, i + excelIndex, excelConfig);
            ++currentDataRowIndex;
        }
        excelConfig.put("excelIndex", excelIndex += datas.size());
        excelConfig.put("styles", styles);
        excelConfig.put("markStyle", markStyle);
        excelConfig.put("currentDataRowIndex", currentDataRowIndex);
        excelConfig.put("workbook", workbook);
        end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("{0} fill excel data, cost: {1} ms, {2} s", this.getClass().getName(), end - start, Float.valueOf((float)(end - start) / 1000.0f)));
        }
    }

    private void fillExcel0(SXSSFWorkbook workbook, Map<String, CellStyle> styles, Map<String, Object> data, int currentDataRowIndex, Sheet sheet, Map<Integer, Boolean> markStyle, List<Map<String, Object>> columnModel, int rowIndex, Map<String, Object> excelConfig) {
        int scale = 2;
        Row row = null;
        Cell cell = null;
        Object value = null;
        row = sheet.createRow(currentDataRowIndex);
        CreationHelper creationHelper = workbook.getCreationHelper();
        int col = 0;
        cell = row.createCell(0);
        cell.setCellValue((double)(rowIndex + 1));
        CellStyle cellSty = styles.get(INTEGER_FORMAT_CENTER);
        cell.setCellStyle(cellSty);
        Map attributes = null;
        Map datetimeOptions = null;
        Map numberOptions = null;
        DataType dataType = null;
        TimeZone timeZone = (TimeZone)excelConfig.get("timeZone");
        for (Map<String, Object> column : columnModel) {
            block57: {
                cell = row.createCell(col + 1);
                value = data.get(column.get("name"));
                if (null == value || StringUtils.isEmpty((String)value.toString())) {
                    ++col;
                    continue;
                }
                attributes = (Map)column.get("attributes");
                datetimeOptions = (Map)column.get("extendOption");
                numberOptions = (Map)column.get("extendNumberOption");
                dataType = (DataType)column.get("dataType");
                if (value instanceof Number) {
                    if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                        cell.setCellStyle(styles.get(INTEGER_FORMAT));
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                        } else if (value instanceof Long) {
                            cell.setCellValue((double)((Long)value).longValue());
                        } else if (value instanceof BigInteger) {
                            cell.setCellValue((double)((BigInteger)value).intValue());
                        }
                    } else if (value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
                        if (attributes == null || attributes.isEmpty()) {
                            attributes = numberOptions;
                        }
                        if (null != attributes) {
                            Object ignoreDecimalFormatterObject = attributes.get("ignoreDecimalFormatter");
                            String ignoreDecimalFormatter = null;
                            if (ignoreDecimalFormatterObject != null) {
                                ignoreDecimalFormatter = ignoreDecimalFormatterObject.toString();
                            }
                            if (!StringUtils.isEmpty(ignoreDecimalFormatter) && Boolean.valueOf(ignoreDecimalFormatter).booleanValue()) {
                                String decValueSplit = String.valueOf(value);
                                if (value instanceof BigDecimal) {
                                    scale = ((BigDecimal)value).scale();
                                } else if (value instanceof Double) {
                                    if (decValueSplit.indexOf(".") != -1) {
                                        scale = decValueSplit.substring(decValueSplit.indexOf(".") + 1).length();
                                    }
                                } else if (value instanceof Float && decValueSplit.indexOf(".") != -1) {
                                    scale = decValueSplit.substring(decValueSplit.indexOf(".") + 1).length();
                                }
                            } else {
                                String decimalPrecisionStr;
                                Object decimalPrecisionObj = attributes.get("decimalPrecision");
                                if (decimalPrecisionObj != null && !StringUtils.isEmpty((String)(decimalPrecisionStr = decimalPrecisionObj.toString()))) {
                                    scale = Math.round(Float.parseFloat(decimalPrecisionStr));
                                }
                            }
                        }
                        if (2 == scale) {
                            cell.setCellStyle(styles.get(DECIMAL_FORMAT));
                        } else {
                            StringBuffer preStr = new StringBuffer(scale == 0 ? INTEGER_FORMAT : "0.");
                            for (int j = 0; j < scale; ++j) {
                                preStr.append(INTEGER_FORMAT);
                            }
                            CellStyle cellStyleBigDec = styles.get(preStr.toString());
                            if (null == cellStyleBigDec) {
                                cellStyleBigDec = workbook.createCellStyle();
                                cellStyleBigDec.setDataFormat(creationHelper.createDataFormat().getFormat(preStr.toString()));
                                styles.put(preStr.toString(), cellStyleBigDec);
                            }
                            cell.setCellStyle(cellStyleBigDec);
                            if (markStyle.get(col) == null || !markStyle.get(col).booleanValue()) {
                                markStyle.put(col, true);
                                sheet.setColumnWidth(col, 5000);
                            }
                        }
                        if (value instanceof BigDecimal) {
                            cell.setCellValue(((BigDecimal)value).doubleValue());
                        } else if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                        } else if (value instanceof Float) {
                            cell.setCellValue(Double.parseDouble(value.toString()));
                        }
                    } else {
                        cell.setCellStyle(styles.get(DECIMAL_FORMAT));
                        cell.setCellValue(Double.parseDouble(value.toString()));
                    }
                } else if (DataType.TIMESTAMP.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || value instanceof Date) {
                    boolean isRemoveDay = false;
                    CellStyle cellStyleDate = styles.get("yyyy-MM-dd");
                    if (null != datetimeOptions && null != datetimeOptions.get("isRemoveDay")) {
                        isRemoveDay = (Boolean)datetimeOptions.get("isRemoveDay");
                    }
                    if (isRemoveDay) {
                        cellStyleDate = styles.get("yyyy-MM");
                    }
                    if (dataType != null) {
                        if (DataType.TIMESTAMP.equals((Object)dataType)) {
                            cellStyleDate = styles.get("yyyy-MM-dd HH:mm:ss");
                        } else if (DataType.TIME.equals((Object)dataType)) {
                            cellStyleDate = styles.get("HH:mm:ss");
                        }
                    } else if (value instanceof Time) {
                        cellStyleDate = styles.get("HH:mm:ss");
                    } else if (value instanceof Timestamp) {
                        cellStyleDate = styles.get("yyyy-MM-dd HH:mm:ss");
                    }
                    if (markStyle.get(col) == null || !markStyle.get(col).booleanValue()) {
                        markStyle.put(col, true);
                        sheet.setColumnWidth(col, 6000);
                        sheet.setDefaultColumnStyle(col, cellStyleDate);
                    }
                    cell.setCellStyle(cellStyleDate);
                    if (value instanceof String) {
                        try {
                            if ((DataType.TIMESTAMP.equals((Object)dataType) || DataType.TIME.equals((Object)dataType)) && null != datetimeOptions && ((Boolean)datetimeOptions.get("showTimeZoneForCtrl")).booleanValue() && ((Boolean)datetimeOptions.get("isAutoTimeZoneTrans")).booleanValue()) {
                                Date tempDate = DateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd HH:mm:ss");
                                cell.setCellValue(TimeZoneTransfer.timeZoneTrans((Date)tempDate, (TimeZone)timeZone));
                                break block57;
                            }
                            cell.setCellValue(DateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd"));
                        }
                        catch (ParseException e) {
                            cell.setCellValue((String)value);
                        }
                    } else if (null != value) {
                        if ((DataType.TIMESTAMP.equals((Object)dataType) || DataType.TIME.equals((Object)dataType)) && null != datetimeOptions && ((Boolean)datetimeOptions.get("showTimeZoneForCtrl")).booleanValue() && ((Boolean)datetimeOptions.get("isAutoTimeZoneTrans")).booleanValue()) {
                            cell.setCellValue(TimeZoneTransfer.timeZoneTrans((Date)((Date)value), (TimeZone)timeZone));
                        } else {
                            cell.setCellValue((Date)value);
                        }
                    }
                } else {
                    if (null != value && !StringUtils.isEmpty((String)value.toString())) {
                        cell.setCellStyle(styles.get(STR_STYLE));
                    }
                    cell.setCellValue(this.formatObject(value, column));
                }
            }
            ++col;
        }
    }

    protected Map<String, CellStyle> getStyle(SXSSFWorkbook workbook) throws SHRWebException {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CreationHelper creationHelper = workbook.getCreationHelper();
        this.createCellStyle(workbook, INTEGER_FORMAT, creationHelper, styles, INTEGER_FORMAT);
        this.createCellStyle(workbook, INTEGER_FORMAT, creationHelper, styles, INTEGER_FORMAT_CENTER);
        ((CellStyle)styles.get(INTEGER_FORMAT_CENTER)).setAlignment(HorizontalAlignment.CENTER);
        ((CellStyle)styles.get(INTEGER_FORMAT_CENTER)).setVerticalAlignment(VerticalAlignment.CENTER);
        this.createCellStyle(workbook, DECIMAL_FORMAT, creationHelper, styles, DECIMAL_FORMAT);
        try {
            Map dateFormats = UserNantionalUtil.getDateUTCFormat((Context)SHRContext.getInstance().getContext());
            String format = (String)dateFormats.get(DataType.TIMESTAMP.getName());
            String[] ff = format.split("\\s");
            format = MessageFormat.format("{0} {1}", ff[0], "HH:mm:ss");
            dateFormats.put(DataType.TIMESTAMP.getName(), format);
            this.createCellStyle(workbook, (String)dateFormats.get(DataType.DATE.getName()), creationHelper, styles, "yyyy-MM-dd");
            this.createCellStyle(workbook, (String)dateFormats.get(DataType.TIMESTAMP.getName()), creationHelper, styles, "yyyy-MM-dd HH:mm:ss");
            this.createCellStyle(workbook, (String)dateFormats.get(DataType.TIME.getName()), creationHelper, styles, "HH:mm:ss");
            String formatWithoutDay = TimeZoneTransfer.getFormatWithoutDay((String)((String)dateFormats.get(DataType.DATE.getName())));
            this.createCellStyle(workbook, formatWithoutDay, creationHelper, styles, "yyyy-MM");
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        this.createCellStyle(workbook, "@", creationHelper, styles, STR_STYLE);
        return styles;
    }

    private void createCellStyle(SXSSFWorkbook workbook, String formate, CreationHelper creationHelper, Map<String, CellStyle> styles, String key) {
        CellStyle cellStyle = workbook.createCellStyle();
        if (!StringUtils.isEmpty((String)formate)) {
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(formate));
        }
        styles.put(key, cellStyle);
    }

    private void fillExcel(SXSSFWorkbook workbook, Map<String, CellStyle> styles, Map<String, Object> data, int currentDataRowIndex, List<Map<String, Object>> columnModel, int count, Map<Integer, Boolean> markStyle, int index) {
        SXSSFSheet sheet = workbook.getSheetAt(0);
        Row row = null;
        Cell cell = null;
        Object value = null;
        row = sheet.createRow(currentDataRowIndex);
        CreationHelper creationHelper = workbook.getCreationHelper();
        int col = 0;
        cell = row.createCell(0);
        cell.setCellValue((double)(index + 1));
        CellStyle cellSty = styles.get(INTEGER_FORMAT_CENTER);
        cell.setCellStyle(cellSty);
        for (Map<String, Object> column : columnModel) {
            cell = row.createCell(col + 1);
            value = data.get(column.get("name"));
            if (value instanceof Number) {
                if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
                    cell.setCellStyle(styles.get(INTEGER_FORMAT));
                    if (value instanceof Integer) {
                        cell.setCellValue((double)((Integer)value).intValue());
                    } else if (value instanceof Long) {
                        cell.setCellValue((double)((Long)value).longValue());
                    } else if (value instanceof BigInteger) {
                        cell.setCellValue((double)((BigInteger)value).intValue());
                    }
                } else if (value instanceof BigDecimal) {
                    BigDecimal decValue = (BigDecimal)value;
                    int scale = decValue.scale();
                    if (2 == scale) {
                        cell.setCellStyle(styles.get(DECIMAL_FORMAT));
                    } else {
                        StringBuffer preStr = new StringBuffer(scale == 0 ? INTEGER_FORMAT : "0.");
                        for (int j = 0; j < scale; ++j) {
                            preStr.append(INTEGER_FORMAT);
                        }
                        CellStyle cellStyleBigDec = null;
                        cellStyleBigDec = styles.get(preStr.toString());
                        if (null == cellStyleBigDec) {
                            cellStyleBigDec = workbook.createCellStyle();
                            cellStyleBigDec.setDataFormat(creationHelper.createDataFormat().getFormat(preStr.toString()));
                            styles.put(preStr.toString(), cellStyleBigDec);
                        }
                        cell.setCellStyle(cellStyleBigDec);
                        if (markStyle.get(col) == null || !markStyle.get(col).booleanValue()) {
                            markStyle.put(col, true);
                            sheet.setColumnWidth(col, 5000);
                        }
                    }
                    cell.setCellValue(decValue.doubleValue());
                } else {
                    cell.setCellStyle(styles.get(DECIMAL_FORMAT));
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }
            } else if (value instanceof Date || DataType.TIMESTAMP.equals(column.get("dataType"))) {
                CellStyle cellStyleDate = styles.get("yyyy-MM-dd");
                if (DataType.TIMESTAMP.equals(column.get("dataType")) || value instanceof Timestamp) {
                    cellStyleDate = styles.get("yyyy-MM-dd HH:mm:ss");
                }
                if (markStyle.get(col) == null || !markStyle.get(col).booleanValue()) {
                    markStyle.put(col, true);
                    sheet.setColumnWidth(col, 6000);
                }
                cell.setCellStyle(cellStyleDate);
                if (value instanceof String) {
                    try {
                        cell.setCellValue(DateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd"));
                    }
                    catch (ParseException e) {
                        cell.setCellValue((String)value);
                    }
                } else if (null != value) {
                    cell.setCellValue((Date)value);
                }
            } else if (null != value) {
                CellStyle cellStyleStr = styles.get(STR_STYLE);
                cell.setCellStyle(cellStyleStr);
                cell.setCellValue(this.formatObject(value, column));
            }
            ++col;
        }
    }

    public String writeExcelToFileAndCompress(Map<String, Object> excelConfig) {
        String sourceDir = (String)excelConfig.get("pathDir");
        String targetDir = sourceDir.substring(0, sourceDir.lastIndexOf("/"));
        String title = (String)excelConfig.get("title");
        try {
            FileOperateUtil.compress(sourceDir, targetDir, title, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.assembleDownloadUrl(title + ".zip", title + ".zip", excelConfig);
    }

    public String writeExcelToFile(HttpServletRequest request, Map<String, Object> excelConfig) throws SHRWebException {
        return this.writeExcelToFile(request, excelConfig, true);
    }

    public String writeExcelToFile(HttpServletRequest request, Map<String, Object> excelConfig, boolean isPwd) throws SHRWebException {
        SXSSFWorkbook workbook = (SXSSFWorkbook)excelConfig.get("workbook");
        if (workbook == null) {
            return null;
        }
        Context ctx = SHRContext.getInstance().getContext();
        File dir = new File(this.generateFileDir(request.getSession(), excelConfig, false));
        String title = (String)excelConfig.get("title");
        String fileName = WebUtil.generateExcelXlsxFileNameWithTimestamp(title);
        String realFileName = MD5.md5Hash(fileName);
        File file = new File(dir, UserUtil.getEncryRealFileName(ctx, realFileName));
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream workbookInput = null;
        POIFSFileSystem fs = null;
        OPCPackage opc = null;
        OutputStream os = null;
        FileOutputStream fileOut = null;
        String uipk = UIViewUtil.getUipk((ServletRequest)request);
        String assembleDownloadUrl = "";
        try {
            String exportPrivteProtected = request.getParameter("exportPrivteProtected");
            if (ShrSensitiveServiceUtil.isExportInProtected(ctx, request) && isPwd && !UIPK_WHITE_LIST_IGNORE_PASSWORD.contains(uipk)) {
                if (StringUtils.isEmpty((String)exportPrivteProtected)) {
                    throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"exportPrivteProtected", (Context)ctx));
                }
                baos = new ByteArrayOutputStream();
                workbook.write((OutputStream)baos);
                workbook.close();
                workbookInput = new ByteArrayInputStream(baos.toByteArray());
                fs = new POIFSFileSystem();
                EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
                Encryptor enc = info.getEncryptor();
                enc.confirmPassword(exportPrivteProtected);
                opc = OPCPackage.open((InputStream)workbookInput);
                os = enc.getDataStream(fs);
                opc.save(os);
                os.close();
                fileOut = new FileOutputStream(file);
                fs.writeFilesystem((OutputStream)fileOut);
                fileOut.close();
                fs.close();
            } else {
                fileOut = new FileOutputStream(file);
                workbook.write((OutputStream)fileOut);
                fileOut.flush();
            }
            assembleDownloadUrl = this.assembleDownloadUrl(realFileName, fileName, excelConfig);
            if (!StringUtils.isEmpty((String)assembleDownloadUrl) && "true".equals(request.getAttribute("asyn"))) {
                String asynExportUrl = request.getContextPath() + assembleDownloadUrl;
                request.setAttribute("asynExportUrl", (Object)asynExportUrl);
            }
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (InvalidFormatException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            try {
                if (null != workbookInput) {
                    workbookInput.close();
                }
                if (null != baos) {
                    baos.close();
                }
                if (null != opc) {
                    opc.close();
                }
                if (null != workbook) {
                    workbook.close();
                }
                if (null != fileOut) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return assembleDownloadUrl;
    }

    public String saveExcelToFile(HttpSession session, Map<String, Object> excelConfig) throws SHRWebException {
        SXSSFWorkbook workbook = (SXSSFWorkbook)excelConfig.get("workbook");
        if (workbook == null) {
            return null;
        }
        String userTempDirAbsolutePath = this.generateFileDir(session, excelConfig, true);
        File dir = new File(userTempDirAbsolutePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String title = (String)excelConfig.get("title");
        String fileName = WebUtil.generateExcelXlsxFileNameWithTimestamp(title);
        File file = new File(dir, SHRCheck.checkFilePath((String)fileName));
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write((OutputStream)fileOut);
            workbook.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        excelConfig.put("workbook", null);
        return userTempDirAbsolutePath;
    }

    private int fillHeader(Sheet wsheet, List<Map<String, Object>> columnModel, String groupHeaders) {
        Map<String, Object> column;
        HashMap<Object, Integer> columnIndex = new HashMap<Object, Integer>();
        HashMap<Integer, Object> columnName = new HashMap<Integer, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        int nCol = 0;
        int headerRows = 1;
        Workbook wb = wsheet.getWorkbook();
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        Font font = wsheet.getWorkbook().createFont();
        font.setColor(IndexedColors.BLACK.index);
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        String config = " ";
        try {
            SystemConfigSolutionInfo configInfo = SystemSHRCache.getSystemConfigSolutionInfo((Context)ctx);
            if (null != configInfo && !StringUtils.isEmpty((String)configInfo.getConfig())) {
                config = configInfo.getConfig();
            }
        }
        catch (BOSException e) {
            try {
                throw new SHRWebException(e.getMessage(), e);
            }
            catch (SHRWebException sHRWebException) {
            }
        }
        catch (EASBizException e) {
            try {
                throw new SHRWebException(e.getMessage(), e);
            }
            catch (SHRWebException sHRWebException) {
                // empty catch block
            }
        }
        Map configMap = (Map)JSON.parse((String)config);
        String isRemoveTitle = (String)configMap.get("isRemoveTitle");
        if (groupHeaders != null && groupHeaders.length() > 0) {
            column = null;
            for (int i = 0; i < columnModel.size(); ++i) {
                column = columnModel.get(i);
                columnIndex.put(column.get("name"), i);
                columnName.put(i, column.get("alias"));
                ++nCol;
            }
            Gson gson = JSONUtils.getGson(ctx);
            Object[] header = (Object[])gson.fromJson(groupHeaders, Object[].class);
            ArrayList headers = (ArrayList)header[0];
            ArrayList index = new ArrayList();
            Row firstRow = wsheet.createRow(1);
            Row secondRow = wsheet.createRow(2);
            CellRangeAddress region = null;
            Cell cell = null;
            for (int i = 0; i < headers.size(); ++i) {
                Map columnInfo = (Map)headers.get(i);
                int numberOfColumns = (int)Double.parseDouble(columnInfo.get("numberOfColumns").toString());
                Object b = columnIndex.get(columnInfo.get("startColumnName"));
                if (null == b || StringUtils.isEmpty((String)String.valueOf(b))) continue;
                int startColumnIndex = Integer.parseInt(b.toString());
                String titleText = (String)columnInfo.get("titleText");
                if (StringUtils.isEmpty((String)titleText)) {
                    titleText = "";
                }
                firstRow.createCell(startColumnIndex + 1).setCellValue(titleText);
                region = new CellRangeAddress(1, 1, startColumnIndex + 1, startColumnIndex + numberOfColumns);
                wsheet.addMergedRegion(region);
                firstRow.getCell(startColumnIndex + 1).setCellStyle(cellStyle);
                if (i == 0) {
                    cell = firstRow.createCell(0);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "export_index_name"));
                    region = new CellRangeAddress(1, 2, 0, 0);
                    wsheet.addMergedRegion(region);
                    for (int j = 0; j < startColumnIndex; ++j) {
                        cell = firstRow.createCell(j + 1);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(columnName.get(j).toString());
                        region = new CellRangeAddress(1, 2, j + 1, j + 1);
                        wsheet.addMergedRegion(region);
                    }
                } else {
                    int indexlength;
                    Map prevColumnInfo = (Map)headers.get(i - 1);
                    int prevstartColumnIndex = Integer.parseInt(columnIndex.get(prevColumnInfo.get("startColumnName")).toString());
                    if (startColumnIndex - prevstartColumnIndex > (indexlength = (int)Double.parseDouble(prevColumnInfo.get("numberOfColumns").toString()))) {
                        for (int j = prevstartColumnIndex + indexlength; j < startColumnIndex; ++j) {
                            cell = firstRow.createCell(j + 1);
                            cell.setCellStyle(cellStyle);
                            cell.setCellValue(columnName.get(j).toString());
                            region = new CellRangeAddress(1, 2, j + 1, j + 1);
                            wsheet.addMergedRegion(region);
                        }
                    }
                }
                for (int k = startColumnIndex; k < startColumnIndex + numberOfColumns; ++k) {
                    cell = secondRow.createCell(k + 1);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(columnName.get(k).toString());
                }
            }
            headerRows = 2;
        } else {
            column = null;
            Row row = null;
            if (!StringUtils.isEmpty((String)isRemoveTitle) && Boolean.parseBoolean(isRemoveTitle)) {
                row = wsheet.createRow(0);
                headerRows = 0;
            } else {
                row = wsheet.createRow(1);
                headerRows = 1;
            }
            Cell ce = row.createCell(0);
            ce.setCellStyle(cellStyle);
            ce.setCellValue(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "export_index_name"));
            Cell cell = null;
            for (int i = 0; i < columnModel.size(); ++i) {
                column = columnModel.get(i);
                cell = row.createCell(nCol + 1);
                cell.setCellStyle(cellStyle);
                String alias = (String)column.get("alias");
                if (FileVaildUtils.isVaildCSVXSSF((String)alias)) {
                    logger.warn((Object)("csv injection character :" + alias));
                    alias = "";
                }
                cell.setCellValue(alias);
                ++nCol;
            }
        }
        if (StringUtils.isEmpty((String)isRemoveTitle) || Boolean.parseBoolean(isRemoveTitle)) {
            // empty if block
        }
        String lastCol = CellReference.convertNumToColString((int)nCol);
        String cellBegin = "A" + (headerRows + 1);
        String cellEnd = lastCol + (headerRows + 1);
        CellRangeAddress cFilter = CellRangeAddress.valueOf((String)(cellBegin + ":" + cellEnd));
        wsheet.setAutoFilter(cFilter);
        return headerRows;
    }

    private void fillTitle(Sheet sheet, String title) {
        Workbook wb = sheet.getWorkbook();
        Font font = wb.createFont();
        font.setFontName("arial");
        font.setFontHeightInPoints((short)16);
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFont(font);
        DataFormat format = wb.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        Row row = sheet.createRow(0);
        Cell cell = row.createCell(0);
        cell.setCellValue(title);
        cell.setCellStyle(cellStyle);
    }

    private List<Map<String, Object>> assembleColumnModel(Context ctx, String queryModel, UIViewInfo uiViewInfo) throws SHRWebException {
        if (StringUtils.isEmpty((String)queryModel)) {
            return null;
        }
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> map = null;
            HashSet<String> fieldSet = new HashSet<String>();
            String[] queryMode = queryModel.split(";");
            String[] properties = null;
            String columnName = null;
            FieldInfo fieldInfo = null;
            boolean isHidden = false;
            Map attributes = null;
            DataType dataType = null;
            PropertyInfo propertyInfo = null;
            QueryConfigFieldInfo qcf = null;
            QueryConfigCollection qcc = null;
            HashMap extendOptions = null;
            Map datetimeOptions = null;
            Map numberOptions = null;
            if ("dynamicList".equals(uiViewInfo.getType())) {
                qcc = StructureConfigConvertHelper.getQueryConfigCollection((Context)ctx, (String)uiViewInfo.getModel());
            }
            for (int i = 0; i < queryMode.length; ++i) {
                properties = queryMode[i].split(",");
                isHidden = Boolean.valueOf(properties[1]);
                attributes = null;
                propertyInfo = null;
                qcf = null;
                dataType = null;
                if (isHidden || fieldSet.contains(columnName = properties[0])) continue;
                fieldSet.add(columnName);
                extendOptions = null;
                datetimeOptions = null;
                numberOptions = null;
                map = new HashMap<String, Object>();
                map.put("name", columnName);
                map.put("hidden", Boolean.valueOf(properties[1]));
                if (properties.length >= 3) {
                    map.put("alias", properties[2]);
                } else {
                    map.put("alias", "");
                }
                if ("dynamicList".equals(uiViewInfo.getType())) {
                    qcf = StructureConfigConvertHelper.getQueryConfigFieldInfo((QueryConfigCollection)qcc, (String)columnName);
                    if (null != qcf) {
                        dataType = DataType.getEnum((String)qcf.getFactField().getDataType());
                        attributes = Collections.EMPTY_MAP;
                        if (!StringUtils.isEmpty((String)qcf.getFactField().getExtendOptions())) {
                            extendOptions = JSONUtils.convertJsonToObject(ctx, qcf.getFactField().getExtendOptions());
                        }
                        map.put("attributes", attributes);
                        map.put("dataType", dataType);
                        if (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                            datetimeOptions = null != extendOptions && null != extendOptions.get("datetimeOptions") ? (Map)extendOptions.get("datetimeOptions") : new HashMap();
                            propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)qcf.getFactField().getStructureConfig().getEntityName(), (String)qcf.getFactField().getNumber());
                            UserNantionalUtil.setDateExtendOptions((Context)ctx, datetimeOptions, (boolean)true, (Map)attributes, (DataType)dataType, (PropertyInfo)propertyInfo);
                            map.put("extendOption", datetimeOptions);
                        }
                        if (dataType != null && ("BigDecimal".equalsIgnoreCase(dataType.toString()) || DataType.DECIMAL.equals((Object)dataType) || DataType.DOUBLE.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType))) {
                            numberOptions = null != extendOptions && null != extendOptions.get("numberOptions") ? (Map)extendOptions.get("numberOptions") : new HashMap();
                            map.put("extendNumberOption", numberOptions);
                        }
                    }
                } else {
                    fieldInfo = uiViewInfo.getField(columnName);
                    attributes = null != fieldInfo ? fieldInfo.getAttributes() : Collections.EMPTY_MAP;
                    if (fieldInfo != null) {
                        if (null != fieldInfo.getAttributes() && !StringUtils.isEmpty((String)fieldInfo.getAttributes().get("dataType"))) {
                            String dataTp = fieldInfo.getAttributes().get("dataType");
                            String upDataTp = dataTp.toUpperCase();
                            String substring = upDataTp.substring(0, 1);
                            dataTp = substring + dataTp.substring(1);
                            dataType = DataType.getEnum((String)dataTp);
                        } else {
                            dataType = fieldInfo.getDataType();
                        }
                        map.put("dataType", dataType);
                    }
                    if (fieldInfo != null && (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType))) {
                        datetimeOptions = new HashMap();
                        UserNantionalUtil.setDateExtendOptions((Context)ctx, datetimeOptions, (boolean)false, (Map)attributes, (DataType)dataType, (PropertyInfo)fieldInfo.getProperty());
                        map.put("extendOption", datetimeOptions);
                    }
                    if (dataType != null && ("BigDecimal".equalsIgnoreCase(dataType.toString()) || DataType.DECIMAL.equals((Object)dataType) || DataType.DOUBLE.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) && attributes.get("decimalPrecision") == null) {
                        String decimalPrecision = UIViewUtil.getDecimalPrecisionAttrValue(ctx, null, uiViewInfo);
                        attributes.put("decimalPrecision", decimalPrecision);
                    }
                    map.put("attributes", attributes);
                }
                list.add(map);
            }
            return list;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
    }

    private String formatObject(Object object, Map<String, Object> columnOption) {
        if (object == null) {
            return null;
        }
        if (FileVaildUtils.isVaildCSVXSSF((String)object.toString())) {
            logger.warn((Object)("csv injection character :" + object));
            return "";
        }
        String str = null;
        if (object instanceof BigDecimal) {
            BigDecimal number = ((BigDecimal)object).setScale(2, 4);
            str = number.toPlainString();
        } else if (object instanceof Date) {
            String format = null;
            format = DataType.TIMESTAMP.equals(columnOption.get("dataType")) || object instanceof Timestamp ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            str = DateTimeUtils.format((Date)((Date)object), (String)format);
        } else if (object instanceof Boolean) {
            Context ctx = SHRContext.getInstance().getContext();
            str = Boolean.TRUE.equals(object) ? EASCommonResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"yes", (Locale)ctx.getLocale()) : EASCommonResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"no", (Locale)ctx.getLocale());
        } else {
            str = object.toString();
            if (!StringUtils.isEmpty((String)str) && str.length() >= Short.MAX_VALUE) {
                str = str.substring(0, 32766);
                logger.error((Object)"excel cell value too long ");
            }
        }
        return str;
    }

    private String generateFileDir(HttpSession session, Map<String, Object> excelConfig, boolean isMult) {
        String fileDir = null;
        if (this.isAsyn) {
            fileDir = session.getServletContext().getRealPath("/") + FILE_DIR;
        } else {
            fileDir = UserUtil.getUserTempDirAbsolutePath(session);
            if (isMult) {
                fileDir = fileDir + File.separator + "exportExcel_" + session.getId();
            }
        }
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return fileDir;
    }

    protected String assembleDownloadUrl(String realFileName, String fileName, Map<String, Object> excelConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.isAsyn) {
            try {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                String serverName = System.getProperty("cas.client.serverName");
                if (!StringUtils.isEmpty((String)serverName)) {
                    String strPort = serverName.substring(serverName.indexOf(":"));
                    ipAddress = ipAddress + strPort;
                }
                String ipKey = AESUtil.aesEncrypt(ipAddress, AESUtils.getUrlParamEncryptKey());
                params.put("ipkey", ipKey);
            }
            catch (UnknownHostException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            params.put("method", "export");
        } else {
            params.put("method", "tmp");
        }
        params.put("file", realFileName);
        params.put("filename", fileName);
        excelConfig.put("workbook", null);
        return DynamicUtil.assembleUrl("/downloadfile.do", params).replaceAll("\\+", "%20");
    }

    public static String getEncryRealFileName(String realFileName) {
        return UserUtil.getEncryRealFileName(SHRContext.getInstance().getContext(), realFileName);
    }

    static {
        UIPK_WHITE_LIST_IGNORE_PASSWORD.add("com.kingdee.eas.bs.ml.app.EASResource.list");
        UIPK_WHITE_LIST_IGNORE_PASSWORD.add("com.kingdee.eas.bs.ml.app.UIResource.list");
    }
}

