/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.CoreUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ListUIViewDefaultAdvancedFilterTagHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ListUIViewDefaultGridToolBarTagHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import org.jdom2.Document;

public class ListUIViewConfigDefaultTagHelper {
    private static final String LIST_TAG_NAME = "list";
    private static final String GRID_TAG_NAME = "grid";
    private static final String DYNAMICGRID_TAG_NAME = "dynamicGrid";
    private static final String EDITGRID_TAG_NAME = "editGrid";

    public static String addDefaultTagElement(CoreUIViewInfo uiViewInfo, String newContent) {
        String uiType = uiViewInfo.getType();
        boolean isDynamicList = "dynamicList".equalsIgnoreCase(uiType);
        boolean isEditGrid = ListUIViewConfigDefaultTagHelper.isEditGrid(uiType, uiViewInfo);
        if (LIST_TAG_NAME.equalsIgnoreCase(uiType) || isDynamicList) {
            String warpNewContent = ListUIViewConfigDefaultTagHelper.addAdvanceFilterElement(uiViewInfo, newContent);
            if (!ListUIViewConfigDefaultTagHelper.validateXml(warpNewContent = ListUIViewConfigDefaultTagHelper.addGridToolBarElement(uiViewInfo, warpNewContent))) {
                return newContent;
            }
            return warpNewContent;
        }
        if (isEditGrid) {
            String warpNewContent = ListUIViewConfigDefaultTagHelper.addGridToolBarElement(uiViewInfo, newContent);
            if (!ListUIViewConfigDefaultTagHelper.validateXml(warpNewContent)) {
                return newContent;
            }
            return warpNewContent;
        }
        return newContent;
    }

    private static boolean isEditGrid(String uiType, CoreUIViewInfo uiViewInfo) {
        if (uiType.equals("form")) {
            String content = uiViewInfo.getContent();
            Document document = ListUIViewConfigDefaultTagHelper.getXmlDocument(content);
            return ListUIViewConfigDefaultTagHelper.isEditGridTag(document);
        }
        return false;
    }

    private static String addAdvanceFilterElement(CoreUIViewInfo uiViewInfo, String newContent) {
        Document document = ListUIViewConfigDefaultTagHelper.getXmlDocument(newContent);
        String targetElementName = ListUIViewConfigDefaultTagHelper.findTargetElementName(document);
        if (StringUtils.isEmpty((String)targetElementName)) {
            return newContent;
        }
        String warpNewContent = ListUIViewDefaultAdvancedFilterTagHelper.addAdvanceFilterElement(document, targetElementName, newContent);
        if (StringUtils.isEmpty((String)warpNewContent)) {
            return newContent;
        }
        return warpNewContent;
    }

    private static String addGridToolBarElement(CoreUIViewInfo uiViewInfo, String newContent) {
        Document document = ListUIViewConfigDefaultTagHelper.getXmlDocument(newContent);
        String targetElementName = ListUIViewConfigDefaultTagHelper.findTargetElementName(document);
        if (StringUtils.isEmpty((String)targetElementName)) {
            return newContent;
        }
        boolean isEditGrid = ListUIViewConfigDefaultTagHelper.isEditGrid(uiViewInfo.getType(), uiViewInfo);
        String warpContent = ListUIViewDefaultGridToolBarTagHelper.addGridToolBarTagElement(document, targetElementName, newContent, isEditGrid);
        boolean visible = true;
        if ("dynamicList".equals(uiViewInfo.getType())) {
            warpContent = warpContent.replace("<selectAllPanel", "<ctrl.selectAllPanel colspan =\"3\" visible=\"" + visible + "\" ");
            warpContent = warpContent.replace("<searchPanel", "\t<ctrl.dynamicListSetting uipk=\"${viewMeta.uipk!}\" colspan =\"5\" ");
        } else {
            warpContent = warpContent.replace("<selectAllPanel", "<ctrl.selectAllPanel  visible=\"" + visible + "\" ");
            warpContent = warpContent.replace("<searchPanel", "\t<ctrl.searchPanel uipk=\"${viewMeta.uipk!}\" ");
            warpContent = warpContent.replace("<searchInFront", "\t<ctrl.searchInFront uipk=\"${viewMeta.uipk!}\" ");
        }
        warpContent = warpContent.replace("<pagingPanel", "<ctrl.pagingPanel");
        return warpContent;
    }

    public static Document getXmlDocument(String newContent) {
        Document document = null;
        try {
            document = XMLUtil.parseXML((String)newContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static String findTargetElementName(Document document) {
        String targetElementName = "";
        if (ListUIViewConfigDefaultTagHelper.isListTag(document)) {
            targetElementName = LIST_TAG_NAME;
        } else if (ListUIViewConfigDefaultTagHelper.isGridTag(document)) {
            targetElementName = GRID_TAG_NAME;
        }
        if (ListUIViewConfigDefaultTagHelper.isDynamicGridTag(document)) {
            targetElementName = DYNAMICGRID_TAG_NAME;
        }
        if (ListUIViewConfigDefaultTagHelper.isEditGridTag(document)) {
            targetElementName = EDITGRID_TAG_NAME;
        }
        return targetElementName;
    }

    private static boolean isListTag(Document document) {
        String searchPattern = "//list";
        return UIViewUtil.findElement(document, searchPattern);
    }

    private static boolean isGridTag(Document document) {
        String searchPattern = "//grid";
        return UIViewUtil.findElement(document, searchPattern);
    }

    private static boolean isDynamicGridTag(Document document) {
        String searchPattern = "//dynamicGrid";
        return UIViewUtil.findElement(document, searchPattern);
    }

    private static boolean isEditGridTag(Document document) {
        String searchPattern = "//editGrid";
        return UIViewUtil.findElement(document, searchPattern);
    }

    public static boolean isMultiselectGrid(Document document) {
        boolean isMultiselectGrid = true;
        String searchPattern = "//grid [@multiselect='false']";
        if (ListUIViewConfigDefaultTagHelper.isListTag(document)) {
            searchPattern = "//list [@multiselect='false']";
        }
        isMultiselectGrid = !UIViewUtil.findElement(document, searchPattern);
        return isMultiselectGrid;
    }

    private static boolean validateXml(String warpNewContent) {
        boolean flag = true;
        try {
            XMLUtil.parseXML((String)warpNewContent);
        }
        catch (BOSException e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }
}

