/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipUtils {
    private static final Logger logger = Logger.getLogger(ZipUtils.class);
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String[] srcDir, String outDir, boolean KeepDirStructure) throws SHRWebException {
        ZipOutputStream zos = null;
        FileOutputStream out = null;
        try {
            long start = System.currentTimeMillis();
            out = new FileOutputStream(new File(outDir));
            zos = new ZipOutputStream(out);
            ArrayList<File> sourceFileList = new ArrayList<File>();
            for (String dir : srcDir) {
                File sourceFile = new File(dir);
                sourceFileList.add(sourceFile);
            }
            ZipUtils.compress(sourceFileList, zos, KeepDirStructure);
            long end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compress cost:" + (end - start) + " ms"));
            }
        }
        catch (IOException e) {
            throw new SHRWebException(e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws IOException {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + File.separator));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        ZipUtils.compress(file, zos, name + File.separator + file.getName(), KeepDirStructure);
                        continue;
                    }
                    ZipUtils.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }

    private static void compress(List<File> sourceFileList, ZipOutputStream zos, boolean KeepDirStructure) throws IOException {
        byte[] buf = new byte[2048];
        for (File sourceFile : sourceFileList) {
            String name = sourceFile.getName();
            if (sourceFile.isFile()) {
                int len;
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
                continue;
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (!KeepDirStructure) continue;
                zos.putNextEntry(new ZipEntry(name + File.separator));
                zos.closeEntry();
                continue;
            }
            for (File file : listFiles) {
                if (KeepDirStructure) {
                    ZipUtils.compress(file, zos, name + File.separator + file.getName(), KeepDirStructure);
                    continue;
                }
                ZipUtils.compress(file, zos, file.getName(), KeepDirStructure);
            }
        }
    }
}

