/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.view.converter;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.CoreUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.CoreUIViewConverter;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IFragmentUIViewConverter;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;

public class FragmentUIViewConverter
extends CoreUIViewConverter
implements IFragmentUIViewConverter {
    private UIViewInfo baseUIViewInfo;
    private String subType = null;

    public FragmentUIViewConverter(UIViewInfo baseUIViewInfo, Context ctx) {
        super(ctx);
        this.baseUIViewInfo = baseUIViewInfo;
    }

    @Override
    protected UIViewInfo createUIViewInfo() throws SHRWebException {
        CoreUIViewInfo uiViewInfo = (CoreUIViewInfo)this.baseUIViewInfo.clone();
        uiViewInfo.setContent(this.getUIViewInfoFragment(uiViewInfo.getContent(), this.subType));
        uiViewInfo.setFragment(true);
        uiViewInfo.setUipk(UIViewUtil.assembleFragmentKey(uiViewInfo.getUipk(), this.subType));
        return uiViewInfo;
    }

    private String getUIViewInfoFragment(String content, String subType) throws SHRWebException {
        String newContent = null;
        Document doc = XMLUtil.parseXML(content);
        Element root = doc.getRootElement();
        Element entrys = this.getElement(root, subType);
        if (entrys != null) {
            doc.detachRootElement();
            entrys.detach();
            entrys.setName("form");
            doc.setRootElement(entrys);
            newContent = XMLUtil.getXMLOutputter().outputString(doc);
        } else {
            newContent = content;
        }
        return newContent;
    }

    @Override
    protected void assembleViewInfo(Element root, CoreUIViewInfo viewInfo) throws SHRWebException {
        Map properties = MetaDataUtil.getProperties((Context)this.ctx, (String)viewInfo.getEntityName());
        viewInfo.setFields(this.getFields(root, viewInfo, properties));
    }

    @Override
    protected Element assembleHeaderElement(Element mainElement, CoreUIViewInfo viewInfo) throws SHRWebException {
        if (!"fragment".equals(this.subType) && !"entrys".equalsIgnoreCase(this.subType)) {
            return super.assembleHeaderElement(mainElement, viewInfo);
        }
        Element element = this.getElement(mainElement, "header");
        if (element != null) {
            element.detach();
        }
        return null;
    }

    @Override
    protected void convertViewInfo(UIViewInfo viewInfo) throws SHRWebException {
        if ("page".equals(this.subType)) {
            return;
        }
        super.convertViewInfo(viewInfo);
    }

    public String getSubType() {
        return this.subType;
    }

    @Override
    public void setSubType(String subType) {
        this.subType = subType;
    }
}

