/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AppScanAttackFilter
implements Filter {
    private static Logger logger = Logger.getLogger(AppScanAttackFilter.class);
    private boolean enableAppScanAttackFilter = false;
    private static final String[] LDAP_MATCHER_WORDS = new String[]{"))(&(name=", "))(|(name=*", "))(&(objectclass=", "))(|(objectclass=*"};
    private static final String SSRF_ANDS_MATCHER_WORDS = "securityip.appsechcl.com";
    private static final String DUOBLE_POINT = "..";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession httpSession = req.getSession();
        String sid = "";
        if (null != httpSession) {
            sid = httpSession.getId();
        }
        if ("https".equalsIgnoreCase(request.getScheme())) {
            Cookie[] cookies = req.getCookies();
            for (Cookie cookie : cookies) {
                cookie.setSecure(true);
            }
        }
        if (this.enableAppScanAttackFilter) {
            Map params = request.getParameterMap();
            for (String key : params.keySet()) {
                String value = request.getParameter(key);
                if (StringUtils.isEmpty((String)value) || !this.checkLdapKeyWord(key, value) && !this.checkAndsSSRFKeyWord(key, value) && !this.checkSessionId(sid)) continue;
                ((HttpServletResponse)response).sendError(403);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    private boolean checkLdapKeyWord(String key, String value) {
        boolean flag = false;
        for (String matcherWord : LDAP_MATCHER_WORDS) {
            if (value.indexOf(matcherWord) <= -1) continue;
            flag = true;
            logger.error((Object)SHRCheck.vaildLog((String)MessageFormat.format("AppScanAttackFilter  request , key is [{0}] , ldapMatcherWord is [{2}] ", key, matcherWord)));
        }
        return flag;
    }

    private boolean checkAndsSSRFKeyWord(String key, String value) {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)value) && value.indexOf(SSRF_ANDS_MATCHER_WORDS) > -1) {
            flag = true;
            logger.error((Object)SHRCheck.vaildLog((String)MessageFormat.format("AppScanAttackFilter  request , key is [{0}] , ldapMatcherWord is [{2}] ", key, value)));
        }
        return flag;
    }

    private boolean checkSessionId(String value) {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)value) && value.indexOf(DUOBLE_POINT) > -1) {
            flag = true;
            logger.error((Object)SHRCheck.vaildLog((String)MessageFormat.format("AppScanAttackFilter  request , key is [{0}] , MatcherWord is [{2}] ", "err sid: ", value)));
        }
        return flag;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initEnableAppScanAttackFilterValue(filterConfig);
    }

    private void initEnableAppScanAttackFilterValue(FilterConfig filterConfig) {
        String initParameter = filterConfig.getInitParameter("enableAppScanAttackFilter");
        if (!StringUtils.isEmpty((String)initParameter)) {
            try {
                this.enableAppScanAttackFilter = Boolean.valueOf(initParameter);
            }
            catch (Exception e) {
                logger.info((Object)"AppScanAttackFilter getInitParameter enableAppScanAttackFilter  error");
            }
        }
    }

    public void destroy() {
    }
}

