/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DisableUrlSessionFilter
implements Filter {
    private static Logger logger = Logger.getLogger(DisableUrlSessionFilter.class);
    private String excludePattern = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.excludePattern = filterConfig.getInitParameter("excludePattern");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.isRequestedSessionIdFromURL() && !this.isExclude(httpRequest) && (session = httpRequest.getSession()) != null) {
            session.invalidate();
            logger.error((Object)"DisableUrlSessionFilter -->> session.invalidate()");
        }
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(httpResponse){

            public String encodeRedirectUrl(String url) {
                return url;
            }

            public String encodeRedirectURL(String url) {
                return url;
            }

            public String encodeUrl(String url) {
                return url;
            }

            public String encodeURL(String url) {
                return url;
            }
        };
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)wrappedResponse);
    }

    private boolean isExclude(HttpServletRequest httpRequest) {
        String[] items;
        if (StringUtils.isEmpty((String)this.excludePattern)) {
            return false;
        }
        Matcher matcher = null;
        String queryString = httpRequest.getRequestURI() + "?" + httpRequest.getQueryString();
        for (String item : items = this.excludePattern.split(",")) {
            matcher = Pattern.compile(item).matcher(queryString);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

