/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.FastFilterUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BizListHandler
extends ListHandler {
    @Override
    protected FilterInfo getBusinessFastFilter(HttpServletRequest request) throws SHRWebException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        if (StringUtils.isEmpty((String)fastFilterItems) && StringUtils.isEmpty((String)(fastFilterItems = (String)request.getAttribute("fastFilterItems")))) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        Map<String, FilterInfo> fiterMap = this.getBusinessFastFilterExt(request, filter);
        return filter;
    }

    protected Map<String, FilterInfo> getBusinessFastFilterExt(HttpServletRequest request, FilterInfo filter) throws SHRWebException {
        if (null == filter) {
            return null;
        }
        String fastFilterItems = request.getParameter("fastFilterItems");
        if (StringUtils.isEmpty((String)fastFilterItems) && StringUtils.isEmpty((String)(fastFilterItems = (String)request.getAttribute("fastFilterItems")))) {
            return null;
        }
        HashMap<String, FilterInfo> fiterMap = new HashMap<String, FilterInfo>();
        HashMap map = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), fastFilterItems);
        for (Object key : map.keySet()) {
            String stringValues;
            if (null == map.get(key) || !(map.get(key) instanceof Map) || "adminOrgRange".equals(key.toString())) continue;
            Map filterItemMap = (Map)map.get(key);
            String property = String.valueOf(key);
            String dataType = String.valueOf(filterItemMap.get("dataType"));
            String uipk = String.valueOf(filterItemMap.get("uipk"));
            String enumSource = String.valueOf(filterItemMap.get("enumSource"));
            String url = String.valueOf(filterItemMap.get("url"));
            FilterInfo _filter_ = new FilterInfo();
            if ("F7".equals(dataType)) {
                stringValues = String.valueOf(filterItemMap.get("values"));
                if ((key.equals("adminOrgUnit") || key.equals("adminOrg")) && filterItemMap.get("includeSub") != null) {
                    boolean isIncludeSub = (Boolean)filterItemMap.get("isIncludeSub");
                    if (!isIncludeSub) {
                        String orgIds = FastFilterUtil.getOrgIdStr(filterItemMap);
                        if (!StringUtils.isEmpty((String)orgIds)) {
                            _filter_.getFilterItems().add(new FilterItemInfo(key + ".id", (Object)orgIds, CompareType.INNER));
                        }
                    } else {
                        String orgIncludeSubSQL = FastFilterUtil.getOrgIncludeSubSQL(filterItemMap);
                        if (!StringUtils.isEmpty((String)orgIncludeSubSQL)) {
                            _filter_.getFilterItems().add(new FilterItemInfo(key + ".id", (Object)orgIncludeSubSQL, CompareType.INNER));
                        }
                    }
                } else {
                    this.fastFilterF7Convert(request, _filter_, filterItemMap, property, stringValues);
                }
            } else if ("String".equals(dataType)) {
                stringValues = String.valueOf(filterItemMap.get("values"));
                this.fastFilterStringConvert(request, _filter_, filterItemMap, property, stringValues);
            } else if ("Date".equals(dataType) || "dateTime".equalsIgnoreCase(dataType)) {
                this.fastFilterDateOrDateTimeConvert(request, _filter_, filterItemMap, property);
            } else if ("Enum".equals(dataType)) {
                this.fastFilterEnumConvert(request, _filter_, filterItemMap, property, enumSource);
            }
            try {
                filter.mergeFilter(_filter_, "AND");
            }
            catch (BOSException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
            fiterMap.put(property, _filter_);
        }
        return fiterMap;
    }

    protected void fastFilterF7Convert(HttpServletRequest request, FilterInfo filter, Map filterItemMap, String property, String stringValues) {
        if (!StringUtils.isEmpty((String)stringValues)) {
            if (property.indexOf(".") <= 0) {
                property = property + ".id";
            }
            if (stringValues.indexOf(",") <= 0) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)stringValues, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(property, FastFilterUtil.generateSet(stringValues.split(",")), CompareType.INCLUDE));
            }
        }
    }

    protected void fastFilterStringConvert(HttpServletRequest request, FilterInfo filter, Map filterItemMap, String property, String stringValues) {
        if ("adminOrgRange".equals(property)) {
            return;
        }
        if (!StringUtils.isEmpty((String)stringValues)) {
            if (property.indexOf(".") <= 0) {
                property = property + ".id";
            }
            if (stringValues.indexOf(",") <= 0) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)stringValues, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(property, FastFilterUtil.generateSet(stringValues.split(",")), CompareType.INCLUDE));
            }
        }
    }

    protected void fastFilterDateOrDateTimeConvert(HttpServletRequest request, FilterInfo filter, Map filterItemMap, String property) throws SHRWebException {
        if (null != filterItemMap.get("values")) {
            if (String.class.equals(filterItemMap.get("values").getClass()) && StringUtils.isEmpty((String)((String)filterItemMap.get("values")))) {
                return;
            }
            Map mapValues = (Map)filterItemMap.get("values");
            String startDate = mapValues.get("startDate") == null ? null : String.valueOf(mapValues.get("startDate"));
            String endDate = mapValues.get("endDate") == null ? null : String.valueOf(mapValues.get("endDate"));
            String datePoint = mapValues.get("date") == null ? null : String.valueOf(mapValues.get("date"));
            String parten = FastFilterUtil.getParten();
            String dataType = String.valueOf(filterItemMap.get("dataType"));
            String queryDateType = String.valueOf(filterItemMap.get("queryDateType"));
            if ("datetime".equalsIgnoreCase(dataType) || "datetime".equalsIgnoreCase(queryDateType)) {
                parten = "yyyy-MM-dd HH:mm:ss";
            }
            if (!StringUtils.isEmpty((String)startDate) && !StringUtils.isEmpty((String)endDate)) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(startDate, parten), CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(endDate, parten), CompareType.LESS_EQUALS));
            } else if (!StringUtils.isEmpty((String)startDate) && StringUtils.isEmpty((String)endDate)) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(startDate, parten), CompareType.GREATER_EQUALS));
            } else if (StringUtils.isEmpty((String)startDate) && !StringUtils.isEmpty((String)endDate)) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(endDate, parten), CompareType.LESS_EQUALS));
            } else if (!StringUtils.isEmpty((String)datePoint)) {
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(datePoint, parten), CompareType.EQUALS));
            }
        }
    }

    protected void fastFilterEnumConvert(HttpServletRequest request, FilterInfo filter, Map filterItemMap, String property, String enumSource) throws SHRWebException {
        boolean isCustomDefine = (Boolean)filterItemMap.get("isCustomDefine");
        String type = String.valueOf(filterItemMap.get("enumOptionsType"));
        String stringValues = String.valueOf(filterItemMap.get("values"));
        if (!StringUtils.isEmpty((String)stringValues)) {
            try {
                if (isCustomDefine) {
                    if ("boolean".equals(type)) {
                        if (stringValues.split(",").length == 1) {
                            filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getBoolean(stringValues), CompareType.EQUALS));
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.generateEnumSet(stringValues.split(","), (String)null, type), CompareType.INCLUDE));
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.generateEnumSet(stringValues.split(","), enumSource, null), CompareType.INCLUDE));
                }
            }
            catch (Exception e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
    }
}

