/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.interceptor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.api.codingrule.ShrCodeRuleEntityMappingConfig;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRBasicItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class DynamicWebInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = Logger.getLogger(DynamicWebInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.initDynamicModel(request);
        HashMap initDataMap = new HashMap();
        request.setAttribute("view_initData", initDataMap);
        String debug = request.getParameter("debug");
        if (!StringUtils.isEmpty((String)debug)) {
            request.getSession().setAttribute("debug", (Object)debug);
        }
        return super.preHandle(request, response, handler);
    }

    private void initDynamicModel(HttpServletRequest request) throws SHRWebException {
        String modelJSON = request.getParameter("model");
        if (StringUtils.isEmpty((String)modelJSON)) {
            return;
        }
        UIViewInfo viewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        Object obj = null;
        Context ctx = SHRContext.getInstance().getContext();
        if (null != viewInfo && "dynamicForm".equals(viewInfo.getType())) {
            obj = JSONUtils.convertJsonToObject(ctx, modelJSON);
        } else if (null != viewInfo && !StringUtils.isEmpty((String)viewInfo.getEntityName())) {
            Class clazz = MetaDataUtil.getObjectValueClass(viewInfo.getEntityName());
            long start = System.currentTimeMillis();
            obj = JSONUtils.convertJsonToObject(ctx, modelJSON, clazz);
            long end = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" DynamicWebInterceptor ConvertJsonToObject Cost " + (end - start) + " ms"));
            }
            if ("form".equals(viewInfo.getType())) {
                this.intiCodingRule(obj, viewInfo, clazz);
            }
        } else {
            obj = JSONUtils.convertJsonToObject(ctx, modelJSON);
        }
        request.setAttribute("dynamic_model", obj);
    }

    private void intiCodingRule(Object obj, UIViewInfo viewInfo, Class<?> clazz) throws SHRWebException {
        CoreBaseInfo info = (CoreBaseInfo)obj;
        if (null != info.getId()) {
            return;
        }
        String realEntityName = viewInfo.getEntityName();
        Class realClazz = clazz;
        String _realEntityName = ShrCodeRuleEntityMappingConfig.getInstance().getCodingRuleEntityMappingConfig(realEntityName);
        if (!StringUtils.isEmpty((String)_realEntityName) && !realEntityName.equals(_realEntityName)) {
            realEntityName = _realEntityName;
            realClazz = MetaDataUtil.getObjectValueClass(_realEntityName);
        } else {
            SHRBasicItemInfo shrBasicItemInfo;
            EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(realEntityName);
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem((EntityObjectInfo)entityObjectInfo.getBaseEntity()) && null != (shrBasicItemInfo = SHRBasicItemUtil.getSHRBasicItemInfoByEntityName(realEntityName)) && !StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
                realEntityName = shrBasicItemInfo.getRealEntityName();
                realClazz = MetaDataUtil.getObjectValueClass(realEntityName);
            }
        }
        String hrOrgUnit = MetaDataUtil.getHrOrgUnitLinkPropertyInfoName(viewInfo.getEntityName());
        IObjectValue numberFromModel = MetaDataUtil.newInstance(realClazz, realEntityName);
        HROrgUnitInfo hrOrgUnitInfo = null;
        if (!StringUtils.isEmpty((String)hrOrgUnit) && null != info.get(hrOrgUnit)) {
            hrOrgUnitInfo = (HROrgUnitInfo)info.get(hrOrgUnit);
        }
        String orgId = null;
        if (null != hrOrgUnitInfo && null != hrOrgUnitInfo.getId()) {
            orgId = hrOrgUnitInfo.getId().toString();
        }
        try {
            SHRCodingRuleApi.codingNumber((Context)SHRContext.getInstance().getContext(), (IObjectValue)info, (IObjectValue)numberFromModel, orgId);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Map initDataMap = (Map)request.getAttribute("view_initData");
        this.customparamXssfilter(initDataMap);
        request.setAttribute("view_initData", (Object)JSONUtils.convertObjectToJson(SHRContext.getInstance().getContext(), initDataMap));
        this.initUserInfo(request);
        super.postHandle(request, response, handler, modelAndView);
    }

    private void initUserInfo(HttpServletRequest request) throws SHRWebException {
        HttpSession session = null;
        try {
            session = request.getSession();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (session == null) {
            return;
        }
        Map<String, Object> data = (Map<String, Object>)session.getAttribute("userInfo");
        Context ctx = SHRContext.getInstance().getContext();
        if (ctx == null) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (data == null || !currentUserInfo.getId().equals(data.get("userId"))) {
            data = UserUtil.getUserInfo(request);
            session.setAttribute("userInfo", data);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }

    private void customparamXssfilter(Map<String, Object> initDataMap) {
        Map customparams = (Map)initDataMap.get("custom_params");
        if (null != customparams) {
            Set keySet = customparams.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj == null) continue;
                String paramKey = obj.toString();
                if (paramKey.contains(">") || paramKey.contains("</")) {
                    logger.error((Object)"xss key filter");
                    iterator.remove();
                    continue;
                }
                String paramValue = null != customparams.get(paramKey) ? customparams.get(paramKey).toString() : null;
                if (StringUtils.isEmpty((String)paramValue) || !paramValue.contains(">") && !paramValue.contains("</")) continue;
                logger.error((Object)"xss value filter");
                iterator.remove();
            }
        }
    }
}

