/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templateloader;

import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.ITemplateTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.FreeMarkerTemplateTranslator;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;

public class DBTemplateLoader
implements TemplateLoader {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.web.templateloader.DBTemplateLoader");
    private ITemplateTranslator templateTranslator = null;

    public Object findTemplateSource(String name) throws IOException {
        if (!name.startsWith("dynamic:")) {
            return null;
        }
        String key = name.substring("dynamic:".length(), name.lastIndexOf(":"));
        try {
            return UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), key);
        }
        catch (SHRWebException e) {
            throw new IOException("template translate is error, " + e.getMessage());
        }
    }

    public long getLastModified(Object templateSource) {
        UIViewInfo viewInfo = (UIViewInfo)templateSource;
        long lastModified = -1L;
        if (viewInfo != null && viewInfo.getLastUpdateTime() != null) {
            lastModified = viewInfo.getLastUpdateTime().getTime();
        }
        return lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource == null) {
            return null;
        }
        String result = null;
        UIViewInfo viewInfo = (UIViewInfo)templateSource;
        try {
            result = this.getTemplateTranslator().translate(viewInfo, SHRContext.getInstance().getContext());
        }
        catch (TemplateTranslateException e) {
            throw new IOException("template translate is error, " + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.assembleLogInfo(result, viewInfo));
        }
        return new StringReader(result);
    }

    private String assembleLogInfo(String result, UIViewInfo viewInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("[");
        sb.append(viewInfo.getUipk());
        sb.append("]");
        sb.append("");
        sb.append("\n\n[translate before] -------------------------------\n");
        sb.append(viewInfo.getContent());
        sb.append("\n\n[translate after] -------------------------------\n");
        sb.append(result);
        sb.append("\n---------------------------------------------------------------");
        return sb.toString();
    }

    public void closeTemplateSource(Object arg0) throws IOException {
    }

    private synchronized ITemplateTranslator getTemplateTranslator() throws TemplateTranslateException {
        if (this.templateTranslator == null) {
            this.templateTranslator = new FreeMarkerTemplateTranslator();
        }
        return this.templateTranslator;
    }
}

