/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.TranslatorUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.Text;

public abstract class AbstractElementTranslator
implements IElementTranslator {
    protected Element baseElement;
    private Context ctx;

    @Override
    public String translateChildren(Element parentElement, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        if (parentElement == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List children = parentElement.getContent();
        if (!children.isEmpty()) {
            IElementTranslator translator = null;
            Object object = null;
            Element element = null;
            Text text = null;
            int totalColspan = 0;
            int col = this.getElementCol(parentElement);
            String parentElementName = parentElement.getName();
            boolean doLayout = false;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                object = children.get(i);
                if (object instanceof Text) {
                    text = object;
                    if (!StringUtils.isEmpty((String)text.getTextTrim()) && text.getTextTrim().indexOf("$contextLanguage") >= 0) {
                        sb.append(text.getText().replace("$contextLanguage", MessageFormat.format("_{0}", this.ctx.getLocale().getDisplayName())));
                        continue;
                    }
                    sb.append(text.getText());
                    continue;
                }
                if (!(object instanceof Element) || (translator = store.getElementTranslator(element = (Element)children.get(i), this.ctx)) == null) continue;
                translator.beforeTranslate(element, viewInfo);
                if ("f7type".equalsIgnoreCase(element.getName())) continue;
                if ("list".equalsIgnoreCase(parentElementName) || "grid".equalsIgnoreCase(parentElementName)) {
                    sb.append(translator.translate(element, viewInfo, store));
                    continue;
                }
                if (this.isRequireDoLayout(translator, element)) {
                    if (!doLayout) {
                        sb.append("<@ctrl.row>\n");
                        doLayout = true;
                    }
                    String elementName = element.getName();
                    int colspan = this.getColspan(element, col, translator.isSpanFull());
                    element.setAttribute("colspan", String.valueOf(colspan));
                    if ((totalColspan += colspan) > col) {
                        if (i != 0 && !"field".equalsIgnoreCase(elementName) && !"blankField".equalsIgnoreCase(elementName)) {
                            sb.append("</@ctrl.row>\n");
                            sb.append("<@ctrl.row>\n");
                        }
                        totalColspan = colspan;
                    }
                    if ("field".equalsIgnoreCase(elementName) || "blankField".equalsIgnoreCase(elementName)) {
                        element.setAttribute("col", String.valueOf(col));
                        sb.append(translator.translate(element, viewInfo, store));
                        continue;
                    }
                    if (elementName.startsWith("ctrl.")) {
                        sb.append(translator.translate(element, viewInfo, store));
                        continue;
                    }
                    int realColspan = this.convertRealColspan(colspan, col);
                    if ("treeNavigation".equalsIgnoreCase(elementName)) {
                        realColspan = 12;
                    }
                    sb.append("<@ctrl.cell colSpan=" + realColspan);
                    sb.append(">\n");
                    sb.append(translator.translate(element, viewInfo, store));
                    sb.append("</@ctrl.cell>\n");
                    continue;
                }
                sb.append(translator.translate(element, viewInfo, store));
            }
            if (doLayout) {
                sb.append("</@ctrl.row>\n");
            }
        }
        return sb.toString();
    }

    private boolean isRequireDoLayout(IElementTranslator translator, Element element) {
        if ("td".equalsIgnoreCase(element.getName())) {
            return false;
        }
        return translator.requireLayout() && !this.isHiddenField(element) || element.getAttribute("colspan") != null;
    }

    private boolean isHiddenField(Element element) {
        return "field".equalsIgnoreCase(element.getName()) && "hidden".equalsIgnoreCase(element.getAttributeValue("type"));
    }

    private int getElementCol(Element parentElement) {
        int col = 6;
        if (parentElement.getAttributeValue("col") != null) {
            col = Integer.parseInt(parentElement.getAttributeValue("col"));
        }
        return col;
    }

    private int getColspan(Element element, int col, boolean isSpanFull) {
        int colspan = 1;
        if (element.getAttributeValue("colspan") != null) {
            colspan = Integer.parseInt(element.getAttributeValue("colspan"));
        } else if (isSpanFull) {
            colspan = col;
        }
        return colspan;
    }

    private int convertRealColspan(int colspan, int col) {
        if (colspan > col) {
            colspan = col;
        }
        return 12 / col * colspan;
    }

    @Override
    public boolean isSpanFull() {
        return false;
    }

    @Override
    public boolean requireLayout() {
        return false;
    }

    @Override
    public void beforeTranslate(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
    }

    @Override
    public void setElement(Element element) {
        this.baseElement = element;
    }

    @Override
    public Element getElement() {
        return this.baseElement;
    }

    protected String convertFieldString(String namespace, String tag, Map<String, Object> options) {
        return this.convertFieldString(namespace, tag, options, null);
    }

    protected String convertFieldString(String namespace, String tag, Map<String, Object> options, String childrenStr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.assembleStartTag(namespace, tag));
        sb.append(TranslatorUtil.optionToString(options));
        if (StringUtils.isEmpty((String)childrenStr)) {
            sb.append(" />");
        } else {
            sb.append(">\n");
            sb.append(childrenStr);
            sb.append(this.assembleEndTag(namespace, tag));
        }
        return sb.toString();
    }

    private String assembleStartTag(String namespace, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<@");
        sb.append(this.assembleTagName(namespace, tag));
        sb.append(" ");
        return sb.toString();
    }

    private String assembleEndTag(String namespace, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("</@");
        sb.append(this.assembleTagName(namespace, tag));
        sb.append(">");
        return sb.toString();
    }

    private String assembleTagName(String namespace, String tag) {
        return namespace + "." + tag;
    }

    protected String convertFieldString(String namespace, String tag, Element element) {
        return this.convertFieldString(namespace, tag, element, null);
    }

    protected String convertFieldString(String namespace, String tag, Element element, String childrenStr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.assembleStartTag(namespace, tag));
        sb.append(XMLUtil.attributesToString(element));
        if (StringUtils.isEmpty((String)childrenStr)) {
            sb.append(" />\n");
        } else {
            sb.append(">\n");
            sb.append(childrenStr);
            sb.append(this.assembleEndTag(namespace, tag));
        }
        return sb.toString();
    }

    protected final boolean isMultiLan(Element element, UIViewInfo viewInfo) {
        String fieldName = this.getFieldName(element, viewInfo);
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        if (null == fieldInfo) {
            return false;
        }
        PropertyInfo p = fieldInfo.getProperty();
        if (p instanceof OwnPropertyInfo) {
            OwnPropertyInfo p0 = (OwnPropertyInfo)p;
            return p0.isMultilingual();
        }
        return false;
    }

    protected String getFieldName(Element element, UIViewInfo viewInfo) {
        return element.getAttributeValue("name");
    }

    protected final void setStringIsTrimAll(Element element, Map<String, Object> options) {
        String trimAll = element.getAttributeValue("trimAll");
        if ("true".equals(trimAll)) {
            options.put("trimAll", true);
        }
    }

    protected final boolean isShowTimeZoneForCtrl() throws TemplateTranslateException {
        try {
            return UserNantionalUtil.isShowTimeZoneForCtrl((Context)this.ctx);
        }
        catch (EASBizException e) {
            throw new TemplateTranslateException(e);
        }
        catch (BOSException e) {
            throw new TemplateTranslateException(e);
        }
    }

    protected final boolean isAutoTimeZoneTransForTimeOrDatetimeProperty(Element element, UIViewInfo viewInfo) {
        return UIViewUtil.isAutoTimeZoneTransForTimeOrDatetimeProperty(element, viewInfo);
    }

    protected final void setDateTimeOrTimeOptions(Element element, Map<String, Object> options, UIViewInfo viewInfo, DataType dataType) throws TemplateTranslateException {
        try {
            UIViewUtil.setDateTimeOrTimeOptions(this.ctx, element, options, viewInfo, dataType);
        }
        catch (EASBizException e) {
            throw new TemplateTranslateException(e);
        }
        catch (BOSException e) {
            throw new TemplateTranslateException(e);
        }
    }

    protected final boolean isRemoveSecondsForDateTime(Element element) {
        return UIViewUtil.isRemoveSecondsForDateTime(element);
    }

    protected final boolean isRemoveDayForDateTime(Element element) {
        return UIViewUtil.isRemoveDayForDateTime(element);
    }

    protected final void setNumberFieldOptions(Element element, Map<String, Object> options, UIViewInfo viewInfo) {
        UIViewUtil.setNumberFieldOptions(this.ctx, element, options, viewInfo);
    }

    protected final void setSensitiveRule(Map<String, Object> options, FieldInfo fieldInfo, Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        if (null != fieldInfo && null != fieldInfo.getSensitiveRule()) {
            String sensitiveRule = JSONUtils.convertObjectToJson(this.ctx, fieldInfo.getSensitiveRule());
            sensitiveRule = sensitiveRule.replace("\"", "'");
            options.put("sensitiveRule", sensitiveRule);
        }
    }

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }
}

