/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.TranslatorUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;

public class ButtonTranslator
extends AbstractElementTranslator {
    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        if ("dropDownButton".equalsIgnoreCase(element.getParentElement().getName())) {
            return store.getElementTranslator(this.getContext(), "dropDownMenuButton").translate(element, viewInfo, store);
        }
        String visible = element.getAttributeValue("visible");
        if ("false".equalsIgnoreCase(visible)) {
            return "<#t>";
        }
        return this.convertFieldString("ctrl", "button", this.getOptions(element));
    }

    protected Map<String, Object> getOptions(Element element) {
        String bindPermItemUrl;
        String title;
        String states_visible;
        String pageStates_visible;
        HashMap<String, Object> options = new HashMap<String, Object>();
        String name = element.getAttributeValue("name");
        options.put("name", name);
        options.put("id", name + "${uuid}");
        String caption = element.getAttributeValue("caption");
        if (!StringUtils.isEmpty((String)caption)) {
            options.put("value", caption);
        } else {
            options.put("value", name);
        }
        String cls = element.getAttributeValue("class");
        if (!StringUtils.isEmpty((String)cls)) {
            cls = cls.replaceFirst("btn-primary", "shrbtn-primary");
        }
        options.put("class", cls);
        String actionBinding = element.getAttributeValue("actionBinding");
        if (StringUtils.isEmpty((String)actionBinding)) {
            actionBinding = name;
        }
        if (!"false".equalsIgnoreCase(actionBinding)) {
            actionBinding = actionBinding + "Action";
            String subAction = "";
            String isInnerButton = element.getAttributeValue("isInnerButton");
            if (!"true".equalsIgnoreCase(isInnerButton)) {
                subAction = actionBinding;
                actionBinding = "customAction";
            }
            options.put("actionBinding", actionBinding);
            if (!StringUtils.isEmpty((String)subAction)) {
                options.put("subAction", subAction);
            }
        }
        if (!StringUtils.isEmpty((String)(pageStates_visible = element.getAttributeValue("pageStates")))) {
            options.put("pageStates_visible", pageStates_visible);
        }
        if (!StringUtils.isEmpty((String)(states_visible = element.getAttributeValue("states")))) {
            options.put("states_visible", states_visible);
        }
        if (!StringUtils.isEmpty((String)(title = element.getAttributeValue("title")))) {
            options.put("title", title);
        }
        if (StringUtils.isEmpty((String)(bindPermItemUrl = element.getAttributeValue("bindPermItemUrl")))) {
            bindPermItemUrl = "";
        }
        options.put("permItemId", "${getButtonBindPermItemId('" + name + "','" + bindPermItemUrl + "')}");
        TranslatorUtil.copyAttribute(element, options, "modelVersion");
        TranslatorUtil.copyAttribute(element, options, "historyVersion");
        TranslatorUtil.copyAttribute(element, options, "onclick");
        TranslatorUtil.copyAttribute(element, options, "customData");
        TranslatorUtil.copyAttribute(element, options, "functionData");
        TranslatorUtil.copyAttribute(element, options, "isEnableExcelPwd");
        String disValue = element.getAttributeValue("notDisplay");
        if ("true".equals(disValue)) {
            options.put("notDisplay", "none");
        }
        return options;
    }
}

