/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListFieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class GridTranslator
extends AbstractElementTranslator {
    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String type = viewInfo.getType();
        if ("list".equalsIgnoreCase(type)) {
            this.handleListElementAttribute(element, viewInfo, store);
        } else if ("form".equalsIgnoreCase(type)) {
            this.handleFormElementAttribute(element, viewInfo, store);
        }
        this.handleElementAttribute(element, viewInfo);
        return this.translateGrid(element, viewInfo, store);
    }

    private void handleListElementAttribute(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        if (element.getAttribute("datatype") == null) {
            element.setAttribute("datatype", "local");
        }
    }

    private void handleFormElementAttribute(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        if (element.getAttribute("hasPager") == null) {
            Attribute attribute = new Attribute("hasPager", "false");
            element.setAttribute(attribute);
        }
    }

    private void handleElementAttribute(Element element, UIViewInfo viewInfo) {
        Attribute attribute;
        String url = element.getAttributeValue("url");
        if (!StringUtils.isEmpty((String)url)) {
            url = DynamicUtil.appendUrlParam(url, "billId", "${billId}");
            element.setAttribute("url", url);
        }
        if (element.getAttribute("view_model") == null && !StringUtils.isEmpty((String)viewInfo.getEntityName())) {
            attribute = new Attribute("view_model", viewInfo.getEntityName());
            element.setAttribute(attribute);
        }
        if (element.getAttribute("uipk") == null && !StringUtils.isEmpty((String)viewInfo.getUipk())) {
            attribute = new Attribute("uipk", viewInfo.getUipk());
            element.setAttribute(attribute);
        }
        if (!StringUtils.isEmpty((String)viewInfo.getOrderBy())) {
            attribute = new Attribute("sorterItems", viewInfo.getOrderBy());
            element.setAttribute(attribute);
        }
        if (element.getAttribute("pager") == null) {
            element.setAttribute("pager", "gridPager");
        }
        if (element.getAttribute("loadComplete") == null) {
            element.setAttribute("loadComplete", "jsBinder.gridLoadComplete");
        }
    }

    protected String translateGrid(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        StringBuilder sb = new StringBuilder();
        sb.append("<@g.grid {0}>\n");
        sb.append("\t{1}");
        if (!this.hasDefinedKeyField(viewInfo)) {
            sb.append("\t<@g.gridColumn name=\"id\" label=\"id\" hidden=\"true\" />\n");
        }
        sb.append("</@g.grid>\n");
        String result = MessageFormat.format(sb.toString(), XMLUtil.attributesToString(element, this.getExcludeAttributeName()), this.translateChildren(element, viewInfo, store));
        return result;
    }

    protected boolean hasDefinedKeyField(UIViewInfo viewInfo) {
        boolean flag = false;
        List<FieldInfo> fields = viewInfo.getFields();
        FieldInfo fieldInfo = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = fields.get(i);
            if ((!(fieldInfo instanceof ListFieldInfo) || !((ListFieldInfo)fieldInfo).isKeyField()) && !fieldInfo.getName().equals("id")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private Set<String> getExcludeAttributeName() {
        HashSet<String> excludeAttribute = new HashSet<String>();
        excludeAttribute.add("colspan");
        excludeAttribute.add("name");
        return excludeAttribute;
    }

    @Override
    public boolean isSpanFull() {
        return true;
    }

    @Override
    public boolean requireLayout() {
        return true;
    }
}

