/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.TranslatorUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import org.jdom2.Element;

public class TreeNavigationTranslator
extends AbstractElementTranslator {
    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String gridId = element.getAttributeValue("gridId");
        if (StringUtils.isEmpty((String)gridId)) {
            gridId = "grid";
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("gridId", gridId);
        options.put("url", this.getUrl(element, viewInfo));
        TranslatorUtil.copyAttribute(element, options, "isDefaultLoad");
        if (options.get("isDefaultLoad") == null) {
            options.put("isDefaultLoad", "true");
        }
        TranslatorUtil.copyAttribute(element, options, "id");
        if (options.get("id") == null) {
            options.put("id", "treeNavigation");
        }
        TranslatorUtil.copyAttribute(element, options, "class");
        TranslatorUtil.copyAttribute(element, options, "filterConfig");
        TranslatorUtil.copyAttribute(element, options, "isTree");
        String extendOptions = element.getAttributeValue("extendOptions");
        if (!StringUtils.isEmpty((String)extendOptions)) {
            options.put("extendOptions", extendOptions);
        }
        TranslatorUtil.copyAttribute(element, options, "extendOptions");
        StringBuilder result = new StringBuilder();
        result.append(this.convertFieldString("ctrl", "gridNavigation", options));
        return this.assembleTranslate(element, viewInfo, store, result);
    }

    private String assembleTranslate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store, StringBuilder result) {
        String dragged = element.getAttributeValue("dragged");
        String isTree = element.getAttributeValue("isTree");
        dragged = !StringUtils.isEmpty((String)isTree) && isTree.equalsIgnoreCase("false") ? "false" : (!StringUtils.isEmpty((String)dragged) && dragged.equalsIgnoreCase("false") ? "false" : "true");
        result.append("\n<@ctrl.dragWidget dragged=" + dragged + "></@ctrl.dragWidget>\n");
        return result.toString();
    }

    private String getUrl(Element element, UIViewInfo viewInfo) {
        boolean isList;
        String url = element.getAttributeValue("url");
        boolean bl = isList = "list".equalsIgnoreCase(viewInfo.getType()) || "dynamicList".equalsIgnoreCase(viewInfo.getType());
        if (StringUtils.isEmpty((String)url) && isList) {
            url = "/dynamic.do?method=getTreeData";
        }
        if (!StringUtils.isEmpty((String)url)) {
            url = DynamicUtil.getContextPath() + url;
            url = DynamicUtil.appendUrlParam(url, "uipk", viewInfo.getUipk());
        }
        if (StringUtils.isEmpty((String)url)) {
            url = "";
        }
        return url;
    }

    @Override
    public boolean isSpanFull() {
        return true;
    }

    @Override
    public boolean requireLayout() {
        return true;
    }
}

