/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function.AbstractFreemarkerFunction;
import com.kingdee.shr.ml.util.TimeZoneTransfer;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import freemarker.template.TemplateModelException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DateTimeFormaterForDisplay
extends AbstractFreemarkerFunction {
    private static Logger logger = Logger.getLogger(DateTimeFormaterForDisplay.class);

    public Object exec(List args) throws TemplateModelException {
        Date date = null;
        int size = args.size();
        if (size > 0) {
            Object value = args.get(0);
            if (value == null) {
                return "";
            }
            date = this.getValueDate(value);
            if (date == null) {
                try {
                    value = this.getValueString(value);
                    if (value != null && !StringUtils.isEmpty((String)value.toString())) {
                        date = DateTimeUtils.parseDate((String)value.toString());
                    }
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (date == null) {
            return "";
        }
        String dateType = this.getValueString(args.get(1));
        boolean isAutoTimeZoneTrans = this.getValueBoolean(args.get(2));
        boolean isRemoveSeconds = this.getValueBoolean(args.get(3));
        boolean isRemoveDay = this.getValueBoolean(args.get(4));
        Context ctx = SHRContext.getInstance().getContext();
        try {
            boolean stzfc = UserNantionalUtil.isShowTimeZoneForCtrl((Context)ctx);
            return TimeZoneTransfer.format((Context)ctx, (String)dateType, (Date)date, (isAutoTimeZoneTrans && stzfc ? 1 : 0) != 0, (boolean)isRemoveSeconds, (boolean)isRemoveDay);
        }
        catch (EASBizException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        catch (BOSException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
    }
}

