/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.VersionManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;

public class KingdeeSupportUtil {
    private static LicenseBaseInfo baseInfo = null;

    public static String buildUrl(String type) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        if (baseInfo == null) {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            baseInfo = agent.getLicenseBaseInfo();
        }
        Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo u = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("vendorID", p.getProperty("VENDOR_ID"));
        params.put("type", type);
        params.put("source", p.getProperty("EASPRODUCT"));
        params.put("clientId", EasCloud.CLIENT_ID);
        String uid = u.getUid();
        params.put("kduid", StringUtils.isEmpty((String)uid) ? "unknown" : uid);
        if (!StringUtils.isEmpty((String)uid)) {
            JSONObject rs = EasCloud.cloudErpAccessToken((String)uid, (String)(StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID()));
            if (rs != null && rs.getIntValue("errcode") == 0) {
                String access_token = rs.getJSONObject("data").getString("access_token");
                if ((rs = EasCloud.getUserAuthCode((String)access_token)) != null && rs.getIntValue("errcode") == 0) {
                    params.put("authCode", rs.getJSONObject("data").getString("auth_code"));
                } else if ("Service".equals(type)) {
                    throw new BOSException();
                }
            } else if ("Service".equals(type)) {
                throw new BOSException();
            }
        }
        if (!StringUtils.isEmpty((String)((String)params.get("authCode")))) {
            params.put("serviceType", "1");
        } else {
            params.put("serviceType", "2");
        }
        String version = KingdeeSupportUtil.getEASversion(ctx);
        params.put("prodVersion", URLEncoder.encode(StringUtils.isEmpty((String)version) ? "unknown" : version, "UTF-8"));
        params.put("prodCategoryCode", "EAS");
        params.put("prodDeployWay", "Offline");
        params.put("prodInstCode", StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
        params.put("prodSN", StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
        params.put("userRole", "Normal");
        String timeStamp = String.valueOf(System.currentTimeMillis());
        params.put("timestamp", timeStamp);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        params.put("nonce", nonce);
        Iterator ite = params.entrySet().iterator();
        Object[] values = new String[params.size()];
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry value = ite.next();
            values[i++] = (String)value.getValue();
        }
        Arrays.sort((Object[])values);
        StringBuilder sb = new StringBuilder();
        for (Object str : values) {
            sb.append((String)str);
        }
        params.put("signature", EasCloud.sha1((String)(p.getProperty("SUPPORT_NUMBER") + sb.toString())));
        if ("Sales".equalsIgnoreCase(type)) {
            return p.getProperty("SUPPORT_SALES_URL") + "?" + KingdeeSupportUtil.getQueryString(params);
        }
        return p.getProperty("SUPPORT_SERVICE_URL") + "?" + KingdeeSupportUtil.getQueryString(params);
    }

    private static String getQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value != null && value.contains("+")) {
                value = value.replaceAll("\\+", "");
            }
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String getEASversion(Context ctx) {
        String version = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties((String)"EAS", (Locale)ctx.getLocale());
        if (null == version) {
            VersionManager vmeas = new VersionManager();
            try {
                version = vmeas.getMetadataVersion();
            }
            catch (Exception var3) {
                version = "unknown";
            }
        }
        System.setProperty("productVersion", version);
        return version;
    }
}

