/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.parquet.Files;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SQLScriptPrimaryKeyModifyUtil {
    private static Logger logger = Logger.getLogger(SQLScriptPrimaryKeyModifyUtil.class);
    private static final String ID_OLD = "idold";
    private static final String ID_NEW = "idnew";
    private static final String DELETE_SQL = "deleteSQL";
    private static final String ENTITY_NAME = "entityName";
    private static final String DESC = "DESC";
    private static final String PATH = "path";
    private static final String IS_ERROR = "isError";
    private static final String MATCH_KEY = "'////";

    public static void doModify(Context ctx) throws SHRWebException {
        String startLocation = "W:" + File.separator + "shr_trunck_sql" + File.separator + "8_6_1_2to8_8_0_0" + File.separator + "s_HR";
        File f = new File(startLocation);
        File[] subFiles = f.listFiles();
        if (null == subFiles || subFiles.length <= 0) {
            return;
        }
        LinkedHashMap<String, Map<String, String>> idMapping = new LinkedHashMap<String, Map<String, String>>();
        ArrayList<Map<String, String>> fileMapping = new ArrayList<Map<String, String>>();
        for (File file : subFiles) {
            SQLScriptPrimaryKeyModifyUtil.doFile(ctx, file, idMapping, fileMapping);
        }
        Workbook workbook = SQLScriptPrimaryKeyModifyUtil.genExcelData(idMapping, fileMapping);
        SQLScriptPrimaryKeyModifyUtil.writeExcelFile(workbook, SQLScriptPrimaryKeyModifyUtil.getFilePath("SQLScript_FID_Modify_Result.xlsx"));
    }

    private static void doFile(Context ctx, File file, Map<String, Map<String, String>> idMapping, List<Map<String, String>> fileMapping) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (null == subFiles || subFiles.length <= 0) {
                return;
            }
            for (File f : subFiles) {
                SQLScriptPrimaryKeyModifyUtil.doFile(ctx, f, idMapping, fileMapping);
            }
        } else {
            String type = file.getName().substring(file.getName().lastIndexOf(".") + 1).toLowerCase();
            if ("xml".equals(type) || "sql".equals(type) || "ksql".equals(type)) {
                SQLScriptPrimaryKeyModifyUtil.readAndModifyFile(ctx, file, idMapping, fileMapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndModifyFile(Context ctx, File file, Map<String, Map<String, String>> idMapping, List<Map<String, String>> fileMapping) {
        PrintWriter pw = null;
        try {
            List allLines = Files.readAllLines((File)file, (Charset)StandardCharsets.UTF_8);
            if (null == allLines || allLines.isEmpty()) {
                return;
            }
            String modifyStr = SQLScriptPrimaryKeyModifyUtil.modify(ctx, allLines, idMapping, fileMapping, file.getAbsolutePath());
            pw = new PrintWriter(new FileWriter(file));
            pw.write(modifyStr);
            pw.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (null != pw) {
                pw.close();
            }
        }
    }

    private static String modify(Context ctx, List<String> allLines, Map<String, Map<String, String>> idMapping, List<Map<String, String>> fileMapping, String filePath) {
        StringBuilder result = new StringBuilder();
        for (String str : allLines) {
            while (true) {
                int index;
                if ((index = str.indexOf(MATCH_KEY)) == -1) break;
                result.append(str.substring(0, index));
                String tempStr = str.substring(index).replaceFirst(MATCH_KEY, "");
                int endIndex = tempStr.indexOf("'");
                String variablePlace = MATCH_KEY + tempStr.substring(0, endIndex + 1);
                String oldFID = variablePlace.replace("'", "");
                String newFID = "";
                HashMap<String, String> detail = new HashMap<String, String>(2);
                Map<String, String> temp = null;
                if (idMapping.containsKey(oldFID)) {
                    temp = idMapping.get(oldFID);
                    newFID = temp.get(ID_NEW);
                } else {
                    EntityObjectInfo entityObjectInfo = null;
                    String deleteSQL = "";
                    temp = new HashMap<String, String>(5);
                    temp.put(DESC, "");
                    temp.put(ENTITY_NAME, "");
                    temp.put(IS_ERROR, "false");
                    BOSObjectType bostype = null;
                    try {
                        bostype = MetaDataUtil.getBOSObjectTypeById(oldFID);
                        entityObjectInfo = MetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)bostype);
                        temp.put(ENTITY_NAME, entityObjectInfo.getFullName());
                        newFID = BOSUuid.create((BOSObjectType)bostype).toString();
                        if (null != entityObjectInfo && null != entityObjectInfo.getTable()) {
                            deleteSQL = MessageFormat.format("DELETE FROM {0} WHERE FID=''{1}'';", entityObjectInfo.getTable().getName(), oldFID);
                        } else {
                            temp.put(IS_ERROR, "true");
                            newFID = "";
                            temp.put(DESC, " Not found table, the entity is abstract.");
                        }
                    }
                    catch (MetaDataNotFoundException e) {
                        entityObjectInfo = null;
                        temp.put(DESC, e.getMessage());
                        temp.put(IS_ERROR, "true");
                        newFID = "";
                    }
                    catch (IllegalArgumentException e) {
                        entityObjectInfo = null;
                        temp.put(DESC, e.getMessage());
                        temp.put(IS_ERROR, "true");
                        newFID = "";
                    }
                    temp.put(ID_NEW, newFID);
                    temp.put(DELETE_SQL, deleteSQL);
                    idMapping.put(oldFID, temp);
                }
                detail.put(ID_OLD, oldFID);
                detail.put(PATH, filePath.replace("W:\\shr_trunck_sql", ""));
                fileMapping.add(detail);
                if ("true".equals(temp.get(IS_ERROR))) {
                    result.append(variablePlace);
                } else {
                    result.append("'").append(newFID).append("'");
                }
                str = tempStr.substring(endIndex + 1);
            }
            result.append(str);
            result.append("\n");
        }
        return result.toString();
    }

    private static Workbook genExcelData(Map<String, Map<String, String>> idMapping, List<Map<String, String>> fileMapping) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        Sheet oldFIDMappingNewFID = workbook.createSheet("oldFIDMappingNewFID");
        int oldFIDMappingNewFIDrowindex = 0;
        Row oldFIDMappingNewFIDrow = oldFIDMappingNewFID.createRow(oldFIDMappingNewFIDrowindex++);
        SQLScriptPrimaryKeyModifyUtil.fillExcelHeader(oldFIDMappingNewFIDrow);
        for (Map.Entry<String, Map<String, String>> entry : idMapping.entrySet()) {
            oldFIDMappingNewFIDrow = oldFIDMappingNewFID.createRow(oldFIDMappingNewFIDrowindex++);
            oldFIDMappingNewFIDrow.createCell(0).setCellValue(entry.getKey());
            oldFIDMappingNewFIDrow.createCell(1).setCellValue(entry.getValue().get(ID_NEW));
            oldFIDMappingNewFIDrow.createCell(2).setCellValue(entry.getValue().get(DELETE_SQL));
            oldFIDMappingNewFIDrow.createCell(3).setCellValue(entry.getValue().get(ENTITY_NAME));
            oldFIDMappingNewFIDrow.createCell(4).setCellValue(entry.getValue().get(DESC));
            oldFIDMappingNewFIDrow.createCell(5).setCellValue(entry.getValue().get(IS_ERROR));
        }
        Sheet oldFIDMappingFile = workbook.createSheet("oldFIDMappingFile");
        int oldFIDMappingFilerowindex = 0;
        Row oldFIDMappingFilerow = oldFIDMappingFile.createRow(oldFIDMappingFilerowindex++);
        SQLScriptPrimaryKeyModifyUtil.fillFileExcelHeader(oldFIDMappingFilerow);
        for (Map<String, String> m : fileMapping) {
            oldFIDMappingFilerow = oldFIDMappingFile.createRow(oldFIDMappingFilerowindex++);
            oldFIDMappingFilerow.createCell(0).setCellValue(m.get(ID_OLD));
            Map<String, String> info = idMapping.get(m.get(ID_OLD));
            oldFIDMappingFilerow.createCell(1).setCellValue(info.get(ID_NEW));
            oldFIDMappingFilerow.createCell(2).setCellValue(info.get(DELETE_SQL));
            oldFIDMappingFilerow.createCell(3).setCellValue(info.get(ENTITY_NAME));
            oldFIDMappingFilerow.createCell(4).setCellValue(info.get(DESC));
            oldFIDMappingFilerow.createCell(5).setCellValue(info.get(IS_ERROR));
            oldFIDMappingFilerow.createCell(6).setCellValue(m.get(PATH));
        }
        return workbook;
    }

    private static void fillExcelHeader(Row row) {
        String[] headers = new String[]{"\u4fee\u6539\u524dFID", "\u4fee\u6539\u540eFID", "\u5220\u9664\u6570\u636eSQL", "\u5b9e\u4f53\u5168\u8def\u5f84", "\u8bf4\u660e", "\u662f\u5426\u62a5\u9519"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static void fillFileExcelHeader(Row row) {
        String[] headers = new String[]{"\u4fee\u6539\u524dFID", "\u4fee\u6539\u540eFID", "\u5220\u9664\u6570\u636eSQL", "\u5b9e\u4f53\u5168\u8def\u5f84", "\u8bf4\u660e", "\u662f\u5426\u62a5\u9519", "SQL\u6587\u4ef6"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static String getFilePath(String fileName) {
        StringBuffer dir = new StringBuffer();
        dir.append(SHRSyssettingUtil.getIotmpdir());
        File f = new File(dir.toString());
        if (!f.exists()) {
            f.mkdir();
        }
        StringBuffer filePath0 = new StringBuffer();
        filePath0.append(dir.toString()).append(File.separator).append(fileName);
        return filePath0.toString();
    }

    private static void writeExcelFile(Workbook workbook, String fileName) throws SHRWebException {
        FileOutputStream fileOut = null;
        try {
            File f = new File(fileName);
            if (f.exists()) {
                f.delete();
            } else {
                f.createNewFile();
            }
            fileOut = new FileOutputStream(f);
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != fileOut) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                workbook.close();
                workbook = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

