/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.watermark;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.watermark.IWaterMarkHandlerExtService;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class WaterMarkUtil {
    private static final String USER_PLAN = "user";
    private static final String CELL_PLAN = "cell";
    private static final String NUMBER_PLAN = "number";
    private static final String CUSTOMCLASS_PLAN = "customClass";

    public static Map<String, Object> getWaterMarkInfo(String config) throws BOSException, SHRWebException, EASBizException {
        String description;
        HashMap<String, Object> temp = new HashMap<String, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo uInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Map map = new HashMap();
        if ((map = (Map)JSONUtils.convertJsonToObject(ctx, config, map.getClass())) != null && !StringUtils.isEmpty((String)(description = String.valueOf(((Map)map.get("waterSchema")).get("description"))))) {
            String customClass;
            if (USER_PLAN.equals(description)) {
                temp.put("userName", uInfo.getName());
            } else if (CELL_PLAN.equals(description)) {
                temp.put("userName", uInfo.getName());
                temp.put("userCell", "");
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo(CELL_PLAN));
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(uInfo.getId()), sic);
                String userCell = userInfo.getCell();
                if (!StringUtils.isEmpty((String)userCell)) {
                    userCell = userCell.substring(userCell.length() - 4, userCell.length());
                    temp.put("userCell", userCell);
                }
            } else if (NUMBER_PLAN.equals(description)) {
                temp.put("userName", uInfo.getName());
                temp.put("userNumber", StringUtils.isEmpty((String)uInfo.getNumber()) ? "" : uInfo.getNumber());
            } else if (CUSTOMCLASS_PLAN.equals(description) && !StringUtils.isEmpty((String)(customClass = String.valueOf(map.get(CUSTOMCLASS_PLAN))))) {
                IWaterMarkHandlerExtService service = WaterMarkUtil.getWaterMarkHandlerExtService(customClass);
                temp.put("custom", service.custom(ctx));
            }
        }
        return temp;
    }

    public static IWaterMarkHandlerExtService getWaterMarkHandlerExtService(String customClass) throws BOSException, SHRWebException {
        Class<?> clz;
        block8: {
            clz = null;
            try {
                clz = MsfClassLoaderFactory.forName((String)customClass);
            }
            catch (ClassNotFoundException e) {
                try {
                    clz = Class.forName(customClass);
                }
                catch (ClassNotFoundException e1) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "label265"));
                }
                if (clz != null) break block8;
                throw new BOSException((Throwable)e);
            }
        }
        try {
            if (!(clz.newInstance() instanceof IWaterMarkHandlerExtService)) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "label265"));
            }
            return (IWaterMarkHandlerExtService)clz.newInstance();
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkCustomClass(Context ctx, String config) throws BOSException, SHRWebException {
        String customClass;
        Map map = new HashMap();
        if ((map = (Map)JSONUtils.convertJsonToObject(ctx, config, map.getClass())) != null && !StringUtils.isEmpty((String)(customClass = String.valueOf(map.get(CUSTOMCLASS_PLAN))))) {
            WaterMarkUtil.getWaterMarkHandlerExtService(customClass);
        }
    }
}

