/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.msf.web.controller;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.MethodInfo;
import com.kingdee.bos.bsf.service.OSFResponse;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.app.util.MsfServiceUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.msf.web.util.MsfWebUtils;
import com.kingdee.shr.osf.OSFCacheHelper;
import com.kingdee.util.StringUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/shr/msf/service"})
public class MSFServiceController
extends WebPageController {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.msf.web.controller.MSFServiceController");

    @RequestMapping(params={"method=callService"})
    public String getRefAction(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="serviceName") String serviceName) throws SHRWebException {
        Map param = request.getParameterMap();
        HashMap<String, String> cleanMap = new HashMap<String, String>();
        cleanMap.put("req_header_referer", request.getHeader("Referer"));
        for (Map.Entry entry : param.entrySet()) {
            cleanMap.put((String)entry.getKey(), request.getParameter((String)entry.getKey()));
        }
        Context ctx = SHRContext.getInstance().getContext();
        OSFResponse standataResult = new OSFResponse(0, "", null);
        ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo((Context)ctx, (String)serviceName);
        Object result = null;
        boolean isForamt = MsfServiceUtil.isFormat((Context)ctx, (ServiceInfo)serviceInfo);
        try {
            boolean isOuterCall = MsfWebUtils.isOuterCallOsf(ctx, request);
            if (null == serviceInfo) {
                throw new ServiceBizException(ServiceBizException.SERVICE_NOT_FOUND, new Object[]{serviceName});
            }
            MethodInfo m = MsfServiceUtil.getMethodInfo((String)"process", (ServiceInfo)serviceInfo);
            MsfServiceUtil.checkOuterAndInnerOsfPermission((Context)ctx, (String)serviceName, (ServiceInfo)serviceInfo, (boolean)isOuterCall);
            cleanMap.put("_session_", (String)request.getSession());
            if (serviceInfo.getServiceType() == 10) {
                cleanMap.put("HttpServletRequest", (String)request);
                cleanMap.put("HttpServletResponse", (String)response);
                result = MsfServiceUtil.processService((Context)ctx, (ServiceInfo)serviceInfo, cleanMap);
            } else {
                result = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(serviceName, cleanMap);
                if (result == null) {
                    result = "";
                }
            }
            if (isForamt) {
                if (null != m && m.getRes().isEncrypt() && !StringUtils.isEmpty((String)serviceInfo.getEncryptKey())) {
                    standataResult.setData((Object)MsfServiceUtil.encode((String)JSONUtils.convertObjectToJson(ctx, result), (String)serviceInfo.getEncryptKey()));
                    MsfServiceUtil.setExtData((OSFResponse)standataResult, (String)serviceInfo.getEncryptKey());
                } else {
                    MsfServiceUtil.setExtData((OSFResponse)standataResult, null);
                    standataResult.setData(result);
                }
                if (cleanMap.containsKey("_biz_error_code_")) {
                    standataResult.setBizCode((String)cleanMap.get("_biz_error_code_"));
                    standataResult.setErrMsg((String)cleanMap.get("_biz_error_msg_"));
                    standataResult.setErrCode(1);
                }
            }
        }
        catch (EASBizException e) {
            if (isForamt) {
                MsfServiceUtil.setErrorCodeAndMessage((OSFResponse)standataResult, (Exception)((Object)e), (ServiceInfo)serviceInfo, cleanMap);
            }
            throw new ShrWebBizException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (isForamt) {
                MsfServiceUtil.setErrorCodeAndMessage((OSFResponse)standataResult, (Exception)e, (ServiceInfo)serviceInfo, cleanMap);
            }
            throw new SHRWebException(e);
        }
        if (isForamt) {
            JSONUtils.writeJson(response, standataResult);
        } else {
            JSONUtils.writeJson(response, result);
        }
        return null;
    }

    @RequestMapping(params={"method=callServiceReturnCode"})
    public String callServiceReturnCodeAction(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="serviceName") String serviceName) throws SHRWebException {
        Map param = request.getParameterMap();
        HashMap cleanMap = new HashMap();
        for (Map.Entry entry : param.entrySet()) {
            cleanMap.put(entry.getKey(), request.getParameter((String)entry.getKey()));
        }
        Context ctx = (Context)request.getSession().getAttribute("UserContext");
        StringBuffer caller = new StringBuffer();
        String user = ctx.getAIS() + "@" + ctx.getUserName();
        caller.append("request ip=" + request.getRemoteAddr()).append(" user=").append(user).append(" serviceName=" + serviceName).append(" param=").append(((Object)cleanMap).toString());
        logger.info((Object)("prerequest" + SHRCheck.vaildLog((String)caller.toString())));
        long start = System.currentTimeMillis();
        Object result = null;
        String sucess = "true";
        String errorMsg = "";
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        boolean isOuterCall = MsfWebUtils.isOuterCallOsf(ctx, request);
        try {
            ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo((Context)ctx, (String)serviceName);
            if (null == serviceInfo) {
                throw new ServiceBizException(ServiceBizException.SERVICE_NOT_FOUND, new Object[]{serviceName});
            }
            MethodInfo m = MsfServiceUtil.getMethodInfo((String)"process", (ServiceInfo)serviceInfo);
            MsfServiceUtil.checkOuterAndInnerOsfPermission((Context)ctx, (String)serviceName, (ServiceInfo)serviceInfo, (boolean)isOuterCall);
            if (StringUtils.isEmpty((String)errorMsg)) {
                if (serviceInfo != null && serviceInfo.getServiceType() == 10) {
                    cleanMap.put("HttpServletRequest", (String)request);
                    cleanMap.put("HttpServletResponse", (String)response);
                    result = MsfServiceUtil.processService((Context)ctx, (ServiceInfo)serviceInfo, cleanMap);
                } else {
                    result = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(serviceName, cleanMap);
                    if (result == null) {
                        result = "";
                    }
                }
            }
        }
        catch (Exception e) {
            errorMsg = this.handleException(e, request);
        }
        if (!StringUtils.isEmpty((String)errorMsg)) {
            sucess = "false";
        }
        returnValue.put("data", result);
        returnValue.put("success", sucess);
        returnValue.put("errorMsg", errorMsg);
        long end = System.currentTimeMillis();
        returnValue.put("cost", end - start);
        JSONUtils.writeJson(response, returnValue);
        caller.append(" cost=" + (end - start));
        caller.append(" status=" + sucess).append(" errorMsg=").append(errorMsg);
        if (logger.isDebugEnabled()) {
            caller.append(" returnValue=").append(JSONUtils.convertObjectToJson(ctx, returnValue));
        }
        logger.info((Object)("afterrequest=" + SHRCheck.vaildLog((String)caller.toString())));
        return null;
    }

    private String handleException(Exception e, HttpServletRequest request) {
        logger.error((Object)e.getCause());
        String errorMsg = "";
        if (e instanceof ShrWebBizException) {
            errorMsg = e.getMessage();
        } else if (e instanceof EASBizException || e instanceof ShrWebBizException) {
            errorMsg = e.getMessage();
        } else if (e instanceof UndeclaredThrowableException) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            errorMsg = e.getMessage();
        } else {
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }
}

