/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.config;

import com.kingdee.bos.autoupdate.config.ConfigException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigManager {
    public static final String KD_UPDATER_PROPS = "KDUpdater.properties";
    public static final String KD_UPDATER_CONFIG = "KDUpdater.config";
    public static final String KD_UPDATER_IS_NEED_PROXY = "KDUpdater.isNeedProxy";
    public static final String KD_UPDATER_PROXY_USERNAME = "KDUpdater.proxyUserName";
    public static final String KD_UPDATER_PROXY_PASSWORD = "KDUpdater.proxyPassword";
    public static final String KD_UPDATER_PROXY_HOST = "KDUpdater.proxyHost";
    public static final String KD_UPDATER_PROXY_PORT = "KDUpdater.proxyPort";
    public static final String KD_UPDATER_IS_NEED_BASIC_AUTH = "KDUpdater.isNeedBasicAuth";
    public static final String KD_UPDATER_BASE_AUTH_USERNAME = "KDUpdater.baseAuthUserName";
    public static final String KD_UPDATER_BASE_AUTH_PASSWORD = "KDUpdater.baseAuthPassword";
    public static final String KD_UPDATER_LAST_JNLP_URL = "KDUpdater.lastJnlpUrl";
    public static final String KD_UPDATER_LAST_LOCAL_PATH = "KDUpdater.lastLocalPath";
    public static final String KD_UPDATER_IS_SHOW_CONSONLE = "KDUpdater.isShowConsole";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigInfo load() throws ConfigException {
        File configFile = ConfigManager.getConfigFile(KD_UPDATER_PROPS);
        ConfigInfo configInfo = new ConfigInfo();
        if (!configFile.exists()) {
            configInfo.setNeedBaseAuth(false);
            configInfo.setNeedProxy(false);
            return configInfo;
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(configFile);
                Properties props = new Properties();
                props.load(fis);
                configInfo.setNeedProxy(Boolean.valueOf(props.getProperty(KD_UPDATER_IS_NEED_PROXY, "false")));
                configInfo.setProxyServerUrl(props.getProperty(KD_UPDATER_PROXY_HOST));
                configInfo.setProxyPort(new Integer(props.getProperty(KD_UPDATER_PROXY_PORT, "-1")));
                configInfo.setProxyUserName(props.getProperty(KD_UPDATER_PROXY_USERNAME));
                configInfo.setProxyPassword(props.getProperty(KD_UPDATER_PROXY_PASSWORD));
                configInfo.setNeedBaseAuth(Boolean.valueOf(props.getProperty(KD_UPDATER_IS_NEED_BASIC_AUTH, "false")));
                configInfo.setBaseAuthUserName(props.getProperty(KD_UPDATER_BASE_AUTH_USERNAME));
                configInfo.setBaseAuthPassword(props.getProperty(KD_UPDATER_BASE_AUTH_PASSWORD));
                configInfo.setLastJnlpUrl(props.getProperty(KD_UPDATER_LAST_JNLP_URL));
                configInfo.setLastLocalPath(props.getProperty(KD_UPDATER_LAST_LOCAL_PATH));
                configInfo.setShowConsole(Boolean.valueOf(props.getProperty(KD_UPDATER_IS_SHOW_CONSONLE, "true")));
            }
            catch (IOException ioe) {
                throw new ConfigException(ioe);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        if (fis == null) return configInfo;
        fis.close();
        return configInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(ConfigInfo configInfo) throws ConfigException {
        File configFile = ConfigManager.getConfigFile(KD_UPDATER_PROPS);
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(configFile);
                Properties props = new Properties();
                props.setProperty(KD_UPDATER_IS_NEED_PROXY, configInfo.isNeedProxy() ? "true" : "false");
                props.setProperty(KD_UPDATER_PROXY_HOST, ConfigManager.null2empty(configInfo.getProxyServerUrl()));
                props.setProperty(KD_UPDATER_PROXY_PORT, new Integer(configInfo.getProxyPort()).toString());
                props.setProperty(KD_UPDATER_PROXY_USERNAME, ConfigManager.null2empty(configInfo.getProxyUserName()));
                props.setProperty(KD_UPDATER_PROXY_PASSWORD, ConfigManager.null2empty(configInfo.getProxyPassword()));
                props.setProperty(KD_UPDATER_IS_NEED_BASIC_AUTH, configInfo.isNeedBaseAuth() ? "true" : "false");
                props.setProperty(KD_UPDATER_BASE_AUTH_USERNAME, ConfigManager.null2empty(configInfo.getBaseAuthUserName()));
                props.setProperty(KD_UPDATER_BASE_AUTH_PASSWORD, ConfigManager.null2empty(configInfo.getBaseAuthPassword()));
                props.setProperty(KD_UPDATER_LAST_JNLP_URL, ConfigManager.null2empty(configInfo.getLastJnlpUrl()));
                props.setProperty(KD_UPDATER_LAST_LOCAL_PATH, ConfigManager.null2empty(configInfo.getLastLocalPath()));
                props.setProperty(KD_UPDATER_IS_SHOW_CONSONLE, configInfo.isShowConsole() ? "true" : "false");
                props.store(fos, "");
                fos.flush();
            }
            catch (IOException ioe) {
                throw new ConfigException(ioe);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (fos == null) return;
        fos.close();
        return;
    }

    public static File getConfigFile(String fileName) {
        String configDir = System.getProperty(KD_UPDATER_CONFIG);
        if (configDir == null) {
            configDir = System.getProperty("user.dir");
        }
        File configFile = new File(configDir);
        return new File(configFile, fileName);
    }

    private static String null2empty(String str) {
        return str != null ? str : "";
    }
}

