/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.ui;

import com.kingdee.bos.autoupdate.Logger;
import com.kingdee.bos.autoupdate.ResourceManager;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class Console
extends OutputStream {
    private static final String CONSOLE_TITLE = "CONSOLE_TITLE";
    private static final String CONSOLE_CLEAR = "CONSOLE_CLEAR";
    private static Document document;
    private static JFrame frame;
    private static JTextArea taConsole;
    private boolean showConsole = false;
    private int consoleSize = 0;
    private PrintStream consolePrintStream;

    public Console() {
        frame = new JFrame("");
        taConsole = new JTextArea();
        taConsole.setEditable(false);
        taConsole.setLineWrap(true);
        taConsole.setWrapStyleWord(true);
        document = taConsole.getDocument();
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Console.this.dispose();
            }
        });
        JButton clearButton = new JButton(ResourceManager.getString(CONSOLE_CLEAR));
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Document doc = document;
                if (doc != null) {
                    try {
                        doc.remove(0, document.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        Container parent = frame.getContentPane();
        parent.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.fill = 1;
        cons.insets = new Insets(2, 2, 5, 2);
        parent.add((Component)new JScrollPane(taConsole), cons);
        cons.gridy = 1;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weighty = 0.0;
        cons.weightx = 0.0;
        cons.insets.top = 0;
        cons.insets.bottom = 2;
        parent.add((Component)clearButton, cons);
        this.init();
        Logger.getInstance().info("Log record in " + Logger.getLogFile());
        this.consolePrintStream.println("Log record in " + Logger.getLogFile());
    }

    private void init() {
        this.consolePrintStream = new PrintStream(this);
        try {
            this.showConsole = ConfigManager.load().isShowConsole();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void show() {
        if (frame != null && this.showConsole) {
            frame.pack();
            frame.setBounds(10, 10, 410, 310);
            frame.setTitle(ResourceManager.getString(CONSOLE_TITLE));
            frame.show();
        } else {
            this.dispose();
        }
    }

    public void write(int b) throws IOException {
        Logger.getInstance().info(String.valueOf((char)b));
        this.insert(String.valueOf((char)b));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        Logger.getInstance().info(new String(b, off, len));
        this.insert(new String(b, off, len));
    }

    private void insert(String string) {
        if (document != null && taConsole != null) {
            try {
                int length = document.getLength();
                if (length > this.consoleSize && this.consoleSize > 0) {
                    document.remove(0, length - this.consoleSize);
                    length = this.consoleSize;
                }
                document.insertString(length, string, null);
                if (taConsole.getCaretPosition() == length) {
                    taConsole.setCaretPosition(length + string.length());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void dispose() {
    }

    public static void main(String[] args) {
        new Console().show();
    }
}

