/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.services.IAdminOrgUnitService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IAdminOrgUnitService"})
@Description(value="")
public class AdminOrgUnitService
extends BusinessServices
implements IAdminOrgUnitService {
    public AdminOrgUnitService(Context context) {
        super(context);
    }

    @Override
    public Set getApplierAdminOrgUnitIds() throws BOSException, EASBizException {
        return CommonDataUtils.getApplierAdminOrgUnitIds(this.getContext());
    }

    @Override
    public Map getAdminAndCompanyFilter() throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        Context context = this.getContext();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        List companyOrgUnitIds = OrgRangeFactory.getLocalInstance((Context)this.getContext()).getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (companyOrgUnitIds == null || companyOrgUnitIds.size() == 0) {
            return result;
        }
        StringBuffer companyOrgUnitIdsBuffer = new StringBuffer();
        for (int i = 0; i < companyOrgUnitIds.size(); ++i) {
            companyOrgUnitIdsBuffer.append("'").append(companyOrgUnitIds.get(i)).append("',");
        }
        companyOrgUnitIdsBuffer.deleteCharAt(companyOrgUnitIdsBuffer.length() - 1);
        result.put("companyIds", companyOrgUnitIdsBuffer.toString());
        String adminOrgUnitIds = this.getAdminOrgIdsByCompany(companyOrgUnitIds, context);
        result.put("adminIds", adminOrgUnitIds);
        return result;
    }

    @Override
    public Map<String, String> getEqAndChildCUAdminIds() throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        Context context = this.getContext();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        AdminOrgUnitInfo primaryAdminOrgUnit = PersonFactory.getLocalInstance((Context)context).getPrimaryAdminOrgUnit(user.getPerson().getId());
        CtrlUnitInfo currentCU = primaryAdminOrgUnit.getCU();
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)context).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(currentCU.getId()));
        result.put("parentCUId", ctrlUnitInfo.getParent().getId().toString());
        result.put("currentCUNumber", ctrlUnitInfo.getNumber());
        TreeBaseCollection eqCU = CtrlUnitFactory.getLocalInstance((Context)context).getChildren((TreeBaseInfo)ctrlUnitInfo.getParent());
        ArrayList<String> cuIds = new ArrayList<String>();
        int is = eqCU.size();
        for (int i = 0; i < is; ++i) {
            cuIds.add(eqCU.get(i).getId().toString());
        }
        TreeBaseCollection allChildren = CtrlUnitFactory.getLocalInstance((Context)this.getContext()).getAllChildren((TreeBaseInfo)currentCU);
        int js = allChildren.size();
        for (int j = 0; j < js; ++j) {
            cuIds.add(allChildren.get(j).getId().toString());
        }
        EntityViewInfo adminEntityViewInfo = new EntityViewInfo();
        FilterInfo queryAdminFilter = new FilterInfo();
        queryAdminFilter.getFilterItems().add(new FilterItemInfo("cu.id", new HashSet(cuIds), CompareType.INCLUDE));
        adminEntityViewInfo.setFilter(queryAdminFilter);
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)this.getContext()).getAdminOrgUnitCollection(adminEntityViewInfo);
        ArrayList<String> adminOrgUnitIds = new ArrayList<String>();
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        int ks = adminOrgUnitCollection.size();
        for (int k = 0; k < ks; ++k) {
            adminOrgUnitIds.add(adminOrgUnitCollection.get(k).getId().toString());
            adminOrgUnitIdsBuffer.append("'").append(adminOrgUnitCollection.get(k).getId().toString()).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        result.put("adminIds", adminOrgUnitIdsBuffer.toString());
        return result;
    }

    private String getAdminOrgIdsByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet<String>(companyOrgUnitIds), CompareType.INCLUDE));
        filterInfo.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        for (int i = 0; i < orgUnitRelations.size(); ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            String fromUnitId = orgUnitRelationInfo.getFromUnit().getId().toString();
            adminOrgUnitIdsBuffer.append("'").append(fromUnitId).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        return adminOrgUnitIdsBuffer.toString();
    }

    @Override
    public String getAdminIdsByCompany(String companyId) throws BOSException, EASBizException {
        StringBuffer adminSb = new StringBuffer();
        OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext()).getFromUnit(companyId, 1, 0);
        for (OrgUnitInfo unitInfo : unitColl) {
            adminSb.append("'").append(unitInfo.getId().toString()).append("',");
        }
        adminSb.deleteCharAt(adminSb.length() - 1);
        return adminSb.toString();
    }

    @Override
    public Map getCompanysMapByAdmins(List adminIds) throws BOSException, EASBizException {
        HashMap<String, CommonDataObject> result = new HashMap<String, CommonDataObject>();
        Iterator it = adminIds.iterator();
        while (it.hasNext()) {
            String adminId = it.next().toString();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)this.getContext()).getToUnit(adminId, 0, 1).get(0);
            CommonDataObject companyInfo = new CommonDataObject();
            companyInfo.setBosType(company.getBOSType().toString());
            companyInfo.put((Object)"id", (Object)company.getId().toString());
            companyInfo.put((Object)"number", (Object)company.getNumber().toString());
            companyInfo.put((Object)"name", (Object)company.getName().toString());
            result.put(adminId, companyInfo);
        }
        return result;
    }

    @Override
    public CommonDataObject getCompanyByAdminId(String adminId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)this.getContext()).getToUnit(adminId, 0, 1).get(0);
        CommonDataObject companyInfo = new CommonDataObject();
        companyInfo.setBosType(company.getBOSType().toString());
        companyInfo.put((Object)"id", (Object)company.getId().toString());
        companyInfo.put((Object)"number", (Object)company.getNumber().toString());
        companyInfo.put((Object)"name", (Object)company.getName().toString());
        return companyInfo;
    }
}

