/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUCollection;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUFactory;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUInfo;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonCollection;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonFactory;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonInfo;
import com.kingdee.eas.cp.bc.EvectionStandardCollection;
import com.kingdee.eas.cp.bc.EvectionStandardFactory;
import com.kingdee.eas.cp.bc.EvectionStandardGroupCollection;
import com.kingdee.eas.cp.bc.EvectionStandardGroupFactory;
import com.kingdee.eas.cp.bc.EvectionStandardGroupInfo;
import com.kingdee.eas.cp.bc.EvectionStandardInfo;
import com.kingdee.eas.cp.bc.IEvectionStandard;
import com.kingdee.eas.cp.bc.IEvectionStandardAssignCU;
import com.kingdee.eas.cp.bc.IEvectionStandardAssignPerson;
import com.kingdee.eas.cp.bc.ReimburseLevelCollection;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.app.control.ControlFactory;
import com.kingdee.eas.cp.bc.app.control.IControl;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.cp.bc.services.IEvectionStandardService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IEvectionStandardService"})
@Description(value="")
public class EvectionStandardService
extends BusinessServices
implements IEvectionStandardService {
    public EvectionStandardService(Context context) {
        super(context);
    }

    @Override
    public List<Map<String, Object>> initGroupTree() throws BOSException, EASBizException {
        EvectionStandardGroupCollection evectionStandardGroupCollection = EvectionStandardGroupFactory.getLocalInstance((Context)this.getContext()).getEvectionStandardGroupCollection();
        ArrayList<Map<String, Object>> treeList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < evectionStandardGroupCollection.size(); ++i) {
            EvectionStandardGroupInfo evectionStandardGroupInfo = evectionStandardGroupCollection.get(i);
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            nodeMap.put("id", evectionStandardGroupInfo.getId().toString());
            nodeMap.put("name", evectionStandardGroupInfo.getName());
            nodeMap.put("pId", "root");
            treeList.add(nodeMap);
        }
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("id", "root");
        rootMap.put("tId", "root");
        rootMap.put("name", "\u5dee\u65c5\u6807\u51c6");
        rootMap.put("open", true);
        treeList.add(rootMap);
        return treeList;
    }

    @Override
    public void delGroup(String groupId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)groupId)) {
            return;
        }
        Context context = this.getContext();
        CoreBaseCollection existEvectionSts = EvectionStandardFactory.getLocalInstance((Context)context).getCollection("where group.id = '" + groupId + "'");
        if (existEvectionSts.size() > 0) {
            throw new StandardException(StandardException.EVECTIONSTANDARD_GROUP_EXIST_ST);
        }
        EvectionStandardGroupFactory.getLocalInstance((Context)this.getContext()).delete((IObjectPK)new ObjectUuidPK(groupId));
    }

    @Override
    public List<Map<String, Object>> enableEvectionStandard(List<Map<String, Object>> evectionStandards, boolean enable) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (evectionStandards == null || evectionStandards.size() == 0) {
            return resultList;
        }
        StringBuffer queryExistSql = new StringBuffer();
        String querySql = "SELECT FID WHERE ";
        String whereSql = "CURRENCYTYPE.ID = '%s' AND REIMBURSELEVEL.ID = '%s' AND AREA.ID = '%s' AND STATE = 1 AND ID != '%s'";
        IEvectionStandard evectionStInstance = EvectionStandardFactory.getLocalInstance((Context)this.getContext());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        for (Map<String, Object> evectionStandard : evectionStandards) {
            String evectionStId = evectionStandard.get("id").toString();
            EvectionStandardInfo evectionStInfo = new EvectionStandardInfo();
            evectionStInfo.setId(BOSUuid.read((String)evectionStId));
            if (!enable) {
                evectionStInfo.setState(EnableStateEnum.DISABLE);
                evectionStInstance.updatePartial(evectionStInfo, selector);
                continue;
            }
            queryExistSql = new StringBuffer();
            queryExistSql.append(querySql);
            queryExistSql.append(String.format(whereSql, evectionStandard.get("currencyType.id"), evectionStandard.get("reimburseLevel.id"), evectionStandard.get("area.id"), evectionStId));
            CoreBaseCollection existCollection = evectionStInstance.getCollection(queryExistSql.toString());
            if (existCollection.size() != 0) {
                HashMap<String, String> failEvectionst = new HashMap<String, String>();
                failEvectionst.put("id", evectionStId);
                failEvectionst.put("name", evectionStandard.get("name").toString());
                resultList.add(failEvectionst);
                continue;
            }
            evectionStInfo.setState(EnableStateEnum.ENABLE);
            evectionStInstance.updatePartial(evectionStInfo, selector);
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> queryAssignPerson(String evectionStandardId) throws BOSException, EASBizException, SQLException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.EvectionStandardAssignPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)1));
        filterInfo.setMaskString("#0 AND #1");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        while (rowSet.next()) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            personMap.put("id", (String)rowSet.getObject("person.id"));
            personMap.put("name", (String)rowSet.getObject("person.name"));
            personMap.put("number", (String)rowSet.getObject("person.number"));
            personMap.put("AdminOrgUnit.name", (String)rowSet.getObject("adminOrgUnit.name"));
            resultList.add(personMap);
        }
        return resultList;
    }

    @Override
    public String saveEvectionStandard(IObjectValue model) throws BOSException, EASBizException {
        EvectionStandardInfo info = (EvectionStandardInfo)model;
        CtrlUnitInfo currentCtrlUnit = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String currentCuId = currentCtrlUnit.getId().toString();
        String reimburseLevelId = info.getReimburseLevel().getId().toString();
        String currencyTypeId = info.getCurrencyType().getId().toString();
        String travelAreaId = info.getArea().getId().toString();
        String id = info.getId().toString();
        String oql = " where reimburseLevel = '%s' and currencyType.id = '%s' and area.id = '%s' and id != '%s' and cu.id = '%s' and state = %s";
        oql = String.format(oql, reimburseLevelId, currencyTypeId, travelAreaId, id, currentCuId, 1);
        EvectionStandardCollection existEvectionSts = EvectionStandardFactory.getLocalInstance((Context)this.getContext()).getEvectionStandardCollection(oql);
        if (existEvectionSts.size() > 0) {
            throw new StandardException(StandardException.ACCOUNTSTANDARD_UNIQUE);
        }
        IObjectPK objectPk = EvectionStandardFactory.getLocalInstance((Context)this.getContext()).save((CoreBaseInfo)info);
        id = objectPk.toString();
        String evectionStandardId = (String)model.get("id");
        String personsStr = (String)model.get("persons");
        List personIds = (List)JSONUtils.convertJsonToObject((Context)this.getContext(), (String)personsStr, (Type)new TypeToken<List<String>>(){}.getType());
        this.assignPerson(evectionStandardId, personIds);
        return id;
    }

    public void assignPerson(String evectionStandardId, List<String> personIds) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)evectionStandardId)) {
            return;
        }
        FilterInfo delFilter = new FilterInfo();
        delFilter.getFilterItems().add(new FilterItemInfo("evectionStandard", (Object)evectionStandardId));
        EvectionStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).delete(delFilter);
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        CoreBaseCollection evectionStandardAssigns = new CoreBaseCollection();
        EvectionStandardInfo evectionStandardInfo = new EvectionStandardInfo();
        evectionStandardInfo.setId(BOSUuid.read((String)evectionStandardId));
        for (String personId : personIds) {
            EvectionStandardAssignPersonInfo evectionStandardAssignPersonInfo = new EvectionStandardAssignPersonInfo();
            evectionStandardAssignPersonInfo.setEvectionStandard(evectionStandardInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            evectionStandardAssignPersonInfo.setPerson(personInfo);
            evectionStandardAssigns.add((CoreBaseInfo)evectionStandardAssignPersonInfo);
        }
        EvectionStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).addnewBatchData(evectionStandardAssigns);
    }

    @Override
    public List<Map<String, Object>> assignPerson(Map evectionStandard, List<Map> persons) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>();
        IEvectionStandardAssignPerson evectionStAssignPersonFactory = EvectionStandardAssignPersonFactory.getLocalInstance((Context)this.getContext());
        FilterInfo queryExistFilter = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String evectionStId = (String)evectionStandard.get("id");
        String evectionStName = (String)evectionStandard.get("name");
        String currencyType = (String)evectionStandard.get("currencyType.id");
        String travelArea = (String)evectionStandard.get("area.id");
        Set assignPersonIds = CommonDataUtils.getIds(persons);
        queryExistFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)assignPersonIds, CompareType.INCLUDE));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.currencyType.id", (Object)currencyType, CompareType.EQUALS));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.area.id", (Object)travelArea, CompareType.EQUALS));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.NOTEQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.id"));
        entityViewInfo.setFilter(queryExistFilter);
        entityViewInfo.setSelector(selector);
        EvectionStandardAssignPersonCollection evecStAssignPersons = evectionStAssignPersonFactory.getEvectionStandardAssignPersonCollection(entityViewInfo);
        Set<String> existAssignPersonIds = CommonDataUtils.getPropIds((AbstractObjectCollection)evecStAssignPersons, "person");
        ArrayList<String> errorPersonList = new ArrayList<String>();
        EvectionStandardInfo evectionStandardInfo = new EvectionStandardInfo();
        evectionStandardInfo.setId(BOSUuid.read((String)evectionStId));
        CoreBaseCollection assignPersons = new CoreBaseCollection();
        int is = persons.size();
        for (int i = 0; i < is; ++i) {
            String personId = (String)persons.get(i).get("id");
            if (existAssignPersonIds.contains(personId)) {
                String personName = (String)persons.get(i).get("name");
                errorPersonList.add(personName);
                continue;
            }
            EvectionStandardAssignPersonInfo assignPerson = new EvectionStandardAssignPersonInfo();
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            assignPerson.setPerson(person);
            assignPerson.setEvectionStandard(evectionStandardInfo);
            assignPersons.add((CoreBaseInfo)assignPerson);
        }
        if (errorPersonList.size() != 0) {
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("standardName", evectionStName);
            errorMap.put("personList", errorPersonList);
            errorList.add(errorMap);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.EQUALS));
        evectionStAssignPersonFactory.delete(delFilterInfo);
        if (assignPersons.size() != 0) {
            evectionStAssignPersonFactory.addnewBatchData(assignPersons);
        }
        return errorList;
    }

    @Override
    public List<Map<String, Object>> assignCu(List<Map> evectionStandards, List<Map> cus) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>();
        IEvectionStandardAssignCU evectionStAssignCuFactory = EvectionStandardAssignCUFactory.getLocalInstance((Context)this.getContext());
        CoreBaseCollection assignCus = new CoreBaseCollection();
        Set assignCuIds = CommonDataUtils.getIds(cus);
        Set assignStandardIds = CommonDataUtils.getIds(evectionStandards);
        int is = evectionStandards.size();
        for (int i = 0; i < is; ++i) {
            Map evectionStandard = evectionStandards.get(i);
            String evectionStId = (String)evectionStandard.get("id");
            String evectionStName = (String)evectionStandard.get("name");
            String travelArea = (String)evectionStandard.get("area.id");
            String currencyType = (String)evectionStandard.get("currencyType.id");
            String reimburseLevel = (String)evectionStandard.get("reimburseLevel.id");
            EvectionStandardInfo evectionSt = new EvectionStandardInfo();
            evectionSt.setId(BOSUuid.read((String)evectionStId));
            FilterInfo queryExistFilter = new FilterInfo();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            queryExistFilter.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)assignCuIds, CompareType.INCLUDE));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.currencyType.id", (Object)currencyType, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.area.id", (Object)travelArea, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.reimburseLevel.id", (Object)reimburseLevel, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.NOTEQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("assignCU.id"));
            entityViewInfo.setSelector(selector);
            entityViewInfo.setFilter(queryExistFilter);
            CoreBaseCollection existAssignCus = evectionStAssignCuFactory.getCollection(entityViewInfo);
            Set<String> existCuIds = CommonDataUtils.getPropIds((AbstractObjectCollection)existAssignCus, "assignCU");
            ArrayList<String> errorCuList = new ArrayList<String>();
            int js = cus.size();
            for (int j = 0; j < js; ++j) {
                String cuId = (String)cus.get(j).get("id");
                if (existCuIds.contains(cuId)) {
                    String cuName = (String)cus.get(j).get("name");
                    errorCuList.add(cuName);
                    continue;
                }
                EvectionStandardAssignCUInfo evectionStAssignCu = new EvectionStandardAssignCUInfo();
                evectionStAssignCu.setEvectionStandard(evectionSt);
                CtrlUnitInfo assignCu = new CtrlUnitInfo();
                assignCu.setId(BOSUuid.read((String)cuId));
                evectionStAssignCu.setAssignCU(assignCu);
                assignCus.add((CoreBaseInfo)evectionStAssignCu);
            }
            if (errorCuList.size() == 0) continue;
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("standardName", evectionStName);
            errorMap.put("cuList", errorCuList);
            errorList.add(errorMap);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)assignStandardIds, CompareType.INCLUDE));
        evectionStAssignCuFactory.delete(delFilterInfo);
        if (assignCus.size() != 0) {
            evectionStAssignCuFactory.addnewBatchData(assignCus);
        }
        return errorList;
    }

    @Override
    public Map<String, Object> initEvectionStandardView(String evectionStandardId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)evectionStandardId)) {
            return resultMap;
        }
        List<String> eqAndChildCuIds = CommonDataUtils.getEqAndChildCuIds(this.getContext());
        resultMap.put("cuIds", eqAndChildCuIds);
        ArrayList<String> evectionStandardIds = new ArrayList<String>();
        evectionStandardIds.add(evectionStandardId);
        Set<String> assignCUIds = this.getAssignCUIds(evectionStandardIds);
        resultMap.put("assignCUIds", new ArrayList<String>(assignCUIds));
        HashSet<String> personIds = new HashSet<String>();
        FilterInfo queryPersonFilter = new FilterInfo();
        queryPersonFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryPersonFilter);
        EvectionStandardAssignPersonCollection evectionStandardAssignPersonCollection = EvectionStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).getEvectionStandardAssignPersonCollection(entityViewInfo);
        int l = evectionStandardAssignPersonCollection.size();
        for (int i = 0; i < l; ++i) {
            personIds.add(evectionStandardAssignPersonCollection.get(i).getPerson().getId().toString());
        }
        resultMap.put("assignPersonIds", new ArrayList(personIds));
        List<String> adminOrgUnitIds = CommonDataUtils.getEqAndChildCuAdminIds(this.getContext(), eqAndChildCuIds);
        resultMap.put("adminOrgUnitIds", adminOrgUnitIds);
        return resultMap;
    }

    @Override
    public void cancelEvectionStandardAssign(String type, String evectionStandardId, String assignId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if ("cu".equals(type)) {
            IEvectionStandardAssignCU evectionStandardFacotry = EvectionStandardAssignCUFactory.getLocalInstance((Context)this.getContext());
            filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)assignId));
            filterInfo.setMaskString("#0 And #1");
            evectionStandardFacotry.delete(filterInfo);
        } else if ("person".equals(type)) {
            IEvectionStandardAssignPerson evectionStandardFactory = EvectionStandardAssignPersonFactory.getLocalInstance((Context)this.getContext());
            filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)assignId));
            filterInfo.setMaskString("#0 And #1");
            evectionStandardFactory.delete(filterInfo);
        }
    }

    @Override
    public Set<String> getAssignCUIds(List<String> evectionStandardIds) throws BOSException, EASBizException {
        if (evectionStandardIds == null || evectionStandardIds.size() == 0) {
            return null;
        }
        HashSet<String> assignCuIds = new HashSet<String>();
        IEvectionStandardAssignCU evectionSTAssignCUFactory = EvectionStandardAssignCUFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard", new HashSet<String>(evectionStandardIds), CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        EvectionStandardAssignCUCollection evectionSTAssignCUs = evectionSTAssignCUFactory.getEvectionStandardAssignCUCollection(entityViewInfo);
        int is = evectionSTAssignCUs.size();
        for (int i = 0; i < is; ++i) {
            assignCuIds.add(evectionSTAssignCUs.get(i).getAssignCU().getId().toString());
        }
        return assignCuIds;
    }

    @Override
    public Map<String, Object> initEvectionStandardAssign(List<String> evectionStandardIds) throws BOSException, EASBizException, SQLException {
        if (evectionStandardIds == null || evectionStandardIds.size() == 0) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set<String> assignCUIds = this.getAssignCUIds(evectionStandardIds);
        resultMap.put("assignCUIds", new ArrayList<String>(assignCUIds));
        List<String> eqAndChildCuIds = CommonDataUtils.getEqAndChildCuIds(this.getContext());
        resultMap.put("cuIds", eqAndChildCuIds);
        return resultMap;
    }

    @Override
    public List<Map> fetchEvectionStandard(IObjectValue billInfo) throws BOSException, EASBizException, SQLException {
        IControl travelControl = ControlFactory.createTravelControl();
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("billinfo", billInfo);
        List resultList = travelControl.check(this.getContext(), StaffLevelAttriEnum.USERDEFINED, paramMap);
        return resultList;
    }

    @Override
    public List<Map<String, Object>> queryPersonEvectionSt() throws BOSException, EASBizException, SQLException {
        Context context = this.getContext();
        UserInfo user = (UserInfo)this.getContext().get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        List queryPersonEvectionSt = ControlUtil.queryPersonEvectionSt((Context)context, (String)personId);
        return queryPersonEvectionSt;
    }

    @Override
    public IObjectValue initEvectionStandardCreate(IObjectValue model) throws BOSException, EASBizException {
        EvectionStandardInfo evectionStandardInfo = (EvectionStandardInfo)model;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String oql = "select baseCurrency.id, baseCurrency.name where id = '" + company.getId().toString() + "'";
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo(oql);
        CurrencyInfo baseCurrency = companyOrgUnitInfo.getBaseCurrency();
        evectionStandardInfo.setCurrencyType(baseCurrency);
        List<String> adminOrgUnitIds = CommonDataUtils.getEqAndChildCuAdminIds(this.getContext(), null);
        HashMap<String, List<String>> initData = new HashMap<String, List<String>>();
        initData.put("adminOrgUnitIds", adminOrgUnitIds);
        evectionStandardInfo.put("initData", initData);
        return evectionStandardInfo;
    }

    @Override
    public IObjectValue initEvectionStandardEdit(IObjectValue model) throws BOSException, EASBizException {
        List<String> adminOrgUnitIds = CommonDataUtils.getEqAndChildCuAdminIds(this.getContext(), null);
        HashMap<String, List<String>> initData = new HashMap<String, List<String>>();
        initData.put("adminOrgUnitIds", adminOrgUnitIds);
        model.put("initData", initData);
        return model;
    }

    @Override
    public List<Map<String, Object>> getGroupFilter() throws EASBizException, BOSException, SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> reimburseLevelGroup = new HashMap<String, Object>();
        reimburseLevelGroup.put("field", "reimburseLevel");
        reimburseLevelGroup.put("dataType", "ObjectValue");
        reimburseLevelGroup.put("title", "\u804c\u5458\u7ea7\u522b");
        reimburseLevelGroup.put("mitiSelect", "false");
        reimburseLevelGroup.put("displayCount", 8);
        reimburseLevelGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        ReimburseLevelCollection reimburseLevelCollection = ReimburseLevelFactory.getLocalInstance((Context)this.getContext()).getReimburseLevelCollection();
        int is = reimburseLevelCollection.size();
        for (int i = 0; i < is; ++i) {
            ReimburseLevelInfo reimburseLevelInfo = reimburseLevelCollection.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", reimburseLevelInfo.getName());
            filterMap.put("value", reimburseLevelInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        reimburseLevelGroup.put("filterItems", filterItems);
        resultList.add(reimburseLevelGroup);
        return resultList;
    }
}

