/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BcParamInfo;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.reverse.BillReverse;
import com.kingdee.eas.cp.bc.services.IExpenseCommenFacadeService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IExpenseCommenFacadeService"})
@Description(value="")
public class ExpenseCommenFacadeService
extends BusinessServices
implements IExpenseCommenFacadeService {
    public ExpenseCommenFacadeService(Context context) {
        super(context);
    }

    @Override
    public String getBudget(CommonDataObject billInfo, CommonDataObject expenseType, CommonDataObject operationType, CommonDataObject costCenter, String id) throws BOSException, EASBizException {
        BizCollBillBaseInfo bill = (BizCollBillBaseInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)billInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (expenseType != null) {
            map.put("expenseType", CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)expenseType));
        }
        if (operationType != null) {
            map.put("operationType", CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)operationType));
        }
        if (costCenter != null) {
            map.put("costCenter", CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)costCenter));
        }
        if (id != null) {
            map.put("sourceEntryId", id);
        }
        try {
            IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
            String labelText = iExpenseCommenFacade.getBudget(bill, bill.getId(), map);
            return labelText;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<String> getBudgets(CommonDataObject model) throws BOSException, EASBizException {
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)model);
        if (info instanceof OtherExpenseBillInfo) {
            return this.getBudgetsForOtherExpense((OtherExpenseBillInfo)info);
        }
        if (info instanceof DailyLoanBillInfo) {
            return this.getBudgetsForDailyLoan((DailyLoanBillInfo)info);
        }
        if (info instanceof BizAccountBillInfo) {
            return this.getBudgetsForBizAccount((BizAccountBillInfo)info);
        }
        if (info instanceof EvectionReqBillInfo) {
            return this.getBudgetsForEvectionReq((EvectionReqBillInfo)info);
        }
        if (info instanceof EvectionLoanBillInfo) {
            return this.getBudgetsForEvectionLoan((EvectionLoanBillInfo)info);
        }
        if (info instanceof TravelAccountBillInfo) {
            return this.getBudgetsForTravelAccount((TravelAccountBillInfo)info);
        }
        return new ArrayList<String>();
    }

    private List<String> getBudgetsForOtherExpense(OtherExpenseBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        OtherExpenseBillInfo clone = (OtherExpenseBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            OtherExpenseBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForDailyLoan(DailyLoanBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        DailyLoanBillInfo clone = (DailyLoanBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            DailyLoanBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForBizAccount(BizAccountBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        BizAccountBillInfo clone = (BizAccountBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            BizAccountBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("operationType", operationType);
            map.put("costCenter", costCenter);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            if (budget == null) {
                budget = "";
            }
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForEvectionReq(EvectionReqBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        EvectionReqBillInfo clone = (EvectionReqBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            EvectionReqBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForEvectionLoan(EvectionLoanBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        EvectionLoanBillInfo clone = (EvectionLoanBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            EvectionLoanBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForTravelAccount(TravelAccountBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext());
        TravelAccountBillInfo clone = (TravelAccountBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            TravelAccountBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expenseType", expenseType);
            map.put("operationType", operationType);
            map.put("costCenter", costCenter);
            map.put("sourceEntryId", sourceEntryId);
            String budget = iExpenseCommenFacade.getBudget((BizCollBillBaseInfo)clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private ExpenseTypeInfo getExpenseType(ExpenseTypeInfo expenseType) throws EASBizException, BOSException {
        if (expenseType == null || expenseType.getId() == null) {
            return expenseType;
        }
        if (expenseType.getNumber() != null && expenseType.getName() != null && expenseType.getTypeName() != null) {
            return expenseType;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("typeName");
        selector.add("operationType.id");
        selector.add("operationType.number");
        selector.add("operationType.name");
        ExpenseTypeInfo result = ExpenseTypeFactory.getLocalInstance((Context)this.getContext()).getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(expenseType.getId().toString()), selector);
        return result;
    }

    @Override
    public Map getParams(List paramList) throws BOSException, EASBizException {
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        return paramMap;
    }

    @Override
    public Boolean checkBillHasNextBill(CommonDataObject info) throws BOSException, EASBizException, SQLException {
        return CommonDataUtils.checkBillHasNextBill(this.getContext(), info);
    }

    @Override
    public Boolean checkBillHasRePaybill(CommonDataObject info) throws BOSException, EASBizException, SQLException {
        return CommonDataUtils.checkBillHasRePaybill(this.getContext(), info);
    }

    @Override
    public void reBgForCheckEntry(CommonDataObject info) throws BOSException, EASBizException {
        BizCollBillBaseInfo billInfo;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP029");
        paramList.add("CP030");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        boolean loanUseBg = false;
        boolean reqBillUseBg = false;
        if (Boolean.valueOf(paramMap.get("CP029").toString()).booleanValue()) {
            loanUseBg = true;
        }
        if (Boolean.valueOf(paramMap.get("CP030").toString()).booleanValue()) {
            reqBillUseBg = true;
        }
        if ((billInfo = (BizCollBillBaseInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)info)) instanceof ExpenseAccountBillInfo || billInfo instanceof DailyLoanBillInfo) {
            BizCollBillBaseInfo baseInfo = null;
            try {
                baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)this.getContext()).getValue(billInfo.getId().getType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), BizCollUtil.getBudgetSelector());
            }
            catch (Exception e) {
                // empty catch block
            }
            CommonUtilFacadeFactory.getLocalInstance((Context)this.getContext()).deleteBotpRelations(billInfo.getId().toString());
            CommonUtilFacadeFactory.getLocalInstance((Context)this.getContext()).createBotpRelations(billInfo);
            if (baseInfo != null && billInfo.getState().equals((Object)StateEnum.CHECKING)) {
                BillReverse reverse = new BillReverse();
                reverse.doReverseAmountBalance(this.getContext(), baseInfo, "returnBudget");
                reverse.doReverseBg(this.getContext(), baseInfo, "returnBudget", reqBillUseBg, loanUseBg);
                reverse.doReverseAmountBalance(this.getContext(), billInfo, "bgAudit");
                reverse.doReverseBg(this.getContext(), billInfo, "bgAudit", reqBillUseBg, loanUseBg);
            }
        }
    }

    @Override
    public String getAccount(String applierId, String costedDeptId, String currencyTypeId, String orgUnitId) throws BOSException, EASBizException {
        Map map = new HashMap();
        String tempStr = null;
        BcParamInfo bcParamInfo = null;
        PersonInfo person = null;
        CostCenterOrgUnitInfo costcenter = null;
        CurrencyInfo currency = null;
        AdminOrgUnitInfo adminOrgUnit = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        String loanBalanceAccountNumber = null;
        String loanBalanceShowName = null;
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        if (applierId != null && applierId.length() > 1) {
            person = PersonFactory.getLocalInstance((Context)this.getContext()).getPersonInfo((IObjectPK)new ObjectUuidPK(applierId), selector);
        }
        if (costedDeptId != null && costedDeptId.length() > 1) {
            costcenter = CostCenterOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costedDeptId), selector);
        }
        if (currencyTypeId != null && currencyTypeId.length() > 1) {
            currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyTypeId), selector);
        }
        if (orgUnitId != null && orgUnitId.length() > 1) {
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)this.getContext()).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), selector);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP012");
        paramList.add("CP013");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        loanBalanceAccountNumber = paramMap.get("CP012") == null ? null : paramMap.get("CP012").toString();
        loanBalanceShowName = paramMap.get("CP013") == null ? null : paramMap.get("CP013").toString();
        map = CommonUtilFacadeFactory.getLocalInstance((Context)this.getContext()).getAccount(person, costcenter, currency, adminOrgUnit, loanBalanceAccountNumber);
        tempStr = (String)map.get("tempStr");
        bcParamInfo = (BcParamInfo)map.get("bcParamInfo");
        if (bcParamInfo == null) {
            throw new BOSException("\u5907\u7528\u91d1\u8f85\u52a9\u8d26\u7c7b\u578b\u672a\u8bbe\u7f6e\uff01");
        }
        if (tempStr == null || tempStr.equals("")) {
            tempStr = "0.00";
        }
        StringBuffer sb = new StringBuffer();
        if (bcParamInfo != null) {
            if (!(bcParamInfo.isOrgUnitParam() || bcParamInfo.isCostCenterParam() || bcParamInfo.isPersonParam())) {
                tempStr = "0.00";
            }
            if (bcParamInfo.isOrgUnitParam() && adminOrgUnit != null) {
                sb.append(adminOrgUnit.getName());
                sb.append("  |  ");
            }
            if (bcParamInfo.isCostCenterParam() && costcenter != null) {
                sb.append(costcenter.getName());
                sb.append("  |  ");
            }
            if (bcParamInfo.isPersonParam() && person != null) {
                sb.append(person.getName());
                sb.append("  |  ");
            }
            tempStr = this.parseString(tempStr, "0.00");
            if (sb.length() > 0) {
                sb.append(loanBalanceShowName).append("\u4f59\u989d\u4e3a").append(tempStr);
            }
            return sb.toString();
        }
        return null;
    }

    private String parseString(String str, String back) {
        if (str == null || str.trim().length() == 0) {
            return back;
        }
        if (str.indexOf(46) > 0) {
            String tempStr = str.substring(str.indexOf(46) + 1);
            if (tempStr.length() < 2) {
                for (int i = 0; i < 2 - tempStr.length(); ++i) {
                    str = str + "0";
                }
                return str;
            }
            if (tempStr.length() == 2) {
                return str;
            }
            if (tempStr.length() > 2) {
                return str.substring(0, str.lastIndexOf(46) + 3);
            }
        }
        try {
            Integer d = new Integer(str);
            return str + ".00";
        }
        catch (NumberFormatException e) {
            return back;
        }
    }

    @Override
    public Boolean checkForBillClose(String id) throws BOSException, EASBizException, SQLException {
        return CommonDataUtils.checkForBillClose(this.getContext(), id);
    }

    @Override
    public String getSpecialData(String userId) throws BOSException, EASBizException {
        return CommonDataUtils.getSpecialData(this.getContext(), userId);
    }
}

