/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.services.IPersonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Component(value={"com.kingdee.eas.cp.bc.services.IPersonService"})
@Description(value="")
public class PersonService
extends BusinessServices
implements IPersonService {
    public PersonService(Context context) {
        super(context);
    }

    public String getPersonIdByUser(String userId) throws BOSException, EASBizException {
        if (userId == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            return userInfo.getPerson().getId().toString();
        }
        return null;
    }

    public Map getPrimaryAdminOrgUnit(List personIds) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        CommonDataObject info = new CommonDataObject();
        Iterator it = personIds.iterator();
        while (it.hasNext()) {
            ArrayList<CommonDataObject> list = new ArrayList<CommonDataObject>();
            String personId = (String)it.next();
            AdminOrgUnitInfo unitInfo = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)this.getContext()).getToUnit(unitInfo.getId().toString(), 0, 1).get(0);
            info.setBosType(unitInfo.getBOSType().toString());
            info.put((Object)"id", (Object)unitInfo.getId().toString());
            info.put((Object)"number", (Object)unitInfo.getNumber().toString());
            info.put((Object)"name", (Object)unitInfo.getName().toString());
            list.add(info);
            info.setBosType(companyInfo.getBOSType().toString());
            info.put((Object)"id", (Object)companyInfo.getId().toString());
            info.put((Object)"number", (Object)companyInfo.getNumber().toString());
            info.put((Object)"name", (Object)companyInfo.getName().toString());
            list.add(info);
            result.put(personId, list);
        }
        return result;
    }

    public Map getPersonAndAdminOrgIdByUser(String userId) throws BOSException, EASBizException {
        if (userId == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            String personId = userInfo.getPerson().getId().toString();
            AdminOrgUnitInfo adminOrg = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            if (adminOrg != null) {
                result.put("adminOrgId", adminOrg.getId().toString());
            }
            result.put("personId", personId);
        }
        return result;
    }
}

