/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountCollection;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDataUtils {
    public static String peronType = "person";
    public static String companyType = "company";

    public static boolean checkBillHasRePaybill(Context ctx, CommonDataObject info) throws BOSException, EASBizException, SQLException {
        boolean isHasRePaybill = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.get((Object)"id").toString(), CompareType.EQUALS));
        markString.append("#0 ");
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        IQueryExecutor exec = null;
        IDynamicObject iDynamicObject = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        while (rs.next()) {
            PaymentBillInfo paymentInfo;
            String billId = rs.getString("destObjectID");
            ObjectUuidPK objpk = new ObjectUuidPK(billId);
            if (!CommonDataUtils.isPayMentBill(billId) || BillStatusEnum.PAYED == (paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)objpk)).getBillStatus() || paymentInfo.getActPayLocAmt().compareTo(BizCollUtil.ZERO) >= 0) continue;
            isHasRePaybill = true;
        }
        return isHasRePaybill;
    }

    public static Map getOrgRangeByUser(Context ctx, String userId) throws BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (userId == null || userId.length() <= 0) {
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            userId = user.getId().toString();
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FLONGNUMBER, TPOR.FORGID ").append("FROM T_PM_ORGRANGE TPOR INNER JOIN T_ORG_COMPANY TOC ON TPOR.FORGID = TOC.FID ").append("WHERE TPOR.FTYPE = ? AND TPOR.FUSERID = ? ");
        Object[] params = new Object[]{10, userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
        if (rowSet != null) {
            while (rowSet.next()) {
                String id = rowSet.getObject("FORGID").toString();
                String longNumber = rowSet.getObject("FLONGNUMBER").toString();
                result.put(id, longNumber);
            }
        }
        return result;
    }

    public static List<String> getChildCompanyOrg(Context context) throws EASBizException, BOSException {
        ArrayList<String> companyOrgList = new ArrayList<String>();
        CompanyOrgUnitInfo currentCompanyOrgUnit = ContextUtil.getCurrentFIUnit((Context)context);
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        FilterInfo queryOrgRangeFilter = new FilterInfo();
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryOrgRangeFilter);
        OrgRangeCollection orgRangeCollection = OrgRangeFactory.getLocalInstance((Context)context).getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() == 0) {
            return companyOrgList;
        }
        StringBuffer oqlSb = new StringBuffer();
        oqlSb.append("select id where longNumber like '%").append(currentCompanyOrgUnit.getNumber()).append("!%' ").append("and id in (");
        int is = orgRangeCollection.size();
        for (int i = 0; i < is; ++i) {
            oqlSb.append("'").append(orgRangeCollection.get(i).getOrg().getId().toString()).append("',");
        }
        oqlSb.deleteCharAt(oqlSb.length() - 1);
        oqlSb.append(") ");
        CoreBaseCollection companyOrgUnits = CompanyOrgUnitFactory.getLocalInstance((Context)context).getCollection(oqlSb.toString());
        int js = companyOrgUnits.size();
        for (int j = 0; j < js; ++j) {
            companyOrgList.add(companyOrgUnits.get(j).getId().toString());
        }
        return companyOrgList;
    }

    public static List<String> getEqAndChildCompanyOrg(Context context) throws EASBizException, BOSException {
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        ArrayList<String> resultList = new ArrayList<String>();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)context);
        try {
            int i;
            Map orgRangeMap = CommonDataUtils.getOrgRangeByUser(context, user.getId().toString());
            ICompanyOrgUnit service = CompanyOrgUnitFactory.getLocalInstance((Context)context);
            TreeBaseCollection eqcom = service.getChildren((TreeBaseInfo)company.getParent());
            CompanyOrgUnitCollection companyCon = service.getCompanyOrgUnitCollection("select id where longNumber like '" + company.getLongNumber() + "%'");
            int is = companyCon.size();
            for (i = 0; i < is; ++i) {
                if (!orgRangeMap.containsKey(companyCon.get(i).getId().toString())) continue;
                resultList.add(companyCon.get(i).getId().toString());
            }
            is = eqcom.size();
            for (i = 0; i < is; ++i) {
                if (!orgRangeMap.containsKey(eqcom.get(i).getId().toString())) continue;
                resultList.add(eqcom.get(i).getId().toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<String> getEqAndChildPerson(Context context) throws EASBizException, BOSException {
        List<String> resultList = CommonDataUtils.getEqAndChildCompanyOrg(context);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT ADMINORGUNIT.fid ");
        selectSql.append(" FROM  T_ORG_PositionMember POSITIONMEMBER ");
        selectSql.append(" inner  JOIN T_ORG_Position POSITION  ON POSITIONMEMBER.FPositionID = POSITION.FID ");
        selectSql.append(" inner  JOIN T_ORG_Admin ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID ");
        selectSql.append(" where  POSITIONMEMBER.fisPrimary=1 and ADMINORGUNIT.FID IN (" + CommonDataUtils.getAdminOrgIdsByCompany(resultList, context) + ")  ");
        IRowSet set = DbUtil.executeQuery((Context)context, (String)selectSql.toString());
        resultList = new ArrayList<String>();
        try {
            while (set.next()) {
                resultList.add(set.getString("fid"));
            }
            return resultList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isPayMentBill(String id) {
        BOSObjectType bosType = null;
        PaymentBillInfo info = new PaymentBillInfo();
        bosType = info.getBOSType();
        return bosType.equals((Object)CommonDataUtils.getBOSType(id));
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    public static boolean checkBillHasNextBill(Context ctx, CommonDataObject info) throws BOSException, EASBizException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.get((Object)"id").toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        return rs.next();
    }

    public static boolean checkForBillClose(Context ctx, String id) throws BOSException, EASBizException, SQLException {
        boolean isPass = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)id, CompareType.EQUALS));
        markString.append("#0 ");
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        while (rs.next()) {
            ObjectUuidPK objpk;
            BizCollBillBaseInfo sourceinfo;
            String billId = rs.getString("destObjectID");
            if (CommonDataUtils.isPayMentBill(billId) || CommonDataUtils.isVoucher(billId) || StateEnum.CLOSED.equals((Object)(sourceinfo = (BizCollBillBaseInfo)iDynamicObject.getValue((objpk = new ObjectUuidPK(billId)).getObjectType(), (IObjectPK)objpk, CommonDataUtils.getSelector())).getState())) continue;
            isPass = false;
            break;
        }
        return isPass;
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    private static boolean isVoucher(String id) {
        BOSObjectType bosType = null;
        VoucherInfo info = new VoucherInfo();
        bosType = info.getBOSType();
        return bosType.equals((Object)CommonDataUtils.getBOSType(id));
    }

    public static Set getApplierAdminOrgUnitIds(Context ctx) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(company.getId().toString(), 1, 0);
        int size = 0;
        if (unitColl != null) {
            size = unitColl.size();
        }
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ids.add(unitColl.get(i).getId().toString());
            }
        }
        return ids;
    }

    public static Map getApplierRelatedInfo(Context ctx, String applierId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            PositionInfo curInfo;
            PositionCollection col = PersonFactory.getLocalInstance((Context)ctx).getPositions(BOSUuid.read((String)applierId));
            AdminOrgUnitCollection admins = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(BOSUuid.read((String)applierId));
            PositionInfo mainP = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(BOSUuid.read((String)applierId));
            AdminOrgUnitInfo mainAOrg = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)applierId));
            PositionInfo pos = new PositionInfo();
            pos.setId(mainP.getId());
            pos.setNumber(mainP.getNumber());
            pos.setName(mainP.getName());
            AdminOrgUnitInfo mainOrg = new AdminOrgUnitInfo();
            mainOrg.setId(mainAOrg.getId());
            mainOrg.setNumber(mainAOrg.getNumber());
            mainOrg.setName(mainAOrg.getName());
            Iterator it = col.iterator();
            StringBuffer sb = new StringBuffer();
            sb.append("id in (");
            while (it.hasNext()) {
                curInfo = (PositionInfo)it.next();
                sb.append("'").append(curInfo.getId().toString()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") and Person.id = '" + applierId + "' ");
            result.put("mainPosition", pos);
            result.put("positionFilter", sb.toString());
            it = admins.iterator();
            sb.setLength(0);
            sb.append("id in (");
            while (it.hasNext()) {
                curInfo = (AdminOrgUnitInfo)it.next();
                sb.append("'").append(curInfo.getId().toString()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            result.put("mainOrg", mainOrg);
            result.put("orgFilter", sb.toString());
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCostDeptFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        Boolean isDelimitOrgScope = false;
        Set orgRangeSet = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        Map paramMap = null;
        paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)ctx).getParams(paramList);
        isDelimitOrgScope = paramMap.get("CP019") == null ? false : new Boolean(paramMap.get("CP019").toString());
        if (isDelimitOrgScope.booleanValue()) {
            String userid = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
            orgRangeSet = CommonDataUtils.getOrgIdsByUserAndType(ctx, userid, OrgRangeType.BIZ_ORG_TYPE, null);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("CP019", isDelimitOrgScope);
        return CommonDataUtils.getCostDepFilter(ctx, companyId, map, orgRangeSet);
    }

    public static Set getOrgIdsByUserAndType(Context ctx, String userid, OrgRangeType orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)String.valueOf(orgRangeType.getValue())));
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filterColl.add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    private static String getCostDepFilter(Context ctx, String companyId, Map map, Set orgRangeIds) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isBizUnit", (Object)true));
        fic.add(new FilterItemInfo("isSealUp", (Object)false));
        filter.setMaskString("#0 and #1");
        OrgUnitCollection unitColl = null;
        if (StringUtils.isNotBlank((String)companyId) && !companyId.equals("null")) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(companyId, 1, 5);
        }
        Set<String> orgIdSet = new HashSet();
        Boolean isDelimitUserOrgScope = new Boolean(false);
        if (map != null && map.size() > 0) {
            isDelimitUserOrgScope = (Boolean)map.get("CP019");
        }
        if (isDelimitUserOrgScope != null && isDelimitUserOrgScope.booleanValue()) {
            Set setIds = orgRangeIds;
            if (setIds != null && setIds.size() > 0 && unitColl != null && unitColl.size() > 0) {
                String temp = null;
                for (int i = unitColl.size() - 1; i >= 0; --i) {
                    temp = unitColl.get(i).getId().toString();
                    if (!setIds.contains(temp)) continue;
                    orgIdSet.add(temp);
                }
            }
        } else if (unitColl != null) {
            for (int i = unitColl.size() - 1; i >= 0; --i) {
                String temp = unitColl.get(i).getId().toString();
                orgIdSet.add(temp);
            }
        }
        if ((StringUtils.isBlank((String)companyId) || companyId.equals("null")) && orgRangeIds != null) {
            orgIdSet = orgRangeIds;
        }
        if (orgIdSet.size() > 0) {
            fic.add(new FilterItemInfo("id", orgIdSet, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2");
        } else if (isDelimitUserOrgScope.booleanValue() && orgIdSet.size() < 1) {
            fic.add(new FilterItemInfo("id", (Object)"-1", CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2");
        }
        return filter.toString();
    }

    public static Set getOrgIdsByUserAndType(Context ctx, String userid, String orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)orgRangeType));
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filterColl.add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    public static void initDefaultPersonalBank(Context ctx, BizCollBillBaseInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        CollectionAccountInfo collectionAccount = CommonDataUtils.initDefaultPersonalBank(ctx);
        if (collectionAccount != null) {
            info.setPayerAccount(collectionAccount.getBankAccount());
            info.setPayerName(collectionAccount.getPayee());
            info.setPayerBank(collectionAccount.getBebank().getName());
            info.setOpenArea(collectionAccount.getOpenArea());
            info.setPayerBankStr(collectionAccount.getBebank());
        }
    }

    public static CollectionAccountInfo initDefaultPersonalBank(Context ctx) throws BOSException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        CollectionAccountInfo collectionAccount = null;
        String personId = user.getPerson().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select *, openArea.id, ").append("openArea.name, Bebank.id, Bebank.name, BebankStr where applier.id = '").append(personId).append("' and isDefault = 1");
        CollectionAccountCollection collectionAccountCollection = CollectionAccountFactory.getLocalInstance((Context)ctx).getCollectionAccountCollection(oql.toString());
        if (collectionAccountCollection.size() > 0) {
            collectionAccount = (CollectionAccountInfo)collectionAccountCollection.getObject(0);
        }
        return collectionAccount;
    }

    public static List<String> getAdminOrgIdListByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        ArrayList<String> adminOrgIdList = new ArrayList<String>();
        FilterInfo queryAdminOrgFilter = new FilterInfo();
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0, CompareType.EQUALS));
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet<String>(companyOrgUnitIds), CompareType.INCLUDE));
        queryAdminOrgFilter.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryAdminOrgFilter);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        int is = orgUnitRelations.size();
        for (int i = 0; i < is; ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            adminOrgIdList.add(orgUnitRelationInfo.getFromUnit().getId().toString());
        }
        return adminOrgIdList;
    }

    public static String getAdminOrgIdsByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        List<String> adminOrgIdList = CommonDataUtils.getAdminOrgIdListByCompany(companyOrgUnitIds, context);
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        int is = adminOrgIdList.size();
        for (int i = 0; i < is; ++i) {
            adminOrgUnitIdsBuffer.append("'").append(adminOrgIdList.get(i)).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        return adminOrgUnitIdsBuffer.toString();
    }

    public static SelectorItemCollection getAccountSelector(String linkType) {
        SelectorItemCollection selecon = new SelectorItemCollection();
        selecon.add(new SelectorItemInfo("" + linkType + ".id"));
        return selecon;
    }

    public static Set convertSet(AbstractObjectCollection con) {
        HashSet<String> set = new HashSet<String>();
        int is = con.size();
        for (int i = 0; i < is; ++i) {
            set.add(con.getObject(i).getObjectValue("company").get("id").toString());
        }
        return set;
    }

    public static Set<String> getPropIds(AbstractObjectCollection collection, String propertyName) {
        HashSet<String> idSet = new HashSet<String>();
        int is = collection.size();
        for (int i = 0; i < is; ++i) {
            idSet.add(collection.getObject(i).getObjectValue(propertyName).get("id").toString());
        }
        return idSet;
    }

    public static Set getIds(List<Map> list) {
        HashSet<String> idlist = new HashSet<String>();
        int is = list.size();
        for (int i = 0; i < is; ++i) {
            idlist.add(list.get(i).get("id").toString());
        }
        return idlist;
    }

    public static String getSpecialData(Context ctx, String userId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        String result = null;
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo.getPerson() != null) {
            String personID = userInfo.getPerson().getId().toString();
            result = CommonDataUtils.getPositionLongNumbers(ctx, personID);
        }
        if (result != null && result.length() > 0) {
            return result;
        }
        return null;
    }

    private static String getPositionLongNumbers(Context context, String personID) throws BOSException, EASBizException {
        StringBuffer adminids = new StringBuffer();
        String adminid = null;
        String childAdminId = null;
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("SELECT PositionChild.FAdminOrgUnitID as childAdminId,Position.FAdminOrgUnitID as AdminId FROM T_ORG_PositionHierarchy PositionHierarchy ").append(" INNER JOIN T_ORG_PositionMember PositionMember ON PositionHierarchy.Fparentid = PositionMember.FPositionID ").append(" INNER JOIN T_BD_Person Person ON PositionMember.FPersonID = Person.FID ").append(" INNER JOIN T_ORG_Position PositionChild ON PositionChild.FID = PositionHierarchy.FchildID ").append(" INNER JOIN T_ORG_Position Position ON Position.FID = PositionMember.FPositionID ").append(" WHERE PositionMember.FPersonID = ? and Position.fisRespPosition=1 AND PositionHierarchy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' ");
        Object[] params = new Object[]{personID};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)stringBuffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                childAdminId = rowSet.getString("childAdminId");
                adminid = rowSet.getString("AdminId");
                if (!StringUtils.isEmpty((String)adminid) && adminids.indexOf(adminid) < 0) {
                    adminids.append(adminid + ",");
                }
                if (StringUtils.isEmpty((String)childAdminId) || adminids.indexOf(childAdminId) >= 0) continue;
                adminids.append(childAdminId + ",");
            }
            if (adminids.length() > 0) {
                adminids.setLength(adminids.length() - 1);
            }
        }
        catch (SQLException e) {
            throw new PermissionException(PermissionException.GET_INFO_FAIL, (Throwable)e);
        }
        return adminids.toString();
    }

    public static Map getPersonIdsByAdminIds(Context ctx, String ids) throws BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        FilterItemInfo item = new FilterItemInfo("admin.FID", (Object)ids, CompareType.INCLUDE);
        sb.append("SELECT person.FID ID,person.FName_l2 Name ");
        sb.append("FROM t_bd_person person ");
        sb.append("INNER JOIN t_org_positionmember member ON member.FPersonID = person.FID ");
        sb.append("INNER JOIN t_org_position position ON position.FID = member.FPositionID ");
        sb.append("INNER JOIN t_org_admin admin ON admin.FID = position.FAdminOrgUnitID ");
        sb.append("WHERE ").append(item.toString());
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        while (set.next()) {
            result.put(set.getString("ID"), set.getString("Name"));
        }
        return result;
    }

    public static List<String> getEqAndChildCuIds(Context context) throws BOSException, EASBizException {
        ArrayList<String> resultList = new ArrayList<String>();
        CtrlUnitInfo currentCu = ContextUtil.getCurrentCtrlUnit((Context)context);
        String number = currentCu.getNumber();
        String parentId = currentCu.getParent().getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        FilterInfo queryOrgRangeFilter = new FilterInfo();
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryOrgRangeFilter);
        OrgRangeCollection orgRangeCollection = OrgRangeFactory.getLocalInstance((Context)context).getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() == 0) {
            return resultList;
        }
        StringBuffer oqlSb = new StringBuffer();
        oqlSb.append("select id where (longnumber like '%!").append(number).append("!%' ");
        if (StringUtils.isNotBlank((String)parentId)) {
            oqlSb.append("or (parent.id = '").append(parentId).append("' ").append("and number != '").append(number).append("') ");
        }
        oqlSb.append(") and id in (");
        int js = orgRangeCollection.size();
        for (int j = 0; j < js; ++j) {
            oqlSb.append("'").append(orgRangeCollection.get(j).getOrg().getId().toString()).append("'").append(",");
        }
        oqlSb.deleteCharAt(oqlSb.length() - 1);
        oqlSb.append(") ");
        CoreBaseCollection cuCollection = CtrlUnitFactory.getLocalInstance((Context)context).getCollection(oqlSb.toString());
        int is = cuCollection.size();
        for (int i = 0; i < is; ++i) {
            resultList.add(cuCollection.get(i).getId().toString());
        }
        return resultList;
    }

    public static List<String> getEqAndChildCuAdminIds(Context context, List<String> cuIds) throws BOSException, EASBizException {
        ArrayList<String> resultList = new ArrayList<String>();
        if (cuIds == null || cuIds.size() == 0) {
            cuIds = CommonDataUtils.getEqAndChildCuIds(context);
        }
        ArrayList<String> newCuIds = new ArrayList<String>();
        CtrlUnitInfo currentCu = ContextUtil.getCurrentCtrlUnit((Context)context);
        newCuIds.addAll(cuIds);
        newCuIds.add(currentCu.getId().toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", new HashSet(newCuIds), CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection(entityViewInfo);
        int is = adminOrgUnitCollection.size();
        for (int i = 0; i < is; ++i) {
            String adminOrgUnitId = adminOrgUnitCollection.get(i).getId().toString();
            resultList.add(adminOrgUnitId);
        }
        return resultList;
    }

    public static List<String> getChildAdminIds(Context context) throws BOSException, EASBizException {
        ArrayList<String> adminIds = new ArrayList<String>();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        List companyOrgUnitIds = OrgRangeFactory.getLocalInstance((Context)context).getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (companyOrgUnitIds == null || companyOrgUnitIds.size() == 0) {
            return adminIds;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet(companyOrgUnitIds), CompareType.INCLUDE));
        filterInfo.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        int is = orgUnitRelations.size();
        for (int i = 0; i < is; ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            String fromUnitId = orgUnitRelationInfo.getFromUnit().getId().toString();
            adminIds.add(fromUnitId);
        }
        return adminIds;
    }

    public static void checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean orgExtFromCtx) throws EASBizException, BOSException {
        if (permItemName == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
        }
        if (orgPK == null) {
            orgPK = new ObjectUuidPK(((CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo")).getId().toString());
        }
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, orgPK, null, null, permItemName, orgExtFromCtx);
    }
}

