/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IAPBillService;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.impl.SettleSplitHelper;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.impl.BaseService;
import com.kingdee.eas.fi.arap.impl.CodeRuleHelper;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PlanHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.ap.IAPBillService"})
public class APBillService
implements IAPBillService {
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String STATUS_FINDVIEW = "FINDVIEW";
    private Context ctx;

    public APBillService(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() throws BOSException, EASBizException {
        return this.ctx;
    }

    public void setContext(Context ctx) throws BOSException, EASBizException {
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> getCostCenterUnit(String adminOrgUnitId, String companyOrgUnitId) throws EASBizException, BOSException {
        OrgUnitCollection costCenterCollectionByOrg;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection costCenterCollection = iUtilRel.getToUnit(adminOrgUnitId, 0, 5);
        if (costCenterCollection.size() > 0 && (costCenterCollectionByOrg = iUtilRel.getFromUnit(companyOrgUnitId, 1, 5)).contains(costCenterCollection.get(0))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("costCenterUnit", costCenterCollection.get(0));
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> getUIcache(String companyid, String status) throws EASBizException, BOSException {
        OtherBillInfo info = new OtherBillInfo();
        info.getEntry().add(new OtherBillentryInfo());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        map.put("isSCM", new Boolean(false));
        map.put("isInit", false);
        map.put("permissionItem", this.getPermissionItemByStatus(status));
        map.put("billInfo", info);
        map.put("bosType", new OtherBillInfo().getBOSType());
        CompanyOrgUnitInfo company = null;
        if (companyid != null && companyid.length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        ArApSysParamInfo result = ArApBillFacadeFactory.getLocalInstance((Context)this.ctx).getSysParams(company, map);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", result.getCompany());
        params.put("baseCurrency", result.getBaseCurrency());
        params.put("currentAccountTableID", result.getCurrentAccountTableID());
        params.put("paramValueMap", result.getParamValueMap());
        params.put("apSystemStatus", result.getSysStatus(SystemEnum.ACCOUNTSPAYABLE));
        params.put("arSystemStatus", result.getSysStatus(SystemEnum.ACCOUNTSRECEIVABLE));
        params.put("imSystemStatus", result.getSysStatus(SystemEnum.INVENTORYMANAGEMENT));
        params.put("paramValue", result.getParamValueMap());
        params.put("currentPeriod", result.getCurrentPeriod(null));
        params.put("CUId", result.getCUId());
        params.put("isRelationSCM", result.isRelationSCM());
        params.put("defaultAsstActType", result.getDefaultAsstActType());
        StringBuffer sb = new StringBuffer();
        sb.append(" select FPayConditionID from T_BD_PayConditionReference ");
        sb.append("where (FAssignCompanyID = '");
        sb.append(companyid);
        sb.append("') ");
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            while (rs.next()) {
                set.add("'" + rs.getString("FPayConditionID") + "'");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)result.getCompany().getId().toString(), CompareType.EQUALS));
        if (set.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INNER));
            filter.setMaskString("#0 OR #1");
        }
        params.put("payConditionFilter", filter.toString());
        params.put("purOrg2CompanyFilter", this.getOrgFilterByCompany(companyid, 3));
        filter = new FilterInfo();
        AsstActTypeCollection col = result.getAsstActTypeColl();
        set.clear();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            set.add(col.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        params.put("asstActTypeFilter", filter.toString());
        params.put("costCenterFilter", this.getCostCenterFilter(companyid));
        params.put("adminFilter", this.getOrgFilterByCompany(companyid, 0));
        return params;
    }

    private String getPermissionItemByStatus(String status) {
        if (STATUS_ADDNEW.equals(status)) {
            return "fi_arap_ApOtherBill_Add";
        }
        if (STATUS_EDIT.equals(status)) {
            return "fi_ap_ApOtherBill_Update";
        }
        if (STATUS_VIEW.equals(status) || STATUS_FINDVIEW.equals(status)) {
            return "fi_ap_ApOtherBill_View";
        }
        return "fi_arap_ApOtherBill_Add";
    }

    @Override
    public Map<String, Object> getAdminOrgUnitByPerson(String personId) throws EASBizException, BOSException {
        AdminOrgUnitInfo info = null;
        if (!StringUtils.isEmpty((String)personId)) {
            EntityViewInfo viewIn = new EntityViewInfo();
            FilterInfo filterIn = new FilterInfo();
            filterIn.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            filterIn.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
            viewIn.setFilter(filterIn);
            SelectorItemCollection selectorAdmin = new SelectorItemCollection();
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.id"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.number"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.name"));
            viewIn.setSelector(selectorAdmin);
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)this.ctx);
            PositionMemberCollection positionColl = iPositionMember.getPositionMemberCollection(viewIn);
            if (positionColl.size() > 0) {
                info = positionColl.get(0).getPosition().getAdminOrgUnit();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    @Override
    public Map<String, Object> getAdminOrgUnitByPurchaseOrgUnit(String purchaseOrgUnitId) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel;
        OrgUnitCollection toUnit;
        AdminOrgUnitInfo info = null;
        if (!StringUtils.isEmpty((String)purchaseOrgUnitId) && (toUnit = (iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx)).getToUnit(purchaseOrgUnitId, 3, 0)).size() > 0) {
            info = (AdminOrgUnitInfo)toUnit.get(0);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    @Override
    public Map<String, Object> fetchPrice(Object config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getParamCol((Map)config);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getLocalInstance((Context)this.ctx).fetchPrice(paramCol);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("priceInfoCol", priceInfoCol);
        return result;
    }

    private PurPriceParamCollection getParamCol(Map config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        String billTypeId = "510b6503-0105-1000-e000-010fc0a812fd463ED552";
        paramCol.setBillTypeId(billTypeId);
        paramCol.setMerge(((Boolean)config.get("isMerge")).booleanValue());
        paramCol.setSource((String)config.get("source"));
        String bizTypeId = (String)config.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            paramCol.setBizTypeId(bizTypeId);
        }
        ArrayList paramArr = (ArrayList)config.get("paramArr");
        int len = paramArr.size();
        for (int i = 0; i < len; ++i) {
            PurPriceParam param = this.getParamInfo((Map)paramArr.get(i), billTypeId, bizTypeId);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    private PurPriceParam getParamInfo(Map config, String billTypeId, String bizTypeId) throws EASBizException, BOSException {
        PurPriceParam param = new PurPriceParam();
        try {
            ObjectUuidPK pk = null;
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                String bizCategoryId;
                pk = new ObjectUuidPK(bizTypeId);
                BizTypeInfo bizType = BizTypeFactory.getLocalInstance((Context)this.ctx).getBizTypeInfo((IObjectPK)pk);
                if (bizType.getBizCategory() != null && ((bizCategoryId = bizType.getBizCategory().getId().toString()).equals("+f4mYqj4xUGaNf69/HWRdqk4kCA=") || bizCategoryId.equals("6LFeB81CJ0mD3wyAekUV7Kk4kCA="))) {
                    param.setMaterialPurchaseType(1);
                }
            }
            param.setBillTypeId(billTypeId);
            if (config.get("seq") != null) {
                param.setSeq(((Double)config.get("seq")).intValue());
            }
            param.setInTax(((Boolean)config.get("isInTax")).booleanValue());
            String purOrgUnitId = (String)config.get("purOrgUnitId");
            String currencyId = (String)config.get("currencyId");
            param.setPurOrgUnitId(StringUtils.isEmpty((String)purOrgUnitId) ? null : purOrgUnitId);
            param.setCurrencyId(StringUtils.isEmpty((String)currencyId) ? null : currencyId);
            param.setSupplierId((String)config.get("asstActId"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            param.setBizDate(df.parse((String)config.get("bizDate")));
            String materialId = (String)config.get("materialId");
            String unitId = (String)config.get("unitId");
            String receiveOrgUnitId = (String)config.get("recOrgUnitId");
            String asstAttrId = (String)config.get("assistPropertyId");
            param.setMaterialId(StringUtils.isEmpty((String)materialId) ? null : materialId);
            param.setUnitId(StringUtils.isEmpty((String)unitId) ? null : unitId);
            pk = new ObjectUuidPK(materialId);
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)pk);
            param.setBaseUnitId(material.getBaseUnit().getId().toString());
            param.setRecOrgUnitId(StringUtils.isEmpty((String)receiveOrgUnitId) ? null : receiveOrgUnitId);
            param.setAssistPropertyId(StringUtils.isEmpty((String)asstAttrId) ? null : asstAttrId);
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                param.setBizTypeId(bizTypeId);
            }
            if (config.containsKey("qty")) {
                if (config.get("qty") != null) {
                    param.setQty(new BigDecimal((Double)config.get("qty")).abs());
                } else {
                    param.setQty(null);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return param;
    }

    @Override
    public Map<String, Object> generatePlan(String apBillId, String payConditionId, Object otherInfo) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)apBillId) || StringUtils.isEmpty((String)payConditionId)) {
            return null;
        }
        ObjectUuidPK apBillPk = new ObjectUuidPK(apBillId);
        ObjectUuidPK payConditionPk = new ObjectUuidPK(payConditionId);
        IOtherBill iAP = OtherBillFactory.getLocalInstance((Context)this.ctx);
        OtherBillInfo info = iAP.getOtherBillInfo((IObjectPK)apBillPk);
        if (info == null) {
            info = new OtherBillInfo();
        }
        Map otherInfoMap = (Map)otherInfo;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            info.setBillDate(df.parse((String)otherInfoMap.get("billDate")));
            info.setBizDate(df.parse((String)otherInfoMap.get("bizDate")));
            BigDecimal amount = new BigDecimal(String.valueOf(otherInfoMap.get("amount")));
            info.setAmount(amount);
            BigDecimal amountLocal = new BigDecimal(String.valueOf(otherInfoMap.get("amountLocal").toString()));
            info.setAmountLocal(amountLocal);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IPayCondition ipc = PayConditionFactory.getLocalInstance((Context)this.ctx);
        PayConditionInfo payConditionInfo = ipc.getPayConditionInfo((IObjectPK)payConditionPk);
        AbstractObjectCollection planCollection = PlanHelper.generatePlanCollection((Context)this.ctx, (ArApBillBaseInfo)info, (PayConditionInfo)payConditionInfo);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("planCollection", planCollection);
        return result;
    }

    private String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            HashSet<String> set = new HashSet<String>();
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                set.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    @Override
    public Map<String, Object> asstActChangeHandler(boolean isSupplier, String asstActId, String purOrgId, boolean isBillDepart, String companyId) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PersonInfo person = null;
        if (isSupplier) {
            SupplierInfo supplier = SupplierFactory.getLocalInstance((Context)this.ctx).getSupplierInfo("SELECT taxRate WHERE id = '" + asstActId + "'");
            result.put("taxRate", supplier.getTaxRate());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)asstActId));
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)purOrgId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("defaultPurchaser.*"));
            selector.add(new SelectorItemInfo("purchaseGroup.*"));
            view.setSelector(selector);
            ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)this.ctx);
            SupplierPurchaseInfoCollection collection = iSupplierPurchaseInfo.getSupplierPurchaseInfoCollection(view);
            if (collection.size() > 0 && collection.get(0).getDefaultPurchaser() != null) {
                person = collection.get(0).getDefaultPurchaser();
                result.put("person", person);
                if (collection.get(0).getPurchaseGroup() != null) {
                    result.put("purchaseGroup", collection.get(0).getPurchaseGroup());
                } else {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)person.getId()));
                    viewInfo.setFilter(filterInfo);
                    SelectorItemCollection selectorColl = new SelectorItemCollection();
                    selectorColl.add(new SelectorItemInfo("purGroup.*"));
                    viewInfo.setSelector(selectorColl);
                    SorterItemInfo sorterItemInfo = new SorterItemInfo();
                    sorterItemInfo.setPropertyName("purGroup.id");
                    sorterItemInfo.setSortType(SortType.DESCEND);
                    viewInfo.getSorter().add(sorterItemInfo);
                    IPurchasePerson iPurchasePerson = PurchasePersonFactory.getLocalInstance((Context)this.ctx);
                    PurchasePersonCollection purchaseColl = iPurchasePerson.getPurchasePersonCollection(viewInfo);
                    if (purchaseColl.size() > 0 && purchaseColl.get(0).getPurGroup().size() > 0) {
                        result.put("purchaseGroup", purchaseColl.get(0).getPurGroup());
                    }
                }
            }
        }
        Map<String, Object> map = null;
        map = isBillDepart && person != null ? this.getAdminOrgUnitByPerson(person.getId().toString()) : this.getAdminOrgUnitByPurchaseOrgUnit(purOrgId);
        result.putAll(map);
        PayConditionInfo payConditionInfo = PlanHelper.getPayCondition((Context)this.ctx, (String)asstActId, (String)companyId);
        result.put("payCondition", payConditionInfo);
        return result;
    }

    @Override
    public IObjectValue debitTransfer(String billId) throws EASBizException, BOSException {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        paramMap.put("createToFlag", 1);
        paramMap.put("bizType", BOSObjectType.create((String)"48DA3A71"));
        paramMap.put("transSelectors", BaseService.getBillSelectors());
        paramMap.put("selectId", billId);
        paramMap.put("currentUser", ContextUtil.getCurrentUserInfo((Context)this.ctx));
        HashMap hm = OtherBillFactory.getLocalInstance((Context)this.ctx).processArap2Arap(paramMap);
        if (hm == null) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        ArApBillBaseInfo destBillInfo = (ArApBillBaseInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
        if (destBillInfo.isIsInitializeBill()) {
            destBillInfo.setIsInitializeBill(false);
            Date date = new Date();
            destBillInfo.setBillDate(date);
            destBillInfo.setBizDate(date);
        }
        CodeRuleHelper codeHelper = new CodeRuleHelper();
        codeHelper.genNewBillNumber(this.getContext(), (IObjectValue)destBillInfo, (OrgUnitInfo)destBillInfo.getCompany());
        return destBillInfo;
    }

    private String getCostCenterFilter(String companyId) throws EASBizException, BOSException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        HashSet<String> costCenterSet = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyId, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            costCenterSet.add(orgIds.get(i).getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        if (costCenterSet.size() > 0) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterItemInfo filterItemIsBiz = new FilterItemInfo("isBizUnit", (Object)"true", CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemIsBiz);
            FilterItemInfo filterItemIsSealUp = new FilterItemInfo("isSealUp", (Object)"false", CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemIsSealUp);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"null"));
        }
        return filterInfo.toString();
    }

    @Override
    public void checkBeforeReverseBizBill(String billId) throws EASBizException, BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("isAR", false);
        paramMap.put("selectId", billId);
        paramMap.put("bizType", "48DA3A71");
        SelectorItemCollection sic = BaseService.getBillSelectors();
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("payCondition.id"));
        sic.add(new SelectorItemInfo("payCondition.number"));
        sic.add(new SelectorItemInfo("payCondition.name"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActName"));
        sic.add(new SelectorItemInfo("asstActNumber"));
        sic.add(new SelectorItemInfo("asstActID"));
        paramMap.put("selector", sic);
        this.checkBeforeReverseBizBill(this.ctx, paramMap);
    }

    @Override
    public IObjectValue reverseBizBill(String billId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        paramMap.put("isAR", false);
        paramMap.put("selectId", billId);
        paramMap.put("bizType", "48DA3A71");
        SelectorItemCollection sic = BaseService.getBillSelectors();
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("payCondition.id"));
        sic.add(new SelectorItemInfo("payCondition.number"));
        sic.add(new SelectorItemInfo("payCondition.name"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActName"));
        sic.add(new SelectorItemInfo("asstActNumber"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("purOrg.id"));
        sic.add(new SelectorItemInfo("purOrg.number"));
        sic.add(new SelectorItemInfo("purOrg.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        paramMap.put("selector", sic);
        paramMap = OtherBillFactory.getLocalInstance((Context)this.ctx).reversedBizBill(paramMap);
        return (IObjectValue)paramMap.get("destBillInfo");
    }

    @Override
    public void unReversedBizBill(String billId) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        OtherBillFactory.getLocalInstance((Context)this.ctx).unReversedBizBill(new IObjectPK[]{pk});
    }

    @Override
    public void checkBeforeBuildDebitAdjust(String billId) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizType", BOSObjectType.create((String)"48DA3A71"));
        SelectorItemCollection sic = BaseService.getBillSelectors();
        paramMap.put("botpSelectors", sic);
        paramMap.put("idArray", billId);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("cu.id");
        sic.add("entry.id");
        OtherBillInfo billInfo = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        if (billInfo == null) {
            throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTUNAUDIT);
        }
        ArrayList<String> entriesKey = new ArrayList<String>();
        OtherBillentryCollection entries = billInfo.getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entriesKey.add(entries.get(i).getId().toString());
        }
        paramMap.put("entriesKey", entriesKey);
        paramMap.put("cuId", billInfo.getCU().getId());
        this.checkBeforeBuildDebitAdjust(this.ctx, paramMap);
    }

    @Override
    public IObjectValue buildDebitAdjust(String billId) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizType", BOSObjectType.create((String)"48DA3A71"));
        SelectorItemCollection sic = BaseService.getBillSelectors();
        sic.add("payCondition.id");
        sic.add("payCondition.number");
        sic.add("payCondition.name");
        sic.add("asstActName");
        sic.add("asstActNumber");
        sic.add("asstActID");
        paramMap.put("botpSelectors", sic);
        paramMap.put("idArray", billId);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("cu.id");
        sic.add("entry.id");
        OtherBillInfo billInfo = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        ArrayList<String> entriesKey = new ArrayList<String>();
        OtherBillentryCollection entries = billInfo.getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entriesKey.add(entries.get(i).getId().toString());
        }
        paramMap.put("entriesKey", entriesKey);
        paramMap.put("cuId", billInfo.getCU().getId());
        HashMap hm = OtherBillFactory.getLocalInstance((Context)this.ctx).buildDebitAdjust(paramMap);
        return ((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
    }

    @Override
    public Map<String, Object> handlePersonChange(String personId, String purchaseOrgUnitId, boolean isBillDepart) throws BOSException, EASBizException {
        Map<String, Object> map = null;
        map = isBillDepart ? this.getAdminOrgUnitByPerson(personId) : this.getAdminOrgUnitByPurchaseOrgUnit(purchaseOrgUnitId);
        StringBuffer sql = new StringBuffer();
        sql.append("select id,person.id,purGroup.*, purGroup.purOrg.id where purGroup.purOrg.id='");
        sql.append(purchaseOrgUnitId).append("'").append(" and person.id='").append(personId).append("'");
        sql.append(" and deletedStatus = ").append(1);
        IPurchasePerson is = PurchasePersonFactory.getLocalInstance((Context)this.ctx);
        PurchasePersonCollection purchasePersonCollection = is.getPurchasePersonCollection(sql.toString());
        PurchaseGroupInfo aPurchaseGroupInfo = null;
        if (purchasePersonCollection.size() > 0) {
            aPurchaseGroupInfo = purchasePersonCollection.get(0).getPurGroup();
        }
        if (aPurchaseGroupInfo == null || !ForbidStatusEnum.UNFORBID.equals((Object)aPurchaseGroupInfo.getDeletedStatus())) {
            aPurchaseGroupInfo = null;
        }
        map.put("purchaseGroupInfo", aPurchaseGroupInfo);
        return map;
    }

    private void checkBeforeBuildDebitAdjust(Context ctx, HashMap paramMap) throws EASBizException, BOSException {
        if (paramMap.get("createTo") == null) {
            BOSObjectType bizType = (BOSObjectType)paramMap.get("bizType");
            String cuId = paramMap.get("cuId").toString();
            BOTMappingInfo btpMappingInfo = null;
            try {
                btpMappingInfo = ArApBillHelper.getBotpMappingInfo((Context)ctx, (BOSObjectType)bizType, (String)cuId, (String)"AP118");
                if (btpMappingInfo == null) {
                    throw new OtherBillBizException(BTPException.GETMAPPINGINFOERROR);
                }
            }
            catch (Exception e) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
            String selectId = paramMap.get("idArray").toString();
            SelectorItemCollection transSelectors = (SelectorItemCollection)paramMap.get("botpSelectors");
            OtherBillInfo info = (OtherBillInfo)OtherBillFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(selectId), transSelectors);
            CoreBillBaseCollection coll = new CoreBillBaseCollection();
            if (info == null) {
                throw new ObjectNotFoundException();
            }
            if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTUNAUDIT);
            }
            if (info.isIsBizBill()) {
                throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
            }
            if (!OtherBillType.InvoiceBill.equals((Object)info.getBillTypeEnum()) && !OtherBillType.ExpenseInvoice.equals((Object)info.getBillTypeEnum())) {
                throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTNOTPURCHASEINVOICE);
            }
            if (info.getPaymentType().getId().toString().equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                throw new OtherBillBizException(OtherBillBizException.CASHPUR_FORBIDDEN);
            }
            OtherBillentryCollection destEntrys = info.getEntry();
            ArrayList entryID = (ArrayList)paramMap.get("selectEntryId");
            boolean deleteentry = false;
            if (entryID != null && entryID.size() != 0) {
                deleteentry = true;
            }
            OtherBillentryInfo destEntryInfo = null;
            Iterator it = destEntrys.iterator();
            while (it.hasNext()) {
                destEntryInfo = (OtherBillentryInfo)it.next();
                if (!deleteentry || entryID.contains(destEntryInfo.getId().toString())) continue;
                it.remove();
            }
            coll.add((CoreBillBaseInfo)info);
            try {
                BTPTransformResult btpResult = null;
                IBTPManager iBTPManager = null;
                iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                if (bizType != null && btpMappingInfo != null && btpMappingInfo.getId() != null) {
                    btpResult = iBTPManager.transform(coll, bizType.toString(), (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()));
                }
                if (btpResult == null) {
                    throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
                }
                String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(bizType.toString(), "editUI");
            }
            catch (BOSException e) {
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
            catch (BTPException e) {
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
        }
    }

    protected void checkBeforeReverseBizBill(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        ArApBillBaseInfo info = (ArApBillBaseInfo)OtherBillFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(paramMap.get("selectId").toString()), (SelectorItemCollection)paramMap.get("selector"));
        if (info == null) {
            throw new ObjectNotFoundException();
        }
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (!info.isIsBizBill()) {
            throw new OtherBillBizException(OtherBillBizException.NOTBIZARAPBILL, (Object[])new String[]{""});
        }
        boolean isInvoiceBill = OtherBillTypeEnum.InvoiceBill.equals((Object)info.getBillTypeEnum()) || OtherBillType.InvoiceBill.equals((Object)info.getBillTypeEnum());
        AbstractObjectCollection destEntrys = info.getEntries();
        ArrayList entryID = paramMap.get("selectEntryId") != null ? (ArrayList)paramMap.get("selectEntryId") : null;
        boolean deleteentry = false;
        if (entryID != null && entryID.size() != 0) {
            deleteentry = true;
        }
        Iterator it = destEntrys.iterator();
        BigDecimal reversedBaseQty = null;
        ArApBillEntryBaseInfo destEntryInfo = null;
        while (it.hasNext()) {
            destEntryInfo = (ArApBillEntryBaseInfo)it.next();
            if (deleteentry && !entryID.contains(destEntryInfo.getId().toString())) {
                it.remove();
                continue;
            }
            if (isInvoiceBill) {
                reversedBaseQty = destEntryInfo.getBaseQty().subtract(destEntryInfo.getReversedBaseQty());
            }
            if (isInvoiceBill && reversedBaseQty.signum() != 0 || !isInvoiceBill && destEntryInfo.getUnVerifyAmountLocal().signum() != 0) continue;
            it.remove();
        }
        if (destEntrys.size() == 0) {
            throw new OtherBillBizException(OtherBillBizException.UNREVERSEDBASEQTYISZERO);
        }
    }

    @Override
    public void checkBeforeDebitTransfer(String billId) throws BOSException, EASBizException {
        ArApBillBaseInfo info = (ArApBillBaseInfo)OtherBillFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(billId), BaseService.getBillSelectors());
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (info.isIsBizBill()) {
            throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
        }
        if (info.getUnLockAmt().signum() == 0) {
            throw new OtherBillBizException(OtherBillBizException.ISALLLOCKED);
        }
    }

    @Override
    public Map getAPCreateToBOTPOption(List billIds) throws BOSException, EASBizException {
        long beginTime = System.currentTimeMillis();
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(billIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        CoreBillBaseCollection billCol = OtherBillFactory.getLocalInstance((Context)this.ctx).getCoreBillBaseCollection(evi);
        IBOTMapping ibot = BOTMappingFactory.getLocalInstance((Context)this.ctx);
        BOTMappingCollection botpCol = ibot.getMappingCollectionForSelect(billCol, "40284E81", DefineSysEnum.BTP);
        botpCol.addCollection(ibot.getMappingCollectionForSelect(billCol, "D001019A", DefineSysEnum.BTP));
        idSet = new HashSet();
        int size = botpCol.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(botpCol.get(i).getId().toString());
        }
        evi = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("alias");
        sic.add("description");
        sic.add("destEntityName");
        sic.add("destEntityAlias");
        evi.setSelector(sic);
        botpCol = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingCollection(evi);
        System.out.println("operation costed " + (System.currentTimeMillis() - beginTime) + "ms");
        HashMap<String, BOTMappingCollection> map = new HashMap<String, BOTMappingCollection>();
        map.put("botpCol", botpCol);
        return map;
    }

    @Override
    public void afterSetupCustomAmount(String listType, String botpId, Map data) throws BOSException, EASBizException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        SettleSplitHelper ssh = new SettleSplitHelper();
        if ("materialList".equals(listType)) {
            List entryIds = (List)data.get("entryIds");
            ssh.initSplitQueueByEntry(this.ctx, entryIds);
        } else {
            ssh.initSplitQueueByPlan(this.ctx, data);
        }
        EntityViewInfo evi = ssh.getBillIdEvi();
        OtherBillCollection apCol = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillCollection(evi);
        int size_j = apCol.size();
        for (int j = 0; j < size_j; ++j) {
            OtherBillInfo info = apCol.get(j);
            OtherBillentryCollection entries = info.getEntry();
            OtherBillentryCollection entriesTmp = (OtherBillentryCollection)entries.clone();
            entries.clear();
            int size = entriesTmp.size();
            for (int i = 0; i < size; ++i) {
                OtherBillentryInfo entry = entriesTmp.get(i);
                ssh.setSplitQueue(entry.getId().toString());
                while (ssh.hasNext()) {
                    OtherBillentryInfo entrySplit = (OtherBillentryInfo)entry.clone();
                    entrySplit.setPayableDate(ssh.getPayableDate());
                    entrySplit.setLockUnVerifyAmt(ssh.getActiveAmt());
                    entrySplit.setLockUnVerifyAmtLocal(ssh.getActiveAmtLoc());
                    entries.addObjectDirect((IObjectValue)entrySplit);
                    ssh.dequeue();
                }
            }
            col.add((CoreBillBaseInfo)info);
        }
        BOTMappingInfo botpInfo = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingInfo("select destEntityName where id='" + botpId + "'");
        IBTPManager btpInstance = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        this.ctx.put((Object)"NO_SettingValue", (Object)"true");
        BTPTransformResult btpResult = btpInstance.transformForBotp(col, botpInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(botpId));
        IObjectCollection targetBillCol = btpResult.getBills();
        for (int i = 0; i < targetBillCol.size(); ++i) {
            CoreBillBaseInfo coreInfo = (CoreBillBaseInfo)targetBillCol.getObject(i);
            btpInstance.saveRelations(coreInfo, btpResult.getBOTRelationCollection());
        }
        this.ctx.put((Object)"NO_SettingValue", null);
    }

    @Override
    public boolean isOpenCodingRule(String orgId) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        return codingRuleManager.getRuleStatus((IObjectValue)new OtherBillInfo(), orgId).isExist();
    }
}

