/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPMulOrgParamInfo;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPUtils;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.dap.util.DAPCommonUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPBillTrans;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPMultiOrgBillTrans;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPTrans;
import com.kingdee.eas.fi.fa.manage.services.dap.IMultiOrgBizInfo;
import com.kingdee.eas.fi.fa.manage.services.dap.impl.IDAPController;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.MultiOrgBatchExceptionInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DAPTransImpl
implements IDAPTrans,
IDAPBillTrans,
IDAPMultiOrgBillTrans {
    private static Logger logger = Logger.getLogger(DAPTransImpl.class);
    protected IDAPController controller = null;
    protected static final String VOUCHERTYPE = "2652E01E";
    protected static final String VOUCHERFLAG = "fiVouchered";
    protected static final String TRANSMITCU = "TRANSMITCU";
    public static final String TRANSMITCUFROMBIZ = "TRANSMITCUFROMBIZ";
    protected static final String DAP_Multi_Org = "DAP_Multi_Org";
    protected static final String COMPANYORGLIST = "Company_Org_List";
    protected static final String handlerName = "com.kingdee.eas.base.dap.app.DAPTransImplHandler";
    protected static final String RULE = "DAPTransImpl_param_mapping";
    protected static final String DATAIDS = "DAPTransImpl_param_srcBillIds";
    protected static final String SELECTORS = "DAPTransImpl_param_selectors";
    protected static final String RULES = "DAPTransImpl_param_mappings";
    protected static final String ORG_FIRST_RULE = "DAPTransImpl_param_firstmapping";
    private IUIWindow mappingSelecteWindow = null;
    private LowTimer ts = new LowTimer();
    public static final String EDITRULE = "EDITRULE";
    public static String ADDNEW = "ADDNEW";
    public static String VIEW = "VIEW";
    public static String EDIT = "EDIT";
    public static String COPYADDNEW = "COPYADDNEW";
    public static String EXITING = "EXITING";

    public DAPTransImpl(IDAPController controller) {
        this.controller = controller;
    }

    public void init() throws Exception {
    }

    protected Map beforeDAPTrans(String[] idList, String[] entrysName, List entriesKey, String sourceBillType, SelectorItemCollection botpSelectors, Map ctx) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)this.controller.getCtx());
        BOTMappingCollection botMappingCollection = null;
        OrgUnitInfo transmitCU = null;
        if (ctx != null) {
            transmitCU = (OrgUnitInfo)ctx.get(TRANSMITCU);
        } else {
            ctx = new HashMap<String, OrgUnitInfo>();
        }
        if (ctx.get(TRANSMITCUFROMBIZ) != null) {
            transmitCU = (OrgUnitInfo)ctx.get(TRANSMITCUFROMBIZ);
            if (!(transmitCU instanceof CtrlUnitInfo)) {
                transmitCU = ((OrgUnitInfo)transmitCU).getCU();
            }
            ctx.put(TRANSMITCU, transmitCU);
        } else if (transmitCU == null || !(transmitCU instanceof CtrlUnitInfo)) {
            if (this.controller != null) {
                transmitCU = this.controller.getMainOrgInfo();
            }
            ctx.put(TRANSMITCU, transmitCU);
        }
        botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, VOUCHERTYPE, DefineSysEnum.DAP, ctx, idList, entrysName, entriesKey, botpSelectors);
        if (botMappingCollection.size() == 0) {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        BOTMappingInfo botMappingInfo = null;
        if (botMappingCollection.size() <= 1 || this.controller == null || !this.controller.isNeedShowBOTPRule()) {
            botMappingInfo = botMappingCollection.get(0);
        }
        params.put(RULE, botMappingInfo);
        IObjectPK[] sourceBillPkList = new IObjectPK[idList.length];
        for (int index = 0; index < idList.length; ++index) {
            sourceBillPkList[index] = new ObjectUuidPK(idList[index]);
        }
        params.put(DATAIDS, sourceBillPkList);
        SelectorItemCollection botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
        params.put(SELECTORS, botSelectors);
        return params;
    }

    protected String getBillMainEntryName(EntityObjectInfo entity) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }

    protected List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    protected DAPTransformResult doDAPOrgTrans(String srcBillType, Map params, String srcBosType) throws Exception {
        DAPTransformResult transResult = null;
        IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)this.controller.getCtx());
        IObjectPK[] ids = (IObjectPK[])params.get(DATAIDS);
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < ids.length; ++i) {
            IObjectPK pk = ids[i];
            idList.add(pk);
        }
        if (idList.size() > 0) {
            transResult = dapTransformer.generateVoucherForOrg(srcBillType, idList.toArray(new IObjectPK[idList.size()]), (SelectorItemCollection)params.get(SELECTORS), (IObjectPK[])params.get(RULES));
        }
        return transResult;
    }

    protected DAPTransformResult doDAPTrans(ICoreBillBase srcBillBase, Map params, String srcBosType) throws Exception {
        DAPTransformResult transResult = null;
        BOTMappingInfo mappingInfo = (BOTMappingInfo)params.get(RULE);
        if (mappingInfo.getMappingType().equals((Object)MappingTypeEnum.SqlEngine)) {
            IDAPTransformer dapTrans = DAPTransformerFactory.getLocalInstance((Context)this.controller.getCtx());
            IObjectPK[] dataIds = (IObjectPK[])params.get(DATAIDS);
            transResult = dapTrans.transformSQLE(dataIds, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), (SelectorItemCollection)params.get(SELECTORS));
            logger.debug((Object)("transResult=" + transResult));
        } else {
            transResult = srcBillBase.generateVoucher((IObjectPK[])params.get(DATAIDS), (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), (SelectorItemCollection)params.get(SELECTORS));
            logger.debug((Object)("transResult=" + transResult));
        }
        return transResult;
    }

    protected EntityViewInfo getDAPRelationEntityViewInfo(String[] idArray) throws BOSException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer("(");
        String strIdLists = StringUtils.arrayToString((Object[])idArray, (String)",");
        sbMaskString.append("#" + String.valueOf(filter.getFilterItems().size()));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)strIdLists, CompareType.INCLUDE));
        sbMaskString.append(") and #");
        sbMaskString.append(String.valueOf(filter.getFilterItems().size()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE));
        filter.setMaskString(sbMaskString.toString());
        entityView.setFilter(filter);
        SelectorItemCollection sic = entityView.getSelector();
        sic.add("destObjectID");
        return entityView;
    }

    protected BOTRelationCollection getDAPRelationCollection(String[] idArray) throws BOSException, EASBizException {
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.controller.getCtx());
        EntityViewInfo entityView = this.getDAPRelationEntityViewInfo(idArray);
        BOTRelationCollection relationCollection = iBotRelation.getCollection(entityView);
        return relationCollection;
    }

    protected EntityViewInfo getVoucherEntityViewInfo(BOTRelationCollection relationCollection) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("number");
        sic.add("bizStatus");
        sic.add("company.*");
        SorterItemInfo createTimeSorter = new SorterItemInfo("createTime");
        createTimeSorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(createTimeSorter);
        FilterInfo voucherIdFilter = new FilterInfo();
        if (relationCollection.size() > 0) {
            int voucherIndex = 0;
            StringBuffer voucherFilterMask = new StringBuffer();
            Iterator iter2 = relationCollection.iterator();
            StringBuffer strVchIdLists = new StringBuffer();
            while (iter2.hasNext()) {
                BOTRelationInfo relationInfo = (BOTRelationInfo)iter2.next();
                String voucherId = relationInfo.getDestObjectID();
                if (voucherIndex > 0) {
                    strVchIdLists.append(",");
                }
                strVchIdLists.append(voucherId);
                ++voucherIndex;
            }
            voucherFilterMask.append("#" + String.valueOf(voucherIdFilter.getFilterItems().size()));
            voucherIdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)strVchIdLists.toString(), CompareType.INCLUDE));
            voucherIdFilter.setMaskString(voucherFilterMask.toString());
        }
        evi.setFilter(voucherIdFilter);
        return evi;
    }

    protected VoucherCollection getVoucherCollection(BOTRelationCollection relationCollection) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.controller.getCtx());
        EntityViewInfo evi = this.getVoucherEntityViewInfo(relationCollection);
        VoucherCollection voucherCols = null;
        voucherCols = iVoucher.getVoucherCollection(evi);
        return voucherCols;
    }

    protected void afterDAPOrgTrans(String sourceBillType, Map params, DAPTransformResult transResult) throws Exception {
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)params.get(ORG_FIRST_RULE);
        IObjectPK[] pkArray = (IObjectPK[])params.get(DATAIDS);
        String[] idArray = new String[pkArray.length];
        this.afterDAPOrgTrans(sourceBillType, botMappingInfo, idArray, transResult);
    }

    protected void afterDAPOrgTrans(String sourceBillType, BOTMappingInfo botMappingInfo, String[] idArray, DAPTransformResult transResult) throws Exception {
        logger.error((Object)"---------------------begin afterDAPOrgTrans ");
        boolean isTempSave = false;
        boolean isOnlyShowLast = false;
        if (sourceBillType.equals("23B52381")) {
            isOnlyShowLast = true;
        }
        VoucherCollection voucherCols = null;
        if (transResult != null && transResult.getVoucherCollection() != null) {
            voucherCols = (VoucherCollection)transResult.getVoucherCollection();
        } else {
            BOTRelationCollection relationCollection = this.getDAPRelationCollection(idArray);
            String strIdLists = StringUtils.arrayToString((Object[])idArray, (String)",");
            if (relationCollection.size() == 0) {
                logger.error((Object)"afterDAPOrgTrans ----------------------relationCollection.size() ==0");
                logger.error((Object)("afterDAPOrgTrans ----------------------" + strIdLists));
                return;
            }
            voucherCols = this.getVoucherCollection(relationCollection);
        }
        StringBuffer sbVoucherNumbers = new StringBuffer("");
        int size = voucherCols.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo voucher = voucherCols.get(i);
            if (sbVoucherNumbers.length() > 0) {
                sbVoucherNumbers.append(" , " + voucher.getNumber());
            } else {
                sbVoucherNumbers.append(voucher.getNumber());
            }
            if (!isTempSave && VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus())) {
                isTempSave = true;
            }
            if (isOnlyShowLast) break;
        }
        Component ownerComponent = null;
        if (isTempSave) {
            if (botMappingInfo.getIsShowEditUI() == 1) {
                this.sortByRule(botMappingInfo, voucherCols);
                Context ctx = this.controller.getCtx();
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
                if (company.isIsBizUnit()) {
                    logger.error((Object)"afterDAPOrgTrans ----------------------\u02b5\ufffd\ufffd\ufffd\ufffd\u05af");
                    this.viewVouchers(ownerComponent, voucherCols, EDIT);
                } else {
                    logger.error((Object)"afterDAPOrgTrans ----------------------\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05af");
                    this.viewVouchers(ownerComponent, voucherCols, VIEW);
                }
            }
        } else if (botMappingInfo.getIsShowEditUI() == 1) {
            this.sortByRule(botMappingInfo, voucherCols);
            this.viewVouchers(ownerComponent, voucherCols, VIEW);
        }
    }

    protected void afterDAPTrans(String sourceBillType, Map params, DAPTransformResult transResult, boolean showMsg) throws Exception {
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)params.get(ORG_FIRST_RULE);
        if (botMappingInfo == null) {
            botMappingInfo = (BOTMappingInfo)params.get(RULE);
        }
        IObjectPK[] pkArray = (IObjectPK[])params.get(DATAIDS);
        String[] idArray = new String[pkArray.length];
        this.afterDAPTrans(sourceBillType, botMappingInfo, idArray, transResult, showMsg);
    }

    protected void afterDAPTrans(String sourceBillType, BOTMappingInfo botMappingInfo, String[] idArray, DAPTransformResult transResult, boolean showMsg) throws Exception {
        boolean isTempSave = false;
        boolean isOnlyShowLast = false;
        long t0 = System.currentTimeMillis();
        if (sourceBillType.equals("23B52381")) {
            isOnlyShowLast = true;
        }
        VoucherCollection voucherCols = null;
        BOTRelationCollection relationCollection = null;
        if (transResult != null && transResult.getVoucherCollection() != null) {
            voucherCols = (VoucherCollection)transResult.getVoucherCollection();
            relationCollection = transResult.getRelationCollection();
        } else {
            relationCollection = this.getDAPRelationCollection(idArray);
            String strIdLists = StringUtils.arrayToString((Object[])idArray, (String)",");
            if (relationCollection.size() == 0) {
                logger.error((Object)"afterDAPTrans ----------------------relationCollection.size() ==0");
                logger.error((Object)("afterDAPTrans ----------------------" + strIdLists));
                return;
            }
            voucherCols = this.getVoucherCollection(relationCollection);
        }
        if (voucherCols == null || voucherCols.size() <= 0) {
            return;
        }
        StringBuffer sbVoucherNumbers = new StringBuffer("");
        int size = voucherCols.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo voucher = voucherCols.get(i);
            if (sbVoucherNumbers.length() > 0) {
                sbVoucherNumbers.append(" , " + voucher.getNumber());
            } else {
                sbVoucherNumbers.append(voucher.getNumber());
            }
            if (!isTempSave && VoucherStatusEnum.TEMP.equals((Object)voucher.getBizStatus())) {
                isTempSave = true;
            }
            if (isOnlyShowLast) break;
        }
        Component ownerComponent = null;
        long t1 = System.currentTimeMillis();
        logger.info((Object)("***DAPTransform->afterDAPTrans,   initTime=" + (t1 - t0) + "ms,  transResult = " + transResult));
        if (isTempSave) {
            if (botMappingInfo.getIsShowEditUI() == 1) {
                String uiEClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
                this.sortByRule(botMappingInfo, voucherCols);
                Context ctx = this.controller.getCtx();
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
                if (company.isIsBizUnit()) {
                    this.viewVouchers(ownerComponent, voucherCols, EDIT, uiEClass, false);
                } else {
                    this.viewVouchers(ownerComponent, voucherCols, VIEW, uiEClass, false);
                }
            } else if (botMappingInfo.getIsShowEditUI() == 2) {
                String uiLClass = "com.kingdee.eas.fi.gl.client.VoucherListUI";
                this.sortByRule(botMappingInfo, voucherCols);
                this.viewVouchers(ownerComponent, voucherCols, VIEW, uiLClass, false);
            }
        } else if (botMappingInfo.getIsTempSave() == 0) {
            if (botMappingInfo.getIsShowEditUI() == 1) {
                String uiEClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
                this.sortByRule(botMappingInfo, voucherCols);
                this.viewVouchers(ownerComponent, voucherCols, VIEW, uiEClass, false);
            } else if (botMappingInfo.getIsShowEditUI() == 2) {
                String uiLClass = "com.kingdee.eas.fi.gl.client.VoucherListUI";
                this.sortByRule(botMappingInfo, voucherCols);
                this.viewVouchers(ownerComponent, voucherCols, VIEW, uiLClass, false);
            }
        }
    }

    public void trans(CoreBillBaseCollection sourceBillCollection) throws Exception {
        this.trans(sourceBillCollection, null);
    }

    public boolean trans(String[] idList, String[] entryNames, List entriesKey, SelectorItemCollection botpSelectors) throws Exception {
        return this.trans(idList, entryNames, entriesKey, botpSelectors, null);
    }

    private void checkReGenerate(ICoreBillBase srcBillBase, String[] idList) throws Exception {
        boolean isCheckVoucherFlag = true;
        try {
            Class<DAPUtils> DAPUtilsClass = DAPUtils.class;
            Method method = DAPUtilsClass.getMethod("isMultiOrgVoucherEnabled", null);
            isCheckVoucherFlag = (Boolean)method.invoke(DAPUtilsClass.newInstance(), null) == false;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isCheckVoucherFlag) {
            FilterInfo filterInfo = new FilterInfo();
            StringBuffer sbMaskString = new StringBuffer();
            String strIdLists = StringUtils.arrayToString((Object[])idList, (String)",");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
            sbMaskString.append("#0");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo(VOUCHERFLAG));
            entityViewInfo.setFilter(filterInfo);
            CoreBillBaseCollection sourceBillCollection = srcBillBase.getCoreBillBaseCollection(entityViewInfo);
            for (CoreBillBaseInfo sourceBill : sourceBillCollection) {
                if (!sourceBill.getBoolean(VOUCHERFLAG)) continue;
                if (idList.length > 1) {
                    throw new DAPException(DAPException.FIVOUCHERED);
                }
                throw new BillBaseException(BillBaseException.FIVOUCHERED);
            }
        }
    }

    public boolean trans(String[] idList, String[] entryNames, List entriesKey, SelectorItemCollection botpSelectors, Map ctx) throws Exception {
        return this.trans(idList, entryNames, entriesKey, botpSelectors, ctx, true);
    }

    public boolean trans(String[] idList, String[] entryNames, List entriesKey, SelectorItemCollection botpSelectors, Map ctx, boolean showMsg) throws Exception {
        ICoreBillBase srcBillBase = null;
        if (this.controller != null) {
            srcBillBase = this.controller.getBillInterface();
        }
        this.checkReGenerate(srcBillBase, idList);
        String sourceBillType = BOSUuid.read((String)idList[0]).getType().toString();
        Map params = this.beforeDAPTrans(idList, entryNames, entriesKey, sourceBillType, botpSelectors, ctx);
        if (params.get(RULE) == null) {
            return false;
        }
        DAPTransformResult transResult = this.doDAPTrans(srcBillBase, params, sourceBillType);
        return true;
    }

    public MultiOrgBatchExceptionInfo transMultiOrg(IMultiOrgBizInfo mulBizOrgInfo, String[] entryNames, SelectorItemCollection botpSelectors, Map ctx) throws Exception {
        MultiOrgBatchExceptionInfo multiOrgBatchExceptionInfo = null;
        if (mulBizOrgInfo == null) {
            throw new BOSException((Throwable)new IllegalArgumentException("The param mulBizOrgInfo is null"));
        }
        IMultiOrgBizInfo newBiz = null;
        List cuList = newBiz.getOrgIDList();
        if (cuList == null || cuList.size() <= 0) {
            List orgList = mulBizOrgInfo.getOrgIDList();
            throw new BOSException((Throwable)new IllegalArgumentException("Get the CtrlUnitInfo List failed!  orgList=" + orgList));
        }
        List idList = new ArrayList();
        List entriesKey = new ArrayList();
        CtrlUnitInfo cu = null;
        String orgID = null;
        Object transResult = null;
        Object sourceBillType = null;
        if (cuList.size() > 1) {
            return this.innerTransOrg(newBiz, entryNames, botpSelectors, ctx);
        }
        cu = (CtrlUnitInfo)cuList.get(0);
        orgID = cu.getId().toString();
        idList = newBiz.getIDList(orgID);
        entriesKey = newBiz.getEntryIDList(orgID);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        ICoreBillBase srcBillBase = null;
        if (this.controller != null) {
            srcBillBase = this.controller.getBillInterface();
        }
        this.checkReGenerate(srcBillBase, idArray);
        ctx.put(TRANSMITCU, cu);
        boolean succ = this.trans(idArray, entryNames, entriesKey, botpSelectors, ctx, false);
        if (succ) {
            multiOrgBatchExceptionInfo = new MultiOrgBatchExceptionInfo();
            multiOrgBatchExceptionInfo.addSuccCount((long)idArray.length);
        }
        return multiOrgBatchExceptionInfo;
    }

    protected MultiOrgBatchExceptionInfo innerTransOrg(IMultiOrgBizInfo newBiz, String[] entryNames, SelectorItemCollection botpSelectors, Map ctx) throws Exception {
        MultiOrgBatchExceptionInfo multiOrgBatchExceptionInfo = new MultiOrgBatchExceptionInfo();
        List cuList = newBiz.getOrgIDList();
        if (cuList.size() <= 1) {
            throw new BOSException((Throwable)new IllegalArgumentException("The argument cuList's size is empty !"));
        }
        List idList = new ArrayList();
        List entriesKey = new ArrayList();
        CtrlUnitInfo cu = null;
        String orgID = null;
        DAPTransformResult transResult = null;
        String sourceBillType = null;
        ArrayList idAllList = new ArrayList();
        HashMap<String, BOTMappingInfo> orgMappingsMap = new HashMap<String, BOTMappingInfo>();
        for (int i = 0; i < cuList.size(); ++i) {
            cu = (CtrlUnitInfo)cuList.get(i);
            orgID = cu.getId().toString();
            idList = newBiz.getIDList(orgID);
            idAllList.addAll(idList);
            entriesKey = newBiz.getEntryIDList(orgID);
            String[] idArray = new String[idList.size()];
            idList.toArray(idArray);
            if (sourceBillType == null) {
                sourceBillType = BOSUuid.read((String)idArray[0]).getType().toString();
            }
            BOTMappingInfo botMappingInfo = this.checkMappingStatusForMultiOrg(sourceBillType, orgID, idArray, entryNames, entriesKey, botpSelectors, cu);
            orgMappingsMap.put(orgID, botMappingInfo);
        }
        String[] idAllArray = new String[idList.size()];
        idAllList.toArray(idAllArray);
        ICoreBillBase srcBillBase = null;
        if (this.controller != null) {
            srcBillBase = this.controller.getBillInterface();
        }
        this.checkReGenerate(srcBillBase, idAllArray);
        BOTMappingInfo firstMappingInfo = null;
        for (int i = 0; i < cuList.size(); ++i) {
            cu = (CtrlUnitInfo)cuList.get(i);
            orgID = cu.getId().toString();
            BOTMappingInfo botMappingInfo = (BOTMappingInfo)orgMappingsMap.get(orgID);
            if (i == 0) {
                firstMappingInfo = botMappingInfo;
            }
            idList = newBiz.getIDList(orgID);
            entriesKey = newBiz.getEntryIDList(orgID);
            if (idList.size() <= 0) {
                throw new BOSException((Throwable)new IllegalArgumentException("The argument idList's size is empty !"));
            }
            String[] idArray = new String[idList.size()];
            idList.toArray(idArray);
            boolean succ = true;
            DAPTransformResult tempResult = null;
            try {
                tempResult = this.handlerTransMultiOrg(idArray, entryNames, entriesKey, botpSelectors, ctx, botMappingInfo);
            }
            catch (Exception e) {
                succ = false;
                multiOrgBatchExceptionInfo.addException(orgID, e);
            }
            if (succ && tempResult != null) {
                multiOrgBatchExceptionInfo.addSuccCount((long)idArray.length);
                transResult = this.mergeTransResult(transResult, tempResult);
                continue;
            }
            multiOrgBatchExceptionInfo.addFailedCount((long)idArray.length);
        }
        if (transResult != null) {
            this.afterDAPTrans(sourceBillType, firstMappingInfo, idAllArray, transResult, false);
        }
        return multiOrgBatchExceptionInfo;
    }

    public MultiOrgBatchExceptionInfo transMultiOrg(CoreBillBaseCollection sourceBillCollection, String orgPropName, Map ctx) throws Exception {
        MultiOrgBatchExceptionInfo multiOrgBatchExceptionInfo = new MultiOrgBatchExceptionInfo();
        DAPTransformResult transResult = null;
        String sourceBillType = null;
        SelectorItemCollection botpSelectors = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(sourceBillCollection.getObject(0).getBOSType());
        String[] entrysName = new String[]{this.getBillMainEntryName(entity)};
        List entriesKey = this.getSelectEntryIDs(sourceBillCollection, entrysName[0]);
        String[] idAllArray = new String[sourceBillCollection.size()];
        sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
        HashMap<CtrlUnitInfo, CoreBillBaseCollection> orgIDMap = new HashMap<CtrlUnitInfo, CoreBillBaseCollection>();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bill = sourceBillCollection.get(i);
            CompanyOrgUnitInfo orgUnit = (CompanyOrgUnitInfo)bill.get(orgPropName);
            CtrlUnitInfo cu = orgUnit.getCU();
            String cuID = cu.getId().toString();
            idAllArray[i] = bill.getId().toString();
            CoreBillBaseCollection tempBillCollection = (CoreBillBaseCollection)orgIDMap.get(cu);
            if (tempBillCollection == null) {
                tempBillCollection = new CoreBillBaseCollection();
                orgIDMap.put(cu, tempBillCollection);
            }
            tempBillCollection.add(bill);
        }
        ArrayList<DAPMulOrgParamInfo> paramsList = new ArrayList<DAPMulOrgParamInfo>();
        for (CtrlUnitInfo cu : orgIDMap.keySet()) {
            CoreBillBaseCollection tempBillCollection = (CoreBillBaseCollection)orgIDMap.get(cu);
            String orgID = cu.getId().toString();
            int count = tempBillCollection.size();
            String[] idArray = new String[count];
            for (int i = 0; i < count; ++i) {
                idArray[i] = tempBillCollection.get(i).getId().toString();
            }
            List subEntriesKey = this.getSelectEntryIDs(tempBillCollection, entrysName[0]);
            BOTMappingInfo botMappingInfo = this.checkMappingStatusForMultiOrg(sourceBillType, orgID, idArray, entrysName, subEntriesKey, botpSelectors, cu);
            DAPMulOrgParamInfo param = new DAPMulOrgParamInfo(ctx, cu, botMappingInfo, botpSelectors, subEntriesKey, entrysName, idArray, sourceBillType);
            paramsList.add(param);
        }
        BOTMappingInfo firstMappingInfo = null;
        for (int i = 0; i < paramsList.size(); ++i) {
            DAPMulOrgParamInfo param = (DAPMulOrgParamInfo)paramsList.get(i);
            CtrlUnitInfo cu = param.getCu();
            String orgID = cu.getId().toString();
            String[] idArray = param.getIdArray();
            List subEntriesKey = param.getEntriesKey();
            BOTMappingInfo botMappingInfo = param.getBotMappingInfo();
            if (i == 0) {
                firstMappingInfo = botMappingInfo;
            }
            if (idArray.length <= 0) continue;
            ctx.put(TRANSMITCU, cu);
            DAPTransformResult tempResult = null;
            boolean succ = true;
            try {
                tempResult = this.handlerTransMultiOrg(idArray, entrysName, subEntriesKey, botpSelectors, ctx, botMappingInfo);
            }
            catch (Exception e) {
                succ = false;
                multiOrgBatchExceptionInfo.addFailedCount((long)idArray.length);
                multiOrgBatchExceptionInfo.addException(orgID, e);
            }
            if (!succ) continue;
            multiOrgBatchExceptionInfo.addSuccCount((long)idArray.length);
            transResult = this.mergeTransResult(transResult, tempResult);
        }
        this.afterDAPTrans(sourceBillType, firstMappingInfo, idAllArray, transResult, false);
        return multiOrgBatchExceptionInfo;
    }

    protected DAPTransformResult handlerTransMultiOrg(String[] idList, String[] entryNames, List entriesKey, SelectorItemCollection botpSelectors, Map ctx, BOTMappingInfo botMappingInfo) throws Exception {
        ICoreBillBase srcBillBase = null;
        srcBillBase = this.controller != null ? this.controller.getBillInterface() : this.controller.getBillInterface();
        String sourceBillType = BOSUuid.read((String)idList[0]).getType().toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(RULE, botMappingInfo);
        IObjectPK[] sourceBillPkList = DAPCommonUtils.StringList2PKArray((String[])idList);
        params.put(DATAIDS, sourceBillPkList);
        DAPTransformResult transResult = this.doDAPTrans(srcBillBase, params, sourceBillType);
        return transResult;
    }

    private DAPTransformResult mergeTransResult(DAPTransformResult baseResult, DAPTransformResult destResult) throws Exception {
        if (baseResult == null && destResult == null) {
            return null;
        }
        if (baseResult == null) {
            return destResult;
        }
        if (destResult == null) {
            return baseResult;
        }
        baseResult.getVoucherCollection().addObjectCollection(destResult.getVoucherCollection());
        baseResult.getRelationCollection().addObjectCollection((IObjectCollection)destResult.getRelationCollection());
        return baseResult;
    }

    private BOTMappingInfo checkMappingStatusForMultiOrg(String sourceBillType, String orgID, String[] idList, String[] entrysName, List entriesKey, SelectorItemCollection botpSelectors, CtrlUnitInfo cu) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TRANSMITCU_ID", orgID);
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)this.controller.getCtx());
        BOTMappingCollection botMappingCollection = null;
        botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, VOUCHERTYPE, DefineSysEnum.DAP, ctx, idList, entrysName, entriesKey, botpSelectors);
        if (botMappingCollection == null || botMappingCollection.size() <= 0) {
            throw new DAPException(DAPException.DAPMULTIORGMAPISNONE, new Object[]{cu.getDisplayName()});
        }
        if (botMappingCollection.size() > 1) {
            throw new DAPException(DAPException.DAPMULTIORGMAPISMORE, new Object[]{cu.getDisplayName()});
        }
        return botMappingCollection.get(0);
    }

    public IUIActionPostman prepareRPC(RequestContext request) {
        IUIActionPostman handler = null;
        handler.setAvailabe(true);
        request.setClassName(handlerName);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public void trans(CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
        if (ctx != null && ctx.containsKey(DAP_Multi_Org)) {
            this.transForOrg(sourceBillCollection, ctx);
        } else {
            this.ts.reset();
            ICoreBillBase srcBillBase = null;
            if (this.controller != null) {
                srcBillBase = this.controller.getBillInterface();
            }
            String sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
            Map params = this.beforeDAPTrans(sourceBillCollection, ctx);
            if (params.get(RULE) == null) {
                return;
            }
            DAPTransformResult transResult = this.doDAPTrans(srcBillBase, params, sourceBillType);
            this.afterDAPTrans(sourceBillType, params, transResult, true);
        }
    }

    protected void transForOrg(CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
        String sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
        Map params = this.beforeDAPOrgTrans(sourceBillCollection, ctx);
        if (params.get(RULES) == null) {
            return;
        }
        DAPTransformResult transResult = this.doDAPOrgTrans(sourceBillType, params, sourceBillType);
        this.afterDAPOrgTrans(sourceBillType, params, transResult);
    }

    protected BOTMappingCollection loadDAPRulesByOrg(String srcType, String voucherType, List companyOrgnames) throws BOSException, SQLException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        FilterInfo filter2 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("srcEntityName", (Object)srcType, CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("destEntityName", (Object)voucherType, CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)true));
        filter2.getFilterItems().add(new FilterItemInfo("org.name", null, CompareType.NOTEMPTY));
        filter1.mergeFilter(filter2, "AND");
        ev.setFilter(filter1);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("alias"));
        ev.getSelector().add(new SelectorItemInfo("extRule.isEffected"));
        ev.getSelector().add(new SelectorItemInfo("extRule.org.name"));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.BOTMappingQuery"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                idList.add(rs.getString("id"));
            }
        }
        if (idList == null || idList.size() == 0) {
            throw new DAPException(DAPException.BOTMAPPINGISNULL);
        }
        int SIZEPER = 30;
        int size = idList.size();
        ArrayList<BOTMappingCollection> botMappingColsList = new ArrayList<BOTMappingCollection>();
        IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)this.controller.getCtx());
        for (int i = 0; i <= size / SIZEPER; ++i) {
            BOTMappingCollection botMappingCols = new BOTMappingCollection();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("rules.*"));
            evi.getSelector().add(new SelectorItemInfo("rules.ruleSegments.*"));
            evi.getSelector().add(new SelectorItemInfo("rules.groups.*"));
            evi.getSelector().add(new SelectorItemInfo("revRule.*"));
            evi.getSelector().add(new SelectorItemInfo("revRule.revRuleSegments.*"));
            evi.getSelector().add(new SelectorItemInfo("delRevRule.*"));
            evi.getSelector().add(new SelectorItemInfo("delRevRule.delRevRuleSegments.*"));
            evi.getSelector().add(new SelectorItemInfo("extRule.*"));
            evi.getSelector().add(new SelectorItemInfo("extRule.org.*"));
            evi.getSelector().add(new SelectorItemInfo("aggregateCollection.*"));
            StringBuffer mask = new StringBuffer();
            for (int j = 0; j < SIZEPER && i * SIZEPER + j < size; ++j) {
                String botId = (String)idList.get(i * SIZEPER + j);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)botId));
                if (j == 0) {
                    mask.append("#");
                } else {
                    mask.append(" or #");
                }
                mask.append(j);
            }
            if (mask.toString().length() <= 0) continue;
            filter.setMaskString(mask.toString());
            botMappingCols = iBotMapping.getBOTMappingCollection(evi);
            botMappingColsList.add(botMappingCols);
        }
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        int count = botMappingColsList.size();
        for (int i = 0; i < count; ++i) {
            BOTMappingCollection current = (BOTMappingCollection)botMappingColsList.get(i);
            botMappingCols.addCollection(current);
        }
        return botMappingCols;
    }

    protected Map beforeDAPOrgTrans(CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        BOTMappingCollection botMappingCollection = null;
        String sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
        ArrayList<String> companyOrgnames = new ArrayList<String>();
        if (ctx.get(COMPANYORGLIST) != null) {
            List companyOrgs = (List)ctx.get(COMPANYORGLIST);
            for (int i = 0; i < companyOrgs.size(); ++i) {
                CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companyOrgs.get(i);
                companyOrgnames.add(org.getName());
            }
        }
        if ((botMappingCollection = this.loadDAPRulesByOrg(sourceBillType, VOUCHERTYPE, companyOrgnames)).size() == 0) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        BOTMappingCollection botMappingCollectionSelected = new BOTMappingCollection();
        if (botMappingCollection.size() < 1 || this.controller == null || !this.controller.isNeedShowBOTPRule()) {
            botMappingCollectionSelected = botMappingCollection;
        }
        IObjectPK[] botMappingPkList = new IObjectPK[botMappingCollectionSelected.size()];
        Iterator ite = botMappingCollectionSelected.iterator();
        int m = 0;
        while (ite.hasNext()) {
            BOTMappingInfo botMappingInfo = (BOTMappingInfo)ite.next();
            botMappingPkList[m] = new ObjectUuidPK(botMappingInfo.getId());
            ++m;
        }
        params.put(RULES, botMappingPkList);
        params.put(ORG_FIRST_RULE, botMappingCollectionSelected.get(0));
        IObjectPK[] sourceBillPkList = new IObjectPK[sourceBillCollection.size()];
        Iterator iter = sourceBillCollection.iterator();
        int index = 0;
        while (iter.hasNext()) {
            CoreBillBaseInfo sourceBillInfo = (CoreBillBaseInfo)iter.next();
            sourceBillPkList[index] = new ObjectUuidPK(sourceBillInfo.getId());
            ++index;
        }
        params.put(DATAIDS, sourceBillPkList);
        SelectorItemCollection botSelectors = new SelectorItemCollection();
        for (int i = 0; i < botMappingCollectionSelected.size(); ++i) {
            BOTMappingInfo botMappingInfo = botMappingCollectionSelected.get(i);
            SelectorItemCollection selectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
            for (int j = 0; j < selectors.size(); ++j) {
                SelectorItemInfo item = selectors.get(j);
                if (botSelectors.contains(item)) continue;
                botSelectors.add(item);
            }
        }
        params.put(SELECTORS, botSelectors);
        return params;
    }

    protected Map beforeDAPTrans(CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)this.controller.getCtx());
        BOTMappingCollection botMappingCollection = null;
        OrgUnitInfo transmitCU = null;
        if (ctx != null) {
            transmitCU = (OrgUnitInfo)ctx.get(TRANSMITCU);
        } else {
            ctx = new HashMap<String, OrgUnitInfo>();
        }
        if (transmitCU == null || !(transmitCU instanceof CtrlUnitInfo)) {
            if (this.controller != null) {
                transmitCU = this.controller.getMainOrgInfo();
            }
            if (transmitCU != null) {
                transmitCU = transmitCU.getCU();
                ctx.put(TRANSMITCU, transmitCU);
            }
        }
        String sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(sourceBillCollection.getObject(0).getBOSType());
        int count = sourceBillCollection.size();
        String[] idList = new String[count];
        for (int i = 0; i < count; ++i) {
            idList[i] = sourceBillCollection.get(i).getId().toString();
        }
        String[] entrysName = new String[]{this.getBillMainEntryName(entity)};
        List entriesKey = this.getSelectEntryIDs(sourceBillCollection, entrysName[0]);
        SelectorItemCollection botpSelectors = null;
        RequestContext request = new RequestContext();
        request.setMethodName("beforeDAPTrans");
        request.put("DAPTransImpl_beforeDAPTrans_bostype", (Object)sourceBillType);
        request.put("DAPTransImpl_beforeDAPTrans_VOUCHERTYPE", (Object)VOUCHERTYPE);
        request.put("DAPTransImpl_beforeDAPTrans_transmitCU", ctx);
        request.put("DAPTransImpl_beforeDAPTrans_idList", (Object)idList);
        request.put("DAPTransImpl_beforeDAPTrans_entryNames", (Object)entrysName);
        request.put("DAPTransImpl_beforeDAPTrans_entriesKey", (Object)entriesKey);
        request.put("DAPTransImpl_beforeDAPTrans_botpSelectors", botpSelectors);
        this.prepareRPC(request).callHandler();
        botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, VOUCHERTYPE, DefineSysEnum.DAP, ctx, idList, entrysName, entriesKey, botpSelectors);
        IObjectPK[] sourceBillPkList = new IObjectPK[sourceBillCollection.size()];
        Iterator iter = sourceBillCollection.iterator();
        int index = 0;
        while (iter.hasNext()) {
            CoreBillBaseInfo sourceBillInfo = (CoreBillBaseInfo)iter.next();
            sourceBillPkList[index] = new ObjectUuidPK(sourceBillInfo.getId());
            ++index;
        }
        params.put(DATAIDS, sourceBillPkList);
        BOTMappingInfo botMappingInfo = this.getSelectedDAPMappingInfo(botMappingCollection);
        params.put(RULE, botMappingInfo);
        SelectorItemCollection botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
        params.put(SELECTORS, botSelectors);
        logger.info((Object)("***DAPTransform, beforeDAPTrans=" + this.ts.msValue() + "ms"));
        return params;
    }

    private void reshowSelectUIWindow(Map params, CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
        Object selectedMappingInfo = null;
    }

    private BOTMappingInfo getSelectedDAPMappingInfo(BOTMappingCollection botMappingCollection) throws UIException, BOTPException {
        if (botMappingCollection.size() == 0) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        BOTMappingInfo botMappingInfo = null;
        return botMappingInfo;
    }

    protected void sortByRule(BOTMappingInfo botMappingInfo, VoucherCollection voucherCols) throws Exception {
        block6: {
            VoucherInfo voucher;
            int i;
            String extconfig = botMappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
            if (extconfig == null || extconfig.equals("")) break block6;
            info = processor.marshallingExtConfig(extconfig);
            if (info.getOrderField() == null || info.getOrderField().equals("")) {
                return;
            }
            String orderField = info.getOrderField();
            String orderStyle = info.getOrderStyle();
            VoucherInfoComparator comparator = new VoucherInfoComparator(orderField);
            ArrayList<VoucherInfo> list = new ArrayList<VoucherInfo>();
            int size = voucherCols.size();
            for (i = 0; i < size; ++i) {
                voucher = voucherCols.get(i);
                list.add(voucher);
            }
            Collections.sort(list, comparator);
            voucherCols.clear();
            if (orderStyle.equals("asc")) {
                size = list.size();
                for (i = 0; i < size; ++i) {
                    voucher = (VoucherInfo)list.get(i);
                    voucherCols.add(voucher);
                }
            } else {
                for (i = list.size(); i > 0; --i) {
                    VoucherInfo voucher2 = (VoucherInfo)list.get(i - 1);
                    voucherCols.add(voucher2);
                }
            }
        }
    }

    private void viewVouchers(Component ownerComponent, VoucherCollection voucherCol, String soprState, String uiClass, boolean notSave) throws Exception {
    }

    private void viewVouchers(Component ownerComponent, VoucherCollection voucherCol, String soprState) throws Exception {
    }

    public void delTrans(ArrayList idList) throws Exception {
        String param;
        Context ctx = this.controller.getCtx();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        ObjectUuidPK currentOrgId = new ObjectUuidPK(company.getId());
        ICoreBillBase srcBillInterface = null;
        if (this.controller != null) {
            srcBillInterface = this.controller.getBillInterface();
        }
        if ("1".equals(param = ParamManager.getParamValue((Context)ctx, (IObjectPK)currentOrgId, (String)"G002"))) {
            return;
        }
        Iterator idIter = idList.iterator();
        ArrayList<String> srcObjId = new ArrayList<String>();
        ArrayList<String> voucherIdList = new ArrayList<String>();
        int i = 1;
        while (idIter.hasNext()) {
            String id = (String)idIter.next();
            ArrayList voucherList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)id, (String)VOUCHERTYPE);
            if (voucherList.size() > 0) {
                for (String voucherId : voucherList) {
                    if (voucherIdList.contains(voucherId)) continue;
                    voucherIdList.add(voucherId);
                    if (srcObjId.contains(id)) continue;
                    srcObjId.add(id);
                }
            }
            ++i;
        }
        for (String id : srcObjId) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            if (srcBillInterface.deleteVoucher((IObjectPK)pk)) continue;
            return;
        }
    }

    public void delTransOrg(ArrayList idList) throws Exception {
        Component ownerComponent = null;
        List voucherIDList = this.beforeOrgDelTrans(ownerComponent, idList);
        if (voucherIDList == null || voucherIDList.size() <= 0) {
            return;
        }
        IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)this.controller.getCtx());
        dapTransformer.removeVoucherRelationOrg(voucherIDList, DAPVoucherTypeEnum.FIVoucher);
    }

    protected List beforeOrgDelTrans(Component ownerComponent, ArrayList idList) throws Exception {
        ArrayList voucherIDList = new ArrayList();
        Context ctx = this.controller.getCtx();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        ObjectUuidPK currentOrgId = new ObjectUuidPK(company.getId());
        String param = ParamManager.getParamValue(null, (IObjectPK)currentOrgId, (String)"G002");
        if ("1".equals(param)) {
            return null;
        }
        IDAPTransformer transformer = DAPTransformerFactory.getLocalInstance((Context)this.controller.getCtx());
        List voucherOrgInfoList = transformer.getDestVoucherInfoListFullOrg((List)idList);
        if (voucherOrgInfoList == null || voucherOrgInfoList.size() <= 0) {
            return null;
        }
        return voucherIDList;
    }

    public boolean isEnabledMultiTypeVoucher() {
        return false;
    }

    public MultiOrgBatchExceptionInfo transMultiOrg(com.kingdee.eas.framework.client.IMultiOrgBizInfo mulBizOrgInfo, String[] entryNames, SelectorItemCollection botpSelectors, Map ctx) throws Exception {
        return null;
    }

    class VoucherInfoComparator
    implements Comparator {
        String orderField = null;

        public VoucherInfoComparator(String orderField) {
            this.orderField = orderField;
        }

        public int compare(Object arg0, Object arg1) {
            VoucherInfo info1 = (VoucherInfo)arg0;
            VoucherInfo info2 = (VoucherInfo)arg1;
            Object value1 = info1.get(this.orderField);
            Object value2 = info2.get(this.orderField);
            if (value1 == null || value2 == null) {
                return 0;
            }
            if (value1 instanceof BigDecimal) {
                return ((BigDecimal)value1).compareTo((BigDecimal)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            return value1.toString().compareToIgnoreCase(value2.toString());
        }
    }
}

