/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.dap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.services.dap.DAPTransImpl;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPBillTrans;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPTrans;
import com.kingdee.eas.fi.fa.manage.services.dap.IDAPTransService;
import com.kingdee.eas.fi.fa.manage.services.dap.impl.IDAPController;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.dap.IDAPTransService"})
public class DAPTransServiceImpl
extends BusinessServices
implements IDAPTransService,
IDAPController {
    private IDAPTrans dapTrans = null;
    private boolean isDAPTrans = false;
    ICoreBillBase iBillInterface = null;
    private String[] billIDs = null;

    public DAPTransServiceImpl(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> generateVoucher(String bosType, String[] billIDs) throws BOSException, EASBizException {
        ICoreBillBase bizCtrl;
        this.iBillInterface = bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        this.billIDs = billIDs;
        HashSet<String> idSet = new HashSet<String>();
        int size = billIDs.length;
        for (int i = 0; i < size; ++i) {
            idSet.add(billIDs[i]);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(FaServerUtil.getSelectors("true"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)0, CompareType.NOTEQUALS));
        entityViewInfo.setFilter(filter);
        CoreBaseCollection collection = this.iBillInterface.getCollection(entityViewInfo);
        try {
            DAPTransServiceImpl controller = this;
            this.dapTrans = new DAPTransImpl(controller);
            this.dapTrans.init();
            if (this.dapTrans instanceof IDAPBillTrans) {
                IDAPBillTrans dapTransform = (IDAPBillTrans)this.dapTrans;
                dapTransform.init();
                this.actionVoucherByID(dapTransform, collection);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected void actionVoucherByID(IDAPBillTrans dapTransform, CoreBaseCollection collection) throws Exception {
        if (dapTransform == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList entriesKey = new ArrayList();
        for (CoreBaseInfo info : collection) {
            idList.add(info.getId().toString());
        }
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        if (this.isDAPTrans) {
            entriesKey.clear();
        }
        if (idList.size() > 0) {
            boolean succ = dapTransform.trans(idArray, new String[]{this.getEntriesName()}, entriesKey, FaServerUtil.getSelectors("true"));
            System.out.println("success");
        }
    }

    public String getEntriesName() {
        return "entries";
    }

    @Override
    public OrgUnitInfo getMainOrgInfo() throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(this.billIDs[0].toString());
        CoreBaseInfo billInfo = this.iBillInterface.getValue("select company.* where id = '" + pk + "'");
        return (CompanyOrgUnitInfo)billInfo.get("company");
    }

    @Override
    public boolean isNeedShowBOTPRule() {
        return true;
    }

    @Override
    public ICoreBillBase getBillInterface() throws BOSException, EASBizException {
        return FaCurCardFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public Context getCtx() throws BOSException, EASBizException {
        return this.getContext();
    }

    @Override
    public Map<String, Object> delVoucher(String bosType, String[] billIDs) throws BOSException, EASBizException {
        ICoreBillBase bizCtrl;
        this.iBillInterface = bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        boolean bool = this.judgeVoucherState(billIDs);
        if (bool) {
            String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DelVoucherError");
            throw new BOSException(msg);
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        try {
            DAPTransServiceImpl controller = this;
            DAPTransImpl dapTrans = new DAPTransImpl(controller);
            dapTrans.init();
            dapTrans.delTrans(idList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private boolean judgeVoucherState(String[] billIDs) throws EASBizException, BOSException {
        boolean isExist = false;
        String strIdLists = StringUtils.arrayToString((Object[])billIDs, (String)",");
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
        maskString = new StringBuffer();
        maskString.append("#0 AND (#1 or #2)");
        filterInfo.setMaskString(maskString.toString());
        isExist = this.iBillInterface.exists(filterInfo);
        return isExist;
    }
}

